/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.dispatch.Envelope;
import akka.dispatch.MailboxType;
import akka.dispatch.ProducesMessageQueue;
import akka.dispatch.UnboundedQueueBasedMessageQueue;
import akka.util.StablePriorityBlockingQueue;
import java.util.Comparator;
import java.util.Queue;
import scala.Option;

public class UnboundedStablePriorityMailbox
implements MailboxType,
ProducesMessageQueue<MessageQueue> {
    private final Comparator cmp;
    private final int initialCapacity;

    public UnboundedStablePriorityMailbox(Comparator<Envelope> cmp, int initialCapacity) {
        this.cmp = cmp;
        this.initialCapacity = initialCapacity;
    }

    public Comparator<Envelope> cmp() {
        return this.cmp;
    }

    public int initialCapacity() {
        return this.initialCapacity;
    }

    public UnboundedStablePriorityMailbox(Comparator<Envelope> cmp) {
        this(cmp, 11);
    }

    @Override
    public final akka.dispatch.MessageQueue create(Option<ActorRef> owner, Option<ActorSystem> system) {
        return new MessageQueue(this.initialCapacity(), this.cmp());
    }

    public static class MessageQueue
    extends StablePriorityBlockingQueue<Envelope>
    implements UnboundedQueueBasedMessageQueue {
        public MessageQueue(int initialCapacity, Comparator<Envelope> cmp) {
            super(initialCapacity, cmp);
        }

        @Override
        public final Queue<Envelope> queue() {
            return this;
        }
    }
}

