/*
 * Decompiled with CFR 0.152.
 */
package akka.event;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogMarker$;
import akka.actor.ActorRef;
import akka.actor.ActorRef$;
import akka.actor.AllDeadLetters;
import akka.actor.DeadLetter;
import akka.actor.DeadLetterActorRef;
import akka.actor.DeadLetterSuppression;
import akka.actor.Dropped;
import akka.actor.UnhandledMessage;
import akka.actor.WrappedMessage;
import akka.actor.WrappedMessage$;
import akka.event.EventStream;
import akka.event.Logging$;
import akka.event.Logging$Info$;
import akka.util.PrettyDuration$;
import akka.util.PrettyDuration$PrettyPrintableDuration$;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.collection.immutable.Map;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;

public class DeadLetterListener
implements Actor {
    private final ActorContext context = Actor.super.initial$context();
    private final ActorRef self = Actor.super.initial$self();
    private final EventStream eventStream;
    private final int maxCount;
    private final boolean isAlwaysLoggingDeadLetters;
    private int count;

    public DeadLetterListener() {
        this.eventStream = this.context().system().eventStream();
        this.maxCount = this.context().system().settings().LogDeadLetters();
        this.isAlwaysLoggingDeadLetters = this.maxCount() == Integer.MAX_VALUE;
        this.count = 0;
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    public EventStream eventStream() {
        return this.eventStream;
    }

    public int maxCount() {
        return this.maxCount;
    }

    public int count() {
        return this.count;
    }

    public void count_$eq(int x$1) {
        this.count = x$1;
    }

    @Override
    public void preStart() {
        this.eventStream().subscribe(this.self(), DeadLetter.class);
        this.eventStream().subscribe(this.self(), Dropped.class);
        this.eventStream().subscribe(this.self(), UnhandledMessage.class);
    }

    @Override
    public void postRestart(Throwable reason) {
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) {
    }

    @Override
    public void postStop() {
        this.eventStream().unsubscribe(this.self());
    }

    public void akka$event$DeadLetterListener$$incrementCount() {
        if (this.count() == Integer.MAX_VALUE) {
            Logging$.MODULE$.getLogger(this).info("Resetting DeadLetterListener counter after reaching Int.MaxValue.");
            this.count_$eq(1);
        } else {
            this.count_$eq(this.count() + 1);
        }
    }

    @Override
    public PartialFunction receive() {
        PartialFunction partialFunction;
        if (this.isAlwaysLoggingDeadLetters) {
            partialFunction = this.receiveWithAlwaysLogging();
        } else {
            Duration duration = this.context().system().settings().LogDeadLettersSuspendDuration();
            if (duration instanceof FiniteDuration) {
                FiniteDuration suspendDuration = (FiniteDuration)duration;
                partialFunction = this.akka$event$DeadLetterListener$$receiveWithSuspendLogging(suspendDuration);
            } else {
                partialFunction = this.receiveWithMaxCountLogging();
            }
        }
        return partialFunction;
    }

    private PartialFunction receiveWithAlwaysLogging() {
        return new Serializable(this){
            private final DeadLetterListener $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                boolean bl;
                Object object = x;
                if (object instanceof AllDeadLetters) {
                    AllDeadLetters d = (AllDeadLetters)object;
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof AllDeadLetters) {
                    AllDeadLetters d = (AllDeadLetters)object2;
                    if (!this.$outer.akka$event$DeadLetterListener$$isWrappedSuppressed(d)) {
                        this.$outer.akka$event$DeadLetterListener$$incrementCount();
                        this.$outer.akka$event$DeadLetterListener$$logDeadLetter(d, "");
                        object = BoxedUnit.UNIT;
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                } else {
                    object = function1.apply(x);
                }
                return object;
            }
        };
    }

    private PartialFunction receiveWithMaxCountLogging() {
        return new Serializable(this){
            private final DeadLetterListener $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                boolean bl;
                Object object = x;
                if (object instanceof AllDeadLetters) {
                    AllDeadLetters d = (AllDeadLetters)object;
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof AllDeadLetters) {
                    AllDeadLetters d = (AllDeadLetters)object2;
                    if (!this.$outer.akka$event$DeadLetterListener$$isWrappedSuppressed(d)) {
                        this.$outer.akka$event$DeadLetterListener$$incrementCount();
                        if (this.$outer.count() == this.$outer.maxCount()) {
                            this.$outer.akka$event$DeadLetterListener$$logDeadLetter(d, ", no more dead letters will be logged");
                            this.$outer.context().stop(this.$outer.self());
                            object = BoxedUnit.UNIT;
                        } else {
                            this.$outer.akka$event$DeadLetterListener$$logDeadLetter(d, "");
                            object = BoxedUnit.UNIT;
                        }
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                } else {
                    object = function1.apply(x);
                }
                return object;
            }
        };
    }

    public PartialFunction akka$event$DeadLetterListener$$receiveWithSuspendLogging(FiniteDuration suspendDuration) {
        return new Serializable(suspendDuration, this){
            private final FiniteDuration suspendDuration$1;
            private final DeadLetterListener $outer;
            {
                this.suspendDuration$1 = suspendDuration$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                boolean bl;
                Object object = x;
                if (object instanceof AllDeadLetters) {
                    AllDeadLetters d = (AllDeadLetters)object;
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof AllDeadLetters) {
                    AllDeadLetters d = (AllDeadLetters)object2;
                    if (!this.$outer.akka$event$DeadLetterListener$$isWrappedSuppressed(d)) {
                        this.$outer.akka$event$DeadLetterListener$$incrementCount();
                        if (this.$outer.count() == this.$outer.maxCount()) {
                            String doneMsg = ", no more dead letters will be logged in next [" + PrettyDuration$PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.suspendDuration$1)) + "]";
                            this.$outer.akka$event$DeadLetterListener$$logDeadLetter(d, doneMsg);
                            this.$outer.context().become(this.$outer.akka$event$DeadLetterListener$$receiveWhenSuspended(this.suspendDuration$1, Deadline$.MODULE$.now().$plus(this.suspendDuration$1)));
                            object = BoxedUnit.UNIT;
                        } else {
                            this.$outer.akka$event$DeadLetterListener$$logDeadLetter(d, "");
                            object = BoxedUnit.UNIT;
                        }
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                } else {
                    object = function1.apply(x);
                }
                return object;
            }
        };
    }

    public PartialFunction akka$event$DeadLetterListener$$receiveWhenSuspended(FiniteDuration suspendDuration, Deadline suspendDeadline) {
        return new Serializable(suspendDuration, suspendDeadline, this){
            private final FiniteDuration suspendDuration$1;
            private final Deadline suspendDeadline$1;
            private final DeadLetterListener $outer;
            {
                this.suspendDuration$1 = suspendDuration$4;
                this.suspendDeadline$1 = suspendDeadline$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                boolean bl;
                Object object = x;
                if (object instanceof AllDeadLetters) {
                    AllDeadLetters d = (AllDeadLetters)object;
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof AllDeadLetters) {
                    AllDeadLetters d = (AllDeadLetters)object2;
                    if (!this.$outer.akka$event$DeadLetterListener$$isWrappedSuppressed(d)) {
                        this.$outer.akka$event$DeadLetterListener$$incrementCount();
                        if (this.suspendDeadline$1.isOverdue()) {
                            String doneMsg = ", of which " + (this.$outer.count() - this.$outer.maxCount() - 1) + " were not logged. The counter will be reset now";
                            this.$outer.akka$event$DeadLetterListener$$logDeadLetter(d, doneMsg);
                            this.$outer.count_$eq(0);
                            this.$outer.context().become(this.$outer.akka$event$DeadLetterListener$$receiveWithSuspendLogging(this.suspendDuration$1));
                            object = BoxedUnit.UNIT;
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                } else {
                    object = function1.apply(x);
                }
                return object;
            }
        };
    }

    public void akka$event$DeadLetterListener$$logDeadLetter(AllDeadLetters d, String doneMsg) {
        String string;
        String origin = this.isReal(d.sender()) ? " from " + d.sender() : "";
        Object unwrapped = WrappedMessage$.MODULE$.unwrap(d.message());
        String messageStr = unwrapped.getClass().getName();
        String wrappedIn = d.message() instanceof WrappedMessage ? " wrapped in [" + d.message().getClass().getName() + "]" : "";
        AllDeadLetters allDeadLetters = d;
        if (allDeadLetters instanceof Dropped) {
            Dropped dropped = (Dropped)allDeadLetters;
            String destination = this.isReal(d.recipient()) ? " to " + d.recipient() : "";
            string = "Message [" + messageStr + "]" + wrappedIn + origin + destination + " was dropped. " + dropped.reason() + ". " + ("[" + this.count() + "] dead letters encountered" + doneMsg + ". ");
        } else if (allDeadLetters instanceof UnhandledMessage) {
            String destination = this.isReal(d.recipient()) ? " to " + d.recipient() : "";
            string = "Message [" + messageStr + "]" + wrappedIn + origin + destination + " was unhandled. " + ("[" + this.count() + "] dead letters encountered" + doneMsg + ". ");
        } else {
            string = "Message [" + messageStr + "]" + wrappedIn + origin + " to " + d.recipient() + " was not delivered. " + ("[" + this.count() + "] dead letters encountered" + doneMsg + ". ") + ("If this is not an expected behavior then " + d.recipient() + " may have terminated unexpectedly. ");
        }
        String logMessage = string;
        this.eventStream().publish(Logging$Info$.MODULE$.apply(d.recipient().path().toString(), d.recipient().getClass(), logMessage + "This logging can be turned off or adjusted with configuration settings 'akka.log-dead-letters' " + "and 'akka.log-dead-letters-during-shutdown'.", (Map<String, Object>)Logging$.MODULE$.emptyMDC(), ActorLogMarker$.MODULE$.deadLetter(messageStr)));
    }

    private boolean isReal(ActorRef snd) {
        return snd != ActorRef$.MODULE$.noSender() && snd != this.context().system().deadLetters() && !(snd instanceof DeadLetterActorRef);
    }

    public boolean akka$event$DeadLetterListener$$isWrappedSuppressed(AllDeadLetters d) {
        WrappedMessage w;
        Object object = d.message();
        return object instanceof WrappedMessage && (w = (WrappedMessage)object).message() instanceof DeadLetterSuppression;
    }
}

