/*
 * Decompiled with CFR 0.152.
 */
package akka.event;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.event.ActorWithLogClass;
import akka.event.DummyClassForStringSources;
import akka.event.LogSource;
import akka.event.Logging$;
import java.io.Serializable;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.control.NonFatal$;

public final class LogSource$
implements Serializable {
    public static final LogSource$ MODULE$;
    private final LogSource fromString;
    private final LogSource fromActor;
    private final LogSource fromActorRef;
    @InternalApi
    private final LogSource fromActorWithLoggerClass;
    private final LogSource fromClass;

    static {
        new LogSource$();
    }

    private LogSource$() {
        MODULE$ = this;
        this.fromString = new LogSource(){

            public String genString(String s) {
                return s;
            }

            public String genString(String s, ActorSystem system) {
                return s + "(" + system + ")";
            }

            public Class getClazz(String s) {
                return DummyClassForStringSources.class;
            }
        };
        this.fromActor = new LogSource(){

            public String genString(Actor a) {
                return LogSource$.MODULE$.fromActorRef().genString(a.self());
            }

            public String genString(Actor a, ActorSystem system) {
                return LogSource$.MODULE$.fromActorRef().genString(a.self(), system);
            }
        };
        this.fromActorRef = new LogSource(){

            public String genString(ActorRef a) {
                return a.path().toString();
            }

            public String genString(ActorRef a, ActorSystem system) {
                String string;
                try {
                    string = a.path().toStringWithAddress(((ExtendedActorSystem)system).provider().getDefaultAddress());
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3 = (Throwable)option.get();
                        string = a.path().toString();
                    }
                    throw throwable;
                }
                return string;
            }
        };
        this.fromActorWithLoggerClass = new LogSource(){

            public String genString(ActorWithLogClass a) {
                return LogSource$.MODULE$.fromActor().genString(a.actor());
            }

            public String genString(ActorWithLogClass a, ActorSystem system) {
                return LogSource$.MODULE$.fromActor().genString(a.actor(), system);
            }

            public Class getClazz(ActorWithLogClass a) {
                return a.logClass();
            }
        };
        this.fromClass = new LogSource(){

            public String genString(Class c) {
                return Logging$.MODULE$.simpleName(c);
            }

            public String genString(Class c, ActorSystem system) {
                return this.genString(c) + "(" + system + ")";
            }

            public Class getClazz(Class c) {
                return c;
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LogSource$.class);
    }

    public LogSource<String> fromString() {
        return this.fromString;
    }

    public LogSource<Actor> fromActor() {
        return this.fromActor;
    }

    public LogSource<ActorRef> fromActorRef() {
        return this.fromActorRef;
    }

    public LogSource<ActorWithLogClass> fromActorWithLoggerClass() {
        return this.fromActorWithLoggerClass;
    }

    public LogSource<Class<?>> fromClass() {
        return this.fromClass;
    }

    public <T> LogSource<Class<? extends T>> fromAnyClass() {
        return this.fromClass();
    }

    public <T> Tuple2<String, Class<?>> apply(T o, LogSource<T> evidence$5) {
        LogSource<T> ls = evidence$5;
        return Tuple2$.MODULE$.apply((Object)ls.genString(o), ls.getClazz(o));
    }

    public <T> Tuple2<String, Class<?>> apply(T o, ActorSystem system, LogSource<T> evidence$6) {
        LogSource<T> ls = evidence$6;
        return Tuple2$.MODULE$.apply((Object)ls.genString(o, system), ls.getClazz(o));
    }

    public Tuple2<String, Class<?>> fromAnyRef(Object o) {
        Tuple2 tuple2;
        Object object = o;
        if (object instanceof Class) {
            Class c = (Class)object;
            tuple2 = this.apply(c, this.fromAnyClass());
        } else if (object instanceof Actor) {
            Actor a = (Actor)object;
            tuple2 = this.apply(a, this.fromActor());
        } else if (object instanceof ActorRef) {
            ActorRef a = (ActorRef)object;
            tuple2 = this.apply(a, this.fromActorRef());
        } else if (object instanceof String) {
            String s = (String)object;
            tuple2 = this.apply(s, this.fromString());
        } else {
            Object x = object;
            tuple2 = Tuple2$.MODULE$.apply((Object)Logging$.MODULE$.simpleName(x), x.getClass());
        }
        return tuple2;
    }

    public Tuple2<String, Class<?>> fromAnyRef(Object o, ActorSystem system) {
        Tuple2 tuple2;
        Object object = o;
        if (object instanceof Class) {
            Class c = (Class)object;
            tuple2 = this.apply(c, this.fromAnyClass());
        } else if (object instanceof Actor) {
            Actor a = (Actor)object;
            tuple2 = this.apply(a, this.fromActor());
        } else if (object instanceof ActorRef) {
            ActorRef a = (ActorRef)object;
            tuple2 = this.apply(a, this.fromActorRef());
        } else if (object instanceof String) {
            String s = (String)object;
            tuple2 = this.apply(s, this.fromString());
        } else {
            Object x = object;
            tuple2 = Tuple2$.MODULE$.apply((Object)(Logging$.MODULE$.simpleName(x) + "(" + system + ")"), x.getClass());
        }
        return tuple2;
    }
}

