/*
 * Decompiled with CFR 0.152.
 */
package akka.event;

import akka.actor.Actor;
import akka.actor.ActorSelectionMessage;
import akka.actor.ActorSelectionMessage$;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.SelectionPathElement;
import akka.annotation.InternalApi;
import akka.event.BusLogging;
import akka.event.DiagnosticLoggingAdapter;
import akka.event.DiagnosticMarkerBusLoggingAdapter;
import akka.event.LogSource;
import akka.event.LogSource$;
import akka.event.Logging;
import akka.event.Logging$Debug$;
import akka.event.Logging$Error$;
import akka.event.Logging$Error$NoCause$;
import akka.event.Logging$Error2$;
import akka.event.Logging$Info$;
import akka.event.Logging$InitializeLogger$;
import akka.event.Logging$LogEvent$;
import akka.event.Logging$LogExt$;
import akka.event.Logging$LogLevel$;
import akka.event.Logging$LoggerInitialized$;
import akka.event.Logging$StdOutLogger$;
import akka.event.Logging$Warning$;
import akka.event.LoggingAdapter;
import akka.event.LoggingBus;
import akka.event.MarkerLoggingAdapter;
import akka.util.Helpers$;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NoStackTrace;

public final class Logging$
implements Serializable {
    public static final Logging$ MODULE$;
    public final Logging$LogExt$ LogExt;
    public final Logging$LogLevel$ LogLevel;
    private final int ErrorLevel;
    private final int WarningLevel;
    private final int InfoLevel;
    private final int DebugLevel;
    @InternalApi
    private final int OffLevel;
    private final Seq AllLogLevels;
    public final Logging$LogEvent$ LogEvent;
    public final Logging$Error2$ Error2;
    public final Logging$Error$ Error;
    public final Logging$Warning$ Warning;
    public final Logging$Info$ Info;
    public final Logging$Debug$ Debug;
    public final Logging$InitializeLogger$ InitializeLogger;
    public final Logging$LoggerInitialized$ LoggerInitialized;
    public final Logging$StdOutLogger$ StdOutLogger;
    public final Logging.SerializedStandardOutLogger akka$event$Logging$$$serializedStandardOutLogger;
    private final Logging.StandardOutLogger StandardOutLogger;
    private final Map emptyMDC;

    static {
        new Logging$();
    }

    private Logging$() {
        MODULE$ = this;
        this.ErrorLevel = Logging$LogLevel$.MODULE$.apply(1);
        this.WarningLevel = Logging$LogLevel$.MODULE$.apply(2);
        this.InfoLevel = Logging$LogLevel$.MODULE$.apply(3);
        this.DebugLevel = Logging$LogLevel$.MODULE$.apply(4);
        this.OffLevel = Logging$LogLevel$.MODULE$.apply(Integer.MIN_VALUE);
        this.AllLogLevels = (Seq)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Logging.LogLevel[]{new Logging.LogLevel(this.ErrorLevel()), new Logging.LogLevel(this.WarningLevel()), new Logging.LogLevel(this.InfoLevel()), new Logging.LogLevel(this.DebugLevel())}));
        this.akka$event$Logging$$$serializedStandardOutLogger = new Logging.SerializedStandardOutLogger();
        this.StandardOutLogger = new Logging.StandardOutLogger();
        this.emptyMDC = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Logging$.class);
    }

    public String simpleName(Object obj) {
        return this.simpleName(obj.getClass());
    }

    public String simpleName(Class<?> clazz) {
        String n = clazz.getName();
        int i = n.lastIndexOf(46);
        return n.substring(i + 1);
    }

    public String messageClassName(Object message) {
        String string;
        Object object = message;
        if (object == null) {
            string = "null";
        } else if (object instanceof ActorSelectionMessage) {
            ActorSelectionMessage actorSelectionMessage = ActorSelectionMessage$.MODULE$.unapply((ActorSelectionMessage)object);
            Object object2 = actorSelectionMessage._1();
            Iterable<SelectionPathElement> iterable = actorSelectionMessage._2();
            boolean bl = actorSelectionMessage._3();
            Object m = object2;
            string = "ActorSelectionMessage(" + m.getClass().getName() + ")";
        } else {
            Object m = object;
            string = m.getClass().getName();
        }
        return string;
    }

    public final int ErrorLevel() {
        return this.ErrorLevel;
    }

    public final int WarningLevel() {
        return this.WarningLevel;
    }

    public final int InfoLevel() {
        return this.InfoLevel;
    }

    public final int DebugLevel() {
        return this.DebugLevel;
    }

    public final int OffLevel() {
        return this.OffLevel;
    }

    public Option<Logging.LogLevel> levelFor(String s) {
        String string = Helpers$.MODULE$.toRootLowerCase(s);
        return "off".equals(string) ? Some$.MODULE$.apply((Object)new Logging.LogLevel(this.OffLevel())) : ("error".equals(string) ? Some$.MODULE$.apply((Object)new Logging.LogLevel(this.ErrorLevel())) : ("warning".equals(string) ? Some$.MODULE$.apply((Object)new Logging.LogLevel(this.WarningLevel())) : ("info".equals(string) ? Some$.MODULE$.apply((Object)new Logging.LogLevel(this.InfoLevel())) : ("debug".equals(string) ? Some$.MODULE$.apply((Object)new Logging.LogLevel(this.DebugLevel())) : None$.MODULE$))));
    }

    public int levelFor(Class<? extends Logging.LogEvent> eventClass) {
        return Logging.Error.class.isAssignableFrom(eventClass) ? this.ErrorLevel() : (Logging.Warning.class.isAssignableFrom(eventClass) ? this.WarningLevel() : (Logging.Info.class.isAssignableFrom(eventClass) ? this.InfoLevel() : (Logging.Debug.class.isAssignableFrom(eventClass) ? this.DebugLevel() : this.DebugLevel())));
    }

    public Class<? extends Logging.LogEvent> classFor(int level) {
        Class clazz;
        int n = level;
        Logging.LogLevel logLevel = new Logging.LogLevel(this.ErrorLevel());
        Logging.LogLevel logLevel2 = new Logging.LogLevel(n);
        if (!(logLevel != null ? !((Object)logLevel).equals(logLevel2) : logLevel2 != null)) {
            clazz = Logging.Error.class;
        } else {
            Logging.LogLevel logLevel3 = new Logging.LogLevel(this.WarningLevel());
            Logging.LogLevel logLevel4 = new Logging.LogLevel(n);
            if (!(logLevel3 != null ? !((Object)logLevel3).equals(logLevel4) : logLevel4 != null)) {
                clazz = Logging.Warning.class;
            } else {
                Logging.LogLevel logLevel5 = new Logging.LogLevel(this.InfoLevel());
                Logging.LogLevel logLevel6 = new Logging.LogLevel(n);
                if (!(logLevel5 != null ? !((Object)logLevel5).equals(logLevel6) : logLevel6 != null)) {
                    clazz = Logging.Info.class;
                } else {
                    Logging.LogLevel logLevel7 = new Logging.LogLevel(this.DebugLevel());
                    Logging.LogLevel logLevel8 = new Logging.LogLevel(n);
                    if (!(logLevel7 != null ? !((Object)logLevel7).equals(logLevel8) : logLevel8 != null)) {
                        clazz = Logging.Debug.class;
                    } else {
                        int level2 = n;
                        throw new IllegalArgumentException("Unsupported log level [" + new Logging.LogLevel(level2) + "]");
                    }
                }
            }
        }
        return clazz;
    }

    public Seq<Logging.LogLevel> AllLogLevels() {
        return this.AllLogLevels;
    }

    public <T> LoggingAdapter apply(ActorSystem system, T logSource, LogSource<T> evidence$1) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, system, evidence$1);
        if (!(tuple2 instanceof Tuple2)) {
            throw new MatchError(tuple2);
        }
        Tuple2<String, Class<?>> tuple22 = tuple2;
        String str = (String)tuple22._1();
        Class clazz = (Class)tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)str, (Object)clazz);
        String str2 = (String)tuple23._1();
        Class clazz2 = (Class)tuple23._2();
        return new BusLogging(system.eventStream(), str2, clazz2, ((ExtendedActorSystem)system).logFilter());
    }

    public <T> MarkerLoggingAdapter withMarker(ActorSystem system, T logSource, LogSource<T> evidence$2) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, system, evidence$2);
        if (!(tuple2 instanceof Tuple2)) {
            throw new MatchError(tuple2);
        }
        Tuple2<String, Class<?>> tuple22 = tuple2;
        String str = (String)tuple22._1();
        Class clazz = (Class)tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)str, (Object)clazz);
        String str2 = (String)tuple23._1();
        Class clazz2 = (Class)tuple23._2();
        return new MarkerLoggingAdapter(system.eventStream(), str2, clazz2, ((ExtendedActorSystem)system).logFilter());
    }

    public <T> LoggingAdapter apply(LoggingBus bus, T logSource, LogSource<T> evidence$3) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, evidence$3);
        if (!(tuple2 instanceof Tuple2)) {
            throw new MatchError(tuple2);
        }
        Tuple2<String, Class<?>> tuple22 = tuple2;
        String str = (String)tuple22._1();
        Class clazz = (Class)tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)str, (Object)clazz);
        String str2 = (String)tuple23._1();
        Class clazz2 = (Class)tuple23._2();
        return new BusLogging(bus, str2, clazz2);
    }

    public <T> MarkerLoggingAdapter withMarker(LoggingBus bus, T logSource, LogSource<T> evidence$4) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, evidence$4);
        if (!(tuple2 instanceof Tuple2)) {
            throw new MatchError(tuple2);
        }
        Tuple2<String, Class<?>> tuple22 = tuple2;
        String str = (String)tuple22._1();
        Class clazz = (Class)tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)str, (Object)clazz);
        String str2 = (String)tuple23._1();
        Class clazz2 = (Class)tuple23._2();
        return new MarkerLoggingAdapter(bus, str2, clazz2);
    }

    public DiagnosticLoggingAdapter apply(Actor logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, LogSource$.MODULE$.fromActor());
        if (!(tuple2 instanceof Tuple2)) {
            throw new MatchError(tuple2);
        }
        Tuple2<String, Class<?>> tuple22 = tuple2;
        String str = (String)tuple22._1();
        Class clazz = (Class)tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)str, (Object)clazz);
        String str2 = (String)tuple23._1();
        Class clazz2 = (Class)tuple23._2();
        ExtendedActorSystem system = (ExtendedActorSystem)logSource.context().system();
        return new DiagnosticLoggingAdapter(str2, clazz2, system){
            private Map akka$event$DiagnosticLoggingAdapter$$_mdc;
            {
                this.akka$event$DiagnosticLoggingAdapter$$_mdc = DiagnosticLoggingAdapter.super.akka$event$DiagnosticLoggingAdapter$$initial$_mdc();
                DiagnosticLoggingAdapter.super.$init$();
            }

            public Map akka$event$DiagnosticLoggingAdapter$$_mdc() {
                return this.akka$event$DiagnosticLoggingAdapter$$_mdc;
            }

            public void akka$event$DiagnosticLoggingAdapter$$_mdc_$eq(Map x$1) {
                this.akka$event$DiagnosticLoggingAdapter$$_mdc = x$1;
            }
        };
    }

    public DiagnosticMarkerBusLoggingAdapter withMarker(Actor logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, LogSource$.MODULE$.fromActor());
        if (!(tuple2 instanceof Tuple2)) {
            throw new MatchError(tuple2);
        }
        Tuple2<String, Class<?>> tuple22 = tuple2;
        String str = (String)tuple22._1();
        Class clazz = (Class)tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)str, (Object)clazz);
        String str2 = (String)tuple23._1();
        Class clazz2 = (Class)tuple23._2();
        ExtendedActorSystem system = (ExtendedActorSystem)logSource.context().system();
        return new DiagnosticMarkerBusLoggingAdapter(system.eventStream(), str2, clazz2, system.logFilter());
    }

    public LoggingAdapter getLogger(ActorSystem system, Object logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.fromAnyRef(logSource, system);
        if (!(tuple2 instanceof Tuple2)) {
            throw new MatchError(tuple2);
        }
        Tuple2<String, Class<?>> tuple22 = tuple2;
        String str = (String)tuple22._1();
        Class clazz = (Class)tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)str, (Object)clazz);
        String str2 = (String)tuple23._1();
        Class clazz2 = (Class)tuple23._2();
        return new BusLogging(system.eventStream(), str2, clazz2, ((ExtendedActorSystem)system).logFilter());
    }

    public LoggingAdapter getLogger(LoggingBus bus, Object logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.fromAnyRef(logSource);
        if (!(tuple2 instanceof Tuple2)) {
            throw new MatchError(tuple2);
        }
        Tuple2<String, Class<?>> tuple22 = tuple2;
        String str = (String)tuple22._1();
        Class clazz = (Class)tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)str, (Object)clazz);
        String str2 = (String)tuple23._1();
        Class clazz2 = (Class)tuple23._2();
        return new BusLogging(bus, str2, clazz2);
    }

    public DiagnosticLoggingAdapter getLogger(Actor logSource) {
        return this.apply(logSource);
    }

    public Logging$Error$NoCause$ noCause() {
        return Logging$Error$NoCause$.MODULE$;
    }

    public Logging$LoggerInitialized$ loggerInitialized() {
        return Logging$LoggerInitialized$.MODULE$;
    }

    public Logging.StandardOutLogger StandardOutLogger() {
        return this.StandardOutLogger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String stackTraceFor(Throwable e) {
        String string;
        Throwable throwable = e;
        if (throwable == null) return "";
        if (Logging$Error$NoCause$.MODULE$.equals(throwable)) {
            return "";
        }
        boolean bl = false;
        if (bl) {
            return "";
        }
        if (throwable instanceof NoStackTrace) {
            string = " (" + e.getClass().getName() + ": " + e.getMessage() + ")";
            return string;
        } else {
            Throwable other = throwable;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.append('\n');
            other.printStackTrace(pw);
            string = sw.toString();
        }
        return string;
    }

    public Map emptyMDC() {
        return this.emptyMDC;
    }
}

