/*
 * Decompiled with CFR 0.152.
 */
package akka.event;

import akka.event.Logging;
import akka.event.Logging$;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public interface LoggingAdapter {
    default public Map mdc() {
        return Logging$.MODULE$.emptyMDC();
    }

    public boolean isErrorEnabled();

    public boolean isWarningEnabled();

    public boolean isInfoEnabled();

    public boolean isDebugEnabled();

    public void notifyError(String var1);

    public void notifyError(Throwable var1, String var2);

    public void notifyWarning(String var1);

    public void notifyInfo(String var1);

    public void notifyDebug(String var1);

    default public void error(Throwable cause, String message) {
        if (this.isErrorEnabled()) {
            this.notifyError(cause, message);
        }
    }

    default public void error(Throwable cause, String template, Object arg1) {
        if (this.isErrorEnabled()) {
            this.notifyError(cause, this.format1(template, arg1));
        }
    }

    default public void error(Throwable cause, String template, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.notifyError(cause, this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
        }
    }

    default public void error(Throwable cause, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isErrorEnabled()) {
            this.notifyError(cause, this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
        }
    }

    default public void error(Throwable cause, String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isErrorEnabled()) {
            this.notifyError(cause, this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})));
        }
    }

    default public void error(String message) {
        if (this.isErrorEnabled()) {
            this.notifyError(message);
        }
    }

    default public void error(String template, Object arg1) {
        if (this.isErrorEnabled()) {
            this.notifyError(this.format1(template, arg1));
        }
    }

    default public void error(String template, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.notifyError(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
        }
    }

    default public void error(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isErrorEnabled()) {
            this.notifyError(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
        }
    }

    default public void error(String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isErrorEnabled()) {
            this.notifyError(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})));
        }
    }

    default public void warning(String message) {
        if (this.isWarningEnabled()) {
            this.notifyWarning(message);
        }
    }

    default public void warning(String template, Object arg1) {
        if (this.isWarningEnabled()) {
            this.notifyWarning(this.format1(template, arg1));
        }
    }

    default public void warning(String template, Object arg1, Object arg2) {
        if (this.isWarningEnabled()) {
            this.notifyWarning(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
        }
    }

    default public void warning(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isWarningEnabled()) {
            this.notifyWarning(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
        }
    }

    default public void warning(String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isWarningEnabled()) {
            this.notifyWarning(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})));
        }
    }

    default public void info(String message) {
        if (this.isInfoEnabled()) {
            this.notifyInfo(message);
        }
    }

    default public void info(String template, Object arg1) {
        if (this.isInfoEnabled()) {
            this.notifyInfo(this.format1(template, arg1));
        }
    }

    default public void info(String template, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.notifyInfo(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
        }
    }

    default public void info(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isInfoEnabled()) {
            this.notifyInfo(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
        }
    }

    default public void info(String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isInfoEnabled()) {
            this.notifyInfo(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})));
        }
    }

    default public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.notifyDebug(message);
        }
    }

    default public void debug(String template, Object arg1) {
        if (this.isDebugEnabled()) {
            this.notifyDebug(this.format1(template, arg1));
        }
    }

    default public void debug(String template, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.notifyDebug(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
        }
    }

    default public void debug(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isDebugEnabled()) {
            this.notifyDebug(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
        }
    }

    default public void debug(String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isDebugEnabled()) {
            this.notifyDebug(this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})));
        }
    }

    default public void log(int level, String message) {
        if (this.isEnabled(level)) {
            this.notifyLog(level, message);
        }
    }

    default public void log(int level, String template, Object arg1) {
        if (this.isEnabled(level)) {
            this.notifyLog(level, this.format1(template, arg1));
        }
    }

    default public void log(int level, String template, Object arg1, Object arg2) {
        if (this.isEnabled(level)) {
            this.notifyLog(level, this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
        }
    }

    default public void log(int level, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isEnabled(level)) {
            this.notifyLog(level, this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
        }
    }

    default public void log(int level, String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isEnabled(level)) {
            this.notifyLog(level, this.format(template, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})));
        }
    }

    default public boolean isEnabled(int level) {
        boolean bl;
        int n = level;
        Logging.LogLevel logLevel = new Logging.LogLevel(Logging$.MODULE$.ErrorLevel());
        Logging.LogLevel logLevel2 = new Logging.LogLevel(n);
        if (!(logLevel != null ? !((Object)logLevel).equals(logLevel2) : logLevel2 != null)) {
            bl = this.isErrorEnabled();
        } else {
            Logging.LogLevel logLevel3 = new Logging.LogLevel(Logging$.MODULE$.WarningLevel());
            Logging.LogLevel logLevel4 = new Logging.LogLevel(n);
            if (!(logLevel3 != null ? !((Object)logLevel3).equals(logLevel4) : logLevel4 != null)) {
                bl = this.isWarningEnabled();
            } else {
                Logging.LogLevel logLevel5 = new Logging.LogLevel(Logging$.MODULE$.InfoLevel());
                Logging.LogLevel logLevel6 = new Logging.LogLevel(n);
                if (!(logLevel5 != null ? !((Object)logLevel5).equals(logLevel6) : logLevel6 != null)) {
                    bl = this.isInfoEnabled();
                } else {
                    Logging.LogLevel logLevel7 = new Logging.LogLevel(Logging$.MODULE$.DebugLevel());
                    Logging.LogLevel logLevel8 = new Logging.LogLevel(n);
                    bl = !(logLevel7 != null ? !((Object)logLevel7).equals(logLevel8) : logLevel8 != null) ? this.isDebugEnabled() : false;
                }
            }
        }
        return bl;
    }

    default public void notifyLog(int level, String message) {
        int n = level;
        Logging.LogLevel logLevel = new Logging.LogLevel(Logging$.MODULE$.ErrorLevel());
        Logging.LogLevel logLevel2 = new Logging.LogLevel(n);
        if (!(logLevel != null ? !((Object)logLevel).equals(logLevel2) : logLevel2 != null)) {
            if (this.isErrorEnabled()) {
                this.notifyError(message);
            }
        } else {
            Logging.LogLevel logLevel3 = new Logging.LogLevel(Logging$.MODULE$.WarningLevel());
            Logging.LogLevel logLevel4 = new Logging.LogLevel(n);
            if (!(logLevel3 != null ? !((Object)logLevel3).equals(logLevel4) : logLevel4 != null)) {
                if (this.isWarningEnabled()) {
                    this.notifyWarning(message);
                }
            } else {
                Logging.LogLevel logLevel5 = new Logging.LogLevel(Logging$.MODULE$.InfoLevel());
                Logging.LogLevel logLevel6 = new Logging.LogLevel(n);
                if (!(logLevel5 != null ? !((Object)logLevel5).equals(logLevel6) : logLevel6 != null)) {
                    if (this.isInfoEnabled()) {
                        this.notifyInfo(message);
                    }
                } else {
                    Logging.LogLevel logLevel7 = new Logging.LogLevel(Logging$.MODULE$.DebugLevel());
                    Logging.LogLevel logLevel8 = new Logging.LogLevel(n);
                    if (!(logLevel7 != null ? !((Object)logLevel7).equals(logLevel8) : logLevel8 != null)) {
                        if (this.isDebugEnabled()) {
                            this.notifyDebug(message);
                        }
                    } else {
                        int level2 = n;
                        throw new IllegalArgumentException("Unsupported log level [" + new Logging.LogLevel(level2) + "]");
                    }
                }
            }
        }
    }

    private String format1(String t, Object arg) {
        String string;
        Object a;
        Object object = arg;
        if (ScalaRunTime$.MODULE$.isArray(object, 1) && !(a = object).getClass().getComponentType().isPrimitive()) {
            Object object2 = Predef$.MODULE$.genericArrayOps(a);
            string = this.formatImpl(t, (Seq<Object>)ArrayOps$.MODULE$.toSeq$extension(object2));
        } else if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object a2 = object;
            Object object3 = Predef$.MODULE$.genericArrayOps(a2);
            Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)_$4 -> _$4, ClassTag$.MODULE$.apply(Object.class)));
            string = this.formatImpl(t, (Seq<Object>)ArrayOps$.MODULE$.toSeq$extension(object4));
        } else {
            Object x = object;
            string = this.format(t, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{x}));
        }
        return string;
    }

    default public String format(String t, Seq<Object> arg) {
        return this.formatImpl(t, arg);
    }

    private String formatImpl(String t, Seq<Object> arg) {
        StringBuilder sb = new StringBuilder(64);
        int p = 0;
        int startIndex = 0;
        while (p < arg.length()) {
            int index = t.indexOf("{}", startIndex);
            if (index == -1) {
                sb.append(t.substring(startIndex, t.length())).append(" WARNING arguments left: ").append(arg.length() - p);
                p = arg.length();
                startIndex = t.length();
                continue;
            }
            sb.append(t.substring(startIndex, index)).append(arg.apply(p));
            startIndex = index + 2;
            ++p;
        }
        return sb.append(t.substring(startIndex, t.length())).toString();
    }
}

