/*
 * Decompiled with CFR 0.152.
 */
package akka.event;

import akka.ConfigurationException;
import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ActorSystemImpl;
import akka.actor.InternalActorRef;
import akka.actor.InvalidActorNameException;
import akka.actor.Props$;
import akka.actor.UnhandledMessage;
import akka.actor.UnhandledMessage$;
import akka.event.ActorEventBus;
import akka.event.Logging;
import akka.event.Logging$;
import akka.event.Logging$Debug$;
import akka.event.Logging$Error$;
import akka.event.Logging$InitializeLogger$;
import akka.event.Logging$LogExt$;
import akka.event.Logging$LogLevel$;
import akka.event.Logging$LoggerInitialized$;
import akka.event.Logging$Warning$;
import akka.event.LoggingBus$;
import akka.pattern.AskableActorRef$;
import akka.util.ReentrantGuard;
import akka.util.Timeout;
import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface LoggingBus
extends ActorEventBus {
    default public void $init$() {
    }

    public ReentrantGuard akka$event$LoggingBus$$guard();

    default public ReentrantGuard akka$event$LoggingBus$$initial$guard() {
        return new ReentrantGuard();
    }

    public Seq<ActorRef> akka$event$LoggingBus$$loggers();

    default public Seq akka$event$LoggingBus$$initial$loggers() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public void akka$event$LoggingBus$$loggers_$eq(Seq<ActorRef> var1);

    public int akka$event$LoggingBus$$_logLevel();

    default public int akka$event$LoggingBus$$initial$_logLevel() {
        return 0;
    }

    public void akka$event$LoggingBus$$_logLevel_$eq(int var1);

    default public int logLevel() {
        return this.akka$event$LoggingBus$$_logLevel();
    }

    default public void setLogLevel(int level) {
        this.akka$event$LoggingBus$$guard().withGuard(() -> this.setLogLevel$$anonfun$1(level));
    }

    private void setUpStdoutLogger(ActorSystem.Settings config) {
        Object object = Logging$.MODULE$.levelFor(config.StdoutLogLevel()).getOrElse((Function0)((JFunction0 & Serializable)() -> this.$anonfun$adapted$1(config)));
        int level = object == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)object).asInt();
        ((IterableOnceOps)Logging$.MODULE$.AllLogLevels().filter((Function1)((JFunction1 & Serializable)arg_0 -> LoggingBus.setUpStdoutLogger$$anonfun$adapted$1(level, arg_0)))).foreach((Function1)((JFunction1 & Serializable)this::setUpStdoutLogger$$anonfun$adapted$2));
        this.akka$event$LoggingBus$$guard().withGuard(() -> this.setUpStdoutLogger$$anonfun$1(level));
    }

    default public void startStdoutLogger(ActorSystem.Settings config) {
        this.setUpStdoutLogger(config);
        this.publish(Logging$Debug$.MODULE$.apply(Logging$.MODULE$.simpleName(this), this.getClass(), "StandardOutLogger started"));
    }

    default public void startDefaultLoggers(ActorSystemImpl system) {
        String logName = Logging$.MODULE$.simpleName(this) + "(" + system + ")";
        Object object = Logging$.MODULE$.levelFor(system.settings().LogLevel()).getOrElse((Function0)((JFunction0 & Serializable)() -> this.$anonfun$adapted$2(system, logName)));
        int level = object == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)object).asInt();
        try {
            List list;
            List list2 = system.settings().Loggers();
            Nil$ nil$ = package$.MODULE$.Nil();
            List list3 = list2;
            if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                String string = Logging.DefaultLogger.class.getName();
                list = package$.MODULE$.Nil().$colon$colon((Object)string);
            } else {
                List loggers;
                list = loggers = list2;
            }
            List defaultLoggers = list;
            Seq myloggers = (Seq)defaultLoggers.withFilter((Function1)(JFunction1 & Serializable)loggerName -> {
                String string = loggerName;
                String string2 = Logging$.MODULE$.StandardOutLogger().getClass().getName();
                return string == null ? string2 != null : !string.equals(string2);
            }).map((Function1)(JFunction1 & Serializable)loggerName -> (ActorRef)system.dynamicAccess().getClassFor((String)loggerName, ClassTag$.MODULE$.apply(Actor.class)).map((Function1)(JFunction1 & Serializable)actorClass -> this.addLogger(system, (Class<? extends Actor>)actorClass, level, logName)).recover((PartialFunction)new Serializable((String)loggerName){
                private final String loggerName$1;
                {
                    this.loggerName$1 = loggerName$2;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    throw new ConfigurationException("Logger specified in config can't be loaded [" + this.loggerName$1 + "] due to [" + e.toString() + "]", e);
                }
            }).get());
            this.akka$event$LoggingBus$$guard().withGuard(() -> this.startDefaultLoggers$$anonfun$1(level, myloggers));
            try {
                if (system.settings().DebugUnhandledMessage()) {
                    this.subscribe(system.systemActorOf(Props$.MODULE$.apply(this::startDefaultLoggers$$anonfun$2, ClassTag$.MODULE$.apply(Actor.class)), "UnhandledMessageForwarder"), UnhandledMessage.class);
                }
            }
            catch (InvalidActorNameException invalidActorNameException) {}
            this.publish(Logging$Debug$.MODULE$.apply(logName, this.getClass(), "Default Loggers started"));
            if (!defaultLoggers.contains((Object)Logging$.MODULE$.StandardOutLogger().getClass().getName())) {
                this.unsubscribe(Logging$.MODULE$.StandardOutLogger());
            }
        }
        catch (Exception e) {
            System.err.println("error while starting up loggers");
            e.printStackTrace();
            throw new ConfigurationException("Could not start logger due to [" + e.toString() + "]");
        }
    }

    default public void stopDefaultLoggers(ActorSystem system) {
        int level = this.akka$event$LoggingBus$$_logLevel();
        if (!this.akka$event$LoggingBus$$loggers().contains((Object)Logging$.MODULE$.StandardOutLogger())) {
            this.setUpStdoutLogger(system.settings());
            this.publish(Logging$Debug$.MODULE$.apply(Logging$.MODULE$.simpleName(this), this.getClass(), "shutting down: StandardOutLogger"));
        }
        this.akka$event$LoggingBus$$loggers().withFilter((Function1)(JFunction1 & Serializable)logger -> {
            ActorRef actorRef = logger;
            Logging.StandardOutLogger standardOutLogger = Logging$.MODULE$.StandardOutLogger();
            return actorRef == null ? standardOutLogger != null : !((Object)actorRef).equals(standardOutLogger);
        }).foreach((Function1)(JProcedure1 & Serializable)logger -> {
            block0: {
                this.unsubscribe(logger);
                ActorRef actorRef = logger;
                if (!(actorRef instanceof InternalActorRef)) break block0;
                InternalActorRef ref = (InternalActorRef)actorRef;
                ref.stop();
            }
        });
        this.publish(Logging$Debug$.MODULE$.apply(Logging$.MODULE$.simpleName(this), this.getClass(), "all default loggers stopped"));
    }

    private ActorRef addLogger(ActorSystemImpl system, Class<? extends Actor> clazz, int level, String logName) {
        Object response;
        Object object;
        String name = "log" + ((Logging.LogExt)Logging$LogExt$.MODULE$.apply(system)).id() + "-" + Logging$.MODULE$.simpleName(clazz);
        ActorRef actor = system.systemActorOf(Props$.MODULE$.apply(clazz, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])).withDispatcher(system.settings().LoggersDispatcher()), name);
        try {
            ActorRef actorRef = akka.pattern.package$.MODULE$.ask(actor);
            Logging.InitializeLogger initializeLogger = Logging$InitializeLogger$.MODULE$.apply(this);
            object = Await$.MODULE$.result(AskableActorRef$.MODULE$.$qmark$extension(actorRef, initializeLogger, LoggingBus.timeout$1(system), AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, initializeLogger)), (Duration)LoggingBus.timeout$1(system).duration());
        }
        catch (TimeoutException timeoutException) {
            this.publish(Logging$Warning$.MODULE$.apply(logName, this.getClass(), "Logger " + name + " did not respond within " + LoggingBus.timeout$1(system) + " to InitializeLogger(bus)"));
            object = "[TIMEOUT]";
        }
        Object object2 = response = object;
        Logging$LoggerInitialized$ logging$LoggerInitialized$ = Logging$LoggerInitialized$.MODULE$;
        if (object2 == null ? logging$LoggerInitialized$ != null : !object2.equals(logging$LoggerInitialized$)) {
            throw new Logging.LoggerInitializationException("Logger " + name + " did not respond with LoggerInitialized, sent instead " + response);
        }
        ((IterableOnceOps)Logging$.MODULE$.AllLogLevels().filter((Function1)((JFunction1 & Serializable)arg_0 -> LoggingBus.addLogger$$anonfun$adapted$1(level, arg_0)))).foreach((Function1)((JFunction1 & Serializable)arg_0 -> this.addLogger$$anonfun$adapted$2(actor, arg_0)));
        this.publish(Logging$Debug$.MODULE$.apply(logName, this.getClass(), "logger " + name + " started"));
        return actor;
    }

    private static /* synthetic */ boolean setLogLevel$$anonfun$2$$anonfun$1(int level$1, int logLvl$1, int l) {
        return Logging$LogLevel$.MODULE$.$greater$extension(l, logLvl$1) && Logging$LogLevel$.MODULE$.$less$eq$extension(l, level$1);
    }

    private static boolean setLogLevel$$anonfun$3$$anonfun$adapted$1(int level$10, int logLvl$3, Object l) {
        return LoggingBus.setLogLevel$$anonfun$2$$anonfun$1(level$10, logLvl$3, l == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)l).asInt());
    }

    private /* synthetic */ void setLogLevel$$anonfun$5$$anonfun$3(int l) {
        this.akka$event$LoggingBus$$loggers().foreach((Function1)(JFunction1 & Serializable)log -> this.subscribe(log, Logging$.MODULE$.classFor(l)));
    }

    private void setLogLevel$$anonfun$6$$anonfun$adapted$2(Object l) {
        this.setLogLevel$$anonfun$5$$anonfun$3(l == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)l).asInt());
    }

    private static /* synthetic */ boolean setLogLevel$$anonfun$7$$anonfun$4(int level$3, int logLvl$2, int l) {
        return Logging$LogLevel$.MODULE$.$less$eq$extension(l, logLvl$2) && Logging$LogLevel$.MODULE$.$greater$extension(l, level$3);
    }

    private static boolean setLogLevel$$anonfun$8$$anonfun$adapted$3(int level$11, int logLvl$4, Object l) {
        return LoggingBus.setLogLevel$$anonfun$7$$anonfun$4(level$11, logLvl$4, l == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)l).asInt());
    }

    private /* synthetic */ void setLogLevel$$anonfun$10$$anonfun$6(int l) {
        this.akka$event$LoggingBus$$loggers().foreach((Function1)(JFunction1 & Serializable)log -> this.unsubscribe(log, Logging$.MODULE$.classFor(l)));
    }

    private void setLogLevel$$anonfun$11$$anonfun$adapted$4(Object l) {
        this.setLogLevel$$anonfun$10$$anonfun$6(l == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)l).asInt());
    }

    private void setLogLevel$$anonfun$1(int level$2) {
        int logLvl = this.akka$event$LoggingBus$$_logLevel();
        Logging$.MODULE$.AllLogLevels().withFilter((Function1)((JFunction1 & Serializable)arg_0 -> LoggingBus.setLogLevel$$anonfun$3$$anonfun$adapted$1(level$2, logLvl, arg_0))).foreach((Function1)((JProcedure1 & Serializable)this::setLogLevel$$anonfun$6$$anonfun$adapted$2));
        Logging$.MODULE$.AllLogLevels().withFilter((Function1)((JFunction1 & Serializable)arg_0 -> LoggingBus.setLogLevel$$anonfun$8$$anonfun$adapted$3(level$2, logLvl, arg_0))).foreach((Function1)((JProcedure1 & Serializable)this::setLogLevel$$anonfun$11$$anonfun$adapted$4));
        this.akka$event$LoggingBus$$_logLevel_$eq(level$2);
    }

    private int $anonfun$3(ActorSystem.Settings config$1) {
        Logging$.MODULE$.StandardOutLogger().print(Logging$Error$.MODULE$.apply(new Logging.LoggerException(), Logging$.MODULE$.simpleName(this), this.getClass(), "unknown akka.stdout-loglevel " + config$1.StdoutLogLevel()));
        return Logging$.MODULE$.ErrorLevel();
    }

    private Object $anonfun$adapted$1(ActorSystem.Settings config$2) {
        return new Logging.LogLevel(this.$anonfun$3(config$2));
    }

    private static boolean setUpStdoutLogger$$anonfun$adapted$1(int level$12, Object _$2) {
        return Logging$LogLevel$.MODULE$.$greater$eq$extension(level$12, _$2 == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)_$2).asInt());
    }

    private /* synthetic */ boolean setUpStdoutLogger$$anonfun$3(int l) {
        return this.subscribe(Logging$.MODULE$.StandardOutLogger(), Logging$.MODULE$.classFor(l));
    }

    private boolean setUpStdoutLogger$$anonfun$adapted$2(Object l) {
        return this.setUpStdoutLogger$$anonfun$3(l == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)l).asInt());
    }

    private void setUpStdoutLogger$$anonfun$1(int level$5) {
        this.akka$event$LoggingBus$$loggers_$eq((Seq<ActorRef>)((Seq)this.akka$event$LoggingBus$$loggers().$colon$plus((Object)Logging$.MODULE$.StandardOutLogger())));
        this.akka$event$LoggingBus$$_logLevel_$eq(level$5);
    }

    private int $anonfun$4(ActorSystemImpl system$1, String logName$1) {
        Logging$.MODULE$.StandardOutLogger().print(Logging$Error$.MODULE$.apply(new Logging.LoggerException(), logName$1, this.getClass(), "unknown akka.loglevel " + system$1.settings().LogLevel()));
        return Logging$.MODULE$.ErrorLevel();
    }

    private Object $anonfun$adapted$2(ActorSystemImpl system$6, String logName$4) {
        return new Logging.LogLevel(this.$anonfun$4(system$6, logName$4));
    }

    private void startDefaultLoggers$$anonfun$1(int level$8, Seq myloggers$1) {
        this.akka$event$LoggingBus$$loggers_$eq((Seq<ActorRef>)myloggers$1);
        this.akka$event$LoggingBus$$_logLevel_$eq(level$8);
    }

    private Actor startDefaultLoggers$$anonfun$2() {
        return new Actor(this){
            private final ActorContext context;
            private final ActorRef self;
            private final LoggingBus $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.context = Actor.super.initial$context();
                this.self = Actor.super.initial$self();
                Actor.super.$init$();
            }

            public ActorContext context() {
                return this.context;
            }

            public final ActorRef self() {
                return this.self;
            }

            public PartialFunction receive() {
                return new Serializable(this){
                    private final $anon$3 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Object x) {
                        boolean bl;
                        Object object = x;
                        if (object instanceof UnhandledMessage) {
                            UnhandledMessage unhandledMessage = UnhandledMessage$.MODULE$.unapply((UnhandledMessage)object);
                            Object object2 = unhandledMessage._1();
                            ActorRef actorRef = unhandledMessage._2();
                            ActorRef actorRef2 = unhandledMessage._3();
                            Object msg = object2;
                            ActorRef sender = actorRef;
                            ActorRef rcp = actorRef2;
                            bl = true;
                        } else {
                            bl = false;
                        }
                        return bl;
                    }

                    public final Object applyOrElse(Object x, Function1 function1) {
                        Object object;
                        Object object2 = x;
                        if (object2 instanceof UnhandledMessage) {
                            UnhandledMessage unhandledMessage = UnhandledMessage$.MODULE$.unapply((UnhandledMessage)object2);
                            Object object3 = unhandledMessage._1();
                            ActorRef actorRef = unhandledMessage._2();
                            ActorRef actorRef2 = unhandledMessage._3();
                            Object msg = object3;
                            ActorRef sender = actorRef;
                            ActorRef rcp = actorRef2;
                            this.$outer.akka$event$LoggingBus$_$_$$anon$$$outer().publish(Logging$Debug$.MODULE$.apply(rcp.path().toString(), rcp.getClass(), "unhandled message from " + sender + ": " + msg));
                            object = BoxedUnit.UNIT;
                        } else {
                            object = function1.apply(x);
                        }
                        return object;
                    }
                };
            }

            public final LoggingBus akka$event$LoggingBus$_$_$$anon$$$outer() {
                return this.$outer;
            }
        };
    }

    private static Timeout timeout$1(ActorSystemImpl system$4) {
        return system$4.settings().LoggerStartTimeout();
    }

    private static boolean addLogger$$anonfun$adapted$1(int level$13, Object _$3) {
        return Logging$LogLevel$.MODULE$.$greater$eq$extension(level$13, _$3 == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)_$3).asInt());
    }

    private /* synthetic */ boolean addLogger$$anonfun$2(ActorRef actor$1, int l) {
        return this.subscribe(actor$1, Logging$.MODULE$.classFor(l));
    }

    private boolean addLogger$$anonfun$adapted$2(ActorRef actor$2, Object l) {
        return this.addLogger$$anonfun$2(actor$2, l == null ? BoxesRunTime.unboxToInt(null) : ((Logging.LogLevel)l).asInt());
    }
}

