/*
 * Decompiled with CFR 0.152.
 */
package akka.event;

import akka.actor.AbstractActor;
import akka.actor.Actor;
import akka.actor.ActorCell;
import akka.actor.ActorContext;
import akka.actor.DiagnosticActorLogging;
import akka.event.LogSource$;
import akka.event.Logging;
import akka.event.Logging$;
import akka.event.Logging$LogEvent$;
import akka.event.Logging$LogLevel$;
import akka.event.LoggingReceive$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;

public class LoggingReceive
implements PartialFunction<Object, BoxedUnit> {
    private final Option<Object> source;
    private final PartialFunction r;
    private final Option<String> label;
    private final int logLevel;
    private final ActorContext context;

    public static AbstractActor.Receive create(AbstractActor.Receive receive, AbstractActor.ActorContext actorContext) {
        return LoggingReceive$.MODULE$.create(receive, actorContext);
    }

    public static PartialFunction withLabel(String string, int n, PartialFunction partialFunction, ActorContext actorContext) {
        return LoggingReceive$.MODULE$.withLabel(string, n, partialFunction, actorContext);
    }

    public static PartialFunction withLabel(String string, PartialFunction partialFunction, ActorContext actorContext) {
        return LoggingReceive$.MODULE$.withLabel(string, partialFunction, actorContext);
    }

    public LoggingReceive(Option<Object> source, PartialFunction<Object, BoxedUnit> r, Option<String> label, int logLevel, ActorContext context) {
        this.source = source;
        this.r = r;
        this.label = label;
        this.logLevel = logLevel;
        this.context = context;
        PartialFunction.$init$((PartialFunction)this);
    }

    public LoggingReceive(Option<Object> source, PartialFunction<Object, BoxedUnit> r, Option<String> label, ActorContext context) {
        this(source, r, label, Logging$.MODULE$.DebugLevel(), context);
    }

    public LoggingReceive(Option<Object> source, PartialFunction<Object, BoxedUnit> r, ActorContext context) {
        this(source, r, (Option<String>)None$.MODULE$, Logging$.MODULE$.DebugLevel(), context);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isDefinedAt(Object o) {
        void var2_2;
        boolean handled = this.r.isDefinedAt(o);
        if (Logging$LogLevel$.MODULE$.$greater$eq$extension(this.context.system().eventStream().logLevel(), this.logLevel)) {
            Logging.LogEvent logEvent;
            String string;
            Object src = this.source.getOrElse(this::$anonfun$1);
            Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.fromAnyRef(src);
            if (!(tuple2 instanceof Tuple2)) {
                throw new MatchError(tuple2);
            }
            Tuple2<String, Class<?>> tuple22 = tuple2;
            String str = (String)tuple22._1();
            Class clazz = (Class)tuple22._2();
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)str, (Object)clazz);
            String str2 = (String)tuple23._1();
            Class clazz2 = (Class)tuple23._2();
            StringBuilder stringBuilder = new StringBuilder().append("received ").append(handled ? "handled" : "unhandled").append(" message ").append(o).append(" from ").append(this.context.sender());
            Option<String> option = this.label;
            if (option instanceof Some) {
                String l = (String)((Some)option).value();
                string = " in state " + l;
            } else {
                string = "";
            }
            String message = stringBuilder.append(string).toString();
            Object object = src;
            if (object instanceof DiagnosticActorLogging) {
                DiagnosticActorLogging a = (DiagnosticActorLogging)object;
                logEvent = Logging$LogEvent$.MODULE$.apply(this.logLevel, str2, clazz2, message, (Map<String, Object>)a.log().mdc());
            } else {
                logEvent = Logging$LogEvent$.MODULE$.apply(this.logLevel, str2, clazz2, message);
            }
            Logging.LogEvent event = logEvent;
            this.context.system().eventStream().publish(event);
        }
        return (boolean)var2_2;
    }

    public void apply(Object o) {
        this.r.apply(o);
    }

    private final Actor $anonfun$1() {
        return ((ActorCell)this.context).actor();
    }
}

