/*
 * Decompiled with CFR 0.152.
 */
package akka.event;

import akka.event.BusLogging;
import akka.event.DefaultLoggingFilter;
import akka.event.LogMarker;
import akka.event.Logging;
import akka.event.Logging$;
import akka.event.Logging$Debug$;
import akka.event.Logging$Error$;
import akka.event.Logging$Info$;
import akka.event.Logging$Warning$;
import akka.event.LoggingBus;
import akka.event.LoggingFilter;
import akka.event.LoggingFilterWithMarker;
import akka.event.LoggingFilterWithMarker$;
import dotty.runtime.function.JFunction0;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public class MarkerLoggingAdapter
extends BusLogging {
    private final LoggingBus bus;
    private final String logSource;
    private final Class logClass;
    private final LoggingFilterWithMarker loggingFilterWithMarker;

    public MarkerLoggingAdapter(LoggingBus bus, String logSource, Class<?> logClass, LoggingFilter loggingFilter) {
        this.bus = bus;
        this.logSource = logSource;
        this.logClass = logClass;
        super(bus, logSource, logClass, loggingFilter);
        this.loggingFilterWithMarker = LoggingFilterWithMarker$.MODULE$.wrap(loggingFilter);
    }

    @Override
    public LoggingBus bus() {
        return this.bus;
    }

    @Override
    public String logSource() {
        return this.logSource;
    }

    @Override
    public Class<?> logClass() {
        return this.logClass;
    }

    public MarkerLoggingAdapter(LoggingBus bus, String logSource, Class<?> logClass) {
        this(bus, logSource, logClass, MarkerLoggingAdapter.MarkerLoggingAdapter$superArg$1(bus, logSource, logClass));
    }

    public LoggingFilterWithMarker loggingFilterWithMarker() {
        return this.loggingFilterWithMarker;
    }

    public boolean isErrorEnabled(LogMarker marker) {
        return this.loggingFilterWithMarker().isErrorEnabled(this.logClass(), this.logSource(), marker);
    }

    public boolean isWarningEnabled(LogMarker marker) {
        return this.loggingFilterWithMarker().isWarningEnabled(this.logClass(), this.logSource(), marker);
    }

    public boolean isInfoEnabled(LogMarker marker) {
        return this.loggingFilterWithMarker().isInfoEnabled(this.logClass(), this.logSource(), marker);
    }

    public boolean isDebugEnabled(LogMarker marker) {
        return this.loggingFilterWithMarker().isDebugEnabled(this.logClass(), this.logSource(), marker);
    }

    public void error(LogMarker marker, Throwable cause, String message) {
        if (this.isErrorEnabled(marker)) {
            this.bus().publish(Logging$Error$.MODULE$.apply(cause, this.logSource(), this.logClass(), message, (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void error(LogMarker marker, Throwable cause, String template, Object arg1) {
        if (this.isErrorEnabled(marker)) {
            this.bus().publish(Logging$Error$.MODULE$.apply(cause, this.logSource(), this.logClass(), this.format1(template, arg1), (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void error(LogMarker marker, Throwable cause, String template, Object arg1, Object arg2) {
        if (this.isErrorEnabled(marker)) {
            this.bus().publish(Logging$Error$.MODULE$.apply(cause, this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})), (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void error(LogMarker marker, Throwable cause, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isErrorEnabled(marker)) {
            this.bus().publish(Logging$Error$.MODULE$.apply(cause, this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})), (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void error(LogMarker marker, Throwable cause, String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isErrorEnabled(marker)) {
            this.bus().publish(Logging$Error$.MODULE$.apply(cause, this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})), (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void error(LogMarker marker, String message) {
        if (this.isErrorEnabled(marker)) {
            this.bus().publish(Logging$Error$.MODULE$.apply(this.logSource(), this.logClass(), message, (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void error(LogMarker marker, String template, Object arg1) {
        if (this.isErrorEnabled(marker)) {
            this.bus().publish(Logging$Error$.MODULE$.apply(this.logSource(), this.logClass(), this.format1(template, arg1), (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void error(LogMarker marker, String template, Object arg1, Object arg2) {
        if (this.isErrorEnabled(marker)) {
            this.bus().publish(Logging$Error$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})), (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void error(LogMarker marker, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isErrorEnabled(marker)) {
            this.bus().publish(Logging$Error$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})), (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void error(LogMarker marker, String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isErrorEnabled(marker)) {
            this.bus().publish(Logging$Error$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})), (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void warning(LogMarker marker, String message) {
        if (this.isWarningEnabled(marker)) {
            this.bus().publish(Logging$Warning$.MODULE$.apply(this.logSource(), this.logClass(), message, (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void warning(LogMarker marker, String template, Object arg1) {
        if (this.isWarningEnabled(marker)) {
            this.bus().publish(Logging$Warning$.MODULE$.apply(this.logSource(), this.logClass(), this.format1(template, arg1), (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void warning(LogMarker marker, String template, Object arg1, Object arg2) {
        if (this.isWarningEnabled(marker)) {
            this.bus().publish(Logging$Warning$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})), (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void warning(LogMarker marker, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isWarningEnabled(marker)) {
            this.bus().publish(Logging$Warning$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})), (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void warning(LogMarker marker, String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isWarningEnabled(marker)) {
            this.bus().publish(Logging$Warning$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})), (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void info(LogMarker marker, String message) {
        if (this.isInfoEnabled(marker)) {
            this.bus().publish(Logging$Info$.MODULE$.apply(this.logSource(), this.logClass(), message, (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void info(LogMarker marker, String template, Object arg1) {
        if (this.isInfoEnabled(marker)) {
            this.bus().publish(Logging$Info$.MODULE$.apply(this.logSource(), this.logClass(), this.format1(template, arg1), (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void info(LogMarker marker, String template, Object arg1, Object arg2) {
        if (this.isInfoEnabled(marker)) {
            this.bus().publish(Logging$Info$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})), (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void info(LogMarker marker, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isInfoEnabled(marker)) {
            this.bus().publish(Logging$Info$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})), (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void info(LogMarker marker, String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isInfoEnabled(marker)) {
            this.bus().publish(Logging$Info$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})), (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void debug(LogMarker marker, String message) {
        if (this.isDebugEnabled(marker)) {
            this.bus().publish(Logging$Debug$.MODULE$.apply(this.logSource(), this.logClass(), message, (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void debug(LogMarker marker, String template, Object arg1) {
        if (this.isDebugEnabled(marker)) {
            this.bus().publish(Logging$Debug$.MODULE$.apply(this.logSource(), this.logClass(), this.format1(template, arg1), (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void debug(LogMarker marker, String template, Object arg1, Object arg2) {
        if (this.isDebugEnabled(marker)) {
            this.bus().publish(Logging$Debug$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})), (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void debug(LogMarker marker, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isDebugEnabled(marker)) {
            this.bus().publish(Logging$Debug$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})), (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void debug(LogMarker marker, String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isDebugEnabled(marker)) {
            this.bus().publish(Logging$Debug$.MODULE$.apply(this.logSource(), this.logClass(), this.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3, arg4})), (Map<String, Object>)this.mdc(), marker));
        }
    }

    public void log(LogMarker marker, int level, String message) {
        block1: {
            int n;
            block3: {
                block2: {
                    block0: {
                        n = level;
                        Logging.LogLevel logLevel = new Logging.LogLevel(Logging$.MODULE$.DebugLevel());
                        Logging.LogLevel logLevel2 = new Logging.LogLevel(n);
                        if (logLevel != null ? !((Object)logLevel).equals(logLevel2) : logLevel2 != null) break block0;
                        this.debug(marker, message);
                        break block1;
                    }
                    Logging.LogLevel logLevel = new Logging.LogLevel(Logging$.MODULE$.InfoLevel());
                    Logging.LogLevel logLevel3 = new Logging.LogLevel(n);
                    if (logLevel != null ? !((Object)logLevel).equals(logLevel3) : logLevel3 != null) break block2;
                    this.info(marker, message);
                    break block1;
                }
                Logging.LogLevel logLevel = new Logging.LogLevel(Logging$.MODULE$.WarningLevel());
                Logging.LogLevel logLevel4 = new Logging.LogLevel(n);
                if (logLevel != null ? !((Object)logLevel).equals(logLevel4) : logLevel4 != null) break block3;
                this.warning(marker, message);
                break block1;
            }
            Logging.LogLevel logLevel = new Logging.LogLevel(Logging$.MODULE$.ErrorLevel());
            Logging.LogLevel logLevel5 = new Logging.LogLevel(n);
            if (logLevel != null ? !((Object)logLevel).equals(logLevel5) : logLevel5 != null) break block1;
            this.error(marker, message);
        }
    }

    private String format1(String t, Object arg) {
        String string;
        Object a;
        Object object = arg;
        if (ScalaRunTime$.MODULE$.isArray(object, 1) && !(a = object).getClass().getComponentType().isPrimitive()) {
            Object[] objectArray = new Object[1];
            Object object2 = Predef$.MODULE$.genericArrayOps(a);
            objectArray[0] = ArrayOps$.MODULE$.toIndexedSeq$extension(object2);
            string = this.format(t, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray));
        } else if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object a2 = object;
            Object[] objectArray = new Object[1];
            Object object3 = Predef$.MODULE$.genericArrayOps(a2);
            Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)_$5 -> _$5, ClassTag$.MODULE$.apply(Object.class)));
            objectArray[0] = ArrayOps$.MODULE$.toIndexedSeq$extension(object4);
            string = this.format(t, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray));
        } else {
            Object x = object;
            string = this.format(t, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{x}));
        }
        return string;
    }

    private static DefaultLoggingFilter MarkerLoggingAdapter$superArg$1(LoggingBus bus, String logSource, Class<?> logClass) {
        return new DefaultLoggingFilter((Function0<Logging.LogLevel>)((JFunction0 & Serializable)() -> MarkerLoggingAdapter.MarkerLoggingAdapter$superArg$1$$anonfun$adapted$1(bus)));
    }

    private static final Object MarkerLoggingAdapter$superArg$1$$anonfun$adapted$1(LoggingBus bus$3) {
        return new Logging.LogLevel(bus$3.logLevel());
    }
}

