/*
 * Decompiled with CFR 0.152.
 */
package akka.io;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ActorRef$;
import akka.actor.Status$Failure$;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.io.Dns;
import akka.io.Dns$Resolve$;
import akka.io.Dns$Resolved$;
import akka.io.SimpleDnsCache;
import akka.io.dns.AAAARecord$;
import akka.io.dns.ARecord$;
import akka.io.dns.CachePolicy;
import akka.io.dns.CachePolicy$Forever$;
import akka.io.dns.CachePolicy$Never$;
import akka.io.dns.CachePolicy$Ttl$;
import akka.io.dns.DnsProtocol;
import akka.io.dns.DnsProtocol$Ip$;
import akka.io.dns.DnsProtocol$Resolve$;
import akka.io.dns.DnsProtocol$Resolved$;
import akka.io.dns.DnsProtocol$Srv$;
import akka.io.dns.ResourceRecord;
import akka.util.Helpers$;
import akka.util.Helpers$Requiring$;
import com.typesafe.config.Config;
import dotty.runtime.LazyVals$;
import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JFunction1;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Security;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@InternalApi
public class InetAddressDnsResolver
implements Actor,
ActorLogging {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(InetAddressDnsResolver.class, "bitmap$0");
    private final ActorContext context;
    private final ActorRef self;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    public long bitmap$0;
    public final SimpleDnsCache akka$io$InetAddressDnsResolver$$cache;
    private final Config config;
    private CachePolicy.Ttl DefaultPositive;
    private CachePolicy.CachePolicy defaultCachePolicy$lzy1;
    private CachePolicy.CachePolicy defaultNegativeCachePolicy$lzy1;
    private final CachePolicy.CachePolicy positiveCachePolicy;
    private final CachePolicy.CachePolicy negativeCachePolicy;
    private final long positiveTtl;
    private final long negativeTtl;

    public InetAddressDnsResolver(SimpleDnsCache cache, Config config) {
        this.akka$io$InetAddressDnsResolver$$cache = cache;
        this.config = config;
        this.context = Actor.super.initial$context();
        this.self = Actor.super.initial$self();
        this.akka$actor$ActorLogging$$_log = ActorLogging.super.akka$actor$ActorLogging$$initial$_log();
        ActorLogging.super.$init$();
        String CachePolicyProp = "networkaddress.cache.ttl";
        String CachePolicyPropFallback = "sun.net.inetaddr.ttl";
        String NegativeCachePolicyProp = "networkaddress.cache.negative.ttl";
        String NegativeCachePolicyPropFallback = "sun.net.inetaddr.negative.ttl";
        this.DefaultPositive = CachePolicy$Ttl$.MODULE$.fromPositive(new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds());
        this.positiveCachePolicy = this.getTtl("positive-ttl", true);
        this.negativeCachePolicy = this.getTtl("negative-ttl", false);
        this.positiveTtl = this.toLongTtl(this.positiveCachePolicy());
        this.negativeTtl = this.toLongTtl(this.negativeCachePolicy());
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CachePolicy.CachePolicy defaultCachePolicy() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    CachePolicy.CachePolicy cachePolicy;
                    Option option = Option$.MODULE$.apply((Object)Security.getProperty("networkaddress.cache.ttl")).filter((Function1)(JFunction1 & Serializable)_$1 -> {
                        String string = _$1;
                        String string2 = "";
                        return string == null ? string2 != null : !string.equals(string2);
                    }).orElse(InetAddressDnsResolver::defaultCachePolicy$$anonfun$2).filter((Function1)(JFunction1 & Serializable)_$2 -> {
                        String string = _$2;
                        String string2 = "";
                        return string == null ? string2 != null : !string.equals(string2);
                    }).map((Function1)(JFunction1 & Serializable)x -> Try$.MODULE$.apply((Function0)((JFunction0.mcI.sp & Serializable)() -> InetAddressDnsResolver.defaultCachePolicy$$anonfun$5$$anonfun$1(x))));
                    if (None$.MODULE$.equals(option)) {
                        cachePolicy = this.DefaultPositive;
                    } else {
                        if (!(option instanceof Some)) throw new MatchError((Object)option);
                        Try try_ = (Try)((Some)option).value();
                        if (try_ instanceof Success) {
                            int n = BoxesRunTime.unboxToInt((Object)((Success)try_).value());
                            cachePolicy = this.parsePolicy(n);
                        } else {
                            if (!(try_ instanceof Failure)) throw new MatchError((Object)option);
                            this.log().warning("Caching TTL misconfigured. Using default value {}.", this.DefaultPositive);
                            cachePolicy = this.DefaultPositive;
                        }
                    }
                    CachePolicy.Ttl ttl = cachePolicy;
                    this.defaultCachePolicy$lzy1 = ttl;
                    this.DefaultPositive = null;
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return ttl;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.defaultCachePolicy$lzy1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CachePolicy.CachePolicy defaultNegativeCachePolicy() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 1)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 1)) continue;
                try {
                    CachePolicy.CachePolicy cachePolicy;
                    Option option = Option$.MODULE$.apply((Object)Security.getProperty("networkaddress.cache.negative.ttl")).filter((Function1)(JFunction1 & Serializable)_$3 -> {
                        String string = _$3;
                        String string2 = "";
                        return string == null ? string2 != null : !string.equals(string2);
                    }).orElse(InetAddressDnsResolver::defaultNegativeCachePolicy$$anonfun$2).filter((Function1)(JFunction1 & Serializable)_$4 -> {
                        String string = _$4;
                        String string2 = "";
                        return string == null ? string2 != null : !string.equals(string2);
                    }).map((Function1)(JFunction1 & Serializable)x -> Try$.MODULE$.apply((Function0)((JFunction0.mcI.sp & Serializable)() -> InetAddressDnsResolver.defaultNegativeCachePolicy$$anonfun$5$$anonfun$1(x))));
                    if (None$.MODULE$.equals(option)) {
                        cachePolicy = CachePolicy$Never$.MODULE$;
                    } else {
                        if (!(option instanceof Some)) throw new MatchError((Object)option);
                        Try try_ = (Try)((Some)option).value();
                        if (try_ instanceof Success) {
                            int n = BoxesRunTime.unboxToInt((Object)((Success)try_).value());
                            cachePolicy = this.parsePolicy(n);
                        } else {
                            if (!(try_ instanceof Failure)) throw new MatchError((Object)option);
                            this.log().warning("Negative caching TTL misconfigured. Using default value {}.", CachePolicy$Never$.MODULE$);
                            cachePolicy = CachePolicy$Never$.MODULE$;
                        }
                    }
                    CachePolicy$Never$ cachePolicy$Never$ = cachePolicy;
                    this.defaultNegativeCachePolicy$lzy1 = cachePolicy$Never$;
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 1);
                    return cachePolicy$Never$;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 1);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 1);
        }
        return this.defaultNegativeCachePolicy$lzy1;
    }

    private CachePolicy.CachePolicy parsePolicy(int n) {
        CachePolicy.CachePolicy cachePolicy;
        int n2 = n;
        if (0 == n2) {
            cachePolicy = CachePolicy$Never$.MODULE$;
        } else {
            int x = n2;
            if (x < 0) {
                cachePolicy = CachePolicy$Forever$.MODULE$;
            } else {
                int x2 = n2;
                cachePolicy = CachePolicy$Ttl$.MODULE$.fromPositive(new package.DurationInt(package$.MODULE$.DurationInt(x2)).seconds());
            }
        }
        return cachePolicy;
    }

    private CachePolicy.CachePolicy getTtl(String path, boolean positive) {
        CachePolicy.CachePolicy cachePolicy;
        String string = this.config.getString(path);
        if ("default".equals(string)) {
            cachePolicy = positive ? this.defaultCachePolicy() : this.defaultNegativeCachePolicy();
        } else if ("forever".equals(string)) {
            cachePolicy = CachePolicy$Forever$.MODULE$;
        } else if ("never".equals(string)) {
            cachePolicy = CachePolicy$Never$.MODULE$;
        } else {
            Long l = Helpers$.MODULE$.Requiring(BoxesRunTime.boxToLong((long)this.config.getDuration(path, TimeUnit.SECONDS)));
            long finiteTtl = BoxesRunTime.unboxToLong((Object)Helpers$Requiring$.MODULE$.requiring$extension(l, (JFunction1.mcZJ.sp & Serializable)_$5 -> _$5 > 0L, (Function0<Object>)((Function0 & Serializable)() -> InetAddressDnsResolver.$anonfun$2(path))));
            cachePolicy = CachePolicy$Ttl$.MODULE$.fromPositive(new package.DurationLong(package$.MODULE$.DurationLong(finiteTtl)).seconds());
        }
        return cachePolicy;
    }

    public CachePolicy.CachePolicy positiveCachePolicy() {
        return this.positiveCachePolicy;
    }

    public CachePolicy.CachePolicy negativeCachePolicy() {
        return this.negativeCachePolicy;
    }

    public long positiveTtl() {
        return this.positiveTtl;
    }

    public long negativeTtl() {
        return this.negativeTtl;
    }

    private long toLongTtl(CachePolicy.CachePolicy cp) {
        Option<FiniteDuration> option;
        long l;
        CachePolicy.CachePolicy cachePolicy = cp;
        if (CachePolicy$Forever$.MODULE$.equals(cachePolicy)) {
            l = Long.MAX_VALUE;
        } else if (CachePolicy$Never$.MODULE$.equals(cachePolicy)) {
            l = 0L;
        } else if (cachePolicy instanceof CachePolicy.Ttl && !(option = CachePolicy$Ttl$.MODULE$.unapply((CachePolicy.Ttl)cachePolicy)).isEmpty()) {
            FiniteDuration finiteDuration;
            FiniteDuration ttl = finiteDuration = (FiniteDuration)option.get();
            l = ttl.toMillis();
        } else {
            throw new MatchError((Object)cachePolicy);
        }
        return l;
    }

    @Override
    public PartialFunction receive() {
        return new Serializable(this){
            private final InetAddressDnsResolver $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x) {
                String string;
                Object object = x;
                if (object instanceof DnsProtocol.Resolve) {
                    DnsProtocol.Resolve resolve = (DnsProtocol.Resolve)object;
                    DnsProtocol.Resolve resolve2 = DnsProtocol$Resolve$.MODULE$.unapply(resolve);
                    String string2 = resolve2._1();
                    DnsProtocol.RequestType requestType = resolve2._2();
                    if (DnsProtocol$Srv$.MODULE$.equals(requestType)) {
                        return true;
                    }
                    String name = string2;
                    if (requestType instanceof DnsProtocol.Ip) {
                        DnsProtocol.Ip ip = (DnsProtocol.Ip)requestType;
                        DnsProtocol.Ip ip2 = DnsProtocol$Ip$.MODULE$.unapply(ip);
                        boolean bl = ip2._1();
                        boolean bl2 = ip2._2();
                        boolean ipv4 = bl;
                        boolean ipv6 = bl2;
                        DnsProtocol.Ip ip3 = ip;
                        DnsProtocol.Resolve r = resolve;
                        return true;
                    }
                }
                if (!(object instanceof Dns.Resolve)) return false;
                Dns.Resolve resolve = Dns$Resolve$.MODULE$.unapply((Dns.Resolve)object);
                String name = string = resolve._1();
                return true;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof DnsProtocol.Resolve) {
                    DnsProtocol.Resolve resolve = (DnsProtocol.Resolve)object2;
                    DnsProtocol.Resolve resolve2 = DnsProtocol$Resolve$.MODULE$.unapply(resolve);
                    String string = resolve2._1();
                    DnsProtocol.RequestType requestType = resolve2._2();
                    if (DnsProtocol$Srv$.MODULE$.equals(requestType)) {
                        ActorRef$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang(Status$Failure$.MODULE$.apply(new IllegalArgumentException("SRV request sent to InetResolver. SRV requests are only supported by async-dns resolver.")), this.$outer.self());
                        object = BoxedUnit.UNIT;
                        return object;
                    }
                    String name = string;
                    if (requestType instanceof DnsProtocol.Ip) {
                        DnsProtocol.Resolved resolved;
                        DnsProtocol.Ip ip = (DnsProtocol.Ip)requestType;
                        DnsProtocol.Ip ip2 = DnsProtocol$Ip$.MODULE$.unapply(ip);
                        boolean bl = ip2._1();
                        boolean bl2 = ip2._2();
                        boolean ipv4 = bl;
                        boolean ipv6 = bl2;
                        DnsProtocol.Ip ip3 = ip;
                        DnsProtocol.Resolve r = resolve;
                        Option<DnsProtocol.Resolved> option = this.$outer.akka$io$InetAddressDnsResolver$$cache.cached(r);
                        if (option instanceof Some) {
                            DnsProtocol.Resolved a;
                            resolved = a = (DnsProtocol.Resolved)((Some)option).value();
                        } else {
                            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                            this.$outer.log().debug("Request for [{}] was not yet cached", name);
                            try {
                                Object[] addresses = InetAddress.getAllByName(name);
                                Seq<ResourceRecord> records = this.$outer.akka$io$InetAddressDnsResolver$$addressToRecords(name, (Seq<InetAddress>)Predef$.MODULE$.wrapRefArray(addresses).toList(), ipv4, ipv6);
                                DnsProtocol.Resolved answer = DnsProtocol$Resolved$.MODULE$.apply(name, (Seq<ResourceRecord>)records.toList());
                                CachePolicy.CachePolicy cachePolicy = this.$outer.positiveCachePolicy();
                                CachePolicy$Never$ cachePolicy$Never$ = CachePolicy$Never$.MODULE$;
                                if (cachePolicy == null ? cachePolicy$Never$ != null : !cachePolicy.equals(cachePolicy$Never$)) {
                                    this.$outer.akka$io$InetAddressDnsResolver$$cache.put((Tuple2<String, DnsProtocol.RequestType>)Tuple2$.MODULE$.apply((Object)name, (Object)DnsProtocol$Ip$.MODULE$.apply(DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$1(), DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$2())), DnsProtocol$Resolved$.MODULE$.apply(name, records), this.$outer.positiveCachePolicy());
                                }
                                resolved = answer;
                            }
                            catch (UnknownHostException unknownHostException) {
                                DnsProtocol.Resolved answer = DnsProtocol$Resolved$.MODULE$.apply(name, (Seq<ResourceRecord>)((Seq)Seq$.MODULE$.empty()));
                                CachePolicy.CachePolicy cachePolicy = this.$outer.negativeCachePolicy();
                                CachePolicy$Never$ cachePolicy$Never$ = CachePolicy$Never$.MODULE$;
                                if (cachePolicy == null ? cachePolicy$Never$ != null : !cachePolicy.equals(cachePolicy$Never$)) {
                                    this.$outer.akka$io$InetAddressDnsResolver$$cache.put((Tuple2<String, DnsProtocol.RequestType>)Tuple2$.MODULE$.apply((Object)name, (Object)ip3), answer, this.$outer.negativeCachePolicy());
                                }
                                resolved = answer;
                            }
                        }
                        DnsProtocol.Resolved answer = resolved;
                        ActorRef$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang(answer, this.$outer.self());
                        object = BoxedUnit.UNIT;
                        return object;
                    }
                }
                if (object2 instanceof Dns.Resolve) {
                    Dns.Resolved resolved;
                    Dns.Resolve resolve = Dns$Resolve$.MODULE$.unapply((Dns.Resolve)object2);
                    String string = resolve._1();
                    String name = string;
                    Option<Dns.Resolved> option = this.$outer.akka$io$InetAddressDnsResolver$$cache.cached(name);
                    if (option instanceof Some) {
                        Dns.Resolved a;
                        resolved = a = (Dns.Resolved)((Some)option).value();
                    } else {
                        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                        try {
                            Object[] addresses = InetAddress.getAllByName(name);
                            Dns.Resolved answer = Dns$Resolved$.MODULE$.apply(name, (Iterable<InetAddress>)Predef$.MODULE$.wrapRefArray(addresses));
                            CachePolicy.CachePolicy cachePolicy = this.$outer.positiveCachePolicy();
                            CachePolicy$Never$ cachePolicy$Never$ = CachePolicy$Never$.MODULE$;
                            if (cachePolicy == null ? cachePolicy$Never$ != null : !cachePolicy.equals(cachePolicy$Never$)) {
                                Seq<ResourceRecord> records = this.$outer.akka$io$InetAddressDnsResolver$$addressToRecords(name, (Seq<InetAddress>)Predef$.MODULE$.wrapRefArray(addresses).toList(), true, true);
                                this.$outer.akka$io$InetAddressDnsResolver$$cache.put((Tuple2<String, DnsProtocol.RequestType>)Tuple2$.MODULE$.apply((Object)name, (Object)DnsProtocol$Ip$.MODULE$.apply(DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$1(), DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$2())), DnsProtocol$Resolved$.MODULE$.apply(name, records), this.$outer.positiveCachePolicy());
                            }
                            resolved = answer;
                        }
                        catch (UnknownHostException unknownHostException) {
                            Dns.Resolved answer = Dns$Resolved$.MODULE$.apply(name, (Seq<Inet4Address>)((Seq)Seq$.MODULE$.empty()), (Seq<Inet6Address>)((Seq)Seq$.MODULE$.empty()));
                            CachePolicy.CachePolicy cachePolicy = this.$outer.negativeCachePolicy();
                            CachePolicy$Never$ cachePolicy$Never$ = CachePolicy$Never$.MODULE$;
                            if (cachePolicy == null ? cachePolicy$Never$ != null : !cachePolicy.equals(cachePolicy$Never$)) {
                                this.$outer.akka$io$InetAddressDnsResolver$$cache.put((Tuple2<String, DnsProtocol.RequestType>)Tuple2$.MODULE$.apply((Object)name, (Object)DnsProtocol$Ip$.MODULE$.apply(DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$1(), DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$2())), DnsProtocol$Resolved$.MODULE$.apply(name, (Seq<ResourceRecord>)((Seq)Seq$.MODULE$.empty())), this.$outer.negativeCachePolicy());
                            }
                            resolved = answer;
                        }
                    }
                    Dns.Resolved answer = resolved;
                    ActorRef$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang(answer, this.$outer.self());
                    object = BoxedUnit.UNIT;
                    return object;
                }
                object = function1.apply(x);
                return object;
            }
        };
    }

    public Seq<ResourceRecord> akka$io$InetAddressDnsResolver$$addressToRecords(String name, Seq<InetAddress> addresses, boolean ipv4, boolean ipv6) {
        return (Seq)addresses.collect((PartialFunction)new Serializable(name, ipv4, ipv6, this){
            private final String name$1;
            private final boolean ipv4$1;
            private final boolean ipv6$1;
            private final InetAddressDnsResolver $outer;
            {
                this.name$1 = name$2;
                this.ipv4$1 = ipv4$2;
                this.ipv6$1 = ipv6$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(InetAddress x) {
                InetAddress inetAddress = x;
                if (inetAddress instanceof Inet4Address) {
                    Inet4Address a = (Inet4Address)inetAddress;
                    if (this.ipv4$1) {
                        return true;
                    }
                }
                if (!(inetAddress instanceof Inet6Address)) return false;
                Inet6Address a = (Inet6Address)inetAddress;
                if (!this.ipv6$1) return false;
                return true;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object applyOrElse(InetAddress x, Function1 function1) {
                Object object;
                InetAddress inetAddress = x;
                if (inetAddress instanceof Inet4Address) {
                    Inet4Address a = (Inet4Address)inetAddress;
                    if (this.ipv4$1) {
                        object = ARecord$.MODULE$.apply(this.name$1, CachePolicy$Ttl$.MODULE$.toTll(this.$outer.positiveCachePolicy()), a);
                        return object;
                    }
                }
                if (inetAddress instanceof Inet6Address) {
                    Inet6Address a = (Inet6Address)inetAddress;
                    if (this.ipv6$1) {
                        object = AAAARecord$.MODULE$.apply(this.name$1, CachePolicy$Ttl$.MODULE$.toTll(this.$outer.positiveCachePolicy()), a);
                        return object;
                    }
                }
                object = function1.apply((Object)x);
                return object;
            }
        });
    }

    private static final Option defaultCachePolicy$$anonfun$2() {
        return Option$.MODULE$.apply((Object)System.getProperty("sun.net.inetaddr.ttl"));
    }

    private static final int defaultCachePolicy$$anonfun$5$$anonfun$1(String x$1) {
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$1));
    }

    private static final Option defaultNegativeCachePolicy$$anonfun$2() {
        return Option$.MODULE$.apply((Object)System.getProperty("sun.net.inetaddr.negative.ttl"));
    }

    private static final int defaultNegativeCachePolicy$$anonfun$5$$anonfun$1(String x$2) {
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$2));
    }

    private static final String $anonfun$2(String path$1) {
        return "akka.io.dns." + path$1 + " must be 'default', 'forever', 'never' or positive duration";
    }
}

