/*
 * Decompiled with CFR 0.152.
 */
package akka.io;

import akka.actor.ActorRef;
import akka.actor.Deploy$;
import akka.actor.ExtendedActorSystem;
import akka.actor.Props$;
import akka.dispatch.MessageDispatcher;
import akka.io.BufferPool;
import akka.io.DirectByteBufferPool;
import akka.io.IO;
import akka.io.SelectionHandlerSettings;
import akka.io.TcpManager;
import akka.util.Helpers$;
import akka.util.Helpers$ConfigOps$;
import akka.util.Helpers$Requiring$;
import com.typesafe.config.Config;
import java.io.Serializable;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class TcpExt
implements IO.Extension {
    private final Settings Settings;
    private final ActorRef manager;
    private final BufferPool bufferPool;
    private final MessageDispatcher fileIoDispatcher;

    public TcpExt(ExtendedActorSystem system) {
        this.Settings = new Settings(this, system.settings().config().getConfig("akka.io.tcp"));
        this.manager = system.systemActorOf(Props$.MODULE$.apply(TcpManager.class, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this})).withDispatcher(this.Settings().ManagementDispatcher()).withDeploy(Deploy$.MODULE$.local()), "IO-TCP");
        this.bufferPool = new DirectByteBufferPool(this.Settings().DirectBufferSize(), this.Settings().MaxDirectBufferPoolSize());
        this.fileIoDispatcher = system.dispatchers().lookup(this.Settings().FileIODispatcher());
    }

    public Settings Settings() {
        return this.Settings;
    }

    @Override
    public ActorRef manager() {
        return this.manager;
    }

    public ActorRef getManager() {
        return this.manager();
    }

    public BufferPool bufferPool() {
        return this.bufferPool;
    }

    public MessageDispatcher fileIoDispatcher() {
        return this.fileIoDispatcher;
    }

    public static final /* synthetic */ boolean akka$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$1(int _$1) {
        return _$1 > 0;
    }

    public static final String akka$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$2() {
        return "nr-of-selectors must be > 0";
    }

    public static final /* synthetic */ boolean akka$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$3(int _$2) {
        return _$2 > 0;
    }

    public static final String akka$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$4() {
        return "batch-accept-limit must be > 0";
    }

    public static final /* synthetic */ boolean akka$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$5(int _$3) {
        return _$3 > 0;
    }

    public static final String akka$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$6() {
        return "finish-connect-retries must be > 0";
    }

    public static final String akka$io$TcpExt$Settings$$_$getIntBytes$$anonfun$1(String path$1) {
        return "" + path$1 + " must be < 2 GiB";
    }

    public static final String akka$io$TcpExt$Settings$$_$getIntBytes$$anonfun$2(String path$2) {
        return "" + path$2 + " must be non-negative";
    }

    public class Settings
    extends SelectionHandlerSettings {
        private final Config _config;
        private final int NrOfSelectors;
        private final int BatchAcceptLimit;
        private final int DirectBufferSize;
        private final int MaxDirectBufferPoolSize;
        private final Duration RegisterTimeout;
        private final int ReceivedMessageSizeLimit;
        private final String ManagementDispatcher;
        private final String FileIODispatcher;
        private final int TransferToLimit;
        private final int MaxChannelsPerSelector;
        private final int FinishConnectRetries;
        private final boolean WindowsConnectionAbortWorkaroundEnabled;
        private final TcpExt $outer;

        public Settings(TcpExt $outer, Config _config) {
            this._config = _config;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(_config);
            Integer n = Helpers$.MODULE$.Requiring(BoxesRunTime.boxToInteger((int)_config.getInt("nr-of-selectors")));
            this.NrOfSelectors = BoxesRunTime.unboxToInt((Object)Helpers$Requiring$.MODULE$.requiring$extension(n, TcpExt::akka$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$1, (Function0<Object>)((Function0 & Serializable)TcpExt::akka$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$2)));
            Integer n2 = Helpers$.MODULE$.Requiring(BoxesRunTime.boxToInteger((int)_config.getInt("batch-accept-limit")));
            this.BatchAcceptLimit = BoxesRunTime.unboxToInt((Object)Helpers$Requiring$.MODULE$.requiring$extension(n2, TcpExt::akka$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$3, (Function0<Object>)((Function0 & Serializable)TcpExt::akka$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$4)));
            this.DirectBufferSize = this.getIntBytes("direct-buffer-size");
            this.MaxDirectBufferPoolSize = _config.getInt("direct-buffer-pool-limit");
            String string = _config.getString("register-timeout");
            this.RegisterTimeout = "infinite".equals(string) ? Duration$.MODULE$.Undefined() : Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(_config), "register-timeout");
            String string2 = _config.getString("max-received-message-size");
            this.ReceivedMessageSizeLimit = "unlimited".equals(string2) ? Integer.MAX_VALUE : this.getIntBytes("max-received-message-size");
            this.ManagementDispatcher = _config.getString("management-dispatcher");
            this.FileIODispatcher = _config.getString("file-io-dispatcher");
            String string3 = _config.getString("file-io-transferTo-limit");
            this.TransferToLimit = "unlimited".equals(string3) ? Integer.MAX_VALUE : this.getIntBytes("file-io-transferTo-limit");
            this.MaxChannelsPerSelector = this.MaxChannels() == -1 ? -1 : package$.MODULE$.max(this.MaxChannels() / this.NrOfSelectors(), 1);
            Integer n3 = Helpers$.MODULE$.Requiring(BoxesRunTime.boxToInteger((int)_config.getInt("finish-connect-retries")));
            this.FinishConnectRetries = BoxesRunTime.unboxToInt((Object)Helpers$Requiring$.MODULE$.requiring$extension(n3, TcpExt::akka$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$5, (Function0<Object>)((Function0 & Serializable)TcpExt::akka$io$TcpExt$Settings$$_$$lessinit$greater$$anonfun$6)));
            String string4 = _config.getString("windows-connection-abort-workaround-enabled");
            this.WindowsConnectionAbortWorkaroundEnabled = "auto".equals(string4) ? Helpers$.MODULE$.isWindows() : _config.getBoolean("windows-connection-abort-workaround-enabled");
        }

        public int NrOfSelectors() {
            return this.NrOfSelectors;
        }

        public int BatchAcceptLimit() {
            return this.BatchAcceptLimit;
        }

        public int DirectBufferSize() {
            return this.DirectBufferSize;
        }

        public int MaxDirectBufferPoolSize() {
            return this.MaxDirectBufferPoolSize;
        }

        public Duration RegisterTimeout() {
            return this.RegisterTimeout;
        }

        public int ReceivedMessageSizeLimit() {
            return this.ReceivedMessageSizeLimit;
        }

        public String ManagementDispatcher() {
            return this.ManagementDispatcher;
        }

        public String FileIODispatcher() {
            return this.FileIODispatcher;
        }

        public int TransferToLimit() {
            return this.TransferToLimit;
        }

        @Override
        public int MaxChannelsPerSelector() {
            return this.MaxChannelsPerSelector;
        }

        public int FinishConnectRetries() {
            return this.FinishConnectRetries;
        }

        public boolean WindowsConnectionAbortWorkaroundEnabled() {
            return this.WindowsConnectionAbortWorkaroundEnabled;
        }

        private int getIntBytes(String path) {
            Long size = this._config.getBytes(path);
            Predef$.MODULE$.require(Predef$.MODULE$.Long2long(size) < Integer.MAX_VALUE, () -> TcpExt.akka$io$TcpExt$Settings$$_$getIntBytes$$anonfun$1(path));
            Predef$.MODULE$.require(Predef$.MODULE$.Long2long(size) >= 0L, () -> TcpExt.akka$io$TcpExt$Settings$$_$getIntBytes$$anonfun$2(path));
            return (int)Predef$.MODULE$.Long2long(size);
        }

        public final TcpExt akka$io$TcpExt$Settings$$$outer() {
            return this.$outer;
        }
    }
}

