/*
 * Decompiled with CFR 0.152.
 */
package akka.io;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ActorRef$;
import akka.actor.NoSerializationVerificationNeeded;
import akka.actor.Props;
import akka.actor.Props$;
import akka.actor.SupervisorStrategy;
import akka.dispatch.RequiresMessageQueue;
import akka.dispatch.UnboundedMessageQueueSemantics;
import akka.event.LoggingAdapter;
import akka.io.ChannelRegistration;
import akka.io.ChannelRegistry;
import akka.io.Inet;
import akka.io.SelectionHandler;
import akka.io.SelectionHandler$;
import akka.io.SelectionHandler$ChannelAcceptable$;
import akka.io.SelectionHandler$WorkerForCommand$;
import akka.io.Tcp;
import akka.io.Tcp$Bound$;
import akka.io.Tcp$ResumeAccepting$;
import akka.io.Tcp$Unbind$;
import akka.io.Tcp$Unbound$;
import akka.io.TcpExt;
import akka.io.TcpIncomingConnection;
import akka.io.TcpListener$FailedRegisterIncoming$;
import akka.io.TcpListener$RegisterIncoming$;
import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public class TcpListener
implements Actor,
ActorLogging,
RequiresMessageQueue<UnboundedMessageQueueSemantics> {
    private final ActorContext context;
    private final ActorRef self;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorRef selectorRouter;
    private final TcpExt tcp;
    private final ChannelRegistry channelRegistry;
    public final ActorRef akka$io$TcpListener$$bindCommander;
    private final Tcp.Bind bind;
    private final ServerSocketChannel channel;
    private int acceptLimit;
    private final Object localAddress;

    public TcpListener(ActorRef selectorRouter, TcpExt tcp, ChannelRegistry channelRegistry, ActorRef bindCommander, Tcp.Bind bind) {
        this.selectorRouter = selectorRouter;
        this.tcp = tcp;
        this.channelRegistry = channelRegistry;
        this.akka$io$TcpListener$$bindCommander = bindCommander;
        this.bind = bind;
        this.context = Actor.super.initial$context();
        this.self = Actor.super.initial$self();
        this.akka$actor$ActorLogging$$_log = ActorLogging.super.akka$actor$ActorLogging$$initial$_log();
        ActorLogging.super.$init$();
        this.context().watch(bind.handler());
        this.channel = ServerSocketChannel.open();
        this.channel().configureBlocking(false);
        this.acceptLimit = bind.pullMode() ? 0 : tcp.Settings().BatchAcceptLimit();
        this.localAddress = this.liftedTree1$1(channelRegistry, bindCommander, bind);
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public ServerSocketChannel channel() {
        return this.channel;
    }

    public int acceptLimit() {
        return this.acceptLimit;
    }

    public void acceptLimit_$eq(int x$1) {
        this.acceptLimit = x$1;
    }

    public Object localAddress() {
        return this.localAddress;
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return SelectionHandler$.MODULE$.connectionSupervisorStrategy();
    }

    @Override
    public PartialFunction receive() {
        return new Serializable(this){
            private final TcpListener $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                boolean bl;
                Object object = x;
                if (object instanceof ChannelRegistration) {
                    ChannelRegistration registration = (ChannelRegistration)object;
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof ChannelRegistration) {
                    ChannelRegistration registration = (ChannelRegistration)object2;
                    ActorRef$.MODULE$.actorRef2Scala(this.$outer.akka$io$TcpListener$$bindCommander).$bang(Tcp$Bound$.MODULE$.apply((InetSocketAddress)this.$outer.channel().socket().getLocalSocketAddress()), this.$outer.self());
                    this.$outer.context().become(this.$outer.bound(registration));
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x);
                }
                return object;
            }
        };
    }

    public PartialFunction bound(ChannelRegistration registration) {
        return new Serializable(registration, this){
            private final ChannelRegistration registration$1;
            private final TcpListener $outer;
            {
                this.registration$1 = registration$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                boolean bl;
                Object object = x;
                if (SelectionHandler$ChannelAcceptable$.MODULE$.equals(object)) {
                    bl = true;
                } else if (object instanceof Tcp.ResumeAccepting) {
                    int n;
                    Tcp.ResumeAccepting resumeAccepting = Tcp$ResumeAccepting$.MODULE$.unapply((Tcp.ResumeAccepting)object);
                    int batchSize = n = resumeAccepting._1();
                    bl = true;
                } else if (object instanceof FailedRegisterIncoming) {
                    SocketChannel socketChannel;
                    FailedRegisterIncoming failedRegisterIncoming = TcpListener$FailedRegisterIncoming$.MODULE$.unapply((FailedRegisterIncoming)object);
                    SocketChannel socketChannel2 = socketChannel = failedRegisterIncoming._1();
                    bl = true;
                } else {
                    bl = Tcp$Unbind$.MODULE$.equals(object);
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (SelectionHandler$ChannelAcceptable$.MODULE$.equals(object2)) {
                    this.$outer.acceptLimit_$eq(this.$outer.acceptAllPending(this.registration$1, this.$outer.acceptLimit()));
                    if (this.$outer.acceptLimit() > 0) {
                        this.registration$1.enableInterest(16);
                        object = BoxedUnit.UNIT;
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                } else if (object2 instanceof Tcp.ResumeAccepting) {
                    int n;
                    Tcp.ResumeAccepting resumeAccepting = Tcp$ResumeAccepting$.MODULE$.unapply((Tcp.ResumeAccepting)object2);
                    int batchSize = n = resumeAccepting._1();
                    this.$outer.acceptLimit_$eq(batchSize);
                    this.registration$1.enableInterest(16);
                    object = BoxedUnit.UNIT;
                } else if (object2 instanceof FailedRegisterIncoming) {
                    SocketChannel socketChannel;
                    FailedRegisterIncoming failedRegisterIncoming = TcpListener$FailedRegisterIncoming$.MODULE$.unapply((FailedRegisterIncoming)object2);
                    SocketChannel socketChannel2 = socketChannel = failedRegisterIncoming._1();
                    this.$outer.log().warning("Could not register incoming connection since selector capacity limit is reached, closing connection");
                    try {
                        socketChannel2.close();
                        object = BoxedUnit.UNIT;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Option option;
                        Throwable throwable3 = throwable;
                        if (throwable3 == null || (option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                            throw throwable;
                        }
                        Throwable e = throwable2 = (Throwable)option.get();
                        this.$outer.log().debug("Error closing socket channel: {}", e);
                        object = BoxedUnit.UNIT;
                    }
                } else if (Tcp$Unbind$.MODULE$.equals(object2)) {
                    this.$outer.log().debug("Unbinding endpoint {}", this.$outer.localAddress());
                    this.registration$1.cancelAndClose((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> ActorRef$.MODULE$.actorRef2Scala(this.$outer.self()).$bang(Tcp$Unbound$.MODULE$, this.$outer.self()));
                    this.$outer.context().become(this.$outer.unregistering(this.$outer.sender()));
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x);
                }
                return object;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1()}, serializedLambda);
            }
        };
    }

    public PartialFunction unregistering(ActorRef requester) {
        return new Serializable(requester, this){
            private final ActorRef requester$1;
            private final TcpListener $outer;
            {
                this.requester$1 = requester$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                return Tcp$Unbound$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (Tcp$Unbound$.MODULE$.equals(object2)) {
                    ActorRef$.MODULE$.actorRef2Scala(this.requester$1).$bang(Tcp$Unbound$.MODULE$, this.$outer.self());
                    this.$outer.log().debug("Unbound endpoint {}, stopping listener", this.$outer.localAddress());
                    this.$outer.context().stop(this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x);
                }
                return object;
            }
        };
    }

    public final int acceptAllPending(ChannelRegistration registration, int limit) {
        TcpListener tcpListener = this;
        int n = limit;
        while (true) {
            SocketChannel socketChannel;
            SocketChannel socketChannel2;
            if (n > 0) {
                try {
                    socketChannel2 = tcpListener.channel().accept();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Option option;
                    Throwable throwable3 = throwable;
                    if (throwable3 == null || (option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = throwable2 = (Throwable)option.get();
                    tcpListener.log().error(e, "Accept error: could not accept new connection");
                    socketChannel2 = null;
                }
            } else {
                socketChannel2 = null;
            }
            if ((socketChannel = socketChannel2) == null) break;
            tcpListener.log().debug("New connection accepted");
            socketChannel.configureBlocking(false);
            ActorRef$.MODULE$.actorRef2Scala(tcpListener.selectorRouter).$bang(SelectionHandler$WorkerForCommand$.MODULE$.apply(TcpListener$RegisterIncoming$.MODULE$.apply(socketChannel), tcpListener.self(), (Function1<ChannelRegistry, Props>)(JFunction1 & Serializable)registry -> TcpListener.props$1(socketChannel, tcpListener, registry)), tcpListener.self());
            TcpListener tcpListener2 = tcpListener;
            int n2 = n - 1;
            tcpListener = tcpListener2;
            n = n2;
        }
        return tcpListener.bind.pullMode() ? n : tcpListener.tcp.Settings().BatchAcceptLimit();
    }

    @Override
    public void postStop() {
        try {
            if (this.channel().isOpen()) {
                this.log().debug("Closing serverSocketChannel after being stopped");
                this.channel().close();
            }
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.log().debug("Error closing ServerSocketChannel: {}", e);
            }
            throw throwable;
        }
    }

    private final Serializable liftedTree1$1(ChannelRegistry channelRegistry$1, ActorRef bindCommander$1, Tcp.Bind bind$1) {
        InetSocketAddress inetSocketAddress;
        try {
            ServerSocket socket = this.channel().socket();
            bind$1.options().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.beforeServerSocketBind(socket));
            socket.bind(bind$1.localAddress(), bind$1.backlog());
            SocketAddress socketAddress = socket.getLocalSocketAddress();
            if (!(socketAddress instanceof InetSocketAddress)) {
                SocketAddress x = socketAddress;
                throw new IllegalArgumentException("bound to unknown SocketAddress [" + x + "]");
            }
            InetSocketAddress isa = (InetSocketAddress)socketAddress;
            InetSocketAddress ret = isa;
            channelRegistry$1.register(this.channel(), bind$1.pullMode() ? 0 : 16, this.self());
            this.log().debug("Successfully bound to {}", ret);
            bind$1.options().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                block0: {
                    Inet.SocketOption socketOption = x$1;
                    if (!(socketOption instanceof Inet.SocketOptionV2)) break block0;
                    Inet.SocketOptionV2 o = (Inet.SocketOptionV2)socketOption;
                    o.afterBind(this.channel().socket());
                }
            });
            inetSocketAddress = ret;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Option option;
            Throwable throwable3 = throwable;
            if (throwable3 != null && !(option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                Throwable throwable4 = (Throwable)option.get();
                Throwable e = throwable4;
                if (e instanceof BindException) {
                    BindException newException = new BindException("[" + bind$1.localAddress() + "] " + e.getMessage());
                    newException.setStackTrace(e.getStackTrace());
                    throwable2 = newException;
                } else {
                    throwable2 = e;
                }
            } else {
                throw throwable;
            }
            Throwable exception = throwable2;
            ActorRef$.MODULE$.actorRef2Scala(bindCommander$1).$bang(bind$1.failureMessage().withCause(exception), this.self());
            this.log().error(exception, "Bind failed for TCP channel on endpoint [{}]", (Object)bind$1.localAddress());
            this.context().stop(this.self());
            inetSocketAddress = BoxedUnit.UNIT;
        }
        return inetSocketAddress;
    }

    private static final Props props$1(SocketChannel socketChannel$1, TcpListener $this$1, ChannelRegistry registry) {
        return Props$.MODULE$.apply(TcpIncomingConnection.class, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{$this$1.tcp, socketChannel$1, registry, $this$1.bind.handler(), $this$1.bind.options(), BoxesRunTime.boxToBoolean((boolean)$this$1.bind.pullMode())}));
    }

    public static final class FailedRegisterIncoming
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final SocketChannel channel;

        public static <A> Function1<SocketChannel, A> andThen(Function1<FailedRegisterIncoming, A> function1) {
            return TcpListener$FailedRegisterIncoming$.MODULE$.andThen(function1);
        }

        public static FailedRegisterIncoming apply(SocketChannel socketChannel) {
            return TcpListener$FailedRegisterIncoming$.MODULE$.apply(socketChannel);
        }

        public static <A> Function1<A, FailedRegisterIncoming> compose(Function1<A, SocketChannel> function1) {
            return TcpListener$FailedRegisterIncoming$.MODULE$.compose(function1);
        }

        public static FailedRegisterIncoming fromProduct(Product product) {
            return TcpListener$FailedRegisterIncoming$.MODULE$.fromProduct(product);
        }

        public static FailedRegisterIncoming unapply(FailedRegisterIncoming failedRegisterIncoming) {
            return TcpListener$FailedRegisterIncoming$.MODULE$.unapply(failedRegisterIncoming);
        }

        public FailedRegisterIncoming(SocketChannel channel) {
            this.channel = channel;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FailedRegisterIncoming)) return false;
            FailedRegisterIncoming failedRegisterIncoming = (FailedRegisterIncoming)object;
            SocketChannel socketChannel = this.channel();
            SocketChannel socketChannel2 = failedRegisterIncoming.channel();
            if (socketChannel != null) {
                if (!socketChannel.equals(socketChannel2)) return false;
                return true;
            }
            if (socketChannel2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FailedRegisterIncoming;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "FailedRegisterIncoming";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "channel";
        }

        public SocketChannel channel() {
            return this.channel;
        }

        public FailedRegisterIncoming copy(SocketChannel channel) {
            return new FailedRegisterIncoming(channel);
        }

        public SocketChannel copy$default$1() {
            return this.channel();
        }

        public SocketChannel _1() {
            return this.channel();
        }
    }

    public static final class RegisterIncoming
    implements SelectionHandler.HasFailureMessage,
    NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final SocketChannel channel;

        public static <A> Function1<SocketChannel, A> andThen(Function1<RegisterIncoming, A> function1) {
            return TcpListener$RegisterIncoming$.MODULE$.andThen(function1);
        }

        public static RegisterIncoming apply(SocketChannel socketChannel) {
            return TcpListener$RegisterIncoming$.MODULE$.apply(socketChannel);
        }

        public static <A> Function1<A, RegisterIncoming> compose(Function1<A, SocketChannel> function1) {
            return TcpListener$RegisterIncoming$.MODULE$.compose(function1);
        }

        public static RegisterIncoming fromProduct(Product product) {
            return TcpListener$RegisterIncoming$.MODULE$.fromProduct(product);
        }

        public static RegisterIncoming unapply(RegisterIncoming registerIncoming) {
            return TcpListener$RegisterIncoming$.MODULE$.unapply(registerIncoming);
        }

        public RegisterIncoming(SocketChannel channel) {
            this.channel = channel;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RegisterIncoming)) return false;
            RegisterIncoming registerIncoming = (RegisterIncoming)object;
            SocketChannel socketChannel = this.channel();
            SocketChannel socketChannel2 = registerIncoming.channel();
            if (socketChannel != null) {
                if (!socketChannel.equals(socketChannel2)) return false;
                return true;
            }
            if (socketChannel2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RegisterIncoming;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RegisterIncoming";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "channel";
        }

        public SocketChannel channel() {
            return this.channel;
        }

        @Override
        public Object failureMessage() {
            return TcpListener$FailedRegisterIncoming$.MODULE$.apply(this.channel());
        }

        public RegisterIncoming copy(SocketChannel channel) {
            return new RegisterIncoming(channel);
        }

        public SocketChannel copy$default$1() {
            return this.channel();
        }

        public SocketChannel _1() {
            return this.channel();
        }
    }
}

