/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns;

import akka.actor.NoSerializationVerificationNeeded;
import akka.io.IpVersionSelector$;
import akka.io.dns.AAAARecord;
import akka.io.dns.AAAARecord$;
import akka.io.dns.ARecord;
import akka.io.dns.ARecord$;
import akka.io.dns.CachePolicy;
import akka.io.dns.DnsProtocol$;
import akka.io.dns.DnsProtocol$Ip$;
import akka.io.dns.DnsProtocol$Resolve$;
import akka.io.dns.DnsProtocol$Resolved$;
import akka.io.dns.ResourceRecord;
import akka.routing.ConsistentHashingRouter;
import akka.util.ccompat.package$JavaConverters$;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class DnsProtocol {
    public static RequestType ipRequestType() {
        return DnsProtocol$.MODULE$.ipRequestType();
    }

    public static RequestType ipRequestType(boolean bl, boolean bl2) {
        return DnsProtocol$.MODULE$.ipRequestType(bl, bl2);
    }

    public static Resolve resolve(String string) {
        return DnsProtocol$.MODULE$.resolve(string);
    }

    public static Resolve resolve(String string, RequestType requestType) {
        return DnsProtocol$.MODULE$.resolve(string, requestType);
    }

    public static RequestType srvRequestType() {
        return DnsProtocol$.MODULE$.srvRequestType();
    }

    public static final class Ip
    implements RequestType,
    Product,
    Serializable {
        private final boolean ipv4;
        private final boolean ipv6;

        public static Ip apply(boolean bl, boolean bl2) {
            return DnsProtocol$Ip$.MODULE$.apply(bl, bl2);
        }

        public static Function1 curried() {
            return DnsProtocol$Ip$.MODULE$.curried();
        }

        public static Ip fromProduct(Product product) {
            return DnsProtocol$Ip$.MODULE$.fromProduct(product);
        }

        public static Function1 tupled() {
            return DnsProtocol$Ip$.MODULE$.tupled();
        }

        public static Ip unapply(Ip ip) {
            return DnsProtocol$Ip$.MODULE$.unapply(ip);
        }

        public static boolean $lessinit$greater$default$1() {
            return DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$1();
        }

        public static boolean $lessinit$greater$default$2() {
            return DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$2();
        }

        public Ip(boolean ipv4, boolean ipv6) {
            this.ipv4 = ipv4;
            this.ipv6 = ipv6;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.ipv4() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.ipv6() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Ip)) return false;
            Ip ip = (Ip)object;
            if (this.ipv4() != ip.ipv4()) return false;
            if (this.ipv6() != ip.ipv6()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Ip;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Ip";
        }

        public Object productElement(int n) {
            boolean bl;
            int n2 = n;
            if (0 == n2) {
                bl = this._1();
            } else if (1 == n2) {
                bl = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToBoolean((boolean)bl);
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "ipv4";
            } else if (1 == n2) {
                string = "ipv6";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public boolean ipv4() {
            return this.ipv4;
        }

        public boolean ipv6() {
            return this.ipv6;
        }

        public Ip copy(boolean ipv4, boolean ipv6) {
            return new Ip(ipv4, ipv6);
        }

        public boolean copy$default$1() {
            return this.ipv4();
        }

        public boolean copy$default$2() {
            return this.ipv6();
        }

        public boolean _1() {
            return this.ipv4();
        }

        public boolean _2() {
            return this.ipv6();
        }
    }

    public static interface RequestType {
    }

    public static final class Resolve
    implements ConsistentHashingRouter.ConsistentHashable,
    Product,
    Serializable {
        private final String name;
        private final RequestType requestType;

        public static Resolve apply(String string) {
            return DnsProtocol$Resolve$.MODULE$.apply(string);
        }

        public static Resolve apply(String string, RequestType requestType) {
            return DnsProtocol$Resolve$.MODULE$.apply(string, requestType);
        }

        public static Resolve fromProduct(Product product) {
            return DnsProtocol$Resolve$.MODULE$.fromProduct(product);
        }

        public static Resolve unapply(Resolve resolve) {
            return DnsProtocol$Resolve$.MODULE$.unapply(resolve);
        }

        public Resolve(String name, RequestType requestType) {
            this.name = name;
            this.requestType = requestType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Resolve)) return false;
            Resolve resolve = (Resolve)object;
            String string = this.name();
            String string2 = resolve.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            RequestType requestType = this.requestType();
            RequestType requestType2 = resolve.requestType();
            if (requestType == null) {
                if (requestType2 == null) return true;
                return false;
            } else {
                if (!requestType.equals(requestType2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Resolve;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Resolve";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "name";
            } else if (1 == n2) {
                string = "requestType";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public String name() {
            return this.name;
        }

        public RequestType requestType() {
            return this.requestType;
        }

        @Override
        public Object consistentHashKey() {
            return this.name();
        }

        public Resolve copy(String name, RequestType requestType) {
            return new Resolve(name, requestType);
        }

        public String copy$default$1() {
            return this.name();
        }

        public RequestType copy$default$2() {
            return this.requestType();
        }

        public String _1() {
            return this.name();
        }

        public RequestType _2() {
            return this.requestType();
        }
    }

    public static final class Resolved
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final String name;
        private final scala.collection.immutable.Seq records;
        private final scala.collection.immutable.Seq additionalRecords;
        private final Option<InetAddress> _address;

        public static Resolved apply(String string, scala.collection.immutable.Seq<ResourceRecord> seq) {
            return DnsProtocol$Resolved$.MODULE$.apply(string, seq);
        }

        public static Resolved apply(String string, scala.collection.immutable.Seq<ResourceRecord> seq, scala.collection.immutable.Seq<ResourceRecord> seq2) {
            return DnsProtocol$Resolved$.MODULE$.apply(string, seq, seq2);
        }

        public static Resolved fromProduct(Product product) {
            return DnsProtocol$Resolved$.MODULE$.fromProduct(product);
        }

        public static Resolved unapply(Resolved resolved) {
            return DnsProtocol$Resolved$.MODULE$.unapply(resolved);
        }

        public Resolved(String name, scala.collection.immutable.Seq<ResourceRecord> records, scala.collection.immutable.Seq<ResourceRecord> additionalRecords) {
            this.name = name;
            this.records = records;
            this.additionalRecords = additionalRecords;
            Option ipv4 = records.collectFirst((PartialFunction)new Serializable(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(ResourceRecord x) {
                    ResourceRecord resourceRecord = x;
                    if (!(resourceRecord instanceof ARecord)) return false;
                    ARecord aRecord = ARecord$.MODULE$.unapply((ARecord)resourceRecord);
                    String string = aRecord._1();
                    CachePolicy.Ttl ttl = aRecord._2();
                    InetAddress inetAddress = aRecord._3();
                    if (!(inetAddress instanceof Inet4Address)) return false;
                    Inet4Address ip = (Inet4Address)inetAddress;
                    return true;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public final Object applyOrElse(ResourceRecord x, Function1 function1) {
                    Object object;
                    ResourceRecord resourceRecord = x;
                    if (resourceRecord instanceof ARecord) {
                        ARecord aRecord = ARecord$.MODULE$.unapply((ARecord)resourceRecord);
                        String string = aRecord._1();
                        CachePolicy.Ttl ttl = aRecord._2();
                        InetAddress inetAddress = aRecord._3();
                        if (inetAddress instanceof Inet4Address) {
                            Inet4Address ip = (Inet4Address)inetAddress;
                            object = ip;
                            return object;
                        }
                    }
                    object = function1.apply((Object)x);
                    return object;
                }
            });
            Option ipv6 = records.collectFirst((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(ResourceRecord x) {
                    boolean bl;
                    ResourceRecord resourceRecord = x;
                    if (resourceRecord instanceof AAAARecord) {
                        Inet6Address inet6Address;
                        AAAARecord aAAARecord = AAAARecord$.MODULE$.unapply((AAAARecord)resourceRecord);
                        String string = aAAARecord._1();
                        CachePolicy.Ttl ttl = aAAARecord._2();
                        Inet6Address ip = inet6Address = aAAARecord._3();
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }

                public final Object applyOrElse(ResourceRecord x, Function1 function1) {
                    Object object;
                    ResourceRecord resourceRecord = x;
                    if (resourceRecord instanceof AAAARecord) {
                        Inet6Address inet6Address;
                        AAAARecord aAAARecord = AAAARecord$.MODULE$.unapply((AAAARecord)resourceRecord);
                        String string = aAAARecord._1();
                        CachePolicy.Ttl ttl = aAAARecord._2();
                        Inet6Address ip = inet6Address = aAAARecord._3();
                        object = ip;
                    } else {
                        object = function1.apply((Object)x);
                    }
                    return object;
                }
            });
            this._address = IpVersionSelector$.MODULE$.getInetAddress((Option<Inet4Address>)ipv4, (Option<Inet6Address>)ipv6);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Resolved)) return false;
            Resolved resolved = (Resolved)object;
            String string = this.name();
            String string2 = resolved.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            scala.collection.immutable.Seq<ResourceRecord> seq = this.records();
            scala.collection.immutable.Seq<ResourceRecord> seq2 = resolved.records();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            scala.collection.immutable.Seq<ResourceRecord> seq3 = this.additionalRecords();
            scala.collection.immutable.Seq<ResourceRecord> seq4 = resolved.additionalRecords();
            if (seq3 == null) {
                if (seq4 == null) return true;
                return false;
            } else {
                if (!seq3.equals(seq4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Resolved;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Resolved";
        }

        public Object productElement(int n) {
            scala.collection.immutable.Seq<ResourceRecord> seq;
            int n2 = n;
            switch (n2) {
                case 0: {
                    seq = this._1();
                    break;
                }
                case 1: {
                    seq = this._2();
                    break;
                }
                case 2: {
                    seq = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return seq;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "name";
                    break;
                }
                case 1: {
                    string = "records";
                    break;
                }
                case 2: {
                    string = "additionalRecords";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public String name() {
            return this.name;
        }

        public scala.collection.immutable.Seq<ResourceRecord> records() {
            return this.records;
        }

        public scala.collection.immutable.Seq<ResourceRecord> additionalRecords() {
            return this.additionalRecords;
        }

        public List<ResourceRecord> getRecords() {
            return package$JavaConverters$.MODULE$.SeqHasAsJava((Seq)this.records()).asJava();
        }

        public List<ResourceRecord> getAdditionalRecords() {
            return package$JavaConverters$.MODULE$.SeqHasAsJava((Seq)this.additionalRecords()).asJava();
        }

        public InetAddress address() {
            Option<InetAddress> option = this._address;
            if (None$.MODULE$.equals(option)) {
                throw new UnknownHostException(this.name());
            }
            if (!(option instanceof Some)) {
                throw new MatchError(option);
            }
            InetAddress ipAddress = (InetAddress)((Some)option).value();
            return ipAddress;
        }

        public Resolved copy(String name, scala.collection.immutable.Seq<ResourceRecord> records, scala.collection.immutable.Seq<ResourceRecord> additionalRecords) {
            return new Resolved(name, records, additionalRecords);
        }

        public String copy$default$1() {
            return this.name();
        }

        public scala.collection.immutable.Seq<ResourceRecord> copy$default$2() {
            return this.records();
        }

        public scala.collection.immutable.Seq<ResourceRecord> copy$default$3() {
            return this.additionalRecords();
        }

        public String _1() {
            return this.name();
        }

        public scala.collection.immutable.Seq<ResourceRecord> _2() {
            return this.records();
        }

        public scala.collection.immutable.Seq<ResourceRecord> _3() {
            return this.additionalRecords();
        }
    }
}

