/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns;

import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.io.dns.CachePolicy;
import akka.io.dns.CachePolicy$Forever$;
import akka.io.dns.CachePolicy$Never$;
import akka.io.dns.CachePolicy$Ttl$;
import akka.io.dns.DnsSettings$;
import akka.io.dns.internal.ResolvConf;
import akka.io.dns.internal.ResolvConfParser$;
import akka.util.Helpers$;
import akka.util.Helpers$Requiring$;
import akka.util.JavaDurationConverters$;
import akka.util.JavaDurationConverters$JavaDurationOps$;
import akka.util.ccompat.package$JavaConverters$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueType;
import dotty.runtime.LazyVals$;
import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JFunction1;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.time.Duration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@InternalApi
public final class DnsSettings {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(DnsSettings.class, "bitmap$0");
    public long bitmap$0;
    private final ExtendedActorSystem system;
    private final Config c;
    private final List NameServers;
    private final FiniteDuration ResolveTimeout;
    private final CachePolicy.CachePolicy PositiveCachePolicy;
    private final CachePolicy.CachePolicy NegativeCachePolicy;
    private Option resolvConf$lzy1;
    private final List SearchDomains;
    private final int NDots;

    public static Try<List<InetSocketAddress>> getDefaultNameServers(ExtendedActorSystem extendedActorSystem) {
        return DnsSettings$.MODULE$.getDefaultNameServers(extendedActorSystem);
    }

    @InternalApi
    public static InetSocketAddress parseNameserverAddress(String string) {
        return DnsSettings$.MODULE$.parseNameserverAddress(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DnsSettings(ExtendedActorSystem system, Config c) {
        int n;
        List list;
        List list2;
        this.system = system;
        this.c = c;
        ConfigValueType configValueType = c.getValue("nameservers").valueType();
        if (ConfigValueType.STRING.equals(configValueType)) {
            String string = c.getString("nameservers");
            if ("default".equals(string)) {
                List osAddresses = (List)DnsSettings$.MODULE$.getDefaultNameServers(system).getOrElse(this::$anonfun$1);
                if (osAddresses.isEmpty()) {
                    throw this.failUnableToDetermineDefaultNameservers();
                }
                list2 = osAddresses;
            } else {
                String other = string;
                InetSocketAddress inetSocketAddress = DnsSettings$.MODULE$.parseNameserverAddress(other);
                list2 = package$.MODULE$.Nil().$colon$colon((Object)inetSocketAddress);
            }
        } else {
            if (!ConfigValueType.LIST.equals(configValueType)) throw new IllegalArgumentException("Invalid type for nameservers. Must be a string or string list");
            IndexedSeq userAddresses = (IndexedSeq)package$JavaConverters$.MODULE$.ListHasAsScala(c.getStringList("nameservers")).asScala().iterator().map((Function1)(JFunction1 & Serializable)str -> DnsSettings$.MODULE$.parseNameserverAddress((String)str)).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$));
            Predef$.MODULE$.require(userAddresses.nonEmpty(), DnsSettings::$init$$$anonfun$1);
            list2 = userAddresses.toList();
        }
        this.NameServers = list2;
        this.ResolveTimeout = JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(c.getDuration("resolve-timeout")));
        this.PositiveCachePolicy = this.getTtl("positive-ttl");
        this.NegativeCachePolicy = this.getTtl("negative-ttl");
        ConfigValueType configValueType2 = c.getValue("search-domains").valueType();
        if (ConfigValueType.STRING.equals(configValueType2)) {
            String string = c.getString("search-domains");
            if ("default".equals(string)) {
                list = (List)this.resolvConf().map((Function1)(JFunction1 & Serializable)_$2 -> _$2.search()).getOrElse(DnsSettings::$init$$$anonfun$3);
            } else {
                String single = string;
                list = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{single}));
            }
        } else {
            if (!ConfigValueType.LIST.equals(configValueType2)) throw new IllegalArgumentException("Invalid type for search-domains. Must be a string or string list.");
            list = package$JavaConverters$.MODULE$.ListHasAsScala(c.getStringList("search-domains")).asScala().toList();
        }
        this.SearchDomains = list;
        ConfigValueType configValueType3 = c.getValue("ndots").valueType();
        if (ConfigValueType.STRING.equals(configValueType3)) {
            String string = c.getString("ndots");
            if (!"default".equals(string)) throw new IllegalArgumentException("Invalid value for ndots. Must be the string 'default' or an integer.");
            n = BoxesRunTime.unboxToInt((Object)this.resolvConf().map((Function1)(JFunction1 & Serializable)_$3 -> _$3.ndots()).getOrElse((Function0)((JFunction0.mcI.sp & Serializable)DnsSettings::$init$$$anonfun$5)));
        } else {
            if (!ConfigValueType.NUMBER.equals(configValueType3)) throw new IllegalArgumentException("Invalid value for ndots. Must be the string 'default' or an integer.");
            int ndots = c.getInt("ndots");
            if (ndots < 0) {
                throw new IllegalArgumentException("Invalid value for ndots, ndots must not be negative.");
            }
            n = ndots;
        }
        this.NDots = n;
    }

    public List<InetSocketAddress> NameServers() {
        return this.NameServers;
    }

    public FiniteDuration ResolveTimeout() {
        return this.ResolveTimeout;
    }

    public CachePolicy.CachePolicy PositiveCachePolicy() {
        return this.PositiveCachePolicy;
    }

    public CachePolicy.CachePolicy NegativeCachePolicy() {
        return this.NegativeCachePolicy;
    }

    private CachePolicy.CachePolicy getTtl(String path) {
        CachePolicy.CachePolicy cachePolicy;
        String string = this.c.getString(path);
        if ("forever".equals(string)) {
            cachePolicy = CachePolicy$Forever$.MODULE$;
        } else if ("never".equals(string)) {
            cachePolicy = CachePolicy$Never$.MODULE$;
        } else {
            Duration duration = Helpers$.MODULE$.Requiring(this.c.getDuration(path));
            Duration finiteTtl = Helpers$Requiring$.MODULE$.requiring$extension(duration, (JFunction1 & Serializable)_$1 -> !_$1.isNegative(), (Function0<Object>)((Function0 & Serializable)() -> DnsSettings.$anonfun$4(path)));
            cachePolicy = CachePolicy$Ttl$.MODULE$.fromPositive(finiteTtl);
        }
        return cachePolicy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<ResolvConf> resolvConf() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    None$ none$;
                    File etcResolvConf = new File("/etc/resolv.conf");
                    if (Helpers$.MODULE$.isWindows()) {
                        none$ = None$.MODULE$;
                    } else if (etcResolvConf.exists()) {
                        Try<ResolvConf> parsed = ResolvConfParser$.MODULE$.parseFile(etcResolvConf);
                        Try<ResolvConf> try_ = parsed;
                        if (try_ instanceof Success) {
                            ResolvConf value = (ResolvConf)((Success)try_).value();
                            none$ = Some$.MODULE$.apply((Object)value);
                        } else {
                            if (!(try_ instanceof Failure)) throw new MatchError(try_);
                            Throwable exception = ((Failure)try_).exception();
                            LoggingAdapter log = Logging$.MODULE$.apply(this.system, this.getClass(), LogSource$.MODULE$.fromAnyClass());
                            if (log.isWarningEnabled()) {
                                log.error(exception, "Error parsing /etc/resolv.conf, ignoring.");
                            }
                            none$ = None$.MODULE$;
                        }
                    } else {
                        none$ = None$.MODULE$;
                    }
                    None$ none$2 = none$;
                    this.resolvConf$lzy1 = none$2;
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return none$2;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.resolvConf$lzy1;
    }

    public List<String> SearchDomains() {
        return this.SearchDomains;
    }

    public int NDots() {
        return this.NDots;
    }

    public Nothing$ failUnableToDetermineDefaultNameservers() {
        throw new IllegalStateException("Unable to obtain default nameservers from JNDI or via reflection. Please set `akka.io.dns.async-dns.nameservers` explicitly in order to be able to resolve domain names. ");
    }

    private final List $anonfun$1() {
        throw this.failUnableToDetermineDefaultNameservers();
    }

    private static final String $init$$$anonfun$1() {
        return "nameservers can not be empty";
    }

    private static final Nil$ $init$$$anonfun$3() {
        return package$.MODULE$.Nil();
    }

    private static final int $init$$$anonfun$5() {
        return 1;
    }

    private static final String $anonfun$4(String path$1) {
        return "akka.io.dns." + path$1 + " must be 'default', 'forever', 'never' or positive duration";
    }
}

