/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ActorRef$;
import akka.actor.Deploy$;
import akka.actor.ExtendedActorSystem;
import akka.actor.Props;
import akka.actor.Props$;
import akka.actor.TimerSchedulerImpl;
import akka.actor.Timers;
import akka.annotation.InternalApi;
import akka.dispatch.RequiresMessageQueue;
import akka.dispatch.UnboundedMessageQueueSemantics;
import akka.event.LoggingAdapter;
import akka.io.Dns;
import akka.io.Dns$Resolve$;
import akka.io.Dns$Resolved$;
import akka.io.DnsExt;
import akka.io.DnsProvider;
import akka.io.PeriodicCacheCleanup;
import akka.io.dns.AAAARecord;
import akka.io.dns.ARecord;
import akka.io.dns.DnsProtocol;
import akka.io.dns.DnsProtocol$Resolve$;
import akka.io.dns.DnsSettings;
import akka.io.dns.ResourceRecord;
import akka.io.dns.internal.AsyncDnsManager$CacheCleanup$;
import akka.io.dns.internal.AsyncDnsManager$GetCache$;
import akka.io.dns.internal.DnsClient;
import akka.pattern.AskableActorRef$;
import akka.pattern.package$;
import akka.routing.FromConfig$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.typesafe.config.Config;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JFunction2;
import dotty.runtime.function.JProcedure1;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class AsyncDnsManager
implements RequiresMessageQueue<UnboundedMessageQueueSemantics>,
ActorLogging,
Timers {
    private final ActorContext context;
    private final ActorRef self;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final TimerSchedulerImpl akka$actor$Timers$$_timers;
    private final Config resolverConfig;
    public final Dns akka$io$dns$internal$AsyncDnsManager$$cache;
    private final ExecutionContextExecutor ec;
    private final DnsSettings settings;
    private final Timeout timeout;
    public final ActorRef akka$io$dns$internal$AsyncDnsManager$$resolver;
    public final Option<Dns> akka$io$dns$internal$AsyncDnsManager$$cacheCleanup;

    public AsyncDnsManager(String name, ExtendedActorSystem system, Config resolverConfig, Dns cache, String dispatcher, DnsProvider provider) {
        None$ none$;
        this.resolverConfig = resolverConfig;
        this.akka$io$dns$internal$AsyncDnsManager$$cache = cache;
        this.context = Actor.super.initial$context();
        this.self = Actor.super.initial$self();
        this.akka$actor$ActorLogging$$_log = ActorLogging.super.akka$actor$ActorLogging$$initial$_log();
        ActorLogging.super.$init$();
        this.akka$actor$Timers$$_timers = Timers.super.akka$actor$Timers$$initial$_timers();
        Timers.super.$init$();
        this.ec = this.context().dispatcher();
        this.settings = new DnsSettings(system, resolverConfig);
        this.timeout = Timeout$.MODULE$.apply(this.settings().ResolveTimeout());
        Props props = FromConfig$.MODULE$.props(Props$.MODULE$.apply(provider.actorClass(), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.settings(), cache, (JFunction2 & Serializable)(factory, dns) -> dns.map((Function1)(JFunction1 & Serializable)ns -> factory.actorOf(Props$.MODULE$.apply(() -> AsyncDnsManager.$anonfun$2$$anonfun$1$$anonfun$1(ns), ClassTag$.MODULE$.apply(DnsClient.class))))})).withDeploy(Deploy$.MODULE$.local()).withDispatcher(dispatcher));
        this.akka$io$dns$internal$AsyncDnsManager$$resolver = this.context().actorOf(props, name);
        Dns dns2 = cache;
        if (dns2 instanceof PeriodicCacheCleanup) {
            Dns cleanup = (Dns)((Object)((PeriodicCacheCleanup)((Object)dns2)));
            none$ = Some$.MODULE$.apply((Object)cleanup);
        } else {
            none$ = None$.MODULE$;
        }
        this.akka$io$dns$internal$AsyncDnsManager$$cacheCleanup = none$;
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public TimerSchedulerImpl akka$actor$Timers$$_timers() {
        return this.akka$actor$Timers$$_timers;
    }

    @Override
    public /* synthetic */ void akka$actor$Timers$$super$aroundPreRestart(Throwable reason, Option message) {
        Actor.super.aroundPreRestart(reason, (Option<Object>)message);
    }

    @Override
    public /* synthetic */ void akka$actor$Timers$$super$aroundPostStop() {
        Actor.super.aroundPostStop();
    }

    @Override
    public /* synthetic */ void akka$actor$Timers$$super$aroundReceive(PartialFunction receive, Object msg) {
        Actor.super.aroundReceive(receive, msg);
    }

    public AsyncDnsManager(DnsExt ext) {
        this(ext.Settings().Resolver(), ext.system(), ext.Settings().ResolverConfig(), ext.cache(), ext.Settings().Dispatcher(), ext.provider());
    }

    public ExecutionContextExecutor ec() {
        return this.ec;
    }

    public DnsSettings settings() {
        return this.settings;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    @Override
    public void preStart() {
        this.akka$io$dns$internal$AsyncDnsManager$$cacheCleanup.foreach((Function1)(JProcedure1 & Serializable)_$1 -> {
            FiniteDuration interval = Duration$.MODULE$.apply(this.resolverConfig.getDuration("cache-cleanup-interval", TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            this.timers().startTimerWithFixedDelay((Object)AsyncDnsManager$CacheCleanup$.MODULE$, (Object)AsyncDnsManager$CacheCleanup$.MODULE$, interval);
        });
    }

    @Override
    public PartialFunction receive() {
        return new Serializable(this){
            private final AsyncDnsManager $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                boolean bl;
                Object object = x;
                if (object instanceof DnsProtocol.Resolve) {
                    DnsProtocol.Resolve r = (DnsProtocol.Resolve)object;
                    bl = true;
                } else if (object instanceof Dns.Resolve) {
                    String string;
                    Dns.Resolve resolve = Dns$Resolve$.MODULE$.unapply((Dns.Resolve)object);
                    String name = string = resolve._1();
                    bl = true;
                } else {
                    bl = AsyncDnsManager$CacheCleanup$.MODULE$.equals(object) ? true : AsyncDnsManager$GetCache$.MODULE$.equals(object);
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof DnsProtocol.Resolve) {
                    DnsProtocol.Resolve r = (DnsProtocol.Resolve)object2;
                    this.$outer.log().debug("Resolution request for {} {} from {}", r.name(), r.requestType(), this.$outer.sender());
                    this.$outer.akka$io$dns$internal$AsyncDnsManager$$resolver.forward(r, this.$outer.context());
                    object = BoxedUnit.UNIT;
                } else if (object2 instanceof Dns.Resolve) {
                    String string;
                    Dns.Resolve resolve = Dns$Resolve$.MODULE$.unapply((Dns.Resolve)object2);
                    String name = string = resolve._1();
                    this.$outer.log().debug("(deprecated) Resolution request for {} from {}", name, this.$outer.sender());
                    DnsProtocol.Resolve adapted = DnsProtocol$Resolve$.MODULE$.apply(name);
                    Future reply = AskableActorRef$.MODULE$.$qmark$extension(package$.MODULE$.ask(this.$outer.akka$io$dns$internal$AsyncDnsManager$$resolver), adapted, this.$outer.timeout(), this.$outer.self()).mapTo(ClassTag$.MODULE$.apply(DnsProtocol.Resolved.class)).map((Function1)((JFunction1 & Serializable)AsyncDnsManager::akka$io$dns$internal$AsyncDnsManager$$anon$1$$_$_$$anonfun$4), (ExecutionContext)this.$outer.ec());
                    package$.MODULE$.pipe(reply, (ExecutionContext)this.$outer.ec()).pipeTo(this.$outer.sender(), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else if (AsyncDnsManager$CacheCleanup$.MODULE$.equals(object2)) {
                    this.$outer.akka$io$dns$internal$AsyncDnsManager$$cacheCleanup.foreach((Function1)((JProcedure1 & Serializable)AsyncDnsManager::akka$io$dns$internal$AsyncDnsManager$$anon$1$$_$applyOrElse$$anonfun$1));
                    object = BoxedUnit.UNIT;
                } else if (AsyncDnsManager$GetCache$.MODULE$.equals(object2)) {
                    ActorRef$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang(this.$outer.akka$io$dns$internal$AsyncDnsManager$$cache, this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x);
                }
                return object;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{akka$io$dns$internal$AsyncDnsManager$$anon$1$$_$_$$anonfun$4(akka.io.dns.DnsProtocol$Resolved ), akka$io$dns$internal$AsyncDnsManager$$anon$1$$_$applyOrElse$$anonfun$1(akka.io.Dns )}, serializedLambda);
            }
        };
    }

    private static final DnsClient $anonfun$2$$anonfun$1$$anonfun$1(InetSocketAddress ns$1) {
        return new DnsClient(ns$1);
    }

    public static final /* synthetic */ Dns.Resolved akka$io$dns$internal$AsyncDnsManager$$anon$1$$_$_$$anonfun$4(DnsProtocol.Resolved asyncResolved) {
        Seq ips = (Seq)asyncResolved.records().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(ResourceRecord x) {
                boolean bl;
                ResourceRecord resourceRecord = x;
                if (resourceRecord instanceof ARecord) {
                    ARecord a = (ARecord)resourceRecord;
                    bl = true;
                } else if (resourceRecord instanceof AAAARecord) {
                    AAAARecord a = (AAAARecord)resourceRecord;
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(ResourceRecord x, Function1 function1) {
                Object object;
                ResourceRecord resourceRecord = x;
                if (resourceRecord instanceof ARecord) {
                    ARecord a = (ARecord)resourceRecord;
                    object = a.ip();
                } else if (resourceRecord instanceof AAAARecord) {
                    AAAARecord a = (AAAARecord)resourceRecord;
                    object = a.ip();
                } else {
                    object = function1.apply((Object)x);
                }
                return object;
            }
        });
        return Dns$Resolved$.MODULE$.apply(asyncResolved.name(), (Iterable<InetAddress>)ips);
    }

    public static final /* synthetic */ void akka$io$dns$internal$AsyncDnsManager$$anon$1$$_$applyOrElse$$anonfun$1(Dns _$2) {
        ((PeriodicCacheCleanup)((Object)_$2)).cleanup();
    }
}

