/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ActorRef$;
import akka.actor.NoSerializationVerificationNeeded;
import akka.actor.Props$;
import akka.actor.Stash;
import akka.actor.StashSupport;
import akka.actor.Status$Failure$;
import akka.actor.UnrestrictedStash;
import akka.annotation.InternalApi;
import akka.dispatch.DequeBasedMessageQueueSemantics;
import akka.event.LoggingAdapter;
import akka.io.IO$;
import akka.io.Inet;
import akka.io.Tcp$;
import akka.io.Udp;
import akka.io.Udp$;
import akka.io.Udp$Bind$;
import akka.io.Udp$Bound$;
import akka.io.Udp$CommandFailed$;
import akka.io.Udp$Received$;
import akka.io.Udp$Send$;
import akka.io.Udp$Unbind$;
import akka.io.Udp$Unbound$;
import akka.io.dns.RecordClass$;
import akka.io.dns.RecordType;
import akka.io.dns.RecordType$;
import akka.io.dns.ResourceRecord;
import akka.io.dns.internal.DnsClient$Answer$;
import akka.io.dns.internal.DnsClient$DropRequest$;
import akka.io.dns.internal.DnsClient$Question4$;
import akka.io.dns.internal.DnsClient$Question6$;
import akka.io.dns.internal.DnsClient$SrvQuestion$;
import akka.io.dns.internal.Message;
import akka.io.dns.internal.Message$;
import akka.io.dns.internal.MessageFlags$;
import akka.io.dns.internal.Question;
import akka.io.dns.internal.Question$;
import akka.io.dns.internal.ResponseCode$;
import akka.io.dns.internal.TcpDnsClient;
import akka.pattern.BackoffOpts$;
import akka.pattern.BackoffSupervisor$;
import akka.util.ByteString;
import dotty.runtime.LazyVals$;
import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JProcedure1;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Try$;

@InternalApi
public class DnsClient
implements Actor,
ActorLogging,
StashSupport,
UnrestrictedStash,
Stash {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(DnsClient.class, "bitmap$0");
    private final ActorContext context;
    private final ActorRef self;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private Vector akka$actor$StashSupport$$theStash;
    private final int akka$actor$StashSupport$$capacity;
    private final DequeBasedMessageQueueSemantics mailbox;
    public long bitmap$0;
    public final InetSocketAddress akka$io$dns$internal$DnsClient$$ns;
    private final ActorRef udp;
    private final ActorRef tcp;
    private Map inflightRequests;
    public ActorRef tcpDnsClient$lzy1;

    public DnsClient(InetSocketAddress ns) {
        this.akka$io$dns$internal$DnsClient$$ns = ns;
        this.context = Actor.super.initial$context();
        this.self = Actor.super.initial$self();
        this.akka$actor$ActorLogging$$_log = ActorLogging.super.akka$actor$ActorLogging$$initial$_log();
        ActorLogging.super.$init$();
        this.akka$actor$StashSupport$$theStash = StashSupport.super.akka$actor$StashSupport$$initial$theStash();
        this.akka$actor$StashSupport$$capacity = StashSupport.super.akka$actor$StashSupport$$initial$capacity();
        this.mailbox = StashSupport.super.initial$mailbox();
        StashSupport.super.$init$();
        this.udp = IO$.MODULE$.apply(Udp$.MODULE$, this.context().system());
        this.tcp = IO$.MODULE$.apply(Tcp$.MODULE$, this.context().system());
        this.inflightRequests = Predef$.MODULE$.Map().empty();
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public Vector akka$actor$StashSupport$$theStash() {
        return this.akka$actor$StashSupport$$theStash;
    }

    @Override
    public int akka$actor$StashSupport$$capacity() {
        return this.akka$actor$StashSupport$$capacity;
    }

    @Override
    public DequeBasedMessageQueueSemantics mailbox() {
        return this.mailbox;
    }

    public void akka$actor$StashSupport$$theStash_$eq(Vector x$1) {
        this.akka$actor$StashSupport$$theStash = x$1;
    }

    @Override
    public /* synthetic */ void akka$actor$UnrestrictedStash$$super$preRestart(Throwable reason, Option message) {
        Actor.super.preRestart(reason, (Option<Object>)message);
    }

    @Override
    public /* synthetic */ void akka$actor$UnrestrictedStash$$super$postStop() {
        Actor.super.postStop();
    }

    public ActorRef udp() {
        return this.udp;
    }

    public ActorRef tcp() {
        return this.tcp;
    }

    public Map<Object, Tuple2<ActorRef, Message>> inflightRequests() {
        return this.inflightRequests;
    }

    public void inflightRequests_$eq(Map<Object, Tuple2<ActorRef, Message>> x$1) {
        this.inflightRequests = x$1;
    }

    public ActorRef tcpDnsClient() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    ActorRef actorRef;
                    this.tcpDnsClient$lzy1 = actorRef = this.createTcpClient();
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return actorRef;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.tcpDnsClient$lzy1;
    }

    @Override
    public void preStart() {
        ActorRef$.MODULE$.actorRef2Scala(this.udp()).$bang(Udp$Bind$.MODULE$.apply(this.self(), new InetSocketAddress(InetAddress.getByAddress(new byte[4]), 0), (Iterable<Inet.SocketOption>)Udp$Bind$.MODULE$.$lessinit$greater$default$3()), this.self());
    }

    @Override
    public PartialFunction receive() {
        return new Serializable(this){
            private final DnsClient $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                boolean bl;
                Object object = x;
                if (object instanceof Udp.Bound) {
                    InetSocketAddress inetSocketAddress;
                    Udp.Bound bound = Udp$Bound$.MODULE$.unapply((Udp.Bound)object);
                    InetSocketAddress local = inetSocketAddress = bound._1();
                    bl = true;
                } else {
                    bl = object instanceof Question4 ? true : (object instanceof Question6 ? true : object instanceof SrvQuestion);
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof Udp.Bound) {
                    InetSocketAddress inetSocketAddress;
                    Udp.Bound bound = Udp$Bound$.MODULE$.unapply((Udp.Bound)object2);
                    InetSocketAddress local = inetSocketAddress = bound._1();
                    this.$outer.log().debug("Bound to UDP address [{}]", local);
                    this.$outer.context().become(this.$outer.ready(this.$outer.sender()));
                    this.$outer.unstashAll();
                    object = BoxedUnit.UNIT;
                } else if (object2 instanceof Question4) {
                    this.$outer.stash();
                    object = BoxedUnit.UNIT;
                } else if (object2 instanceof Question6) {
                    this.$outer.stash();
                    object = BoxedUnit.UNIT;
                } else if (object2 instanceof SrvQuestion) {
                    this.$outer.stash();
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x);
                }
                return object;
            }
        };
    }

    public Message akka$io$dns$internal$DnsClient$$message(String name, short id, RecordType recordType) {
        return Message$.MODULE$.apply(id, MessageFlags$.MODULE$.apply(MessageFlags$.MODULE$.apply$default$1(), MessageFlags$.MODULE$.apply$default$2(), MessageFlags$.MODULE$.apply$default$3(), MessageFlags$.MODULE$.apply$default$4(), MessageFlags$.MODULE$.apply$default$5(), MessageFlags$.MODULE$.apply$default$6(), MessageFlags$.MODULE$.apply$default$7()), (Seq<Question>)((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Question[]{Question$.MODULE$.apply(name, recordType, RecordClass$.MODULE$.IN())}))), Message$.MODULE$.$lessinit$greater$default$4(), Message$.MODULE$.$lessinit$greater$default$5(), Message$.MODULE$.$lessinit$greater$default$6());
    }

    public PartialFunction ready(ActorRef socket) {
        return new Serializable(socket, this){
            private final ActorRef socket$1;
            private final DnsClient $outer;
            {
                this.socket$1 = socket$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                boolean bl;
                Object object = x;
                if (object instanceof DropRequest) {
                    short s;
                    DropRequest dropRequest = DnsClient$DropRequest$.MODULE$.unapply((DropRequest)object);
                    short id = s = dropRequest._1();
                    bl = true;
                } else if (object instanceof Question4) {
                    Question4 question4 = DnsClient$Question4$.MODULE$.unapply((Question4)object);
                    short s = question4._1();
                    String string = question4._2();
                    short id = s;
                    String name = string;
                    bl = true;
                } else if (object instanceof Question6) {
                    Question6 question6 = DnsClient$Question6$.MODULE$.unapply((Question6)object);
                    short s = question6._1();
                    String string = question6._2();
                    short id = s;
                    String name = string;
                    bl = true;
                } else if (object instanceof SrvQuestion) {
                    SrvQuestion srvQuestion = DnsClient$SrvQuestion$.MODULE$.unapply((SrvQuestion)object);
                    short s = srvQuestion._1();
                    String string = srvQuestion._2();
                    short id = s;
                    String name = string;
                    bl = true;
                } else if (object instanceof Udp.CommandFailed) {
                    Udp.Command command;
                    Udp.CommandFailed commandFailed = Udp$CommandFailed$.MODULE$.unapply((Udp.CommandFailed)object);
                    Udp.Command cmd = command = commandFailed._1();
                    bl = true;
                } else if (object instanceof Udp.Received) {
                    Udp.Received received = Udp$Received$.MODULE$.unapply((Udp.Received)object);
                    ByteString byteString = received._1();
                    InetSocketAddress inetSocketAddress = received._2();
                    ByteString data = byteString;
                    InetSocketAddress remote = inetSocketAddress;
                    bl = true;
                } else if (object instanceof Answer) {
                    Answer response = (Answer)object;
                    bl = true;
                } else {
                    bl = Udp$Unbind$.MODULE$.equals(object) ? true : Udp$Unbound$.MODULE$.equals(object);
                }
                return bl;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof DropRequest) {
                    short s;
                    DropRequest dropRequest = DnsClient$DropRequest$.MODULE$.unapply((DropRequest)object2);
                    short id = s = dropRequest._1();
                    this.$outer.log().debug("Dropping request [{}]", BoxesRunTime.boxToShort((short)id));
                    this.$outer.inflightRequests_$eq((Map<Object, Tuple2<ActorRef, Message>>)((Map)this.$outer.inflightRequests().$minus((Object)BoxesRunTime.boxToShort((short)id))));
                    object = BoxedUnit.UNIT;
                } else if (object2 instanceof Question4) {
                    Question4 question4 = DnsClient$Question4$.MODULE$.unapply((Question4)object2);
                    short s = question4._1();
                    String string = question4._2();
                    short id = s;
                    String name = string;
                    this.$outer.log().debug("Resolving [{}] (A)", name);
                    Message msg = this.$outer.akka$io$dns$internal$DnsClient$$message(name, id, RecordType$.MODULE$.A());
                    Object object3 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToShort((short)id));
                    Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.$outer.sender());
                    this.$outer.inflightRequests_$eq((Map<Object, Tuple2<ActorRef, Message>>)((Map)this.$outer.inflightRequests().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object3, (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object4, (Object)msg)))));
                    this.$outer.log().debug("Message [{}] to [{}]: [{}]", BoxesRunTime.boxToShort((short)id), this.$outer.akka$io$dns$internal$DnsClient$$ns, msg);
                    ActorRef$.MODULE$.actorRef2Scala(this.socket$1).$bang(Udp$Send$.MODULE$.apply(msg.write(), this.$outer.akka$io$dns$internal$DnsClient$$ns), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else if (object2 instanceof Question6) {
                    Question6 question6 = DnsClient$Question6$.MODULE$.unapply((Question6)object2);
                    short s = question6._1();
                    String string = question6._2();
                    short id = s;
                    String name = string;
                    this.$outer.log().debug("Resolving [{}] (AAAA)", name);
                    Message msg = this.$outer.akka$io$dns$internal$DnsClient$$message(name, id, RecordType$.MODULE$.AAAA());
                    Object object5 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToShort((short)id));
                    Object object6 = Predef$.MODULE$.ArrowAssoc((Object)this.$outer.sender());
                    this.$outer.inflightRequests_$eq((Map<Object, Tuple2<ActorRef, Message>>)((Map)this.$outer.inflightRequests().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object5, (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object6, (Object)msg)))));
                    this.$outer.log().debug("Message to [{}]: [{}]", this.$outer.akka$io$dns$internal$DnsClient$$ns, msg);
                    ActorRef$.MODULE$.actorRef2Scala(this.socket$1).$bang(Udp$Send$.MODULE$.apply(msg.write(), this.$outer.akka$io$dns$internal$DnsClient$$ns), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else if (object2 instanceof SrvQuestion) {
                    SrvQuestion srvQuestion = DnsClient$SrvQuestion$.MODULE$.unapply((SrvQuestion)object2);
                    short s = srvQuestion._1();
                    String string = srvQuestion._2();
                    short id = s;
                    String name = string;
                    this.$outer.log().debug("Resolving [{}] (SRV)", name);
                    Message msg = this.$outer.akka$io$dns$internal$DnsClient$$message(name, id, RecordType$.MODULE$.SRV());
                    Object object7 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToShort((short)id));
                    Object object8 = Predef$.MODULE$.ArrowAssoc((Object)this.$outer.sender());
                    this.$outer.inflightRequests_$eq((Map<Object, Tuple2<ActorRef, Message>>)((Map)this.$outer.inflightRequests().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object7, (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object8, (Object)msg)))));
                    this.$outer.log().debug("Message to [{}]: [{}]", this.$outer.akka$io$dns$internal$DnsClient$$ns, msg);
                    ActorRef$.MODULE$.actorRef2Scala(this.socket$1).$bang(Udp$Send$.MODULE$.apply(msg.write(), this.$outer.akka$io$dns$internal$DnsClient$$ns), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else if (object2 instanceof Udp.CommandFailed) {
                    Udp.Command command;
                    Udp.CommandFailed commandFailed = Udp$CommandFailed$.MODULE$.unapply((Udp.CommandFailed)object2);
                    Udp.Command cmd = command = commandFailed._1();
                    this.$outer.log().debug("Command failed [{}]", cmd);
                    Udp.Command command2 = cmd;
                    if (command2 instanceof Udp.Send) {
                        Udp.Send send = (Udp.Send)command2;
                        Try$.MODULE$.apply((Function0)((JFunction0.mcV.sp & Serializable)() -> this.applyOrElse$$anonfun$1(send)));
                    } else {
                        this.$outer.log().warning("Dns client failed to send {}", cmd);
                    }
                    object = BoxedUnit.UNIT;
                } else if (object2 instanceof Udp.Received) {
                    Udp.Received received = Udp$Received$.MODULE$.unapply((Udp.Received)object2);
                    ByteString byteString = received._1();
                    InetSocketAddress inetSocketAddress = received._2();
                    ByteString data = byteString;
                    InetSocketAddress remote = inetSocketAddress;
                    this.$outer.log().debug("Received message from [{}]: [{}]", remote, data);
                    Message msg = Message$.MODULE$.parse(data);
                    this.$outer.log().debug("Decoded UDP DNS response [{}]", msg);
                    if (MessageFlags$.MODULE$.isTruncated$extension(msg.flags())) {
                        Tuple2 tuple2;
                        this.$outer.log().debug("DNS response truncated, falling back to TCP");
                        Option option = this.$outer.inflightRequests().get((Object)BoxesRunTime.boxToShort((short)msg.id()));
                        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                            Message msg2 = (Message)tuple2._2();
                            ActorRef$.MODULE$.actorRef2Scala(this.$outer.tcpDnsClient()).$bang(msg2, this.$outer.self());
                        } else {
                            this.$outer.log().debug("Client for id {} not found. Discarding unsuccessful response.", BoxesRunTime.boxToShort((short)msg.id()));
                        }
                        object = BoxedUnit.UNIT;
                    } else {
                        Enumeration.Value value = MessageFlags$.MODULE$.responseCode$extension(msg.flags());
                        Enumeration.Value value2 = ResponseCode$.MODULE$.SUCCESS();
                        Tuple2 tuple2 = !(value != null ? !value.equals(value2) : value2 != null) ? Tuple2$.MODULE$.apply(msg.answerRecs(), msg.additionalRecs()) : Tuple2$.MODULE$.apply((Object)scala.package$.MODULE$.Nil(), (Object)scala.package$.MODULE$.Nil());
                        Seq recs = (Seq)tuple2._1();
                        Seq additionalRecs = (Seq)tuple2._2();
                        ActorRef$.MODULE$.actorRef2Scala(this.$outer.self()).$bang(DnsClient$Answer$.MODULE$.apply(msg.id(), (Seq<ResourceRecord>)recs, (Seq<ResourceRecord>)additionalRecs), this.$outer.self());
                        object = BoxedUnit.UNIT;
                    }
                } else if (object2 instanceof Answer) {
                    Tuple2 tuple2;
                    Answer response = (Answer)object2;
                    Option option = this.$outer.inflightRequests().get((Object)BoxesRunTime.boxToShort((short)response.id()));
                    if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                        ActorRef reply = (ActorRef)tuple2._1();
                        ActorRef$.MODULE$.actorRef2Scala(reply).$bang(response, this.$outer.self());
                        this.$outer.inflightRequests_$eq((Map<Object, Tuple2<ActorRef, Message>>)((Map)this.$outer.inflightRequests().$minus((Object)BoxesRunTime.boxToShort((short)response.id()))));
                    } else if (None$.MODULE$.equals(option)) {
                        this.$outer.log().debug("Client for id {} not found. Discarding response.", BoxesRunTime.boxToShort((short)response.id()));
                    } else {
                        throw new MatchError((Object)option);
                    }
                    object = BoxedUnit.UNIT;
                } else if (Udp$Unbind$.MODULE$.equals(object2)) {
                    ActorRef$.MODULE$.actorRef2Scala(this.socket$1).$bang(Udp$Unbind$.MODULE$, this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else if (Udp$Unbound$.MODULE$.equals(object2)) {
                    this.$outer.context().stop(this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x);
                }
                return object;
            }

            private final void applyOrElse$$anonfun$1(Udp.Send send$1) {
                Message msg = Message$.MODULE$.parse(send$1.payload());
                this.$outer.inflightRequests().get((Object)BoxesRunTime.boxToShort((short)msg.id())).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    ActorRef s = (ActorRef)tuple2._1();
                    ActorRef$.MODULE$.actorRef2Scala(s).$bang(Status$Failure$.MODULE$.apply(new RuntimeException("Send failed to nameserver")), this.$outer.self());
                    this.$outer.inflightRequests_$eq((Map<Object, Tuple2<ActorRef, Message>>)((Map)this.$outer.inflightRequests().$minus((Object)BoxesRunTime.boxToShort((short)msg.id()))));
                });
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(akka.io.Udp$Send ), applyOrElse$$anonfun$2$$anonfun$1(akka.io.dns.internal.Message scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    public ActorRef createTcpClient() {
        return this.context().actorOf(BackoffSupervisor$.MODULE$.props(BackoffOpts$.MODULE$.onFailure(Props$.MODULE$.apply(TcpDnsClient.class, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tcp(), this.akka$io$dns$internal$DnsClient$$ns, this.self()})), "tcpDnsClient", new package.DurationInt(package$.MODULE$.DurationInt(10)).millis(), new package.DurationInt(package$.MODULE$.DurationInt(20)).seconds(), 0.1)), "tcpDnsClientSupervisor");
    }

    public static final class Answer
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final short id;
        private final Seq rrs;
        private final Seq additionalRecs;

        public static Answer apply(short s, Seq<ResourceRecord> seq, Seq<ResourceRecord> seq2) {
            return DnsClient$Answer$.MODULE$.apply(s, seq, seq2);
        }

        public static Function1 curried() {
            return DnsClient$Answer$.MODULE$.curried();
        }

        public static Answer fromProduct(Product product) {
            return DnsClient$Answer$.MODULE$.fromProduct(product);
        }

        public static Function1 tupled() {
            return DnsClient$Answer$.MODULE$.tupled();
        }

        public static Answer unapply(Answer answer) {
            return DnsClient$Answer$.MODULE$.unapply(answer);
        }

        public static Nil$ $lessinit$greater$default$3() {
            return DnsClient$Answer$.MODULE$.$lessinit$greater$default$3();
        }

        public Answer(short id, Seq<ResourceRecord> rrs, Seq<ResourceRecord> additionalRecs) {
            this.id = id;
            this.rrs = rrs;
            this.additionalRecs = additionalRecs;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.id());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.rrs()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.additionalRecs()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Answer)) return false;
            Answer answer = (Answer)object;
            if (this.id() != answer.id()) return false;
            Seq<ResourceRecord> seq = this.rrs();
            Seq<ResourceRecord> seq2 = answer.rrs();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<ResourceRecord> seq3 = this.additionalRecs();
            Seq<ResourceRecord> seq4 = answer.additionalRecs();
            if (seq3 == null) {
                if (seq4 == null) return true;
                return false;
            } else {
                if (!seq3.equals(seq4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Answer;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Answer";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = BoxesRunTime.boxToShort((short)this._1());
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "id";
                    break;
                }
                case 1: {
                    string = "rrs";
                    break;
                }
                case 2: {
                    string = "additionalRecs";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public short id() {
            return this.id;
        }

        public Seq<ResourceRecord> rrs() {
            return this.rrs;
        }

        public Seq<ResourceRecord> additionalRecs() {
            return this.additionalRecs;
        }

        public Answer copy(short id, Seq<ResourceRecord> rrs, Seq<ResourceRecord> additionalRecs) {
            return new Answer(id, rrs, additionalRecs);
        }

        public short copy$default$1() {
            return this.id();
        }

        public Seq<ResourceRecord> copy$default$2() {
            return this.rrs();
        }

        public Seq<ResourceRecord> copy$default$3() {
            return this.additionalRecs();
        }

        public short _1() {
            return this.id();
        }

        public Seq<ResourceRecord> _2() {
            return this.rrs();
        }

        public Seq<ResourceRecord> _3() {
            return this.additionalRecs();
        }
    }

    public static interface DnsQuestion {
        public short id();
    }

    public static final class DropRequest
    implements Product,
    Serializable {
        private final short id;

        public static <A> Function1<Object, A> andThen(Function1<DropRequest, A> function1) {
            return DnsClient$DropRequest$.MODULE$.andThen(function1);
        }

        public static DropRequest apply(short s) {
            return DnsClient$DropRequest$.MODULE$.apply(s);
        }

        public static <A> Function1<A, DropRequest> compose(Function1<A, Object> function1) {
            return DnsClient$DropRequest$.MODULE$.compose(function1);
        }

        public static DropRequest fromProduct(Product product) {
            return DnsClient$DropRequest$.MODULE$.fromProduct(product);
        }

        public static DropRequest unapply(DropRequest dropRequest) {
            return DnsClient$DropRequest$.MODULE$.unapply(dropRequest);
        }

        public DropRequest(short id) {
            this.id = id;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.id());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DropRequest)) return false;
            DropRequest dropRequest = (DropRequest)object;
            if (this.id() != dropRequest.id()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DropRequest;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DropRequest";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToShort((short)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "id";
        }

        public short id() {
            return this.id;
        }

        public DropRequest copy(short id) {
            return new DropRequest(id);
        }

        public short copy$default$1() {
            return this.id();
        }

        public short _1() {
            return this.id();
        }
    }

    public static final class Question4
    implements DnsQuestion,
    Product,
    Serializable {
        private final short id;
        private final String name;

        public static Question4 apply(short s, String string) {
            return DnsClient$Question4$.MODULE$.apply(s, string);
        }

        public static Function1 curried() {
            return DnsClient$Question4$.MODULE$.curried();
        }

        public static Question4 fromProduct(Product product) {
            return DnsClient$Question4$.MODULE$.fromProduct(product);
        }

        public static Function1 tupled() {
            return DnsClient$Question4$.MODULE$.tupled();
        }

        public static Question4 unapply(Question4 question4) {
            return DnsClient$Question4$.MODULE$.unapply(question4);
        }

        public Question4(short id, String name) {
            this.id = id;
            this.name = name;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.id());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Question4)) return false;
            Question4 question4 = (Question4)object;
            if (this.id() != question4.id()) return false;
            String string = this.name();
            String string2 = question4.name();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Question4;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Question4";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = BoxesRunTime.boxToShort((short)this._1());
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "id";
            } else if (1 == n2) {
                string = "name";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        @Override
        public short id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public Question4 copy(short id, String name) {
            return new Question4(id, name);
        }

        public short copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.name();
        }

        public short _1() {
            return this.id();
        }

        public String _2() {
            return this.name();
        }
    }

    public static final class Question6
    implements DnsQuestion,
    Product,
    Serializable {
        private final short id;
        private final String name;

        public static Question6 apply(short s, String string) {
            return DnsClient$Question6$.MODULE$.apply(s, string);
        }

        public static Function1 curried() {
            return DnsClient$Question6$.MODULE$.curried();
        }

        public static Question6 fromProduct(Product product) {
            return DnsClient$Question6$.MODULE$.fromProduct(product);
        }

        public static Function1 tupled() {
            return DnsClient$Question6$.MODULE$.tupled();
        }

        public static Question6 unapply(Question6 question6) {
            return DnsClient$Question6$.MODULE$.unapply(question6);
        }

        public Question6(short id, String name) {
            this.id = id;
            this.name = name;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.id());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Question6)) return false;
            Question6 question6 = (Question6)object;
            if (this.id() != question6.id()) return false;
            String string = this.name();
            String string2 = question6.name();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Question6;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Question6";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = BoxesRunTime.boxToShort((short)this._1());
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "id";
            } else if (1 == n2) {
                string = "name";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        @Override
        public short id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public Question6 copy(short id, String name) {
            return new Question6(id, name);
        }

        public short copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.name();
        }

        public short _1() {
            return this.id();
        }

        public String _2() {
            return this.name();
        }
    }

    public static final class SrvQuestion
    implements DnsQuestion,
    Product,
    Serializable {
        private final short id;
        private final String name;

        public static SrvQuestion apply(short s, String string) {
            return DnsClient$SrvQuestion$.MODULE$.apply(s, string);
        }

        public static Function1 curried() {
            return DnsClient$SrvQuestion$.MODULE$.curried();
        }

        public static SrvQuestion fromProduct(Product product) {
            return DnsClient$SrvQuestion$.MODULE$.fromProduct(product);
        }

        public static Function1 tupled() {
            return DnsClient$SrvQuestion$.MODULE$.tupled();
        }

        public static SrvQuestion unapply(SrvQuestion srvQuestion) {
            return DnsClient$SrvQuestion$.MODULE$.unapply(srvQuestion);
        }

        public SrvQuestion(short id, String name) {
            this.id = id;
            this.name = name;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.id());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SrvQuestion)) return false;
            SrvQuestion srvQuestion = (SrvQuestion)object;
            if (this.id() != srvQuestion.id()) return false;
            String string = this.name();
            String string2 = srvQuestion.name();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SrvQuestion;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SrvQuestion";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = BoxesRunTime.boxToShort((short)this._1());
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "id";
            } else if (1 == n2) {
                string = "name";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        @Override
        public short id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public SrvQuestion copy(short id, String name) {
            return new SrvQuestion(id, name);
        }

        public short copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.name();
        }

        public short _1() {
            return this.id();
        }

        public String _2() {
            return this.name();
        }
    }
}

