/*
 * Decompiled with CFR 0.152.
 */
package akka.pattern;

import akka.actor.OneForOneStrategy;
import akka.actor.OneForOneStrategy$;
import akka.actor.Props;
import akka.actor.Props$;
import akka.actor.SupervisorStrategy$;
import akka.pattern.AutoReset;
import akka.pattern.AutoReset$;
import akka.pattern.BackoffOptions;
import akka.pattern.BackoffOptionsImpl$;
import akka.pattern.BackoffReset;
import akka.pattern.BackoffType;
import akka.pattern.ForwardDeathLetters$;
import akka.pattern.HandlingWhileStopped;
import akka.pattern.ManualReset$;
import akka.pattern.ReplyWith$;
import akka.pattern.RestartImpliesFailure$;
import akka.pattern.StopImpliesFailure$;
import akka.pattern.internal.BackoffOnRestartSupervisor;
import akka.pattern.internal.BackoffOnStopSupervisor;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class BackoffOptionsImpl
implements BackoffOptions,
Product,
Serializable {
    private final BackoffType backoffType;
    private final Props childProps;
    private final String childName;
    private final FiniteDuration minBackoff;
    private final FiniteDuration maxBackoff;
    private final double randomFactor;
    private final Option reset;
    private final OneForOneStrategy supervisorStrategy;
    private final Option replyWhileStopped;
    private final Option finalStopMessage;
    private final BackoffReset backoffReset;

    public static BackoffOptionsImpl apply(BackoffType backoffType, Props props, String string, FiniteDuration finiteDuration, FiniteDuration finiteDuration2, double d, Option<BackoffReset> option, OneForOneStrategy oneForOneStrategy, Option<Object> option2, Option<Function1<Object, Object>> option3) {
        return BackoffOptionsImpl$.MODULE$.apply(backoffType, props, string, finiteDuration, finiteDuration2, d, option, oneForOneStrategy, option2, option3);
    }

    public static Function1 curried() {
        return BackoffOptionsImpl$.MODULE$.curried();
    }

    public static BackoffOptionsImpl fromProduct(Product product) {
        return BackoffOptionsImpl$.MODULE$.fromProduct(product);
    }

    public static Function1 tupled() {
        return BackoffOptionsImpl$.MODULE$.tupled();
    }

    public static BackoffOptionsImpl unapply(BackoffOptionsImpl backoffOptionsImpl) {
        return BackoffOptionsImpl$.MODULE$.unapply(backoffOptionsImpl);
    }

    public static RestartImpliesFailure$ $lessinit$greater$default$1() {
        return BackoffOptionsImpl$.MODULE$.$lessinit$greater$default$1();
    }

    public static None$ $lessinit$greater$default$7() {
        return BackoffOptionsImpl$.MODULE$.$lessinit$greater$default$7();
    }

    public static OneForOneStrategy $lessinit$greater$default$8() {
        return BackoffOptionsImpl$.MODULE$.$lessinit$greater$default$8();
    }

    public static None$ $lessinit$greater$default$9() {
        return BackoffOptionsImpl$.MODULE$.$lessinit$greater$default$9();
    }

    public static None$ $lessinit$greater$default$10() {
        return BackoffOptionsImpl$.MODULE$.$lessinit$greater$default$10();
    }

    public BackoffOptionsImpl(BackoffType backoffType, Props childProps, String childName, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, Option<BackoffReset> reset, OneForOneStrategy supervisorStrategy, Option<Object> replyWhileStopped, Option<Function1<Object, Object>> finalStopMessage) {
        this.backoffType = backoffType;
        this.childProps = childProps;
        this.childName = childName;
        this.minBackoff = minBackoff;
        this.maxBackoff = maxBackoff;
        this.randomFactor = randomFactor;
        this.reset = reset;
        this.supervisorStrategy = supervisorStrategy;
        this.replyWhileStopped = replyWhileStopped;
        this.finalStopMessage = finalStopMessage;
        this.backoffReset = (BackoffReset)reset.getOrElse(() -> BackoffOptionsImpl.$init$$$anonfun$1(minBackoff));
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.backoffType()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.childProps()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.childName()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.minBackoff()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.maxBackoff()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.randomFactor()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.reset()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.supervisorStrategy()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.replyWhileStopped()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.finalStopMessage()));
        return Statics.finalizeHash((int)n, (int)10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof BackoffOptionsImpl)) return false;
        BackoffOptionsImpl backoffOptionsImpl = (BackoffOptionsImpl)object;
        if (this.randomFactor() != backoffOptionsImpl.randomFactor()) return false;
        BackoffType backoffType = this.backoffType();
        BackoffType backoffType2 = backoffOptionsImpl.backoffType();
        if (backoffType == null) {
            if (backoffType2 != null) {
                return false;
            }
        } else if (!backoffType.equals(backoffType2)) return false;
        Props props = this.childProps();
        Props props2 = backoffOptionsImpl.childProps();
        if (props == null) {
            if (props2 != null) {
                return false;
            }
        } else if (!((Object)props).equals(props2)) return false;
        String string = this.childName();
        String string2 = backoffOptionsImpl.childName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        FiniteDuration finiteDuration = this.minBackoff();
        FiniteDuration finiteDuration2 = backoffOptionsImpl.minBackoff();
        if (finiteDuration == null) {
            if (finiteDuration2 != null) {
                return false;
            }
        } else if (!finiteDuration.equals(finiteDuration2)) return false;
        FiniteDuration finiteDuration3 = this.maxBackoff();
        FiniteDuration finiteDuration4 = backoffOptionsImpl.maxBackoff();
        if (finiteDuration3 == null) {
            if (finiteDuration4 != null) {
                return false;
            }
        } else if (!finiteDuration3.equals(finiteDuration4)) return false;
        Option<BackoffReset> option = this.reset();
        Option<BackoffReset> option2 = backoffOptionsImpl.reset();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        OneForOneStrategy oneForOneStrategy = this.supervisorStrategy();
        OneForOneStrategy oneForOneStrategy2 = backoffOptionsImpl.supervisorStrategy();
        if (oneForOneStrategy == null) {
            if (oneForOneStrategy2 != null) {
                return false;
            }
        } else if (!((Object)oneForOneStrategy).equals(oneForOneStrategy2)) return false;
        Option<Object> option3 = this.replyWhileStopped();
        Option<Object> option4 = backoffOptionsImpl.replyWhileStopped();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Function1<Object, Object>> option5 = this.finalStopMessage();
        Option<Function1<Object, Object>> option6 = backoffOptionsImpl.finalStopMessage();
        if (option5 == null) {
            if (option6 == null) return true;
            return false;
        } else {
            if (!option5.equals(option6)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof BackoffOptionsImpl;
    }

    public int productArity() {
        return 10;
    }

    public String productPrefix() {
        return "BackoffOptionsImpl";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            case 3: {
                object = this._4();
                break;
            }
            case 4: {
                object = this._5();
                break;
            }
            case 5: {
                object = BoxesRunTime.boxToDouble((double)this._6());
                break;
            }
            case 6: {
                object = this._7();
                break;
            }
            case 7: {
                object = this._8();
                break;
            }
            case 8: {
                object = this._9();
                break;
            }
            case 9: {
                object = this._10();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "backoffType";
                break;
            }
            case 1: {
                string = "childProps";
                break;
            }
            case 2: {
                string = "childName";
                break;
            }
            case 3: {
                string = "minBackoff";
                break;
            }
            case 4: {
                string = "maxBackoff";
                break;
            }
            case 5: {
                string = "randomFactor";
                break;
            }
            case 6: {
                string = "reset";
                break;
            }
            case 7: {
                string = "supervisorStrategy";
                break;
            }
            case 8: {
                string = "replyWhileStopped";
                break;
            }
            case 9: {
                string = "finalStopMessage";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public BackoffType backoffType() {
        return this.backoffType;
    }

    public Props childProps() {
        return this.childProps;
    }

    public String childName() {
        return this.childName;
    }

    public FiniteDuration minBackoff() {
        return this.minBackoff;
    }

    public FiniteDuration maxBackoff() {
        return this.maxBackoff;
    }

    public double randomFactor() {
        return this.randomFactor;
    }

    public Option<BackoffReset> reset() {
        return this.reset;
    }

    public OneForOneStrategy supervisorStrategy() {
        return this.supervisorStrategy;
    }

    public Option<Object> replyWhileStopped() {
        return this.replyWhileStopped;
    }

    public Option<Function1<Object, Object>> finalStopMessage() {
        return this.finalStopMessage;
    }

    public BackoffReset backoffReset() {
        return this.backoffReset;
    }

    @Override
    public BackoffOptions withAutoReset(FiniteDuration resetBackoff) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), (Option<BackoffReset>)Some$.MODULE$.apply((Object)AutoReset$.MODULE$.apply(resetBackoff)), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    @Override
    public BackoffOptions withManualReset() {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), (Option<BackoffReset>)Some$.MODULE$.apply((Object)ManualReset$.MODULE$), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    @Override
    public BackoffOptions withSupervisorStrategy(OneForOneStrategy supervisorStrategy) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), supervisorStrategy, this.copy$default$9(), this.copy$default$10());
    }

    @Override
    public BackoffOptions withDefaultStoppingStrategy() {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), OneForOneStrategy$.MODULE$.apply(this.supervisorStrategy().maxNrOfRetries(), (Duration)OneForOneStrategy$.MODULE$.$lessinit$greater$default$2(), OneForOneStrategy$.MODULE$.$lessinit$greater$default$3(), SupervisorStrategy$.MODULE$.stoppingStrategy().decider()), this.copy$default$9(), this.copy$default$10());
    }

    @Override
    public BackoffOptions withReplyWhileStopped(Object replyWhileStopped) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), (Option<Object>)Some$.MODULE$.apply(replyWhileStopped), this.copy$default$10());
    }

    @Override
    public BackoffOptions withMaxNrOfRetries(int maxNrOfRetries) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.supervisorStrategy().withMaxNrOfRetries(maxNrOfRetries), this.copy$default$9(), this.copy$default$10());
    }

    @Override
    public BackoffOptions withFinalStopMessage(Function1<Object, Object> action) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), (Option<Function1<Object, Object>>)Some$.MODULE$.apply(action));
    }

    @Override
    public Props props() {
        Props props;
        BackoffType backoffType;
        Predef$.MODULE$.require(this.minBackoff().$greater((Object)Duration$.MODULE$.Zero()), BackoffOptionsImpl::props$$anonfun$1);
        Predef$.MODULE$.require(this.maxBackoff().$greater$eq((Object)this.minBackoff()), BackoffOptionsImpl::props$$anonfun$2);
        Predef$.MODULE$.require(0.0 <= this.randomFactor() && this.randomFactor() <= 1.0, BackoffOptionsImpl::props$$anonfun$3);
        BackoffReset backoffReset = this.backoffReset();
        if (backoffReset instanceof AutoReset) {
            FiniteDuration finiteDuration;
            AutoReset autoReset = AutoReset$.MODULE$.unapply((AutoReset)backoffReset);
            FiniteDuration resetBackoff = finiteDuration = autoReset._1();
            Predef$.MODULE$.require(this.minBackoff().$less$eq((Object)resetBackoff) && resetBackoff.$less$eq((Object)this.maxBackoff()));
        }
        if (RestartImpliesFailure$.MODULE$.equals(backoffType = this.backoffType())) {
            props = Props$.MODULE$.apply(this::props$$anonfun$4, ClassTag$.MODULE$.apply(BackoffOnRestartSupervisor.class));
        } else if (StopImpliesFailure$.MODULE$.equals(backoffType)) {
            props = Props$.MODULE$.apply(this::props$$anonfun$5, ClassTag$.MODULE$.apply(BackoffOnStopSupervisor.class));
        } else {
            throw new MatchError((Object)backoffType);
        }
        return props;
    }

    public BackoffOptionsImpl copy(BackoffType backoffType, Props childProps, String childName, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, Option<BackoffReset> reset, OneForOneStrategy supervisorStrategy, Option<Object> replyWhileStopped, Option<Function1<Object, Object>> finalStopMessage) {
        return new BackoffOptionsImpl(backoffType, childProps, childName, minBackoff, maxBackoff, randomFactor, reset, supervisorStrategy, replyWhileStopped, finalStopMessage);
    }

    public BackoffType copy$default$1() {
        return this.backoffType();
    }

    public Props copy$default$2() {
        return this.childProps();
    }

    public String copy$default$3() {
        return this.childName();
    }

    public FiniteDuration copy$default$4() {
        return this.minBackoff();
    }

    public FiniteDuration copy$default$5() {
        return this.maxBackoff();
    }

    public double copy$default$6() {
        return this.randomFactor();
    }

    public Option<BackoffReset> copy$default$7() {
        return this.reset();
    }

    public OneForOneStrategy copy$default$8() {
        return this.supervisorStrategy();
    }

    public Option<Object> copy$default$9() {
        return this.replyWhileStopped();
    }

    public Option<Function1<Object, Object>> copy$default$10() {
        return this.finalStopMessage();
    }

    public BackoffType _1() {
        return this.backoffType();
    }

    public Props _2() {
        return this.childProps();
    }

    public String _3() {
        return this.childName();
    }

    public FiniteDuration _4() {
        return this.minBackoff();
    }

    public FiniteDuration _5() {
        return this.maxBackoff();
    }

    public double _6() {
        return this.randomFactor();
    }

    public Option<BackoffReset> _7() {
        return this.reset();
    }

    public OneForOneStrategy _8() {
        return this.supervisorStrategy();
    }

    public Option<Object> _9() {
        return this.replyWhileStopped();
    }

    public Option<Function1<Object, Object>> _10() {
        return this.finalStopMessage();
    }

    private static final AutoReset $init$$$anonfun$1(FiniteDuration minBackoff$1) {
        return AutoReset$.MODULE$.apply(minBackoff$1);
    }

    private static final String props$$anonfun$1() {
        return "minBackoff must be > 0";
    }

    private static final String props$$anonfun$2() {
        return "maxBackoff must be >= minBackoff";
    }

    private static final String props$$anonfun$3() {
        return "randomFactor must be between 0.0 and 1.0";
    }

    private static final ForwardDeathLetters$ props$$anonfun$7$$anonfun$2() {
        return ForwardDeathLetters$.MODULE$;
    }

    private final BackoffOnRestartSupervisor props$$anonfun$4() {
        return new BackoffOnRestartSupervisor(this.childProps(), this.childName(), this.minBackoff(), this.maxBackoff(), this.backoffReset(), this.randomFactor(), this.supervisorStrategy(), (HandlingWhileStopped)this.replyWhileStopped().map((Function1 & Serializable)msg -> ReplyWith$.MODULE$.apply(msg)).getOrElse(BackoffOptionsImpl::props$$anonfun$7$$anonfun$2));
    }

    private static final ForwardDeathLetters$ props$$anonfun$9$$anonfun$2() {
        return ForwardDeathLetters$.MODULE$;
    }

    private final BackoffOnStopSupervisor props$$anonfun$5() {
        return new BackoffOnStopSupervisor(this.childProps(), this.childName(), this.minBackoff(), this.maxBackoff(), this.backoffReset(), this.randomFactor(), this.supervisorStrategy(), (HandlingWhileStopped)this.replyWhileStopped().map((Function1 & Serializable)msg -> ReplyWith$.MODULE$.apply(msg)).getOrElse(BackoffOptionsImpl::props$$anonfun$9$$anonfun$2), this.finalStopMessage());
    }
}

