/*
 * Decompiled with CFR 0.152.
 */
package akka.pattern;

import akka.actor.Cancellable;
import akka.actor.Scheduler;
import akka.dispatch.ExecutionContexts$;
import akka.pattern.AbstractCircuitBreaker;
import akka.pattern.CircuitBreaker$;
import akka.pattern.CircuitBreaker$Closed$;
import akka.pattern.CircuitBreaker$HalfOpen$;
import akka.pattern.CircuitBreaker$Open$;
import akka.util.JavaDurationConverters$;
import akka.util.JavaDurationConverters$JavaDurationOps$;
import akka.util.Unsafe;
import dotty.runtime.LazyVals$;
import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.compat.java8.FutureConverters$;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NoStackTrace;
import scala.util.control.NonFatal$;

public class CircuitBreaker
extends AbstractCircuitBreaker {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(CircuitBreaker.class, "bitmap$0");
    public long bitmap$0;
    public final Scheduler akka$pattern$CircuitBreaker$$scheduler;
    public final int akka$pattern$CircuitBreaker$$maxFailures;
    public final FiniteDuration akka$pattern$CircuitBreaker$$callTimeout;
    private final FiniteDuration resetTimeout;
    public final FiniteDuration akka$pattern$CircuitBreaker$$maxResetTimeout;
    public final double akka$pattern$CircuitBreaker$$exponentialBackoffFactor;
    public final ExecutionContext akka$pattern$CircuitBreaker$$executor;
    private volatile State _currentStateDoNotCallMeDirectly;
    private volatile FiniteDuration _currentResetTimeoutDoNotCallMeDirectly;
    public final TimeoutException akka$pattern$CircuitBreaker$$timeoutEx;
    private final CopyOnWriteArrayList<Consumer<Object>> callFailureListeners;
    private final CopyOnWriteArrayList<Consumer<Object>> callTimeoutListeners;
    private final CopyOnWriteArrayList<Runnable> callBreakerOpenListeners;
    private final CopyOnWriteArrayList<Consumer<Object>> successListeners;
    private CircuitBreaker$Closed$ Closed$lzy1;
    private CircuitBreaker$HalfOpen$ HalfOpen$lzy1;
    private CircuitBreaker$Open$ Open$lzy1;

    public static CircuitBreaker apply(Scheduler scheduler, int n, FiniteDuration finiteDuration, FiniteDuration finiteDuration2) {
        return CircuitBreaker$.MODULE$.apply(scheduler, n, finiteDuration, finiteDuration2);
    }

    public static CircuitBreaker create(Scheduler scheduler, int n, java.time.Duration duration, java.time.Duration duration2) {
        return CircuitBreaker$.MODULE$.create(scheduler, n, duration, duration2);
    }

    public static CircuitBreaker create(Scheduler scheduler, int n, FiniteDuration finiteDuration, FiniteDuration finiteDuration2) {
        return CircuitBreaker$.MODULE$.create(scheduler, n, finiteDuration, finiteDuration2);
    }

    public CircuitBreaker(Scheduler scheduler, int maxFailures, FiniteDuration callTimeout, FiniteDuration resetTimeout, FiniteDuration maxResetTimeout, double exponentialBackoffFactor, ExecutionContext executor) {
        this.akka$pattern$CircuitBreaker$$scheduler = scheduler;
        this.akka$pattern$CircuitBreaker$$maxFailures = maxFailures;
        this.akka$pattern$CircuitBreaker$$callTimeout = callTimeout;
        this.resetTimeout = resetTimeout;
        this.akka$pattern$CircuitBreaker$$maxResetTimeout = maxResetTimeout;
        this.akka$pattern$CircuitBreaker$$exponentialBackoffFactor = exponentialBackoffFactor;
        this.akka$pattern$CircuitBreaker$$executor = executor;
        Predef$.MODULE$.require(exponentialBackoffFactor >= 1.0, CircuitBreaker::$init$$$anonfun$1);
        this._currentStateDoNotCallMeDirectly = this.Closed();
        this._currentResetTimeoutDoNotCallMeDirectly = resetTimeout;
        this.akka$pattern$CircuitBreaker$$timeoutEx = new NoStackTrace(){
            {
                NoStackTrace.$init$((NoStackTrace)this);
            }

            public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
                return super.fillInStackTrace();
            }
        };
        this.callFailureListeners = new CopyOnWriteArrayList();
        this.callTimeoutListeners = new CopyOnWriteArrayList();
        this.callBreakerOpenListeners = new CopyOnWriteArrayList();
        this.successListeners = new CopyOnWriteArrayList();
    }

    public FiniteDuration resetTimeout() {
        return this.resetTimeout;
    }

    public CircuitBreaker(ExecutionContext executor, Scheduler scheduler, int maxFailures, FiniteDuration callTimeout, FiniteDuration resetTimeout) {
        this(scheduler, maxFailures, callTimeout, resetTimeout, new package.DurationInt(package$.MODULE$.DurationInt(36500)).days(), 1.0, executor);
    }

    public CircuitBreaker(ExecutionContext executor, Scheduler scheduler, int maxFailures, java.time.Duration callTimeout, java.time.Duration resetTimeout) {
        this(scheduler, maxFailures, JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(callTimeout)), JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(resetTimeout)), new package.DurationInt(package$.MODULE$.DurationInt(36500)).days(), 1.0, executor);
    }

    public CircuitBreaker(Scheduler scheduler, int maxFailures, FiniteDuration callTimeout, FiniteDuration resetTimeout, ExecutionContext executor) {
        this(scheduler, maxFailures, callTimeout, resetTimeout, new package.DurationInt(package$.MODULE$.DurationInt(36500)).days(), 1.0, executor);
    }

    public CircuitBreaker withExponentialBackoff(FiniteDuration maxResetTimeout) {
        return new CircuitBreaker(this.akka$pattern$CircuitBreaker$$scheduler, this.akka$pattern$CircuitBreaker$$maxFailures, this.akka$pattern$CircuitBreaker$$callTimeout, this.resetTimeout(), maxResetTimeout, 2.0, this.akka$pattern$CircuitBreaker$$executor);
    }

    public CircuitBreaker withExponentialBackoff(java.time.Duration maxResetTimeout) {
        return this.withExponentialBackoff(JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(maxResetTimeout)));
    }

    private FiniteDuration _dotty_pls_dont_remove_my_unused_private() {
        return this._currentResetTimeoutDoNotCallMeDirectly;
    }

    private boolean swapState(State oldState, State newState) {
        return Unsafe.instance.compareAndSwapObject(this, AbstractCircuitBreaker.stateOffset, oldState, newState);
    }

    private State currentState() {
        return (State)Unsafe.instance.getObjectVolatile(this, AbstractCircuitBreaker.stateOffset);
    }

    public boolean akka$pattern$CircuitBreaker$$swapResetTimeout(FiniteDuration oldResetTimeout, FiniteDuration newResetTimeout) {
        return Unsafe.instance.compareAndSwapObject(this, AbstractCircuitBreaker.resetTimeoutOffset, oldResetTimeout, newResetTimeout);
    }

    public FiniteDuration akka$pattern$CircuitBreaker$$currentResetTimeout() {
        return (FiniteDuration)Unsafe.instance.getObjectVolatile(this, AbstractCircuitBreaker.resetTimeoutOffset);
    }

    public <T> Future<T> withCircuitBreaker(Function0<Future<T>> body, Function1<Try<T>, Object> defineFailureFn) {
        return this.currentState().invoke(body, defineFailureFn);
    }

    public <T> Future<T> withCircuitBreaker(Function0<Future<T>> body) {
        return this.currentState().invoke(body, CircuitBreaker$.MODULE$.akka$pattern$CircuitBreaker$$$exceptionAsFailure);
    }

    public <T> Future<T> callWithCircuitBreaker(Callable<Future<T>> body) {
        return this.callWithCircuitBreaker(body, CircuitBreaker$.MODULE$.akka$pattern$CircuitBreaker$$$exceptionAsFailureJava());
    }

    public <T> Future<T> callWithCircuitBreaker(Callable<Future<T>> body, BiFunction<Optional<T>, Optional<Throwable>, Boolean> defineFailureFn) {
        Function1<Try<T>, Object> failureFnInScala = CircuitBreaker$.MODULE$.convertJavaFailureFnToScala(defineFailureFn);
        return this.withCircuitBreaker(() -> CircuitBreaker.callWithCircuitBreaker$$anonfun$1(body), failureFnInScala);
    }

    public <T> CompletionStage<T> callWithCircuitBreakerCS(Callable<CompletionStage<T>> body) {
        return this.callWithCircuitBreakerCS(body, CircuitBreaker$.MODULE$.akka$pattern$CircuitBreaker$$$exceptionAsFailureJava());
    }

    public <T> CompletionStage<T> callWithCircuitBreakerCS(Callable<CompletionStage<T>> body, BiFunction<Optional<T>, Optional<Throwable>, Boolean> defineFailureFn) {
        return FutureConverters$.MODULE$.toJava(this.callWithCircuitBreaker(new Callable(body){
            private final Callable body$1;
            {
                this.body$1 = body$6;
            }

            public Future call() {
                return FutureConverters$.MODULE$.toScala((CompletionStage)this.body$1.call());
            }
        }, defineFailureFn));
    }

    public <T> T withSyncCircuitBreaker(Function0<T> body) {
        return this.withSyncCircuitBreaker(body, CircuitBreaker$.MODULE$.akka$pattern$CircuitBreaker$$$exceptionAsFailure);
    }

    public <T> T withSyncCircuitBreaker(Function0<T> body, Function1<Try<T>, Object> defineFailureFn) {
        return (T)Await$.MODULE$.result(this.withCircuitBreaker(() -> CircuitBreaker.withSyncCircuitBreaker$$anonfun$1(body), defineFailureFn), (Duration)this.akka$pattern$CircuitBreaker$$callTimeout);
    }

    public <T> T callWithSyncCircuitBreaker(Callable<T> body) {
        return this.callWithSyncCircuitBreaker(body, CircuitBreaker$.MODULE$.akka$pattern$CircuitBreaker$$$exceptionAsFailureJava());
    }

    public <T> T callWithSyncCircuitBreaker(Callable<T> body, BiFunction<Optional<T>, Optional<Throwable>, Boolean> defineFailureFn) {
        Function1<Try<T>, Object> failureFnInScala = CircuitBreaker$.MODULE$.convertJavaFailureFnToScala(defineFailureFn);
        return this.withSyncCircuitBreaker(() -> CircuitBreaker.callWithSyncCircuitBreaker$$anonfun$1(body), failureFnInScala);
    }

    public void succeed() {
        this.currentState().callSucceeds();
    }

    public void fail() {
        this.currentState().callFails();
    }

    public boolean isClosed() {
        State state = this.currentState();
        CircuitBreaker$Closed$ circuitBreaker$Closed$ = this.Closed();
        return !(state != null ? !state.equals(circuitBreaker$Closed$) : circuitBreaker$Closed$ != null);
    }

    public boolean isOpen() {
        State state = this.currentState();
        CircuitBreaker$Open$ circuitBreaker$Open$ = this.Open();
        return !(state != null ? !state.equals(circuitBreaker$Open$) : circuitBreaker$Open$ != null);
    }

    public boolean isHalfOpen() {
        State state = this.currentState();
        CircuitBreaker$HalfOpen$ circuitBreaker$HalfOpen$ = this.HalfOpen();
        return !(state != null ? !state.equals(circuitBreaker$HalfOpen$) : circuitBreaker$HalfOpen$ != null);
    }

    public CircuitBreaker onOpen(Function0 callback) {
        return this.addOnOpenListener(new Runnable(callback){
            private final Function0 callback$1;
            {
                this.callback$1 = callback$8;
            }

            public void run() {
                this.callback$1.apply();
            }
        });
    }

    public CircuitBreaker addOnOpenListener(Runnable callback) {
        this.Open().addListener(callback);
        return this;
    }

    public CircuitBreaker onHalfOpen(Function0 callback) {
        return this.addOnHalfOpenListener(new Runnable(callback){
            private final Function0 callback$1;
            {
                this.callback$1 = callback$9;
            }

            public void run() {
                this.callback$1.apply();
            }
        });
    }

    public CircuitBreaker addOnHalfOpenListener(Runnable callback) {
        this.HalfOpen().addListener(callback);
        return this;
    }

    public CircuitBreaker onClose(Function0 callback) {
        return this.addOnCloseListener(new Runnable(callback){
            private final Function0 callback$1;
            {
                this.callback$1 = callback$10;
            }

            public void run() {
                this.callback$1.apply();
            }
        });
    }

    public CircuitBreaker addOnCloseListener(Runnable callback) {
        this.Closed().addListener(callback);
        return this;
    }

    public CircuitBreaker onCallSuccess(Function1<Object, BoxedUnit> callback) {
        return this.addOnCallSuccessListener(new Consumer(callback){
            private final Function1 callback$1;
            {
                this.callback$1 = callback$11;
            }

            public void accept(long result) {
                this.callback$1.apply((Object)BoxesRunTime.boxToLong((long)result));
            }
        });
    }

    public CircuitBreaker addOnCallSuccessListener(Consumer<Object> callback) {
        this.successListeners.add(callback);
        return this;
    }

    public CircuitBreaker onCallFailure(Function1<Object, BoxedUnit> callback) {
        return this.addOnCallFailureListener(new Consumer(callback){
            private final Function1 callback$1;
            {
                this.callback$1 = callback$12;
            }

            public void accept(long result) {
                this.callback$1.apply((Object)BoxesRunTime.boxToLong((long)result));
            }
        });
    }

    public CircuitBreaker addOnCallFailureListener(Consumer<Object> callback) {
        this.callFailureListeners.add(callback);
        return this;
    }

    public CircuitBreaker onCallTimeout(Function1<Object, BoxedUnit> callback) {
        return this.addOnCallTimeoutListener(new Consumer(callback){
            private final Function1 callback$1;
            {
                this.callback$1 = callback$13;
            }

            public void accept(long result) {
                this.callback$1.apply((Object)BoxesRunTime.boxToLong((long)result));
            }
        });
    }

    public CircuitBreaker addOnCallTimeoutListener(Consumer<Object> callback) {
        this.callTimeoutListeners.add(callback);
        return this;
    }

    public CircuitBreaker onCallBreakerOpen(Function0 callback) {
        return this.addOnCallBreakerOpenListener(new Runnable(callback){
            private final Function0 callback$1;
            {
                this.callback$1 = callback$14;
            }

            public void run() {
                this.callback$1.apply();
            }
        });
    }

    public CircuitBreaker addOnCallBreakerOpenListener(Runnable callback) {
        this.callBreakerOpenListeners.add(callback);
        return this;
    }

    public int currentFailureCount() {
        return this.Closed().get();
    }

    private void transition(State fromState, State toState) {
        if (this.swapState(fromState, toState)) {
            toState.enter();
        }
    }

    public void akka$pattern$CircuitBreaker$$tripBreaker(State fromState) {
        this.transition(fromState, this.Open());
    }

    public void akka$pattern$CircuitBreaker$$resetBreaker() {
        this.transition(this.HalfOpen(), this.Closed());
    }

    public void akka$pattern$CircuitBreaker$$notifyCallSuccessListeners(long start) {
        if (!this.successListeners.isEmpty()) {
            long elapsed = System.nanoTime() - start;
            for (Consumer<Object> listener : this.successListeners) {
                this.akka$pattern$CircuitBreaker$$executor.execute(new Runnable(elapsed, listener){
                    private final long elapsed$1;
                    private final Consumer listener$1;
                    {
                        this.elapsed$1 = elapsed$4;
                        this.listener$1 = listener$4;
                    }

                    public void run() {
                        this.listener$1.accept(BoxesRunTime.boxToLong((long)this.elapsed$1));
                    }
                });
            }
        }
    }

    public void akka$pattern$CircuitBreaker$$notifyCallFailureListeners(long start) {
        if (!this.callFailureListeners.isEmpty()) {
            long elapsed = System.nanoTime() - start;
            for (Consumer<Object> listener : this.callFailureListeners) {
                this.akka$pattern$CircuitBreaker$$executor.execute(new Runnable(elapsed, listener){
                    private final long elapsed$1;
                    private final Consumer listener$1;
                    {
                        this.elapsed$1 = elapsed$5;
                        this.listener$1 = listener$5;
                    }

                    public void run() {
                        this.listener$1.accept(BoxesRunTime.boxToLong((long)this.elapsed$1));
                    }
                });
            }
        }
    }

    public void akka$pattern$CircuitBreaker$$notifyCallTimeoutListeners(long start) {
        if (!this.callTimeoutListeners.isEmpty()) {
            long elapsed = System.nanoTime() - start;
            for (Consumer<Object> listener : this.callTimeoutListeners) {
                this.akka$pattern$CircuitBreaker$$executor.execute(new Runnable(elapsed, listener){
                    private final long elapsed$1;
                    private final Consumer listener$1;
                    {
                        this.elapsed$1 = elapsed$6;
                        this.listener$1 = listener$6;
                    }

                    public void run() {
                        this.listener$1.accept(BoxesRunTime.boxToLong((long)this.elapsed$1));
                    }
                });
            }
        }
    }

    public void akka$pattern$CircuitBreaker$$notifyCallBreakerOpenListeners() {
        if (!this.callBreakerOpenListeners.isEmpty()) {
            for (Runnable listener : this.callBreakerOpenListeners) {
                this.akka$pattern$CircuitBreaker$$executor.execute(listener);
            }
        }
    }

    public void akka$pattern$CircuitBreaker$$attemptReset() {
        this.transition(this.Open(), this.HalfOpen());
    }

    private final CircuitBreaker$Closed$ Closed() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    CircuitBreaker$Closed$ circuitBreaker$Closed$;
                    this.Closed$lzy1 = circuitBreaker$Closed$ = new CircuitBreaker$Closed$(this);
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return circuitBreaker$Closed$;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.Closed$lzy1;
    }

    private final CircuitBreaker$HalfOpen$ HalfOpen() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 1)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 1)) continue;
                try {
                    CircuitBreaker$HalfOpen$ circuitBreaker$HalfOpen$;
                    this.HalfOpen$lzy1 = circuitBreaker$HalfOpen$ = new CircuitBreaker$HalfOpen$(this);
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 1);
                    return circuitBreaker$HalfOpen$;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 1);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 1);
        }
        return this.HalfOpen$lzy1;
    }

    private final CircuitBreaker$Open$ Open() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 2)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 2)) continue;
                try {
                    CircuitBreaker$Open$ circuitBreaker$Open$;
                    this.Open$lzy1 = circuitBreaker$Open$ = new CircuitBreaker$Open$(this);
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 2);
                    return circuitBreaker$Open$;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 2);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 2);
        }
        return this.Open$lzy1;
    }

    private static final String $init$$$anonfun$1() {
        return "factor must be >= 1.0";
    }

    private static final Future callWithCircuitBreaker$$anonfun$1(Callable body$1) {
        return (Future)body$1.call();
    }

    private static final Future liftedTree1$1(Function0 body$4) {
        Future future;
        try {
            future = Future$.MODULE$.successful(body$4.apply());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option.get();
                future = Future$.MODULE$.failed(t);
            }
            throw throwable;
        }
        return future;
    }

    private static final Future withSyncCircuitBreaker$$anonfun$1(Function0 body$3) {
        return CircuitBreaker.liftedTree1$1(body$3);
    }

    private static final Object callWithSyncCircuitBreaker$$anonfun$1(Callable body$5) {
        return body$5.call();
    }

    public static final Future akka$pattern$CircuitBreaker$State$$_$materialize$1(Function0 value) {
        Future future;
        try {
            future = (Future)value.apply();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option.get();
                future = Future$.MODULE$.failed(t);
            }
            throw throwable;
        }
        return future;
    }

    private interface State {
        default public void $init$() {
        }

        public CopyOnWriteArrayList<Runnable> akka$pattern$CircuitBreaker$State$$listeners();

        default public CopyOnWriteArrayList akka$pattern$CircuitBreaker$State$$initial$listeners() {
            return new CopyOnWriteArrayList();
        }

        default public void addListener(Runnable listener) {
            this.akka$pattern$CircuitBreaker$State$$listeners().add(listener);
        }

        private boolean hasListeners() {
            return !this.akka$pattern$CircuitBreaker$State$$listeners().isEmpty();
        }

        default public void notifyTransitionListeners() {
            if (this.hasListeners()) {
                for (Runnable listener : this.akka$pattern$CircuitBreaker$State$$listeners()) {
                    this.akka$pattern$CircuitBreaker$State$$$outer().akka$pattern$CircuitBreaker$$executor.execute(listener);
                }
            }
        }

        default public <T> Future<T> callThrough(Function0<Future<T>> body, Function1<Try<T>, Object> defineFailureFn) {
            Future future;
            FiniteDuration finiteDuration = this.akka$pattern$CircuitBreaker$State$$$outer().akka$pattern$CircuitBreaker$$callTimeout;
            FiniteDuration finiteDuration2 = Duration$.MODULE$.Zero();
            if (!(finiteDuration != null ? !finiteDuration.equals(finiteDuration2) : finiteDuration2 != null)) {
                long start = System.nanoTime();
                Future f = CircuitBreaker.akka$pattern$CircuitBreaker$State$$_$materialize$1(body);
                f.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Try try_ = x$1;
                    if (try_ instanceof Success) {
                        this.akka$pattern$CircuitBreaker$State$$$outer().akka$pattern$CircuitBreaker$$notifyCallSuccessListeners(start);
                        this.callSucceeds();
                    } else if (try_ instanceof Failure) {
                        this.akka$pattern$CircuitBreaker$State$$$outer().akka$pattern$CircuitBreaker$$notifyCallFailureListeners(start);
                        this.callFails();
                    } else {
                        throw new MatchError((Object)try_);
                    }
                }, this.akka$pattern$CircuitBreaker$State$$$outer().akka$pattern$CircuitBreaker$$executor);
                future = f;
            } else {
                long start = System.nanoTime();
                Promise p = Promise$.MODULE$.apply();
                p.future().onComplete((Function1)(JProcedure1 & Serializable)fResult -> {
                    if (BoxesRunTime.unboxToBoolean((Object)defineFailureFn.apply(fResult))) {
                        this.callFails();
                    } else {
                        this.akka$pattern$CircuitBreaker$State$$$outer().akka$pattern$CircuitBreaker$$notifyCallSuccessListeners(start);
                        this.callSucceeds();
                    }
                }, ExecutionContexts$.MODULE$.parasitic());
                Cancellable timeout = this.akka$pattern$CircuitBreaker$State$$$outer().akka$pattern$CircuitBreaker$$scheduler.scheduleOnce(this.akka$pattern$CircuitBreaker$State$$$outer().akka$pattern$CircuitBreaker$$callTimeout, (Function0)((JFunction0.mcV.sp & Serializable)() -> this.$anonfun$1(start, p)), ExecutionContexts$.MODULE$.parasitic());
                CircuitBreaker.akka$pattern$CircuitBreaker$State$$_$materialize$1(body).onComplete((Function1)(JFunction1 & Serializable)x$1 -> {
                    boolean bl;
                    Try try_ = x$1;
                    if (try_ instanceof Success) {
                        Object result = ((Success)try_).value();
                        p.trySuccess(result);
                        bl = timeout.cancel();
                    } else if (try_ instanceof Failure) {
                        Throwable ex = ((Failure)try_).exception();
                        if (p.tryFailure(ex)) {
                            this.akka$pattern$CircuitBreaker$State$$$outer().akka$pattern$CircuitBreaker$$notifyCallFailureListeners(start);
                        }
                        bl = timeout.cancel();
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    return bl;
                }, ExecutionContexts$.MODULE$.parasitic());
                future = p.future();
            }
            return future;
        }

        default public <T> Future<T> callThrough(Function0<Future<T>> body) {
            return this.callThrough(body, CircuitBreaker$.MODULE$.akka$pattern$CircuitBreaker$$$exceptionAsFailure);
        }

        public <T> Future<T> invoke(Function0<Future<T>> var1, Function1<Try<T>, Object> var2);

        default public <T> Future<T> invoke(Function0<Future<T>> body) {
            return this.invoke(body, CircuitBreaker$.MODULE$.akka$pattern$CircuitBreaker$$$exceptionAsFailure);
        }

        public void callSucceeds();

        public void callFails();

        default public void enter() {
            this._enter();
            this.notifyTransitionListeners();
        }

        public void _enter();

        public CircuitBreaker akka$pattern$CircuitBreaker$State$$$outer();

        private void $anonfun$1(long start$3, Promise p$1) {
            if (p$1.tryFailure((Throwable)this.akka$pattern$CircuitBreaker$State$$$outer().akka$pattern$CircuitBreaker$$timeoutEx)) {
                this.akka$pattern$CircuitBreaker$State$$$outer().akka$pattern$CircuitBreaker$$notifyCallTimeoutListeners(start$3);
            }
        }
    }
}

