/*
 * Decompiled with CFR 0.152.
 */
package akka.pattern;

import akka.Done;
import akka.annotation.InternalApi;
import akka.pattern.StatusReply$;
import akka.pattern.StatusReply$ErrorMessage$;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.concurrent.Future;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NoStackTrace;

public final class StatusReply<T> {
    private final Try status;

    public static StatusReply Ack() {
        return StatusReply$.MODULE$.Ack();
    }

    public static StatusReply<Done> ack() {
        return StatusReply$.MODULE$.ack();
    }

    public static <T> StatusReply<T> error(String string) {
        return StatusReply$.MODULE$.error(string);
    }

    public static <T> StatusReply<T> error(Throwable throwable) {
        return StatusReply$.MODULE$.error(throwable);
    }

    @InternalApi
    public static <T> Future<T> flattenStatusFuture(Future<StatusReply<T>> future) {
        return StatusReply$.MODULE$.flattenStatusFuture(future);
    }

    public static <T> StatusReply<T> success(T t) {
        return StatusReply$.MODULE$.success(t);
    }

    public <T> StatusReply(Try<T> status) {
        this.status = status;
    }

    private Try<T> status() {
        return this.status;
    }

    public T getValue() {
        return (T)this.status().get();
    }

    public Throwable getError() {
        Try<T> try_ = this.status();
        if (!(try_ instanceof Failure)) {
            throw new IllegalArgumentException("Expected reply to be a failure, but was a success");
        }
        Throwable ex = ((Failure)try_).exception();
        return ex;
    }

    public boolean isError() {
        return this.status().isFailure();
    }

    public boolean isSuccess() {
        return this.status().isSuccess();
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof StatusReply) {
            StatusReply that = (StatusReply)object;
            Try<T> try_ = this.status();
            Try<T> try_2 = that.status();
            bl = !(try_ != null ? !try_.equals(try_2) : try_2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.status().hashCode();
    }

    public String toString() {
        String string;
        Try<T> try_ = this.status();
        if (try_ instanceof Success) {
            Object t = ((Success)try_).value();
            string = "Success(" + t + ")";
        } else if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            string = "Error(" + ex.getMessage() + ")";
        } else {
            throw new MatchError(try_);
        }
        return string;
    }

    public static final class ErrorMessage
    extends RuntimeException
    implements NoStackTrace,
    Product {
        private final String errorMessage;

        public static <A> Function1<String, A> andThen(Function1<ErrorMessage, A> function1) {
            return StatusReply$ErrorMessage$.MODULE$.andThen(function1);
        }

        public static ErrorMessage apply(String string) {
            return StatusReply$ErrorMessage$.MODULE$.apply(string);
        }

        public static <A> Function1<A, ErrorMessage> compose(Function1<A, String> function1) {
            return StatusReply$ErrorMessage$.MODULE$.compose(function1);
        }

        public static ErrorMessage fromProduct(Product product) {
            return StatusReply$ErrorMessage$.MODULE$.fromProduct(product);
        }

        public static ErrorMessage unapply(ErrorMessage errorMessage) {
            return StatusReply$ErrorMessage$.MODULE$.unapply(errorMessage);
        }

        public ErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            super(errorMessage);
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ErrorMessage)) return false;
            ErrorMessage errorMessage = (ErrorMessage)object;
            String string = this.errorMessage();
            String string2 = errorMessage.errorMessage();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof ErrorMessage;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ErrorMessage";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "errorMessage";
        }

        private String errorMessage() {
            return this.errorMessage;
        }

        @Override
        public String toString() {
            return this.errorMessage();
        }

        public ErrorMessage copy(String errorMessage) {
            return new ErrorMessage(errorMessage);
        }

        public String copy$default$1() {
            return this.errorMessage();
        }

        public String _1() {
            return this.errorMessage();
        }
    }
}

