/*
 * Decompiled with CFR 0.152.
 */
package akka.routing;

import akka.actor.ActorContext;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.SupervisorStrategy;
import akka.dispatch.BalancingDispatcherConfigurator;
import akka.dispatch.Dispatchers;
import akka.routing.ActorRefRoutee$;
import akka.routing.BalancingPool$;
import akka.routing.BalancingPoolDeploy$;
import akka.routing.BalancingRoutingLogic$;
import akka.routing.NoRouter$;
import akka.routing.Pool;
import akka.routing.Pool$;
import akka.routing.Resizer;
import akka.routing.Routee;
import akka.routing.Router;
import akka.routing.RouterConfig;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import dotty.runtime.function.JFunction2;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.collection.IterableOnceOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class BalancingPool
implements RouterConfig,
Pool,
Product {
    private static final long serialVersionUID = 1L;
    private final int nrOfInstances;
    private final SupervisorStrategy supervisorStrategy;
    private final String routerDispatcher;
    private final Option resizer;

    public static BalancingPool apply(int n, SupervisorStrategy supervisorStrategy, String string) {
        return BalancingPool$.MODULE$.apply(n, supervisorStrategy, string);
    }

    public static Function1 curried() {
        return BalancingPool$.MODULE$.curried();
    }

    public static BalancingPool fromProduct(Product product) {
        return BalancingPool$.MODULE$.fromProduct(product);
    }

    public static Function1 tupled() {
        return BalancingPool$.MODULE$.tupled();
    }

    public static BalancingPool unapply(BalancingPool balancingPool) {
        return BalancingPool$.MODULE$.unapply(balancingPool);
    }

    public static SupervisorStrategy $lessinit$greater$default$2() {
        return BalancingPool$.MODULE$.$lessinit$greater$default$2();
    }

    public static String $lessinit$greater$default$3() {
        return BalancingPool$.MODULE$.$lessinit$greater$default$3();
    }

    public BalancingPool(int nrOfInstances, SupervisorStrategy supervisorStrategy, String routerDispatcher) {
        this.nrOfInstances = nrOfInstances;
        this.supervisorStrategy = supervisorStrategy;
        this.routerDispatcher = routerDispatcher;
        this.resizer = None$.MODULE$;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.nrOfInstances());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.supervisorStrategy()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.routerDispatcher()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof BalancingPool)) return false;
        BalancingPool balancingPool = (BalancingPool)object;
        if (this.nrOfInstances() != balancingPool.nrOfInstances()) return false;
        SupervisorStrategy supervisorStrategy = this.supervisorStrategy();
        SupervisorStrategy supervisorStrategy2 = balancingPool.supervisorStrategy();
        if (supervisorStrategy == null) {
            if (supervisorStrategy2 != null) {
                return false;
            }
        } else if (!supervisorStrategy.equals(supervisorStrategy2)) return false;
        String string = this.routerDispatcher();
        String string2 = balancingPool.routerDispatcher();
        if (string == null) {
            if (string2 == null) return true;
            return false;
        } else {
            if (!string.equals(string2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof BalancingPool;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "BalancingPool";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this._1());
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "nrOfInstances";
                break;
            }
            case 1: {
                string = "supervisorStrategy";
                break;
            }
            case 2: {
                string = "routerDispatcher";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public int nrOfInstances() {
        return this.nrOfInstances;
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return this.supervisorStrategy;
    }

    @Override
    public String routerDispatcher() {
        return this.routerDispatcher;
    }

    public BalancingPool(Config config) {
        this(config.getInt("nr-of-instances"), BalancingPool$.MODULE$.$lessinit$greater$default$2(), BalancingPool$.MODULE$.$lessinit$greater$default$3());
    }

    public BalancingPool(int nr) {
        this(nr, BalancingPool$.MODULE$.$lessinit$greater$default$2(), BalancingPool$.MODULE$.$lessinit$greater$default$3());
    }

    @Override
    public Router createRouter(ActorSystem system) {
        return new Router(BalancingRoutingLogic$.MODULE$.apply());
    }

    public BalancingPool withSupervisorStrategy(SupervisorStrategy strategy) {
        return this.copy(this.copy$default$1(), strategy, this.copy$default$3());
    }

    public BalancingPool withDispatcher(String dispatcherId) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), dispatcherId);
    }

    @Override
    public int nrOfInstances(ActorSystem sys) {
        return this.nrOfInstances();
    }

    @Override
    public Routee newRoutee(Props routeeProps, ActorContext context) {
        String rawDeployPath = ((IterableOnceOps)context.self().path().elements().drop(1)).mkString("/", "/", "");
        String deployPath = (String)BalancingPoolDeploy$.MODULE$.invalidConfigKeyChars().foldLeft((Object)rawDeployPath, (Function2)((JFunction2 & Serializable)BalancingPool::$anonfun$adapted$1));
        String dispatcherId = "BalancingPool-" + deployPath;
        if (!BalancingPool.dispatchers$1(context).hasDispatcher(dispatcherId)) {
            String deployDispatcherConfigPath = "akka.actor.deployment." + deployPath + ".pool-dispatcher";
            Config systemConfig = context.system().settings().config();
            Config dispatcherConfig = context.system().dispatchers().config(dispatcherId, systemConfig.hasPath(deployDispatcherConfigPath) ? systemConfig.getConfig(deployDispatcherConfigPath) : ConfigFactory.empty());
            BalancingPool.dispatchers$1(context).registerConfigurator(dispatcherId, new BalancingDispatcherConfigurator(dispatcherConfig, BalancingPool.dispatchers$1(context).prerequisites()));
        }
        Props routeePropsWithDispatcher = routeeProps.withDispatcher(dispatcherId);
        return ActorRefRoutee$.MODULE$.apply(context.actorOf(routeePropsWithDispatcher));
    }

    @Override
    public RouterConfig withFallback(RouterConfig other) {
        BalancingPool balancingPool;
        RouterConfig routerConfig = other;
        NoRouter$ noRouter$ = NoRouter$.MODULE$;
        if (!(routerConfig != null ? !routerConfig.equals(noRouter$) : noRouter$ != null)) {
            balancingPool = this;
        } else {
            RouterConfig routerConfig2 = other;
            if (routerConfig2 instanceof Pool) {
                Pool p = (Pool)routerConfig2;
                balancingPool = this.supervisorStrategy() == Pool$.MODULE$.defaultSupervisorStrategy() && p.supervisorStrategy() != Pool$.MODULE$.defaultSupervisorStrategy() ? this.withSupervisorStrategy(p.supervisorStrategy()) : this;
            } else {
                balancingPool = this;
            }
        }
        return balancingPool;
    }

    @Override
    public Option<Resizer> resizer() {
        return this.resizer;
    }

    public BalancingPool copy(int nrOfInstances, SupervisorStrategy supervisorStrategy, String routerDispatcher) {
        return new BalancingPool(nrOfInstances, supervisorStrategy, routerDispatcher);
    }

    public int copy$default$1() {
        return this.nrOfInstances();
    }

    public SupervisorStrategy copy$default$2() {
        return this.supervisorStrategy();
    }

    public String copy$default$3() {
        return this.routerDispatcher();
    }

    public int _1() {
        return this.nrOfInstances();
    }

    public SupervisorStrategy _2() {
        return this.supervisorStrategy();
    }

    public String _3() {
        return this.routerDispatcher();
    }

    private static final String $anonfun$adapted$1(Object replaced, Object c) {
        return ((String)replaced).replace(BoxesRunTime.unboxToChar((Object)c), '_');
    }

    private static final Dispatchers dispatchers$1(ActorContext context$1) {
        return context$1.system().dispatchers();
    }
}

