/*
 * Decompiled with CFR 0.152.
 */
package akka.routing;

import akka.actor.ActorContext;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.SupervisorStrategy;
import akka.routing.ActorRefRoutee$;
import akka.routing.ResizablePoolActor;
import akka.routing.Resizer;
import akka.routing.Routee;
import akka.routing.RouterActor;
import akka.routing.RouterConfig;
import akka.routing.RouterPoolActor;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;

public interface Pool
extends RouterConfig {
    public int nrOfInstances(ActorSystem var1);

    default public boolean usePoolDispatcher() {
        return false;
    }

    default public Routee newRoutee(Props routeeProps, ActorContext context) {
        return ActorRefRoutee$.MODULE$.apply(context.actorOf(this.enrichWithPoolDispatcher(routeeProps, context)));
    }

    /*
     * Enabled aggressive block sorting
     */
    default public Props enrichWithPoolDispatcher(Props routeeProps, ActorContext context) {
        Props props;
        if (this.usePoolDispatcher()) {
            String string = routeeProps.dispatcher();
            String string2 = "akka.actor.default-dispatcher";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                props = routeeProps.withDispatcher("akka.actor.deployment." + ((IterableOnceOps)context.self().path().elements().drop(1)).mkString("/", "/", "") + ".pool-dispatcher");
                return props;
            }
        }
        props = routeeProps;
        return props;
    }

    public Option<Resizer> resizer();

    public SupervisorStrategy supervisorStrategy();

    default public Props props(Props routeeProps) {
        return routeeProps.withRouter(this);
    }

    @Override
    default public boolean stopRouterWhenAllRouteesRemoved() {
        return this.resizer().isEmpty();
    }

    @Override
    default public RouterActor createRouterActor() {
        RouterPoolActor routerPoolActor;
        Option<Resizer> option = this.resizer();
        if (None$.MODULE$.equals(option)) {
            routerPoolActor = new RouterPoolActor(this.supervisorStrategy());
        } else if (option instanceof Some) {
            routerPoolActor = new ResizablePoolActor(this.supervisorStrategy());
        } else {
            throw new MatchError(option);
        }
        return routerPoolActor;
    }
}

