/*
 * Decompiled with CFR 0.152.
 */
package akka.routing;

import akka.actor.Actor;
import akka.actor.ActorCell;
import akka.actor.ActorRef;
import akka.actor.ActorSystemImpl;
import akka.actor.IndirectActorProducer;
import akka.actor.InternalActorRef;
import akka.actor.PoisonPill$;
import akka.actor.Props;
import akka.actor.dungeon.Dispatch;
import akka.dispatch.Envelope;
import akka.dispatch.MessageDispatcher;
import akka.routing.ActorRefRoutee;
import akka.routing.ActorRefRoutee$;
import akka.routing.Group;
import akka.routing.Pool;
import akka.routing.Routee;
import akka.routing.Router;
import akka.routing.RouterActor;
import akka.routing.RouterConfig;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JFunction2;
import dotty.runtime.function.JProcedure1;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Some;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public class RoutedActorCell
extends ActorCell
implements Dispatch {
    private final Props routeeProps;
    private final RouterConfig routerConfig;
    private volatile Router _router;

    public RoutedActorCell(ActorSystemImpl _system, InternalActorRef _ref, Props _routerProps, MessageDispatcher _routerDispatcher, Props routeeProps, InternalActorRef _supervisor) {
        this.routeeProps = routeeProps;
        super(_system, _ref, _routerProps, _routerDispatcher, _supervisor);
        this.routerConfig = _routerProps.routerConfig();
        this._router = null;
    }

    public Props routeeProps() {
        return this.routeeProps;
    }

    public RouterConfig routerConfig() {
        return this.routerConfig;
    }

    public Router router() {
        return this._router;
    }

    public void addRoutee(Routee routee) {
        this.addRoutees((Iterable<Routee>)((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Routee[]{routee}))));
    }

    public void addRoutees(Iterable<Routee> routees) {
        routees.foreach((Function1)(JProcedure1 & Serializable)routee -> this.watch((Routee)routee));
        Router r = this._router;
        this._router = r.withRoutees((IndexedSeq<Routee>)((IndexedSeq)r.routees().$plus$plus(routees)));
    }

    public void removeRoutee(Routee routee, boolean stopChild) {
        this.removeRoutees((Iterable<Routee>)((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Routee[]{routee}))), stopChild);
    }

    public void removeRoutees(Iterable<Routee> routees, boolean stopChild) {
        Router r = this._router;
        IndexedSeq newRoutees = (IndexedSeq)routees.foldLeft(r.routees(), (Function2)(JFunction2 & Serializable)(xs, x) -> {
            this.unwatch((Routee)x);
            return (IndexedSeq)xs.filterNot((Function1)(JFunction1 & Serializable)_$1 -> {
                Routee routee = _$1;
                Routee routee2 = x;
                return !(routee != null ? !routee.equals(routee2) : routee2 != null);
            });
        });
        this._router = r.withRoutees((IndexedSeq<Routee>)newRoutees);
        if (stopChild) {
            routees.foreach((Function1)(JProcedure1 & Serializable)routee -> this.stopIfChild((Routee)routee));
        }
    }

    private void watch(Routee routee) {
        block0: {
            ActorRef actorRef;
            Routee routee2 = routee;
            if (!(routee2 instanceof ActorRefRoutee)) break block0;
            ActorRefRoutee actorRefRoutee = ActorRefRoutee$.MODULE$.unapply((ActorRefRoutee)routee2);
            ActorRef ref = actorRef = actorRefRoutee._1();
            this.watch(ref);
        }
    }

    private void unwatch(Routee routee) {
        block0: {
            ActorRef actorRef;
            Routee routee2 = routee;
            if (!(routee2 instanceof ActorRefRoutee)) break block0;
            ActorRefRoutee actorRefRoutee = ActorRefRoutee$.MODULE$.unapply((ActorRefRoutee)routee2);
            ActorRef ref = actorRef = actorRefRoutee._1();
            this.unwatch(ref);
        }
    }

    private void stopIfChild(Routee routee) {
        block1: {
            ActorRefRoutee actorRefRoutee;
            ActorRef actorRef;
            ActorRef ref;
            Option option;
            Routee routee2 = routee;
            if (!(routee2 instanceof ActorRefRoutee) || !((option = this.child((ref = (actorRef = (actorRefRoutee = ActorRefRoutee$.MODULE$.unapply((ActorRefRoutee)routee2))._1())).path().name())) instanceof Some)) break block1;
            ActorRef actorRef2 = ref;
            Object object = ((Some)option).value();
            if (!(actorRef2 != null ? !((Object)actorRef2).equals(object) : object != null)) {
                FiniteDuration finiteDuration = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).milliseconds();
                this.system().scheduler().scheduleOnce(finiteDuration, ref, (Object)PoisonPill$.MODULE$, (ExecutionContext)this.dispatcher(), this.system().scheduler().scheduleOnce$default$5(finiteDuration, ref, PoisonPill$.MODULE$));
            }
        }
    }

    @Override
    public RoutedActorCell start() {
        Group group;
        Iterable<String> paths;
        this._router = this.routerConfig().createRouter(this.system());
        RouterConfig routerConfig = this.routerConfig();
        if (routerConfig instanceof Pool) {
            Pool pool = (Pool)routerConfig;
            int nrOfRoutees = pool.nrOfInstances(this.system());
            if (nrOfRoutees > 0) {
                this.addRoutees((Iterable<Routee>)((Iterable)package$.MODULE$.Vector().fill(nrOfRoutees, () -> this.start$$anonfun$1(pool))));
            }
        } else if (routerConfig instanceof Group && (paths = (group = (Group)routerConfig).paths(this.system())).nonEmpty()) {
            this.addRoutees((Iterable<Routee>)((Iterable)paths.iterator().map((Function1)(JFunction1 & Serializable)p -> group.routeeFor((String)p, this)).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$))));
        }
        this.preSuperStart();
        return (RoutedActorCell)Dispatch.super.start();
    }

    public void preSuperStart() {
    }

    @Override
    public void sendMessage(Envelope envelope) {
        if (this.routerConfig().isManagementMessage(envelope.message())) {
            Dispatch.super.sendMessage(envelope);
        } else {
            this.router().route(envelope.message(), envelope.sender());
        }
    }

    private final Routee start$$anonfun$1(Pool pool$1) {
        return pool$1.newRoutee(this.routeeProps(), this);
    }

    public static class RouterActorCreator
    implements IndirectActorProducer {
        private final RouterConfig routerConfig;

        public RouterActorCreator(RouterConfig routerConfig) {
            this.routerConfig = routerConfig;
        }

        @Override
        public Class<? extends Actor> actorClass() {
            return RouterActor.class;
        }

        @Override
        public Actor produce() {
            return this.routerConfig.createRouterActor();
        }
    }
}

