/*
 * Decompiled with CFR 0.152.
 */
package akka.routing;

import akka.ConfigurationException;
import akka.actor.ActorPath;
import akka.actor.ActorSystemImpl;
import akka.actor.Cell;
import akka.actor.InternalActorRef;
import akka.actor.Props;
import akka.actor.RepointableActorRef;
import akka.actor.UnstartedCell;
import akka.dispatch.BalancingDispatcher;
import akka.dispatch.MailboxType;
import akka.dispatch.MessageDispatcher;
import akka.routing.NoRouter$;
import akka.routing.Pool;
import akka.routing.ResizablePoolCell;
import akka.routing.RoutedActorCell;
import akka.routing.RouterConfig;

public class RoutedActorRef
extends RepointableActorRef {
    private final Props _routeeProps;

    public RoutedActorRef(ActorSystemImpl _system, Props _routerProps, MessageDispatcher _routerDispatcher, MailboxType _routerMailbox, Props _routeeProps, InternalActorRef _supervisor, ActorPath _path) {
        this._routeeProps = _routeeProps;
        super(_system, _routerProps, _routerDispatcher, _routerMailbox, _supervisor, _path);
        RouterConfig routerConfig = _routerProps.routerConfig();
        NoRouter$ noRouter$ = NoRouter$.MODULE$;
        if ((routerConfig == null ? noRouter$ != null : !routerConfig.equals(noRouter$)) && _routerDispatcher instanceof BalancingDispatcher) {
            throw new ConfigurationException("Configuration for " + this + " is invalid - you can not use a 'BalancingDispatcher' as a Router's dispatcher, you can however use it for the routees.");
        }
        _routerProps.routerConfig().verifyConfig(_path);
    }

    @Override
    public Cell newCell(UnstartedCell old) {
        Pool pool;
        RouterConfig routerConfig = this.props().routerConfig();
        RoutedActorCell cell = routerConfig instanceof Pool && (pool = (Pool)routerConfig).resizer().isDefined() ? new ResizablePoolCell(this.system(), this, this.props(), this.dispatcher(), this._routeeProps, this.supervisor(), pool) : new RoutedActorCell(this.system(), this, this.props(), this.dispatcher(), this._routeeProps, this.supervisor());
        return (RoutedActorCell)cell.init(false, this.mailboxType());
    }
}

