/*
 * Decompiled with CFR 0.152.
 */
package akka.serialization;

import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.serialization.BaseSerializer$;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.Serializer;
import java.nio.ByteBuffer;
import scala.MatchError;
import scala.Option;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class BooleanSerializer
implements Serializer,
ByteBufferSerializer {
    private final ExtendedActorSystem system;
    private final byte FalseB;
    private final byte TrueB;
    private final int identifier;

    public BooleanSerializer(ExtendedActorSystem system) {
        this.system = system;
        this.FalseB = (byte)0;
        this.TrueB = (byte)1;
        this.identifier = BaseSerializer$.MODULE$.identifierFromConfig("primitive-boolean", system);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    @Override
    public boolean includeManifest() {
        return false;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public void toBinary(Object o, ByteBuffer buf) {
        byte by;
        Object object = o;
        if (BoxesRunTime.equals((Object)Boolean.TRUE, (Object)object)) {
            by = this.TrueB;
        } else if (BoxesRunTime.equals((Object)Boolean.FALSE, (Object)object)) {
            by = this.FalseB;
        } else {
            throw new MatchError(object);
        }
        byte flag = by;
        buf.put(flag);
    }

    @Override
    public Object fromBinary(ByteBuffer buf, String manifest) {
        Boolean bl;
        byte by = buf.get();
        if (this.TrueB == by) {
            bl = Boolean.TRUE;
        } else if (this.FalseB == by) {
            bl = Boolean.FALSE;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
        }
        return bl;
    }

    @Override
    public byte[] toBinary(Object o) {
        byte by;
        Object object = o;
        if (BoxesRunTime.equals((Object)Boolean.TRUE, (Object)object)) {
            by = this.TrueB;
        } else if (BoxesRunTime.equals((Object)Boolean.FALSE, (Object)object)) {
            by = this.FalseB;
        } else {
            throw new MatchError(object);
        }
        byte flag = by;
        byte[] result = new byte[]{flag};
        return result;
    }

    @Override
    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        Boolean bl;
        byte by = bytes[0];
        if (this.TrueB == by) {
            bl = Boolean.TRUE;
        } else if (this.FalseB == by) {
            bl = Boolean.FALSE;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
        }
        return bl;
    }
}

