/*
 * Decompiled with CFR 0.152.
 */
package akka.serialization;

import akka.actor.ExtendedActorSystem;
import akka.event.LogMarker$;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.MarkerLoggingAdapter;
import akka.serialization.BaseSerializer$;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.DisabledJavaSerializer$;
import akka.serialization.JavaSerializer;
import akka.serialization.Serializer;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Array$;
import scala.Option;
import scala.Product;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NoStackTrace;

public final class DisabledJavaSerializer
implements Serializer,
ByteBufferSerializer,
Product,
Serializable {
    private final ExtendedActorSystem system;
    private final int identifier;
    private final byte[] empty;
    private final MarkerLoggingAdapter log;

    public static JavaSerializationException IllegalDeserialization() {
        return DisabledJavaSerializer$.MODULE$.IllegalDeserialization();
    }

    public static JavaSerializationException IllegalSerialization() {
        return DisabledJavaSerializer$.MODULE$.IllegalSerialization();
    }

    public static DisabledJavaSerializer apply(ExtendedActorSystem extendedActorSystem) {
        return DisabledJavaSerializer$.MODULE$.apply(extendedActorSystem);
    }

    public static DisabledJavaSerializer fromProduct(Product product) {
        return DisabledJavaSerializer$.MODULE$.fromProduct(product);
    }

    public static DisabledJavaSerializer unapply(DisabledJavaSerializer disabledJavaSerializer) {
        return DisabledJavaSerializer$.MODULE$.unapply(disabledJavaSerializer);
    }

    public DisabledJavaSerializer(ExtendedActorSystem system) {
        this.system = system;
        this.identifier = BaseSerializer$.MODULE$.identifierFromConfig(JavaSerializer.class, system);
        this.empty = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Byte.TYPE));
        this.log = Logging$.MODULE$.withMarker(system, this.getClass(), LogSource$.MODULE$.fromAnyClass());
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof DisabledJavaSerializer)) return false;
        DisabledJavaSerializer disabledJavaSerializer = (DisabledJavaSerializer)object;
        ExtendedActorSystem extendedActorSystem = this.system();
        ExtendedActorSystem extendedActorSystem2 = disabledJavaSerializer.system();
        if (extendedActorSystem != null) {
            if (!extendedActorSystem.equals(extendedActorSystem2)) return false;
            return true;
        }
        if (extendedActorSystem2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof DisabledJavaSerializer;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "DisabledJavaSerializer";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return this._1();
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return "system";
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public boolean includeManifest() {
        return false;
    }

    @Override
    public void toBinary(Object o, ByteBuffer buf) {
        this.log.warning(LogMarker$.MODULE$.Security(), "Outgoing message attempted to use Java Serialization even though `akka.actor.allow-java-serialization = off` was set! Message type was: [{}]", o.getClass());
        throw DisabledJavaSerializer$.MODULE$.IllegalSerialization();
    }

    @Override
    public Object fromBinary(byte[] bytes, Option<Class<?>> clazz) {
        this.log.warning(LogMarker$.MODULE$.Security(), "Incoming message attempted to use Java Serialization even though `akka.actor.allow-java-serialization = off` was set!");
        throw DisabledJavaSerializer$.MODULE$.IllegalDeserialization();
    }

    @Override
    public Object fromBinary(ByteBuffer buf, String manifest) {
        this.log.warning(LogMarker$.MODULE$.Security(), "Incoming message attempted to use Java Serialization even though `akka.actor.allow-java-serialization = off` was set!");
        throw DisabledJavaSerializer$.MODULE$.IllegalDeserialization();
    }

    @Override
    public byte[] toBinary(Object o) {
        this.toBinary(o, null);
        return this.empty;
    }

    public DisabledJavaSerializer copy(ExtendedActorSystem system) {
        return new DisabledJavaSerializer(system);
    }

    public ExtendedActorSystem copy$default$1() {
        return this.system();
    }

    public ExtendedActorSystem _1() {
        return this.system();
    }

    public static final class JavaSerializationException
    extends RuntimeException
    implements NoStackTrace {
        public JavaSerializationException(String msg) {
            super(msg);
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }
    }
}

