/*
 * Decompiled with CFR 0.152.
 */
package akka.serialization;

import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.serialization.BaseSerializer$;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.Serializer;
import java.nio.ByteBuffer;
import scala.Option;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class IntSerializer
implements Serializer,
ByteBufferSerializer {
    private final ExtendedActorSystem system;
    private final int identifier;

    public IntSerializer(ExtendedActorSystem system) {
        this.system = system;
        this.identifier = BaseSerializer$.MODULE$.identifierFromConfig("primitive-int", system);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    @Override
    public boolean includeManifest() {
        return false;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public void toBinary(Object o, ByteBuffer buf) {
        buf.putInt(BoxesRunTime.unboxToInt((Object)o));
    }

    @Override
    public Object fromBinary(ByteBuffer buf, String manifest) {
        return BoxesRunTime.boxToInteger((int)buf.getInt());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] toBinary(Object o) {
        void var2_2;
        byte[] result = new byte[4];
        int i = 0;
        for (int j = BoxesRunTime.unboxToInt((Object)o); j != 0; j >>>= 8) {
            result[i] = (byte)(j & 0xFF);
            ++i;
        }
        return var2_2;
    }

    @Override
    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        int result = 0;
        for (int i = 3; i >= 0; --i) {
            result <<= 8;
            result |= bytes[i] & 0xFF;
        }
        return BoxesRunTime.boxToInteger((int)result);
    }
}

