/*
 * Decompiled with CFR 0.152.
 */
package akka.serialization;

import akka.actor.ExtendedActorSystem;
import akka.serialization.BaseSerializer;
import akka.serialization.DisabledJavaSerializer;
import akka.serialization.JavaSerializer$;
import akka.serialization.Serializer;
import akka.util.ClassLoaderObjectInputStream;
import dotty.runtime.function.JFunction0;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.Callable;
import scala.Function0;
import scala.Option;
import scala.util.DynamicVariable;

public class JavaSerializer
implements Serializer,
BaseSerializer {
    private final int identifier;
    private final ExtendedActorSystem system;

    public static CurrentSystem currentSystem() {
        return JavaSerializer$.MODULE$.currentSystem();
    }

    public JavaSerializer(ExtendedActorSystem system) {
        this.system = system;
        this.identifier = BaseSerializer.super.initial$identifier();
        if (!system.settings().AllowJavaSerialization()) {
            throw new DisabledJavaSerializer.JavaSerializationException("Attempted creation of `JavaSerializer` while `akka.actor.allow-java-serialization = off` was set!");
        }
    }

    @Override
    public final String SerializationIdentifiers() {
        return BaseSerializer.super.initial$SerializationIdentifiers();
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public ExtendedActorSystem system() {
        return this.system;
    }

    @Override
    public boolean includeManifest() {
        return false;
    }

    @Override
    public byte[] toBinary(Object o) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        JavaSerializer$.MODULE$.currentSystem().withValue(this.system(), (Function0)((JFunction0.mcV.sp & Serializable)() -> JavaSerializer.toBinary$$anonfun$1(o, out)));
        out.close();
        return bos.toByteArray();
    }

    @Override
    public Object fromBinary(byte[] bytes, Option<Class<?>> clazz) {
        ClassLoaderObjectInputStream in = new ClassLoaderObjectInputStream(this.system().dynamicAccess().classLoader(), new ByteArrayInputStream(bytes));
        Object obj = JavaSerializer$.MODULE$.currentSystem().withValue(this.system(), () -> JavaSerializer.$anonfun$1(in));
        in.close();
        return obj;
    }

    private static final void toBinary$$anonfun$1(Object o$1, ObjectOutputStream out$1) {
        out$1.writeObject(o$1);
    }

    private static final Object $anonfun$1(ClassLoaderObjectInputStream in$1) {
        return in$1.readObject();
    }

    public static final class CurrentSystem
    extends DynamicVariable<ExtendedActorSystem> {
        public CurrentSystem() {
            super(null);
        }

        public <S> S withValue(ExtendedActorSystem value, Callable<S> callable) {
            return (S)super.withValue((Object)value, () -> this.withValue$$anonfun$1(callable));
        }

        private final Object withValue$$anonfun$1(Callable callable$1) {
            return callable$1.call();
        }
    }
}

