/*
 * Decompiled with CFR 0.152.
 */
package akka.util;

import akka.util.ByteIterator$ByteArrayIterator$;
import akka.util.ByteIterator$MultiByteArrayIterator$;
import akka.util.ByteString;
import akka.util.ByteString$;
import akka.util.ByteString$ByteString1$;
import akka.util.ByteString$ByteString1C$;
import akka.util.Collections$EmptyImmutableSeq$;
import dotty.DottyPredef$;
import dotty.runtime.Arrays$;
import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JFunction2;
import dotty.runtime.function.JProcedure1;
import dotty.runtime.function.JProcedure3;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Int$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BufferedIterator;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.LinearSeq;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public abstract class ByteIterator
implements BufferedIterator<Object> {
    public ByteIterator() {
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        Iterator.$init$((Iterator)this);
        BufferedIterator.$init$((BufferedIterator)this);
    }

    public abstract int len();

    public abstract byte head();

    public abstract byte next();

    public abstract void clear();

    public ByteIterator $plus$plus(IterableOnce<Object> that) {
        Iterator it = that.iterator();
        return it.isEmpty() ? this : ByteIterator$ByteArrayIterator$.MODULE$.apply((byte[])it.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    public ByteIterator clone() {
        throw new UnsupportedOperationException("Method clone is not implemented in ByteIterator");
    }

    public Tuple2<ByteIterator, ByteIterator> duplicate() {
        return Tuple2$.MODULE$.apply((Object)this, (Object)this.clone());
    }

    public ByteIterator take(int n) {
        throw new UnsupportedOperationException("Method take is not implemented in ByteIterator");
    }

    public ByteIterator drop(int n) {
        throw new UnsupportedOperationException("Method drop is not implemented in ByteIterator");
    }

    public ByteIterator slice(int from, int until) {
        return from > 0 ? this.drop(from).take(until - from) : this.take(until);
    }

    public ByteIterator takeWhile(Function1<Object, Object> p) {
        throw new UnsupportedOperationException("Method takeWhile is not implemented in ByteIterator");
    }

    public ByteIterator dropWhile(Function1<Object, Object> p) {
        throw new UnsupportedOperationException("Method dropWhile is not implemented in ByteIterator");
    }

    public Tuple2<ByteIterator, ByteIterator> span(Function1<Object, Object> p) {
        ByteIterator that = this.clone();
        this.takeWhile((Function1)p);
        that.drop(this.len());
        return Tuple2$.MODULE$.apply((Object)this, (Object)that);
    }

    public int indexWhere(Function1<Object, Object> p, int from) {
        int index;
        for (index = 0; index < from; ++index) {
            this.next();
        }
        boolean found = false;
        while (!found && this.hasNext()) {
            if (BoxesRunTime.unboxToBoolean((Object)p.apply((Object)BoxesRunTime.boxToByte((byte)this.next())))) {
                found = true;
                continue;
            }
            ++index;
        }
        return found ? index : -1;
    }

    public int indexWhere$default$2() {
        return 0;
    }

    public int indexOf(byte elem) {
        return this.indexOf(elem, 0);
    }

    public int indexOf(byte elem, int from) {
        return this.indexWhere((Function1<Object, Object>)((JFunction1 & Serializable)arg_0 -> ByteIterator.indexOf$$anonfun$adapted$1(elem, arg_0)), from);
    }

    public <B> int indexOf(B elem) {
        return this.indexOf(elem, 0);
    }

    public <B> int indexOf(B elem, int from) {
        return this.indexWhere((Function1<Object, Object>)((JFunction1 & Serializable)arg_0 -> ByteIterator.indexOf$$anonfun$adapted$2(elem, arg_0)), from);
    }

    public abstract ByteString toByteString();

    public ByteString toSeq() {
        return this.toByteString();
    }

    public <U> void foreach(Function1<Object, U> f) {
        while (this.hasNext()) {
            f.apply((Object)BoxesRunTime.boxToByte((byte)this.next()));
        }
    }

    public <B> B foldLeft(B z, Function2<B, Object, B> op) {
        ObjectRef acc = ObjectRef.create(z);
        this.foreach((Function1)((JProcedure1 & Serializable)arg_0 -> ByteIterator.foldLeft$$anonfun$adapted$1(op, acc, arg_0)));
        return (B)acc.elem;
    }

    /*
     * WARNING - void declaration
     */
    public <B> Object toArray(ClassTag<B> arg0) {
        void var2_2;
        Object target = Arrays$.MODULE$.newGenericArray(this.len(), arg0);
        this.copyToArray(target);
        return var2_2;
    }

    public byte getByte() {
        return this.next();
    }

    public short getShort(ByteOrder byteOrder) {
        short s;
        ByteOrder byteOrder2 = byteOrder;
        ByteOrder byteOrder3 = ByteOrder.BIG_ENDIAN;
        if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
            s = (short)((this.next() & 0xFF) << 8 | (this.next() & 0xFF) << 0);
        } else {
            ByteOrder byteOrder4 = byteOrder;
            ByteOrder byteOrder5 = ByteOrder.LITTLE_ENDIAN;
            if (!(byteOrder4 != null ? !byteOrder4.equals(byteOrder5) : byteOrder5 != null)) {
                s = (short)((this.next() & 0xFF) << 0 | (this.next() & 0xFF) << 8);
            } else {
                throw new IllegalArgumentException("Unknown byte order " + byteOrder);
            }
        }
        return s;
    }

    public int getInt(ByteOrder byteOrder) {
        int n;
        ByteOrder byteOrder2 = byteOrder;
        ByteOrder byteOrder3 = ByteOrder.BIG_ENDIAN;
        if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
            n = (this.next() & 0xFF) << 24 | (this.next() & 0xFF) << 16 | (this.next() & 0xFF) << 8 | (this.next() & 0xFF) << 0;
        } else {
            ByteOrder byteOrder4 = byteOrder;
            ByteOrder byteOrder5 = ByteOrder.LITTLE_ENDIAN;
            if (!(byteOrder4 != null ? !byteOrder4.equals(byteOrder5) : byteOrder5 != null)) {
                n = (this.next() & 0xFF) << 0 | (this.next() & 0xFF) << 8 | (this.next() & 0xFF) << 16 | (this.next() & 0xFF) << 24;
            } else {
                throw new IllegalArgumentException("Unknown byte order " + byteOrder);
            }
        }
        return n;
    }

    public long getLong(ByteOrder byteOrder) {
        long l;
        ByteOrder byteOrder2 = byteOrder;
        ByteOrder byteOrder3 = ByteOrder.BIG_ENDIAN;
        if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
            l = ((long)this.next() & 0xFFL) << 56 | ((long)this.next() & 0xFFL) << 48 | ((long)this.next() & 0xFFL) << 40 | ((long)this.next() & 0xFFL) << 32 | ((long)this.next() & 0xFFL) << 24 | ((long)this.next() & 0xFFL) << 16 | ((long)this.next() & 0xFFL) << 8 | ((long)this.next() & 0xFFL) << 0;
        } else {
            ByteOrder byteOrder4 = byteOrder;
            ByteOrder byteOrder5 = ByteOrder.LITTLE_ENDIAN;
            if (!(byteOrder4 != null ? !byteOrder4.equals(byteOrder5) : byteOrder5 != null)) {
                l = ((long)this.next() & 0xFFL) << 0 | ((long)this.next() & 0xFFL) << 8 | ((long)this.next() & 0xFFL) << 16 | ((long)this.next() & 0xFFL) << 24 | ((long)this.next() & 0xFFL) << 32 | ((long)this.next() & 0xFFL) << 40 | ((long)this.next() & 0xFFL) << 48 | ((long)this.next() & 0xFFL) << 56;
            } else {
                throw new IllegalArgumentException("Unknown byte order " + byteOrder);
            }
        }
        return l;
    }

    public long getLongPart(int n, ByteOrder byteOrder) {
        long l;
        ByteOrder byteOrder2 = byteOrder;
        ByteOrder byteOrder3 = ByteOrder.BIG_ENDIAN;
        if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
            LongRef x = LongRef.create((long)0L);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), n).foreach((Function1)(JFunction1.mcVI.sp & Serializable)_$29 -> {
                long l;
                x$1.elem = l = x$1.elem << 8 | (long)(this.next() & 0xFF);
            });
            l = x.elem;
        } else {
            ByteOrder byteOrder4 = byteOrder;
            ByteOrder byteOrder5 = ByteOrder.LITTLE_ENDIAN;
            if (!(byteOrder4 != null ? !byteOrder4.equals(byteOrder5) : byteOrder5 != null)) {
                LongRef x = LongRef.create((long)0L);
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), n).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    long l;
                    x$2.elem = l = x$2.elem | (long)((this.next() & 0xFF) << 8 * i);
                });
                l = x.elem;
            } else {
                throw new IllegalArgumentException("Unknown byte order " + byteOrder);
            }
        }
        return l;
    }

    public float getFloat(ByteOrder byteOrder) {
        return Float.intBitsToFloat(this.getInt(byteOrder));
    }

    public double getDouble(ByteOrder byteOrder) {
        return Double.longBitsToDouble(this.getLong(byteOrder));
    }

    public ByteIterator getBytes(byte[] xs) {
        return this.getBytes(xs, 0, xs.length);
    }

    public abstract ByteIterator getBytes(byte[] var1, int var2, int var3);

    /*
     * WARNING - void declaration
     */
    public byte[] getBytes(int n) {
        void var2_2;
        byte[] bytes = new byte[n];
        this.getBytes(bytes, 0, n);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public ByteString getByteString(int n) {
        void var2_2;
        ByteString bs = this.clone().take(n).toByteString();
        this.drop(n);
        return var2_2;
    }

    public ByteIterator getShorts(short[] xs, ByteOrder byteOrder) {
        return this.getShorts(xs, 0, xs.length, byteOrder);
    }

    public abstract ByteIterator getShorts(short[] var1, int var2, int var3, ByteOrder var4);

    public ByteIterator getInts(int[] xs, ByteOrder byteOrder) {
        return this.getInts(xs, 0, xs.length, byteOrder);
    }

    public abstract ByteIterator getInts(int[] var1, int var2, int var3, ByteOrder var4);

    public ByteIterator getLongs(long[] xs, ByteOrder byteOrder) {
        return this.getLongs(xs, 0, xs.length, byteOrder);
    }

    public abstract ByteIterator getLongs(long[] var1, int var2, int var3, ByteOrder var4);

    public ByteIterator getFloats(float[] xs, ByteOrder byteOrder) {
        return this.getFloats(xs, 0, xs.length, byteOrder);
    }

    public abstract ByteIterator getFloats(float[] var1, int var2, int var3, ByteOrder var4);

    public ByteIterator getDoubles(double[] xs, ByteOrder byteOrder) {
        return this.getDoubles(xs, 0, xs.length, byteOrder);
    }

    public abstract ByteIterator getDoubles(double[] var1, int var2, int var3, ByteOrder var4);

    public abstract int copyToBuffer(ByteBuffer var1);

    public abstract InputStream asInputStream();

    private static final /* synthetic */ boolean indexOf$$anonfun$1(byte elem$1, byte _$27) {
        return _$27 == elem$1;
    }

    private static final boolean indexOf$$anonfun$adapted$1(byte elem$3, Object _$27) {
        return ByteIterator.indexOf$$anonfun$1(elem$3, BoxesRunTime.unboxToByte((Object)_$27));
    }

    private static final /* synthetic */ boolean indexOf$$anonfun$2(Object elem$2, byte _$28) {
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToByte((byte)_$28), (Object)elem$2);
    }

    private static final boolean indexOf$$anonfun$adapted$2(Object elem$4, Object _$28) {
        return ByteIterator.indexOf$$anonfun$2(elem$4, BoxesRunTime.unboxToByte((Object)_$28));
    }

    private static final /* synthetic */ void foldLeft$$anonfun$1(Function2 op$1, ObjectRef acc$1, byte by) {
        Object object;
        acc$1.elem = object = op$1.apply(acc$1.elem, (Object)BoxesRunTime.boxToByte((byte)by));
    }

    private static final void foldLeft$$anonfun$adapted$1(Function2 op$2, ObjectRef acc$2, Object object) {
        ByteIterator.foldLeft$$anonfun$1(op$2, acc$2, BoxesRunTime.unboxToByte((Object)object));
    }

    public static class ByteArrayIterator
    extends ByteIterator {
        private byte[] array;
        private int from;
        private int until;

        public static ByteArrayIterator empty() {
            return ByteIterator$ByteArrayIterator$.MODULE$.empty();
        }

        public ByteArrayIterator(byte[] array, int from, int until) {
            this.array = array;
            this.from = from;
            this.until = until;
        }

        private byte[] array() {
            return this.array;
        }

        private void array_$eq(byte[] x$0) {
            this.array = x$0;
        }

        private int from() {
            return this.from;
        }

        private void from_$eq(int x$0) {
            this.from = x$0;
        }

        private int until() {
            return this.until;
        }

        private void until_$eq(int x$0) {
            this.until = x$0;
        }

        @Override
        public final int len() {
            return this.until() - this.from();
        }

        public final boolean hasNext() {
            return this.from() < this.until();
        }

        @Override
        public final byte head() {
            return this.array()[this.from()];
        }

        @Override
        public final byte next() {
            byte by;
            if (!this.hasNext()) {
                by = BoxesRunTime.unboxToByte((Object)Collections$EmptyImmutableSeq$.MODULE$.iterator().next());
            } else {
                int i = this.from();
                this.from_$eq(this.from() + 1);
                by = this.array()[i];
            }
            return by;
        }

        @Override
        public void clear() {
            this.array_$eq(Array$.MODULE$.emptyByteArray());
            this.from_$eq(0);
            this.until_$eq(this.from());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int size() {
            void var1_1;
            int l = this.len();
            this.clear();
            return (int)var1_1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final ByteIterator $plus$plus(IterableOnce<Object> that) {
            ByteIterator byteIterator;
            IterableOnce<Object> iterableOnce = that;
            if (iterableOnce instanceof ByteIterator) {
                ByteIterator that2 = (ByteIterator)iterableOnce;
                if (that2.isEmpty()) {
                    byteIterator = this;
                    return byteIterator;
                } else if (this.isEmpty()) {
                    byteIterator = that2;
                    return byteIterator;
                } else {
                    ByteIterator byteIterator2 = that2;
                    if (byteIterator2 instanceof ByteArrayIterator) {
                        ByteArrayIterator that3 = (ByteArrayIterator)byteIterator2;
                        if (this.array() == that3.array() && this.until() == that3.from()) {
                            this.until_$eq(that3.until());
                            that3.clear();
                            byteIterator = this;
                            return byteIterator;
                        } else {
                            MultiByteArrayIterator result = ByteIterator$MultiByteArrayIterator$.MODULE$.apply((LinearSeq<ByteArrayIterator>)((LinearSeq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ByteArrayIterator[]{this, that3}))));
                            this.clear();
                            byteIterator = result;
                        }
                        return byteIterator;
                    } else {
                        if (!(byteIterator2 instanceof MultiByteArrayIterator)) throw new MatchError((Object)byteIterator2);
                        MultiByteArrayIterator that4 = (MultiByteArrayIterator)byteIterator2;
                        byteIterator = that4.$plus$plus$colon(this);
                    }
                }
                return byteIterator;
            } else {
                byteIterator = super.$plus$plus(that);
            }
            return byteIterator;
        }

        @Override
        public final ByteArrayIterator clone() {
            return new ByteArrayIterator(this.array(), this.from(), this.until());
        }

        @Override
        public final ByteArrayIterator take(int n) {
            if (n < this.len()) {
                this.until_$eq(n > 0 ? this.from() + n : this.from());
            }
            return this;
        }

        @Override
        public final ByteArrayIterator drop(int n) {
            if (n > 0) {
                this.from_$eq(n < this.len() ? this.from() + n : this.until());
            }
            return this;
        }

        @Override
        public final ByteArrayIterator takeWhile(Function1<Object, Object> p) {
            int prev = this.from();
            this.dropWhile((Function1)p);
            this.until_$eq(this.from());
            this.from_$eq(prev);
            return this;
        }

        @Override
        public final ByteArrayIterator dropWhile(Function1<Object, Object> p) {
            boolean stop = false;
            while (!stop && this.hasNext()) {
                if (BoxesRunTime.unboxToBoolean((Object)p.apply((Object)BoxesRunTime.boxToByte((byte)this.array()[this.from()])))) {
                    this.from_$eq(this.from() + 1);
                    continue;
                }
                stop = true;
            }
            return this;
        }

        @Override
        public <B> int copyToArray(Object xs, int start) {
            return this.copyToArray(xs, start, ScalaRunTime$.MODULE$.array_length(xs));
        }

        @Override
        public <B> int copyToArray(Object xs) {
            return this.copyToArray(xs, 0, ScalaRunTime$.MODULE$.array_length(xs));
        }

        @Override
        public final <B> int copyToArray(Object xs, int start, int len) {
            int n = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(ScalaRunTime$.MODULE$.array_length(xs) - start), this.len())), len));
            Array$.MODULE$.copy((Object)this.array(), this.from(), xs, start, n);
            this.drop(n);
            return n;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteString toByteString() {
            void var1_1;
            ByteString result = this.from() == 0 && this.until() == this.array().length ? ByteString$ByteString1C$.MODULE$.apply(this.array()) : ByteString$ByteString1$.MODULE$.apply(this.array(), this.from(), this.len());
            this.clear();
            return var1_1;
        }

        @Override
        public ByteArrayIterator getBytes(byte[] xs, int offset, int n) {
            if (n > this.len()) {
                throw new NoSuchElementException("next on empty iterator");
            }
            Array$.MODULE$.copy((Object)this.array(), this.from(), (Object)xs, offset, n);
            return this.drop(n);
        }

        private ByteBuffer wrappedByteBuffer() {
            return ByteBuffer.wrap(this.array(), this.from(), this.len()).asReadOnlyBuffer();
        }

        @Override
        public ByteArrayIterator getShorts(short[] xs, int offset, int n, ByteOrder byteOrder) {
            this.wrappedByteBuffer().order(byteOrder).asShortBuffer().get(xs, offset, n);
            return this.drop(2 * n);
        }

        @Override
        public ByteArrayIterator getInts(int[] xs, int offset, int n, ByteOrder byteOrder) {
            this.wrappedByteBuffer().order(byteOrder).asIntBuffer().get(xs, offset, n);
            return this.drop(4 * n);
        }

        @Override
        public ByteArrayIterator getLongs(long[] xs, int offset, int n, ByteOrder byteOrder) {
            this.wrappedByteBuffer().order(byteOrder).asLongBuffer().get(xs, offset, n);
            return this.drop(8 * n);
        }

        @Override
        public ByteArrayIterator getFloats(float[] xs, int offset, int n, ByteOrder byteOrder) {
            this.wrappedByteBuffer().order(byteOrder).asFloatBuffer().get(xs, offset, n);
            return this.drop(4 * n);
        }

        @Override
        public ByteArrayIterator getDoubles(double[] xs, int offset, int n, ByteOrder byteOrder) {
            this.wrappedByteBuffer().order(byteOrder).asDoubleBuffer().get(xs, offset, n);
            return this.drop(8 * n);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int copyToBuffer(ByteBuffer buffer) {
            void var2_2;
            int copyLength = scala.math.package$.MODULE$.min(buffer.remaining(), this.len());
            if (copyLength > 0) {
                buffer.put(this.array(), this.from(), copyLength);
                this.drop(copyLength);
            }
            return (int)var2_2;
        }

        @Override
        public InputStream asInputStream() {
            return new InputStream(this){
                private final ByteArrayIterator $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public int available() {
                    return this.$outer.len();
                }

                public int read() {
                    return this.$outer.hasNext() ? this.$outer.next() & 0xFF : -1;
                }

                public int read(byte[] b, int off, int len) {
                    int n;
                    if (off < 0 || len < 0 || off + len > b.length) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (len == 0) {
                        n = 0;
                    } else if (!this.$outer.isEmpty()) {
                        int nRead = scala.math.package$.MODULE$.min(this.available(), len);
                        this.$outer.copyToArray(b, off, nRead);
                        n = nRead;
                    } else {
                        n = -1;
                    }
                    return n;
                }

                public long skip(long n) {
                    int nSkip = scala.math.package$.MODULE$.min(this.$outer.len(), (int)n);
                    this.$outer.drop(nSkip);
                    return Int$.MODULE$.int2long(nSkip);
                }
            };
        }
    }

    public static class MultiByteArrayIterator
    extends ByteIterator {
        private LinearSeq iterators;

        public static MultiByteArrayIterator empty() {
            return ByteIterator$MultiByteArrayIterator$.MODULE$.empty();
        }

        public MultiByteArrayIterator(LinearSeq<ByteArrayIterator> iterators) {
            this.iterators = iterators;
            this.akka$util$ByteIterator$MultiByteArrayIterator$$normalize();
        }

        private LinearSeq<ByteArrayIterator> iterators() {
            return this.iterators;
        }

        private void iterators_$eq(LinearSeq<ByteArrayIterator> x$0) {
            this.iterators = x$0;
        }

        public MultiByteArrayIterator akka$util$ByteIterator$MultiByteArrayIterator$$normalize() {
            this.iterators_$eq((LinearSeq<ByteArrayIterator>)this.norm$1(this.iterators()));
            return this;
        }

        public ByteArrayIterator akka$util$ByteIterator$MultiByteArrayIterator$$current() {
            return (ByteArrayIterator)this.iterators().head();
        }

        private void dropCurrent() {
            this.iterators_$eq((LinearSeq<ByteArrayIterator>)((LinearSeq)this.iterators().tail()));
        }

        @Override
        public void clear() {
            this.iterators_$eq(ByteIterator$MultiByteArrayIterator$.MODULE$.empty().iterators());
        }

        public final boolean hasNext() {
            return this.akka$util$ByteIterator$MultiByteArrayIterator$$current().hasNext();
        }

        @Override
        public final byte head() {
            return this.akka$util$ByteIterator$MultiByteArrayIterator$$current().head();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte next() {
            void var1_1;
            byte result = this.akka$util$ByteIterator$MultiByteArrayIterator$$current().next();
            this.akka$util$ByteIterator$MultiByteArrayIterator$$normalize();
            return (byte)var1_1;
        }

        @Override
        public final int len() {
            return BoxesRunTime.unboxToInt((Object)this.iterators().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)((JFunction2 & Serializable)this::len$$anonfun$adapted$1)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int size() {
            void var1_1;
            int result = this.len();
            this.clear();
            return (int)var1_1;
        }

        public MultiByteArrayIterator $plus$plus$colon(ByteArrayIterator that) {
            this.iterators_$eq((LinearSeq<ByteArrayIterator>)((LinearSeq)this.iterators().$plus$colon((Object)that)));
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final ByteIterator $plus$plus(IterableOnce<Object> that) {
            ByteIterator byteIterator;
            IterableOnce<Object> iterableOnce = that;
            if (iterableOnce instanceof ByteIterator) {
                ByteIterator that2 = (ByteIterator)iterableOnce;
                if (that2.isEmpty()) {
                    byteIterator = this;
                    return byteIterator;
                } else if (this.isEmpty()) {
                    byteIterator = that2;
                    return byteIterator;
                } else {
                    ByteIterator byteIterator2 = that2;
                    if (byteIterator2 instanceof ByteArrayIterator) {
                        ByteArrayIterator that3 = (ByteArrayIterator)byteIterator2;
                        this.iterators_$eq((LinearSeq<ByteArrayIterator>)((LinearSeq)this.iterators().$colon$plus((Object)that3)));
                        that3.clear();
                        byteIterator = this;
                        return byteIterator;
                    } else {
                        if (!(byteIterator2 instanceof MultiByteArrayIterator)) throw new MatchError((Object)byteIterator2);
                        MultiByteArrayIterator that4 = (MultiByteArrayIterator)byteIterator2;
                        this.iterators_$eq((LinearSeq<ByteArrayIterator>)((LinearSeq)this.iterators().$plus$plus(that4.iterators())));
                        that4.clear();
                        byteIterator = this;
                    }
                }
                return byteIterator;
            } else {
                byteIterator = super.$plus$plus(that);
            }
            return byteIterator;
        }

        @Override
        public final MultiByteArrayIterator clone() {
            List clonedIterators = (List)this.iterators().iterator().map((Function1)(JFunction1 & Serializable)_$3 -> _$3.clone()).to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.List()));
            return new MultiByteArrayIterator((LinearSeq<ByteArrayIterator>)clonedIterators);
        }

        @Override
        public final MultiByteArrayIterator take(int n) {
            int rest = n;
            ListBuffer builder = new ListBuffer();
            while (rest > 0 && !this.iterators().isEmpty()) {
                this.akka$util$ByteIterator$MultiByteArrayIterator$$current().take(rest);
                if (this.akka$util$ByteIterator$MultiByteArrayIterator$$current().hasNext()) {
                    rest -= this.akka$util$ByteIterator$MultiByteArrayIterator$$current().len();
                    builder.$plus$eq((Object)this.akka$util$ByteIterator$MultiByteArrayIterator$$current());
                }
                this.iterators_$eq((LinearSeq<ByteArrayIterator>)((LinearSeq)this.iterators().tail()));
            }
            this.iterators_$eq((LinearSeq<ByteArrayIterator>)builder.result());
            return this.akka$util$ByteIterator$MultiByteArrayIterator$$normalize();
        }

        @Override
        public final MultiByteArrayIterator drop(int n) {
            MultiByteArrayIterator multiByteArrayIterator = this;
            int n2 = n;
            while (n2 > 0 && !multiByteArrayIterator.isEmpty()) {
                int nCurrent = scala.math.package$.MODULE$.min(n2, multiByteArrayIterator.akka$util$ByteIterator$MultiByteArrayIterator$$current().len());
                multiByteArrayIterator.akka$util$ByteIterator$MultiByteArrayIterator$$current().drop(n2);
                int rest = n2 - nCurrent;
                if (!multiByteArrayIterator.akka$util$ByteIterator$MultiByteArrayIterator$$current().isEmpty() && rest != 0) {
                    throw DottyPredef$.MODULE$.assertFail();
                }
                multiByteArrayIterator.akka$util$ByteIterator$MultiByteArrayIterator$$normalize();
                MultiByteArrayIterator multiByteArrayIterator2 = multiByteArrayIterator;
                int n3 = rest;
                multiByteArrayIterator = multiByteArrayIterator2;
                n2 = n3;
            }
            return multiByteArrayIterator;
        }

        @Override
        public final MultiByteArrayIterator takeWhile(Function1<Object, Object> p) {
            boolean stop = false;
            ListBuffer builder = new ListBuffer();
            while (!stop && !this.iterators().isEmpty()) {
                int lastLen = this.akka$util$ByteIterator$MultiByteArrayIterator$$current().len();
                this.akka$util$ByteIterator$MultiByteArrayIterator$$current().takeWhile((Function1)p);
                if (this.akka$util$ByteIterator$MultiByteArrayIterator$$current().hasNext()) {
                    builder.$plus$eq((Object)this.akka$util$ByteIterator$MultiByteArrayIterator$$current());
                }
                if (this.akka$util$ByteIterator$MultiByteArrayIterator$$current().len() < lastLen) {
                    stop = true;
                }
                this.dropCurrent();
            }
            this.iterators_$eq((LinearSeq<ByteArrayIterator>)builder.result());
            return this.akka$util$ByteIterator$MultiByteArrayIterator$$normalize();
        }

        @Override
        public final MultiByteArrayIterator dropWhile(Function1<Object, Object> p) {
            MultiByteArrayIterator multiByteArrayIterator;
            block1: {
                MultiByteArrayIterator multiByteArrayIterator2 = this;
                while (!multiByteArrayIterator2.isEmpty()) {
                    multiByteArrayIterator2.akka$util$ByteIterator$MultiByteArrayIterator$$current().dropWhile((Function1)p);
                    boolean dropMore = multiByteArrayIterator2.akka$util$ByteIterator$MultiByteArrayIterator$$current().isEmpty();
                    multiByteArrayIterator2.akka$util$ByteIterator$MultiByteArrayIterator$$normalize();
                    if (dropMore) continue;
                    multiByteArrayIterator = multiByteArrayIterator2;
                    break block1;
                }
                multiByteArrayIterator = multiByteArrayIterator2;
            }
            return multiByteArrayIterator;
        }

        @Override
        public final <B> int copyToArray(Object xs, int start, int len) {
            int rest;
            int n;
            int pos = start;
            for (rest = len; rest > 0 && !this.iterators().isEmpty() && pos < ScalaRunTime$.MODULE$.array_length(xs); pos += n, rest -= n) {
                n = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(ScalaRunTime$.MODULE$.array_length(xs) - pos), this.akka$util$ByteIterator$MultiByteArrayIterator$$current().len())), rest));
                this.akka$util$ByteIterator$MultiByteArrayIterator$$current().copyToArray(xs, pos, n);
                if (!this.akka$util$ByteIterator$MultiByteArrayIterator$$current().isEmpty()) continue;
                this.dropCurrent();
            }
            this.akka$util$ByteIterator$MultiByteArrayIterator$$normalize();
            return len - rest;
        }

        @Override
        public <U> void foreach(Function1<Object, U> f) {
            this.iterators().foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.foreach(f));
            this.clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteString toByteString() {
            ByteString byteString;
            if (((SeqOps)this.iterators().tail()).isEmpty()) {
                byteString = ((ByteArrayIterator)this.iterators().head()).toByteString();
            } else {
                void var1_1;
                ByteString result = (ByteString)this.iterators().foldLeft((Object)ByteString$.MODULE$.empty(), (Function2)(JFunction2 & Serializable)(_$5, _$6) -> _$5.$plus$plus(_$6.toByteString()));
                this.clear();
                byteString = var1_1;
            }
            return byteString;
        }

        public final <A> MultiByteArrayIterator getToArray(Object xs, int offset, int n, int elemSize, Function0<A> getSingle, Function3<Object, Object, Object, BoxedUnit> getMult) {
            MultiByteArrayIterator multiByteArrayIterator = this;
            int n2 = n;
            int n3 = offset;
            while (n2 > 0) {
                int n4;
                if (multiByteArrayIterator.isEmpty()) {
                    Collections$EmptyImmutableSeq$.MODULE$.iterator().next();
                }
                if (multiByteArrayIterator.akka$util$ByteIterator$MultiByteArrayIterator$$current().len() >= elemSize) {
                    int nCurrent = scala.math.package$.MODULE$.min(n2, multiByteArrayIterator.akka$util$ByteIterator$MultiByteArrayIterator$$current().len() / elemSize);
                    getMult.apply(xs, (Object)BoxesRunTime.boxToInteger((int)n3), (Object)BoxesRunTime.boxToInteger((int)nCurrent));
                    n4 = nCurrent;
                } else {
                    ScalaRunTime$.MODULE$.array_update(xs, n3, getSingle.apply());
                    n4 = 1;
                }
                int nDone = n4;
                multiByteArrayIterator.akka$util$ByteIterator$MultiByteArrayIterator$$normalize();
                MultiByteArrayIterator multiByteArrayIterator2 = multiByteArrayIterator;
                int n5 = n3 + nDone;
                int n6 = n2 - nDone;
                multiByteArrayIterator = multiByteArrayIterator2;
                n3 = n5;
                n2 = n6;
            }
            return multiByteArrayIterator;
        }

        @Override
        public MultiByteArrayIterator getBytes(byte[] xs, int offset, int n) {
            return this.getToArray(xs, offset, n, 1, (Function0)((JFunction0.mcB.sp & Serializable)this::getBytes$$anonfun$1), (Function3<Object, Object, Object, BoxedUnit>)((JProcedure3 & Serializable)this::getBytes$$anonfun$adapted$1));
        }

        @Override
        public MultiByteArrayIterator getShorts(short[] xs, int offset, int n, ByteOrder byteOrder) {
            return this.getToArray(xs, offset, n, 2, (Function0)((JFunction0.mcS.sp & Serializable)() -> this.getShorts$$anonfun$1(byteOrder)), (Function3<Object, Object, Object, BoxedUnit>)((JProcedure3 & Serializable)(arg_0, arg_1, arg_2) -> this.getShorts$$anonfun$adapted$1(byteOrder, arg_0, arg_1, arg_2)));
        }

        @Override
        public MultiByteArrayIterator getInts(int[] xs, int offset, int n, ByteOrder byteOrder) {
            return this.getToArray(xs, offset, n, 4, (Function0)((JFunction0.mcI.sp & Serializable)() -> this.getInts$$anonfun$1(byteOrder)), (Function3<Object, Object, Object, BoxedUnit>)((JProcedure3 & Serializable)(arg_0, arg_1, arg_2) -> this.getInts$$anonfun$adapted$1(byteOrder, arg_0, arg_1, arg_2)));
        }

        @Override
        public MultiByteArrayIterator getLongs(long[] xs, int offset, int n, ByteOrder byteOrder) {
            return this.getToArray(xs, offset, n, 8, (Function0)((JFunction0.mcJ.sp & Serializable)() -> this.getLongs$$anonfun$1(byteOrder)), (Function3<Object, Object, Object, BoxedUnit>)((JProcedure3 & Serializable)(arg_0, arg_1, arg_2) -> this.getLongs$$anonfun$adapted$1(byteOrder, arg_0, arg_1, arg_2)));
        }

        @Override
        public MultiByteArrayIterator getFloats(float[] xs, int offset, int n, ByteOrder byteOrder) {
            return this.getToArray(xs, offset, n, 8, (Function0)((JFunction0.mcF.sp & Serializable)() -> this.getFloats$$anonfun$1(byteOrder)), (Function3<Object, Object, Object, BoxedUnit>)((JProcedure3 & Serializable)(arg_0, arg_1, arg_2) -> this.getFloats$$anonfun$adapted$1(byteOrder, arg_0, arg_1, arg_2)));
        }

        @Override
        public MultiByteArrayIterator getDoubles(double[] xs, int offset, int n, ByteOrder byteOrder) {
            return this.getToArray(xs, offset, n, 8, (Function0)((JFunction0.mcD.sp & Serializable)() -> this.getDoubles$$anonfun$1(byteOrder)), (Function3<Object, Object, Object, BoxedUnit>)((JProcedure3 & Serializable)(arg_0, arg_1, arg_2) -> this.getDoubles$$anonfun$adapted$1(byteOrder, arg_0, arg_1, arg_2)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int copyToBuffer(ByteBuffer buffer) {
            void var2_2;
            int n = BoxesRunTime.unboxToInt((Object)this.iterators().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)((JFunction2 & Serializable)(arg_0, arg_1) -> this.$anonfun$adapted$1(buffer, arg_0, arg_1))));
            this.akka$util$ByteIterator$MultiByteArrayIterator$$normalize();
            return (int)var2_2;
        }

        @Override
        public InputStream asInputStream() {
            return new InputStream(this){
                private final MultiByteArrayIterator $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public int available() {
                    return this.$outer.akka$util$ByteIterator$MultiByteArrayIterator$$current().len();
                }

                public int read() {
                    return this.$outer.hasNext() ? this.$outer.next() & 0xFF : -1;
                }

                public int read(byte[] b, int off, int len) {
                    int nRead = this.$outer.akka$util$ByteIterator$MultiByteArrayIterator$$current().asInputStream().read(b, off, len);
                    this.$outer.akka$util$ByteIterator$MultiByteArrayIterator$$normalize();
                    return nRead;
                }

                public long skip(long n) {
                    return this.skipImpl$1(n, 0L);
                }

                private final long skipImpl$1(long n, long skipped) {
                    long l;
                    block4: {
                        long l2 = skipped;
                        long l3 = n;
                        while (l3 > 0L) {
                            if (!this.$outer.isEmpty()) {
                                long m = this.$outer.akka$util$ByteIterator$MultiByteArrayIterator$$current().asInputStream().skip(l3);
                                this.$outer.akka$util$ByteIterator$MultiByteArrayIterator$$normalize();
                                long newN = l3 - m;
                                long newSkipped = l2 + m;
                                if (newN > 0L) {
                                    long l4 = newN;
                                    long l5 = newSkipped;
                                    l3 = l4;
                                    l2 = l5;
                                    continue;
                                }
                                l = newSkipped;
                            } else {
                                l = 0L;
                            }
                            break block4;
                        }
                        l = 0L;
                    }
                    return l;
                }
            };
        }

        private final LinearSeq norm$1(LinearSeq xs) {
            LinearSeq linearSeq;
            block2: {
                LinearSeq linearSeq2 = xs;
                while (true) {
                    if (linearSeq2.isEmpty()) {
                        linearSeq = ByteIterator$MultiByteArrayIterator$.MODULE$.clearedList();
                        break block2;
                    }
                    if (!((Iterator)linearSeq2.head()).isEmpty()) break;
                    linearSeq2 = (LinearSeq)linearSeq2.tail();
                }
                linearSeq = linearSeq2;
            }
            return linearSeq;
        }

        private final /* synthetic */ int len$$anonfun$1(int _$1, ByteArrayIterator _$2) {
            return _$1 + _$2.len();
        }

        private final int len$$anonfun$adapted$1(Object _$1, Object _$2) {
            return this.len$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$1), (ByteArrayIterator)_$2);
        }

        private final byte getBytes$$anonfun$1() {
            return this.getByte();
        }

        private final /* synthetic */ void getBytes$$anonfun$2(byte[] _$7, int _$8, int _$9) {
            this.akka$util$ByteIterator$MultiByteArrayIterator$$current().getBytes(_$7, _$8, _$9);
        }

        private final void getBytes$$anonfun$adapted$1(Object _$7, Object _$8, Object _$9) {
            this.getBytes$$anonfun$2((byte[])_$7, BoxesRunTime.unboxToInt((Object)_$8), BoxesRunTime.unboxToInt((Object)_$9));
        }

        private final short getShorts$$anonfun$1(ByteOrder byteOrder$1) {
            return this.getShort(byteOrder$1);
        }

        private final /* synthetic */ void getShorts$$anonfun$2(ByteOrder byteOrder$2, short[] _$10, int _$11, int _$12) {
            this.akka$util$ByteIterator$MultiByteArrayIterator$$current().getShorts(_$10, _$11, _$12, byteOrder$2);
        }

        private final void getShorts$$anonfun$adapted$1(ByteOrder byteOrder$11, Object _$10, Object _$11, Object _$12) {
            this.getShorts$$anonfun$2(byteOrder$11, (short[])_$10, BoxesRunTime.unboxToInt((Object)_$11), BoxesRunTime.unboxToInt((Object)_$12));
        }

        private final int getInts$$anonfun$1(ByteOrder byteOrder$3) {
            return this.getInt(byteOrder$3);
        }

        private final /* synthetic */ void getInts$$anonfun$2(ByteOrder byteOrder$4, int[] _$13, int _$14, int _$15) {
            this.akka$util$ByteIterator$MultiByteArrayIterator$$current().getInts(_$13, _$14, _$15, byteOrder$4);
        }

        private final void getInts$$anonfun$adapted$1(ByteOrder byteOrder$12, Object _$13, Object _$14, Object _$15) {
            this.getInts$$anonfun$2(byteOrder$12, (int[])_$13, BoxesRunTime.unboxToInt((Object)_$14), BoxesRunTime.unboxToInt((Object)_$15));
        }

        private final long getLongs$$anonfun$1(ByteOrder byteOrder$5) {
            return this.getLong(byteOrder$5);
        }

        private final /* synthetic */ void getLongs$$anonfun$2(ByteOrder byteOrder$6, long[] _$16, int _$17, int _$18) {
            this.akka$util$ByteIterator$MultiByteArrayIterator$$current().getLongs(_$16, _$17, _$18, byteOrder$6);
        }

        private final void getLongs$$anonfun$adapted$1(ByteOrder byteOrder$13, Object _$16, Object _$17, Object _$18) {
            this.getLongs$$anonfun$2(byteOrder$13, (long[])_$16, BoxesRunTime.unboxToInt((Object)_$17), BoxesRunTime.unboxToInt((Object)_$18));
        }

        private final float getFloats$$anonfun$1(ByteOrder byteOrder$7) {
            return this.getFloat(byteOrder$7);
        }

        private final /* synthetic */ void getFloats$$anonfun$2(ByteOrder byteOrder$8, float[] _$19, int _$20, int _$21) {
            this.akka$util$ByteIterator$MultiByteArrayIterator$$current().getFloats(_$19, _$20, _$21, byteOrder$8);
        }

        private final void getFloats$$anonfun$adapted$1(ByteOrder byteOrder$14, Object _$19, Object _$20, Object _$21) {
            this.getFloats$$anonfun$2(byteOrder$14, (float[])_$19, BoxesRunTime.unboxToInt((Object)_$20), BoxesRunTime.unboxToInt((Object)_$21));
        }

        private final double getDoubles$$anonfun$1(ByteOrder byteOrder$9) {
            return this.getDouble(byteOrder$9);
        }

        private final /* synthetic */ void getDoubles$$anonfun$2(ByteOrder byteOrder$10, double[] _$22, int _$23, int _$24) {
            this.akka$util$ByteIterator$MultiByteArrayIterator$$current().getDoubles(_$22, _$23, _$24, byteOrder$10);
        }

        private final void getDoubles$$anonfun$adapted$1(ByteOrder byteOrder$15, Object _$22, Object _$23, Object _$24) {
            this.getDoubles$$anonfun$2(byteOrder$15, (double[])_$22, BoxesRunTime.unboxToInt((Object)_$23), BoxesRunTime.unboxToInt((Object)_$24));
        }

        private final /* synthetic */ int $anonfun$3(ByteBuffer buffer$1, int _$25, ByteArrayIterator _$26) {
            return _$25 + _$26.copyToBuffer(buffer$1);
        }

        private final int $anonfun$adapted$1(ByteBuffer buffer$2, Object _$25, Object _$26) {
            return this.$anonfun$3(buffer$2, BoxesRunTime.unboxToInt((Object)_$25), (ByteArrayIterator)_$26);
        }
    }
}

