/*
 * Decompiled with CFR 0.152.
 */
package akka.util;

import akka.util.ByteIterator;
import akka.util.ByteIterator$ByteArrayIterator$;
import akka.util.ByteIterator$MultiByteArrayIterator$;
import akka.util.ByteString$;
import akka.util.ByteString$ByteString1$;
import akka.util.ByteString$ByteString1C$;
import akka.util.ByteString$ByteStrings$;
import akka.util.ByteString$Companion$;
import akka.util.ByteStringBuilder;
import akka.util.CompactByteString;
import akka.util.CompactByteString$;
import dotty.runtime.Arrays$;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import scala.Array$;
import scala.Byte$;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeq;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.immutable.IndexedSeqOps;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public abstract class ByteString
implements scala.collection.immutable.IndexedSeq<Object>,
scala.collection.immutable.StrictOptimizedSeqOps<Object, scala.collection.immutable.IndexedSeq, ByteString> {
    public static String UTF_8() {
        return ByteString$.MODULE$.UTF_8();
    }

    public static ByteStringBuilder createBuilder() {
        return ByteString$.MODULE$.createBuilder();
    }

    public static ByteString emptyByteString() {
        return ByteString$.MODULE$.emptyByteString();
    }

    public static ByteString fromArray(byte[] byArray) {
        return ByteString$.MODULE$.fromArray(byArray);
    }

    public static ByteString fromArray(byte[] byArray, int n, int n2) {
        return ByteString$.MODULE$.fromArray(byArray, n, n2);
    }

    public static ByteString fromArrayUnsafe(byte[] byArray) {
        return ByteString$.MODULE$.fromArrayUnsafe(byArray);
    }

    public static ByteString fromArrayUnsafe(byte[] byArray, int n, int n2) {
        return ByteString$.MODULE$.fromArrayUnsafe(byArray, n, n2);
    }

    public static ByteString fromByteBuffer(ByteBuffer byteBuffer) {
        return ByteString$.MODULE$.fromByteBuffer(byteBuffer);
    }

    public static ByteString fromInts() {
        return ByteString$.MODULE$.fromInts();
    }

    public static ByteString fromInts(int n) {
        return ByteString$.MODULE$.fromInts(n);
    }

    public static ByteString fromInts(int n, int n2) {
        return ByteString$.MODULE$.fromInts(n, n2);
    }

    public static ByteString fromInts(int n, int n2, int n3) {
        return ByteString$.MODULE$.fromInts(n, n2, n3);
    }

    public static ByteString fromInts(int n, int n2, int n3, int n4) {
        return ByteString$.MODULE$.fromInts(n, n2, n3, n4);
    }

    public static ByteString fromInts(int n, int n2, int n3, int n4, int n5) {
        return ByteString$.MODULE$.fromInts(n, n2, n3, n4, n5);
    }

    public static ByteString fromInts(int n, int n2, int n3, int n4, int n5, scala.collection.immutable.Seq<Object> seq) {
        return ByteString$.MODULE$.fromInts(n, n2, n3, n4, n5, seq);
    }

    public static ByteString fromString(String string) {
        return ByteString$.MODULE$.fromString(string);
    }

    public static ByteString fromString(String string, Charset charset) {
        return ByteString$.MODULE$.fromString(string, charset);
    }

    public static ByteString fromString(String string, String string2) {
        return ByteString$.MODULE$.fromString(string, string2);
    }

    public static ByteStringBuilder newBuilder() {
        return ByteString$.MODULE$.newBuilder();
    }

    public ByteString() {
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        IterableOps.$init$((IterableOps)this);
        IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
        Iterable.$init$((Iterable)this);
        scala.collection.immutable.Iterable.$init$((scala.collection.immutable.Iterable)this);
        PartialFunction.$init$((PartialFunction)this);
        SeqOps.$init$((SeqOps)this);
        Seq.$init$((Seq)this);
        scala.collection.immutable.Seq.$init$((scala.collection.immutable.Seq)this);
        scala.collection.IndexedSeqOps.$init$((scala.collection.IndexedSeqOps)this);
        IndexedSeq.$init$((IndexedSeq)this);
        IndexedSeqOps.$init$((IndexedSeqOps)this);
        scala.collection.immutable.IndexedSeq.$init$((scala.collection.immutable.IndexedSeq)this);
        StrictOptimizedIterableOps.$init$((StrictOptimizedIterableOps)this);
        StrictOptimizedSeqOps.$init$((StrictOptimizedSeqOps)this);
        scala.collection.immutable.StrictOptimizedSeqOps.$init$((scala.collection.immutable.StrictOptimizedSeqOps)this);
    }

    public <B> scala.collection.immutable.IndexedSeq<B> scala$collection$SeqOps$$super$concat(IterableOnce<B> suffix) {
        return (scala.collection.immutable.IndexedSeq)IterableOps.concat$((IterableOps)this, suffix);
    }

    public int scala$collection$SeqOps$$super$sizeCompare(int otherSize) {
        return IterableOps.sizeCompare$((IterableOps)this, (int)otherSize);
    }

    public int scala$collection$SeqOps$$super$sizeCompare(Iterable<?> that) {
        return IterableOps.sizeCompare$((IterableOps)this, that);
    }

    public ByteString scala$collection$immutable$IndexedSeqOps$$super$slice(int from, int until) {
        return (ByteString)scala.collection.IndexedSeqOps.slice$((scala.collection.IndexedSeqOps)this, (int)from, (int)until);
    }

    public boolean scala$collection$immutable$IndexedSeq$$super$canEqual(Object that) {
        return Seq.canEqual$((Seq)this, (Object)that);
    }

    public <B> boolean scala$collection$immutable$IndexedSeq$$super$sameElements(IterableOnce<B> that) {
        return SeqOps.sameElements$((SeqOps)this, that);
    }

    public <B> ByteString scala$collection$immutable$StrictOptimizedSeqOps$$super$sorted(Ordering<B> ord) {
        return (ByteString)SeqOps.sorted$((SeqOps)this, ord);
    }

    public ByteString fromSpecific(IterableOnce<Object> coll) {
        return ByteString$.MODULE$.apply(coll);
    }

    public Builder<Object, ByteString> newSpecificBuilder() {
        return ByteString$.MODULE$.newBuilder();
    }

    public ByteString empty() {
        return ByteString$.MODULE$.empty();
    }

    public abstract byte apply(int var1);

    public abstract Companion byteStringCompanion();

    public final String className() {
        return "ByteString";
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public ByteIterator iterator() {
        throw new UnsupportedOperationException("Method iterator is not implemented in ByteString");
    }

    public byte head() {
        return this.apply(0);
    }

    public ByteString tail() {
        return this.drop(1);
    }

    public byte last() {
        return this.apply(this.length() - 1);
    }

    public ByteString init() {
        return this.dropRight(1);
    }

    public ByteString take(int n) {
        throw new UnsupportedOperationException("Method take is not implemented in ByteString");
    }

    public ByteString takeRight(int n) {
        return this.slice(this.length() - n, this.length());
    }

    public ByteString slice(int from, int until) {
        throw new UnsupportedOperationException("Method slice is not implemented in ByteString");
    }

    public ByteString drop(int n) {
        throw new UnsupportedOperationException("Method drop is not implemented in ByteString");
    }

    public ByteString dropRight(int n) {
        throw new UnsupportedOperationException("Method dropRight is not implemented in ByteString");
    }

    public ByteString takeWhile(Function1<Object, Object> p) {
        return ((ByteIterator)this.iterator().takeWhile((Function1)p)).toByteString();
    }

    public ByteString dropWhile(Function1<Object, Object> p) {
        return ((ByteIterator)this.iterator().dropWhile((Function1)p)).toByteString();
    }

    public Tuple2<ByteString, ByteString> span(Function1<Object, Object> p) {
        Tuple2<ByteIterator, ByteIterator> tuple2 = this.iterator().span(p);
        if (!(tuple2 instanceof Tuple2)) {
            throw new MatchError(tuple2);
        }
        Tuple2<ByteIterator, ByteIterator> tuple22 = tuple2;
        ByteIterator a = (ByteIterator)tuple22._1();
        ByteIterator b = (ByteIterator)tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)a, (Object)b);
        ByteIterator a2 = (ByteIterator)tuple23._1();
        ByteIterator b2 = (ByteIterator)tuple23._2();
        return Tuple2$.MODULE$.apply((Object)a2.toByteString(), (Object)b2.toByteString());
    }

    public Tuple2<ByteString, ByteString> splitAt(int n) {
        return Tuple2$.MODULE$.apply((Object)this.take(n), (Object)this.drop(n));
    }

    public int indexWhere(Function1<Object, Object> p, int from) {
        return this.iterator().indexWhere(p, from);
    }

    public <B> int indexOf(B elem, int from) {
        return this.indexOf(elem, from);
    }

    public Iterator<ByteString> grouped(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("size=" + size + " must be positive");
        }
        return package$.MODULE$.Iterator().iterate((Object)this, (Function1)(JFunction1 & Serializable)_$6 -> _$6.drop(size)).takeWhile((Function1)(JFunction1 & Serializable)_$7 -> _$7.nonEmpty()).map((Function1)(JFunction1 & Serializable)_$8 -> _$8.take(size));
    }

    public String toString() {
        int maxSize = 100;
        return this.size() > maxSize ? this.take(maxSize).toString() + ("... and [" + (this.size() - maxSize) + "] more") : Seq.toString$((Seq)this);
    }

    public byte[] toArray() {
        return (byte[])this.toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
    }

    /*
     * WARNING - void declaration
     */
    public final <B> Object toArray(ClassTag<B> arg0) {
        void var2_2;
        Object array = Arrays$.MODULE$.newGenericArray(this.size(), arg0);
        this.copyToArray(array, 0, this.size());
        return var2_2;
    }

    public final <B> int copyToArray(Object xs, int start) {
        Object object = Predef$.MODULE$.genericArrayOps(xs);
        return this.copyToArray(xs, start, RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.size()), ArrayOps$.MODULE$.size$extension(object)));
    }

    public <B> int copyToArray(Object xs, int start, int len) {
        throw new UnsupportedOperationException("Method copyToArray is not implemented in ByteString");
    }

    public <U> void foreach(Function1<Object, U> f) {
        this.iterator().foreach(f);
    }

    public abstract void writeToOutputStream(ObjectOutputStream var1);

    public abstract ByteString $plus$plus(ByteString var1);

    public ByteString concat(ByteString that) {
        return this.$plus$plus(that);
    }

    public abstract int copyToBuffer(ByteBuffer var1);

    public abstract CompactByteString compact();

    public abstract boolean isCompact();

    public abstract ByteBuffer asByteBuffer();

    public abstract scala.collection.immutable.Iterable<ByteBuffer> asByteBuffers();

    public java.lang.Iterable<ByteBuffer> getByteBuffers() {
        return (java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(this.asByteBuffers()).asJava();
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.toArray());
    }

    public final String utf8String() {
        return this.decodeString(StandardCharsets.UTF_8);
    }

    public abstract String decodeString(String var1);

    public abstract String decodeString(Charset var1);

    public abstract ByteString decodeBase64();

    public abstract ByteString encodeBase64();

    public final ByteString mapI(Function1<Object, Object> f) {
        return this.map(f.andThen((Function1)((JFunction1 & Serializable)ByteString::mapI$$anonfun$adapted$1)));
    }

    public <A> ByteString map(Function1<Object, Object> f) {
        return this.fromSpecific((IterableOnce)StrictOptimizedIterableOps.map$((StrictOptimizedIterableOps)this, f));
    }

    private static final /* synthetic */ byte mapI$$anonfun$1(int _$9) {
        return (byte)_$9;
    }

    private static final byte mapI$$anonfun$adapted$1(Object _$9) {
        return ByteString.mapI$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$9));
    }

    public static final class ByteString1
    extends ByteString
    implements Serializable {
        private final byte[] bytes;
        private final int startIndex;
        private final int length;

        public static byte SerializationIdentity() {
            return ByteString$ByteString1$.MODULE$.SerializationIdentity();
        }

        public static ByteString1 fromString(String string) {
            return ByteString$ByteString1$.MODULE$.fromString(string);
        }

        public static ByteString1 readFromInputStream(ObjectInputStream objectInputStream) {
            return ByteString$ByteString1$.MODULE$.readFromInputStream(objectInputStream);
        }

        public ByteString1(byte[] bytes, int startIndex, int length) {
            this.bytes = bytes;
            this.startIndex = startIndex;
            this.length = length;
        }

        private byte[] bytes() {
            return this.bytes;
        }

        private int startIndex() {
            return this.startIndex;
        }

        public int length() {
            return this.length;
        }

        @Override
        public byte apply(int idx) {
            return this.bytes()[this.checkRangeConvert(idx)];
        }

        @Override
        public ByteIterator.ByteArrayIterator iterator() {
            return ByteIterator$ByteArrayIterator$.MODULE$.apply(this.bytes(), this.startIndex(), this.startIndex() + this.length());
        }

        private int checkRangeConvert(int index) {
            if (0 > index || this.length() <= index) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)index).toString());
            }
            return index + this.startIndex();
        }

        @Override
        public void writeToOutputStream(ObjectOutputStream os) {
            os.writeInt(this.length());
            os.write(this.bytes(), this.startIndex(), this.length());
        }

        @Override
        public boolean isCompact() {
            return this.length() == this.bytes().length;
        }

        @Override
        public Companion byteStringCompanion() {
            return ByteString$ByteString1$.MODULE$;
        }

        @Override
        public ByteString dropRight(int n) {
            return this.dropRight1(n);
        }

        public ByteString1 dropRight1(int n) {
            return n <= 0 ? this : (this.length() - n <= 0 ? ByteString$ByteString1$.MODULE$.empty() : new ByteString1(this.bytes(), this.startIndex(), this.length() - n));
        }

        @Override
        public ByteString drop(int n) {
            return n <= 0 ? this : this.drop1(n);
        }

        public ByteString1 drop1(int n) {
            int nextStartIndex = this.startIndex() + n;
            return nextStartIndex >= this.bytes().length ? ByteString$ByteString1$.MODULE$.empty() : ByteString$ByteString1$.MODULE$.apply(this.bytes(), nextStartIndex, this.length() - n);
        }

        @Override
        public ByteString take(int n) {
            return n <= 0 ? ByteString$.MODULE$.empty() : this.take1(n);
        }

        public ByteString1 take1(int n) {
            return n >= this.length() ? this : ByteString$ByteString1$.MODULE$.apply(this.bytes(), this.startIndex(), n);
        }

        @Override
        public ByteString slice(int from, int until) {
            return this.drop(from).take(until - Math.max(0, from));
        }

        @Override
        public int copyToBuffer(ByteBuffer buffer) {
            return this.writeToBuffer(buffer);
        }

        /*
         * WARNING - void declaration
         */
        public int writeToBuffer(ByteBuffer buffer) {
            void var2_2;
            int copyLength = Math.min(buffer.remaining(), this.length());
            if (copyLength > 0) {
                buffer.put(this.bytes(), this.startIndex(), copyLength);
            }
            return (int)var2_2;
        }

        @Override
        public CompactByteString compact() {
            return this.isCompact() ? ByteString$ByteString1C$.MODULE$.apply(this.bytes()) : ByteString$ByteString1C$.MODULE$.apply(this.toArray());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ByteBuffer asByteBuffer() {
            void var1_1;
            ByteBuffer buffer = ByteBuffer.wrap(this.bytes(), this.startIndex(), this.length()).asReadOnlyBuffer();
            return buffer.remaining() < this.bytes().length ? buffer.slice() : var1_1;
        }

        @Override
        public scala.collection.immutable.Iterable<ByteBuffer> asByteBuffers() {
            return (scala.collection.immutable.Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ByteBuffer[]{this.asByteBuffer()}));
        }

        @Override
        public String decodeString(String charset) {
            return this.isEmpty() ? "" : new String(this.bytes(), this.startIndex(), this.length(), charset);
        }

        @Override
        public String decodeString(Charset charset) {
            return this.isEmpty() ? "" : new String(this.bytes(), this.startIndex(), this.length(), charset);
        }

        @Override
        public ByteString decodeBase64() {
            ByteBuffer dst;
            return this.isEmpty() ? this : (this.isCompact() ? ByteString$ByteString1C$.MODULE$.apply(Base64.getDecoder().decode(this.bytes())) : ((dst = Base64.getDecoder().decode(ByteBuffer.wrap(this.bytes(), this.startIndex(), this.length()))).hasArray() ? (ByteString)(dst.array().length == dst.remaining() ? ByteString$ByteString1C$.MODULE$.apply(dst.array()) : ByteString$ByteString1$.MODULE$.apply(dst.array(), dst.arrayOffset() + dst.position(), dst.remaining())) : CompactByteString$.MODULE$.apply(dst)));
        }

        @Override
        public ByteString encodeBase64() {
            ByteBuffer dst;
            return this.isEmpty() ? this : (this.isCompact() ? ByteString$ByteString1C$.MODULE$.apply(Base64.getEncoder().encode(this.bytes())) : ((dst = Base64.getEncoder().encode(ByteBuffer.wrap(this.bytes(), this.startIndex(), this.length()))).hasArray() ? (ByteString)(dst.array().length == dst.remaining() ? ByteString$ByteString1C$.MODULE$.apply(dst.array()) : ByteString$ByteString1$.MODULE$.apply(dst.array(), dst.arrayOffset() + dst.position(), dst.remaining())) : CompactByteString$.MODULE$.apply(dst)));
        }

        @Override
        public ByteString $plus$plus(ByteString that) {
            ByteString byteString;
            if (that.isEmpty()) {
                byteString = this;
            } else if (this.isEmpty()) {
                byteString = that;
            } else {
                ByteString byteString2 = that;
                if (byteString2 instanceof ByteString1C) {
                    ByteString1C b = (ByteString1C)byteString2;
                    byteString = ByteString$ByteStrings$.MODULE$.apply(this, b.toByteString1());
                } else if (byteString2 instanceof ByteString1) {
                    ByteString1 b = (ByteString1)byteString2;
                    byteString = this.bytes() == b.bytes() && this.startIndex() + this.length() == b.startIndex() ? new ByteString1(this.bytes(), this.startIndex(), this.length() + b.length()) : ByteString$ByteStrings$.MODULE$.apply(this, b);
                } else if (byteString2 instanceof ByteStrings) {
                    ByteStrings bs = (ByteStrings)byteString2;
                    byteString = ByteString$ByteStrings$.MODULE$.apply(this, bs);
                } else {
                    throw new MatchError((Object)byteString2);
                }
            }
            return byteString;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <B> int indexOf(B elem, int from) {
            int n;
            if (from >= this.length()) {
                n = -1;
            } else {
                void var3_3;
                int found = -1;
                for (int i = scala.math.package$.MODULE$.max(from, 0); i < this.length() && found == -1; ++i) {
                    if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToByte((byte)this.bytes()[this.startIndex() + i]), elem)) continue;
                    found = i;
                }
                n = var3_3;
            }
            return n;
        }

        @Override
        public <B> int copyToArray(Object dest, int start, int len) {
            int toCopy = scala.math.package$.MODULE$.min(scala.math.package$.MODULE$.min(len, this.length()), ScalaRunTime$.MODULE$.array_length(dest) - start);
            if (toCopy > 0) {
                Array$.MODULE$.copy((Object)this.bytes(), this.startIndex(), dest, start, toCopy);
            }
            return toCopy;
        }

        public Object writeReplace() {
            return new SerializationProxy(this);
        }
    }

    public static final class ByteString1C
    extends CompactByteString {
        private static final long serialVersionUID = 3956956327691936932L;
        private final byte[] bytes;

        public static byte SerializationIdentity() {
            return ByteString$ByteString1C$.MODULE$.SerializationIdentity();
        }

        public static ByteString1C fromString(String string) {
            return ByteString$ByteString1C$.MODULE$.fromString(string);
        }

        public static ByteString1C readFromInputStream(ObjectInputStream objectInputStream) {
            return ByteString$ByteString1C$.MODULE$.readFromInputStream(objectInputStream);
        }

        public ByteString1C(byte[] bytes) {
            this.bytes = bytes;
        }

        private byte[] bytes() {
            return this.bytes;
        }

        @Override
        public byte apply(int idx) {
            return this.bytes()[idx];
        }

        public int length() {
            return this.bytes().length;
        }

        @Override
        public ByteIterator.ByteArrayIterator iterator() {
            return ByteIterator$ByteArrayIterator$.MODULE$.apply(this.bytes(), 0, this.bytes().length);
        }

        public ByteString1 toByteString1() {
            return ByteString$ByteString1$.MODULE$.apply(this.bytes(), 0, this.bytes().length);
        }

        @Override
        public Companion byteStringCompanion() {
            return ByteString$ByteString1C$.MODULE$;
        }

        @Override
        public ByteBuffer asByteBuffer() {
            return this.toByteString1().asByteBuffer();
        }

        @Override
        public scala.collection.immutable.Iterable<ByteBuffer> asByteBuffers() {
            return (scala.collection.immutable.Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ByteBuffer[]{this.asByteBuffer()}));
        }

        @Override
        public String decodeString(String charset) {
            return this.isEmpty() ? "" : new String(this.bytes(), charset);
        }

        @Override
        public String decodeString(Charset charset) {
            return this.isEmpty() ? "" : new String(this.bytes(), charset);
        }

        @Override
        public ByteString decodeBase64() {
            return this.isEmpty() ? this : ByteString$ByteString1C$.MODULE$.apply(Base64.getDecoder().decode(this.bytes()));
        }

        @Override
        public ByteString encodeBase64() {
            return this.isEmpty() ? this : ByteString$ByteString1C$.MODULE$.apply(Base64.getEncoder().encode(this.bytes()));
        }

        @Override
        public ByteString $plus$plus(ByteString that) {
            return that.isEmpty() ? this : (this.isEmpty() ? that : this.toByteString1().$plus$plus(that));
        }

        @Override
        public ByteString take(int n) {
            return n <= 0 ? ByteString$.MODULE$.empty() : (n >= this.length() ? this : this.toByteString1().take(n));
        }

        @Override
        public ByteString dropRight(int n) {
            return n <= 0 ? this : this.toByteString1().dropRight(n);
        }

        @Override
        public ByteString drop(int n) {
            return n <= 0 ? this : this.toByteString1().drop(n);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <B> int indexOf(B elem, int from) {
            int n;
            if (from >= this.length()) {
                n = -1;
            } else {
                void var3_3;
                int found = -1;
                for (int i = scala.math.package$.MODULE$.max(from, 0); i < this.length() && found == -1; ++i) {
                    if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToByte((byte)this.bytes()[i]), elem)) continue;
                    found = i;
                }
                n = var3_3;
            }
            return n;
        }

        @Override
        public ByteString slice(int from, int until) {
            return from <= 0 && until >= this.length() ? this : (from >= this.length() || until <= 0 || from >= until ? ByteString$.MODULE$.empty() : this.toByteString1().slice(from, until));
        }

        @Override
        public void writeToOutputStream(ObjectOutputStream os) {
            this.toByteString1().writeToOutputStream(os);
        }

        @Override
        public int copyToBuffer(ByteBuffer buffer) {
            return this.writeToBuffer(buffer, 0);
        }

        /*
         * WARNING - void declaration
         */
        public int writeToBuffer(ByteBuffer buffer, int offset) {
            void var3_3;
            int copyLength = Math.min(buffer.remaining(), offset + this.length());
            if (copyLength > 0) {
                buffer.put(this.bytes(), offset, copyLength);
            }
            return (int)var3_3;
        }

        public ByteStringBuilder appendToBuilder(ByteStringBuilder buffer) {
            return buffer.putByteArrayUnsafe(this.bytes());
        }

        @Override
        public <B> int copyToArray(Object dest, int start, int len) {
            int toCopy = scala.math.package$.MODULE$.min(scala.math.package$.MODULE$.min(len, this.bytes().length), ScalaRunTime$.MODULE$.array_length(dest) - start);
            if (toCopy > 0) {
                Array$.MODULE$.copy((Object)this.bytes(), 0, dest, start, toCopy);
            }
            return toCopy;
        }
    }

    public static final class ByteStrings
    extends ByteString
    implements Serializable {
        private final Vector bytestrings;
        private final int length;

        public static byte SerializationIdentity() {
            return ByteString$ByteStrings$.MODULE$.SerializationIdentity();
        }

        public static int compare(ByteString byteString, ByteString byteString2) {
            return ByteString$ByteStrings$.MODULE$.compare(byteString, byteString2);
        }

        public static ByteStrings readFromInputStream(ObjectInputStream objectInputStream) {
            return ByteString$ByteStrings$.MODULE$.readFromInputStream(objectInputStream);
        }

        public ByteStrings(Vector<ByteString1> bytestrings, int length) {
            this.bytestrings = bytestrings;
            this.length = length;
            if (bytestrings.isEmpty()) {
                throw new IllegalArgumentException("bytestrings must not be empty");
            }
            if (((ByteString)bytestrings.head()).isEmpty()) {
                throw new IllegalArgumentException("bytestrings.head must not be empty");
            }
        }

        public Vector<ByteString1> bytestrings() {
            return this.bytestrings;
        }

        public int length() {
            return this.length;
        }

        @Override
        public byte apply(int idx) {
            int seen;
            int pos;
            if (0 <= idx && idx < this.length()) {
                pos = 0;
                seen = 0;
                while (idx >= seen + ((ByteString1)this.bytestrings().apply(pos)).length()) {
                    seen += ((ByteString1)this.bytestrings().apply(pos)).length();
                    ++pos;
                }
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)idx).toString());
            }
            return ((ByteString1)this.bytestrings().apply(pos)).apply(idx - seen);
        }

        @Override
        public ByteIterator.MultiByteArrayIterator iterator() {
            return ByteIterator$MultiByteArrayIterator$.MODULE$.apply((LinearSeq<ByteIterator.ByteArrayIterator>)((LazyList)this.bytestrings().to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.LazyList()))).map((Function1)(JFunction1 & Serializable)_$3 -> _$3.iterator()));
        }

        @Override
        public ByteString $plus$plus(ByteString that) {
            ByteString byteString;
            if (that.isEmpty()) {
                byteString = this;
            } else if (this.isEmpty()) {
                byteString = that;
            } else {
                ByteString byteString2 = that;
                if (byteString2 instanceof ByteString1C) {
                    ByteString1C b = (ByteString1C)byteString2;
                    byteString = ByteString$ByteStrings$.MODULE$.apply(this, b.toByteString1());
                } else if (byteString2 instanceof ByteString1) {
                    ByteString1 b = (ByteString1)byteString2;
                    byteString = ByteString$ByteStrings$.MODULE$.apply(this, b);
                } else if (byteString2 instanceof ByteStrings) {
                    ByteStrings bs = (ByteStrings)byteString2;
                    byteString = ByteString$ByteStrings$.MODULE$.apply(this, bs);
                } else {
                    throw new MatchError((Object)byteString2);
                }
            }
            return byteString;
        }

        @Override
        public Companion byteStringCompanion() {
            return ByteString$ByteStrings$.MODULE$;
        }

        @Override
        public boolean isCompact() {
            return this.bytestrings().length() == 1 ? ((ByteString1)this.bytestrings().head()).isCompact() : false;
        }

        @Override
        public int copyToBuffer(ByteBuffer buffer) {
            return this.copyItToTheBuffer$1(buffer, 0, 0);
        }

        @Override
        public CompactByteString compact() {
            CompactByteString compactByteString;
            if (this.isCompact()) {
                compactByteString = ((ByteString1)this.bytestrings().head()).compact();
            } else {
                byte[] ar = new byte[this.length()];
                IntRef pos = IntRef.create((int)0);
                this.bytestrings().foreach((Function1)(JProcedure1 & Serializable)b -> {
                    int n;
                    b.copyToArray(ar, pos$1.elem, b.length());
                    pos$1.elem = n = pos$1.elem + b.length();
                });
                compactByteString = ByteString$ByteString1C$.MODULE$.apply(ar);
            }
            return compactByteString;
        }

        @Override
        public ByteBuffer asByteBuffer() {
            return this.compact().asByteBuffer();
        }

        @Override
        public scala.collection.immutable.Iterable<ByteBuffer> asByteBuffers() {
            return (scala.collection.immutable.Iterable)this.bytestrings().map((Function1)(JFunction1 & Serializable)_$4 -> _$4.asByteBuffer());
        }

        @Override
        public String decodeString(String charset) {
            return this.compact().decodeString(charset);
        }

        @Override
        public String decodeString(Charset charset) {
            return this.compact().decodeString(charset);
        }

        @Override
        public ByteString decodeBase64() {
            return this.compact().decodeBase64();
        }

        @Override
        public ByteString encodeBase64() {
            return this.compact().encodeBase64();
        }

        @Override
        public void writeToOutputStream(ObjectOutputStream os) {
            os.writeInt(this.bytestrings().length());
            this.bytestrings().foreach((Function1)(JProcedure1 & Serializable)_$5 -> _$5.writeToOutputStream(os));
        }

        @Override
        public ByteString take(int n) {
            return n <= 0 ? ByteString$.MODULE$.empty() : (n >= this.length() ? this : this.take0(n));
        }

        public ByteString take0(int n) {
            Tuple2 tuple2 = this.go$1(0, n);
            if (!(tuple2 instanceof Tuple2)) {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 tuple22 = tuple2;
            int last = BoxesRunTime.unboxToInt((Object)tuple22._1());
            int restToTake = BoxesRunTime.unboxToInt((Object)tuple22._2());
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)last), (Object)BoxesRunTime.boxToInteger((int)restToTake));
            int last2 = BoxesRunTime.unboxToInt((Object)tuple23._1());
            int restToTake2 = BoxesRunTime.unboxToInt((Object)tuple23._2());
            return last2 == 0 ? ((ByteString1)this.bytestrings().apply(last2)).take(restToTake2) : (restToTake2 == 0 ? new ByteStrings((Vector<ByteString1>)this.bytestrings().take(last2), n) : new ByteStrings((Vector<ByteString1>)((Vector)this.bytestrings().take(last2).$colon$plus((Object)((ByteString1)this.bytestrings().apply(last2)).take1(restToTake2))), n));
        }

        @Override
        public ByteString dropRight(int n) {
            return 0 < n && n < this.length() ? this.dropRight0(n) : (n >= this.length() ? ByteString$.MODULE$.empty() : this);
        }

        private ByteString dropRight0(int n) {
            int byteStringsSize = this.bytestrings().length();
            return this.dropRightWithFullDropsAndRemainig$1(n, byteStringsSize, 0, n);
        }

        @Override
        public ByteString slice(int from, int until) {
            return from <= 0 && until >= this.length() ? this : (from > this.length() || until <= from ? ByteString$.MODULE$.empty() : this.drop(from).dropRight(this.length() - until));
        }

        @Override
        public ByteString drop(int n) {
            return n <= 0 ? this : (n >= this.length() ? ByteString$.MODULE$.empty() : this.drop0(n));
        }

        private ByteString drop0(int n) {
            ByteString byteString;
            Tuple2 tuple2 = this.findSplit$1(0, n);
            if (!(tuple2 instanceof Tuple2)) {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 tuple22 = tuple2;
            int fullDrops = BoxesRunTime.unboxToInt((Object)tuple22._1());
            int remainingToDrop = BoxesRunTime.unboxToInt((Object)tuple22._2());
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)fullDrops), (Object)BoxesRunTime.boxToInteger((int)remainingToDrop));
            int fullDrops2 = BoxesRunTime.unboxToInt((Object)tuple23._1());
            int remainingToDrop2 = BoxesRunTime.unboxToInt((Object)tuple23._2());
            if (remainingToDrop2 == 0) {
                byteString = new ByteStrings((Vector<ByteString1>)this.bytestrings().drop(fullDrops2), this.length() - n);
            } else if (fullDrops2 == this.bytestrings().length() - 1) {
                byteString = ((ByteString1)this.bytestrings().apply(fullDrops2)).drop(remainingToDrop2);
            } else {
                ByteString1 byteString1 = ((ByteString1)this.bytestrings().apply(fullDrops2)).drop1(remainingToDrop2);
                ByteStrings byteStrings = new ByteStrings((Vector<ByteString1>)((Vector)this.bytestrings().drop(fullDrops2 + 1).$plus$colon((Object)byteString1)), this.length() - n);
                byteString = byteStrings;
            }
            return byteString;
        }

        @Override
        public <B> int indexOf(B elem, int from) {
            int n;
            if (from >= this.length()) {
                n = -1;
            } else {
                int byteStringsSize = this.bytestrings().size();
                n = this.find$1(elem, byteStringsSize, 0, scala.math.package$.MODULE$.max(from, 0), 0);
            }
            return n;
        }

        @Override
        public <B> int copyToArray(Object dest, int start, int len) {
            int n;
            if (this.bytestrings().size() == 1) {
                n = ((ByteString1)this.bytestrings().head()).copyToArray(dest, start, len);
            } else {
                int totalToCopy = scala.math.package$.MODULE$.min(scala.math.package$.MODULE$.min(len, this.length()), ScalaRunTime$.MODULE$.array_length(dest) - start);
                if (totalToCopy > 0) {
                    ByteString1 current;
                    Iterator bsIterator = this.bytestrings().iterator();
                    for (int copied = 0; copied < totalToCopy; copied += current.copyToArray(dest, start + copied, totalToCopy - copied)) {
                        current = (ByteString1)bsIterator.next();
                    }
                }
                n = totalToCopy;
            }
            return n;
        }

        public Object writeReplace() {
            return new SerializationProxy(this);
        }

        private final int copyItToTheBuffer$1(ByteBuffer buffer, int i, int written) {
            int n = written;
            int n2 = i;
            while (n2 < this.bytestrings().length()) {
                int n3 = n2 + 1;
                int n4 = n + ((ByteString1)this.bytestrings().apply(n2)).writeToBuffer(buffer);
                n2 = n3;
                n = n4;
            }
            return n;
        }

        private final Tuple2 go$1(int last, int restToTake) {
            ByteString1 bs;
            int n = restToTake;
            int n2 = last;
            while ((bs = (ByteString1)this.bytestrings().apply(n2)).length() <= n) {
                int n3 = n2 + 1;
                int n4 = n - bs.length();
                n2 = n3;
                n = n4;
            }
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)n2), (Object)BoxesRunTime.boxToInteger((int)n));
        }

        private final ByteString dropRightWithFullDropsAndRemainig$1(int n$1, int byteStringsSize$1, int fullDrops, int remainingToDrop) {
            ByteString byteString;
            int n = remainingToDrop;
            int n2 = fullDrops;
            while (true) {
                ByteString1 bs;
                if ((bs = (ByteString1)this.bytestrings().apply(byteStringsSize$1 - n2 - 1)).length() > n) {
                    if (n2 == byteStringsSize$1 - 1) {
                        byteString = ((ByteString1)this.bytestrings().apply(0)).dropRight(n);
                        break;
                    }
                    if (n == 0) {
                        byteString = new ByteStrings((Vector<ByteString1>)this.bytestrings().dropRight(n2), this.length() - n$1);
                        break;
                    }
                    byteString = new ByteStrings((Vector<ByteString1>)((Vector)this.bytestrings().dropRight(n2 + 1).$colon$plus((Object)((ByteString1)this.bytestrings().apply(byteStringsSize$1 - n2 - 1)).dropRight1(n))), this.length() - n$1);
                    break;
                }
                int n3 = n2 + 1;
                int n4 = n - bs.length();
                n2 = n3;
                n = n4;
            }
            return byteString;
        }

        private final Tuple2 findSplit$1(int fullDrops, int remainingToDrop) {
            ByteString1 bs;
            int n = remainingToDrop;
            int n2 = fullDrops;
            while ((bs = (ByteString1)this.bytestrings().apply(n2)).length() <= n) {
                int n3 = n2 + 1;
                int n4 = n - bs.length();
                n2 = n3;
                n = n4;
            }
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)n2), (Object)BoxesRunTime.boxToInteger((int)n));
        }

        private final int find$1(Object elem$2, int byteStringsSize$2, int bsIdx, int relativeIndex, int bytesPassed) {
            int n;
            block3: {
                int subIndexOf;
                int n2 = bytesPassed;
                int n3 = relativeIndex;
                int n4 = bsIdx;
                while (true) {
                    int nextString;
                    if (n4 >= byteStringsSize$2) {
                        n = -1;
                        break block3;
                    }
                    ByteString1 bs = (ByteString1)this.bytestrings().apply(n4);
                    if (bs.length() <= n3) {
                        int n5 = n4 + 1;
                        int n6 = n3 - bs.length();
                        int n7 = n2 + bs.length();
                        n4 = n5;
                        n3 = n6;
                        n2 = n7;
                        continue;
                    }
                    subIndexOf = bs.indexOf(elem$2, n3);
                    if (subIndexOf >= 0) break;
                    int n8 = nextString = n4 + 1;
                    int n9 = n3 - bs.length();
                    int n10 = n2 + bs.length();
                    n4 = n8;
                    n3 = n9;
                    n2 = n10;
                }
                n = subIndexOf + n2;
            }
            return n;
        }
    }

    public static interface Companion {
        public byte SerializationIdentity();

        public ByteString readFromInputStream(ObjectInputStream var1);
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private ByteString orig;

        public SerializationProxy(ByteString orig) {
            this.orig = orig;
        }

        private ByteString orig() {
            return this.orig;
        }

        private void orig_$eq(ByteString x$0) {
            this.orig = x$0;
        }

        private void writeObject(ObjectOutputStream out) {
            out.writeByte(Byte$.MODULE$.byte2int(this.orig().byteStringCompanion().SerializationIdentity()));
            this.orig().writeToOutputStream(out);
        }

        private void readObject(ObjectInputStream in) {
            byte serializationId = in.readByte();
            this.orig_$eq(ByteString$Companion$.MODULE$.apply(serializationId).readFromInputStream(in));
        }

        private Object readResolve() {
            return this.orig();
        }
    }
}

