/*
 * Decompiled with CFR 0.152.
 */
package akka.util;

import akka.annotation.InternalApi;
import akka.util.ImmutableIntMap$;
import dotty.runtime.function.JFunction1;
import java.io.Serializable;
import java.util.Arrays;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterator;
import scala.package$;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class ImmutableIntMap {
    private final int[] kvs;
    private final int size;

    public static ImmutableIntMap empty() {
        return ImmutableIntMap$.MODULE$.empty();
    }

    public ImmutableIntMap(int[] kvs, int size) {
        this.kvs = kvs;
        this.size = size;
    }

    private final int[] kvs() {
        return this.kvs;
    }

    public final int size() {
        return this.size;
    }

    private ImmutableIntMap(int key, int value) {
        this(new int[2], 1);
        this.kvs()[0] = key;
        this.kvs()[1] = value;
    }

    private final int indexForKey(int key) {
        return this.find$1(key, 0, this.size() - 1);
    }

    public final int get(int key) {
        return this.find$2(key, 0, this.size() - 1);
    }

    public final boolean contains(int key) {
        return this.indexForKey(key) >= 0;
    }

    public final ImmutableIntMap updateIfAbsent(int key, Function0 value) {
        int i;
        return this.size() > 0 ? ((i = this.indexForKey(key)) >= 0 ? this : this.insert(key, BoxesRunTime.unboxToInt((Object)value.apply()), i)) : new ImmutableIntMap(key, BoxesRunTime.unboxToInt((Object)value.apply()));
    }

    public final ImmutableIntMap updated(int key, int value) {
        ImmutableIntMap immutableIntMap;
        if (this.size() > 0) {
            int i = this.indexForKey(key);
            if (i >= 0) {
                int valueIndex = i + 1;
                immutableIntMap = this.kvs()[valueIndex] != value ? this.update(value, valueIndex) : this;
            } else {
                immutableIntMap = this.insert(key, value, i);
            }
        } else {
            immutableIntMap = new ImmutableIntMap(key, value);
        }
        return immutableIntMap;
    }

    private final ImmutableIntMap update(int value, int valueIndex) {
        int[] newKvs = (int[])this.kvs().clone();
        newKvs[valueIndex] = value;
        return new ImmutableIntMap(newKvs, this.size());
    }

    private final ImmutableIntMap insert(int key, int value, int index) {
        int at = ~index;
        int[] newKvs = new int[this.kvs().length + 2];
        System.arraycopy(this.kvs(), 0, newKvs, 0, at);
        newKvs[at] = key;
        newKvs[at + 1] = value;
        System.arraycopy(this.kvs(), at, newKvs, at + 2, this.kvs().length - at);
        return new ImmutableIntMap(newKvs, this.size() + 1);
    }

    public final ImmutableIntMap remove(int key) {
        ImmutableIntMap immutableIntMap;
        int i = this.indexForKey(key);
        if (i >= 0) {
            if (this.size() > 1) {
                int newSz = this.kvs().length - 2;
                int[] newKvs = new int[newSz];
                System.arraycopy(this.kvs(), 0, newKvs, 0, i);
                System.arraycopy(this.kvs(), i + 2, newKvs, i, newSz - i);
                immutableIntMap = new ImmutableIntMap(newKvs, this.size() - 1);
            } else {
                immutableIntMap = ImmutableIntMap$.MODULE$.empty();
            }
        } else {
            immutableIntMap = this;
        }
        return immutableIntMap;
    }

    public final Iterator<Object> keysIterator() {
        return this.size() < 1 ? package$.MODULE$.Iterator().empty() : package$.MODULE$.Iterator().range(0, this.kvs().length - 1, 2).map((Function1)(JFunction1.mcII.sp & Serializable)i -> this.kvs()[i]);
    }

    public final String toString() {
        return this.size() < 1 ? "ImmutableIntMap()" : package$.MODULE$.Iterator().range(0, this.kvs().length - 1, 2).map((Function1)((JFunction1 & Serializable)this::toString$$anonfun$adapted$1)).mkString("ImmutableIntMap(", ", ", ")");
    }

    public final int hashCode() {
        return Arrays.hashCode(this.kvs());
    }

    public final boolean equals(Object obj) {
        boolean bl;
        Object object = obj;
        if (object instanceof ImmutableIntMap) {
            ImmutableIntMap other = (ImmutableIntMap)object;
            bl = Arrays.equals(this.kvs(), other.kvs());
        } else {
            bl = false;
        }
        return bl;
    }

    private final int find$1(int key$1, int lo, int hi) {
        int n;
        block3: {
            int n2 = hi;
            int n3 = lo;
            while (n3 <= n2) {
                int lohi = n3 + n2;
                int idx = lohi & 0xFFFFFFFE;
                int k = this.kvs()[idx];
                if (k == key$1) {
                    n = idx;
                    break block3;
                }
                if (k < key$1) {
                    n3 = (lohi >>> 1) + 1;
                    continue;
                }
                n2 = (lohi >>> 1) - 1;
            }
            n = ~(n3 << 1);
        }
        return n;
    }

    private final int find$2(int key$2, int lo, int hi) {
        int n;
        block3: {
            int n2 = hi;
            int n3 = lo;
            while (n3 <= n2) {
                int lohi = n3 + n2;
                int k = this.kvs()[lohi & 0xFFFFFFFE];
                if (k == key$2) {
                    n = this.kvs()[lohi | 1];
                    break block3;
                }
                if (k < key$2) {
                    n3 = (lohi >>> 1) + 1;
                    continue;
                }
                n2 = (lohi >>> 1) - 1;
            }
            n = Integer.MIN_VALUE;
        }
        return n;
    }

    private final /* synthetic */ String toString$$anonfun$1(int i) {
        return "" + this.kvs()[i] + " -> " + this.kvs()[i + 1];
    }

    private final String toString$$anonfun$adapted$1(Object i) {
        return this.toString$$anonfun$1(BoxesRunTime.unboxToInt((Object)i));
    }
}

