/*
 * Decompiled with CFR 0.152.
 */
package akka.util;

import akka.util.ccompat.package$JavaConverters$;
import dotty.runtime.function.JProcedure1;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public class Index<K, V> {
    private final int mapSize;
    private final Comparator valueComparator;
    private final ConcurrentHashMap<K, ConcurrentSkipListSet<V>> container;
    private final ConcurrentSkipListSet<V> emptySet;

    public <K, V> Index(int mapSize, Comparator<V> valueComparator) {
        this.mapSize = mapSize;
        this.valueComparator = valueComparator;
        this.container = new ConcurrentHashMap(mapSize);
        this.emptySet = new ConcurrentSkipListSet();
    }

    public int mapSize() {
        return this.mapSize;
    }

    public Comparator<V> valueComparator() {
        return this.valueComparator;
    }

    public <K, V> Index(int mapSize, Function2<V, V, Object> cmp) {
        this(mapSize, Index.Index$superArg$1(mapSize, cmp));
    }

    public boolean put(K key, V value) {
        return this.spinPut$1(key, value);
    }

    public Option<V> findValue(K key, Function1<V, Object> f) {
        None$ none$;
        ConcurrentSkipListSet<V> concurrentSkipListSet = this.container.get(key);
        if (concurrentSkipListSet == null) {
            none$ = None$.MODULE$;
        } else {
            ConcurrentSkipListSet<V> set = concurrentSkipListSet;
            none$ = package$JavaConverters$.MODULE$.IteratorHasAsScala(set.iterator()).asScala().find(f);
        }
        return none$;
    }

    public Iterator<V> valueIterator(K key) {
        Iterator iterator;
        ConcurrentSkipListSet<V> concurrentSkipListSet = this.container.get(key);
        if (concurrentSkipListSet == null) {
            iterator = package$.MODULE$.Iterator().empty();
        } else {
            ConcurrentSkipListSet<V> some = concurrentSkipListSet;
            iterator = package$JavaConverters$.MODULE$.IteratorHasAsScala(some.iterator()).asScala();
        }
        return iterator;
    }

    public void foreach(Function2<K, V, BoxedUnit> fun) {
        package$JavaConverters$.MODULE$.IteratorHasAsScala(this.container.entrySet().iterator()).asScala().foreach((Function1)(JProcedure1 & Serializable)e -> package$JavaConverters$.MODULE$.IteratorHasAsScala(((ConcurrentSkipListSet)e.getValue()).iterator()).asScala().foreach((Function1)(JProcedure1 & Serializable)_$1 -> fun.apply(e.getKey(), _$1)));
    }

    public Set<V> values() {
        Builder builder = Predef$.MODULE$.Set().newBuilder();
        package$JavaConverters$.MODULE$.IteratorHasAsScala(this.container.values().iterator()).asScala().foreach((Function1)(JProcedure1 & Serializable)values -> package$JavaConverters$.MODULE$.IteratorHasAsScala(values.iterator()).asScala().foreach((Function1 & Serializable)v -> (Builder)builder.$plus$eq(v)));
        return (Set)builder.result();
    }

    public Iterable<K> keys() {
        return package$JavaConverters$.MODULE$.SetHasAsScala(this.container.keySet()).asScala();
    }

    public boolean remove(K key, V value) {
        boolean bl;
        ConcurrentSkipListSet<V> set = this.container.get(key);
        if (set != null) {
            ConcurrentSkipListSet<V> concurrentSkipListSet = set;
            synchronized (concurrentSkipListSet) {
                boolean bl2;
                if (set.remove(value)) {
                    if (set.isEmpty()) {
                        this.container.remove(key, this.emptySet);
                    }
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                boolean bl3 = bl2;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 7] lbl14 : MonitorExitStatement: MONITOREXIT : var4_4
                bl = bl3;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public Option<Iterable<V>> remove(K key) {
        None$ none$;
        ConcurrentSkipListSet<V> set = this.container.get(key);
        if (set != null) {
            ConcurrentSkipListSet<V> concurrentSkipListSet = set;
            synchronized (concurrentSkipListSet) {
                this.container.remove(key, set);
                Iterable ret = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)set.clone()).asScala();
                set.clear();
                Some some = Some$.MODULE$.apply((Object)ret);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                none$ = some;
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void removeValue(V value) {
        for (Map.Entry<K, ConcurrentSkipListSet<V>> e : this.container.entrySet()) {
            ConcurrentSkipListSet<V> set = e.getValue();
            if (set == null) continue;
            ConcurrentSkipListSet<V> concurrentSkipListSet = set;
            synchronized (concurrentSkipListSet) {
                BoxedUnit boxedUnit;
                if (set.remove(value)) {
                    if (set.isEmpty()) {
                        this.container.remove(e.getKey(), this.emptySet);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
    }

    public boolean isEmpty() {
        return this.container.isEmpty();
    }

    public void clear() {
        for (Map.Entry<K, ConcurrentSkipListSet<V>> e : this.container.entrySet()) {
            ConcurrentSkipListSet<V> set = e.getValue();
            if (set == null) continue;
            ConcurrentSkipListSet<V> concurrentSkipListSet = set;
            synchronized (concurrentSkipListSet) {
                set.clear();
                this.container.remove(e.getKey(), this.emptySet);
            }
        }
    }

    private static <K, V> Comparator<V> Index$superArg$1(int mapSize, Function2<V, V, Object> cmp) {
        return (a, b) -> BoxesRunTime.unboxToInt((Object)cmp.apply(a, b));
    }

    private final boolean spinPut$1(Object k, Object v) {
        boolean added;
        boolean retry;
        do {
            retry = false;
            added = false;
            ConcurrentSkipListSet<V> set = this.container.get(k);
            if (set != null) {
                ConcurrentSkipListSet<V> concurrentSkipListSet = set;
                synchronized (concurrentSkipListSet) {
                    BoxedUnit boxedUnit;
                    if (set.isEmpty()) {
                        retry = true;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        added = set.add(v);
                        retry = false;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            } else {
                ConcurrentSkipListSet<V> newSet = new ConcurrentSkipListSet<V>(this.valueComparator());
                newSet.add(v);
                ConcurrentSkipListSet<V> oldSet = this.container.putIfAbsent(k, newSet);
                if (oldSet != null) {
                    ConcurrentSkipListSet<V> concurrentSkipListSet = oldSet;
                    synchronized (concurrentSkipListSet) {
                        BoxedUnit boxedUnit;
                        if (oldSet.isEmpty()) {
                            retry = true;
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            added = oldSet.add(v);
                            retry = false;
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                } else {
                    added = true;
                }
            }
        } while (retry);
        return added;
    }
}

