/*
 * Decompiled with CFR 0.152.
 */
package akka.util;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.util.HashCode$;
import akka.util.ManifestInfo$;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ManifestInfo
implements Extension {
    private final ExtendedActorSystem system;
    private final Map versions;

    public static Extension apply(ActorSystem actorSystem) {
        return ManifestInfo$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return ManifestInfo$.MODULE$.apply(classicActorSystemProvider);
    }

    public static ManifestInfo createExtension(ExtendedActorSystem extendedActorSystem) {
        return ManifestInfo$.MODULE$.createExtension(extendedActorSystem);
    }

    public static Extension get(ActorSystem actorSystem) {
        return ManifestInfo$.MODULE$.get(actorSystem);
    }

    public static ManifestInfo get(ActorSystem actorSystem) {
        return ManifestInfo$.MODULE$.get(actorSystem);
    }

    public static Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ManifestInfo$.MODULE$.get(classicActorSystemProvider);
    }

    public static ManifestInfo get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ManifestInfo$.MODULE$.get(classicActorSystemProvider);
    }

    public static ManifestInfo$ lookup() {
        return ManifestInfo$.MODULE$.lookup();
    }

    public ManifestInfo(ExtendedActorSystem system) {
        this.system = system;
        ObjectRef manifests = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        this.liftedTree1$1(system, manifests);
        this.versions = (Map)manifests.elem;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Map<String, Version> versions() {
        return this.versions;
    }

    public boolean checkSameVersion(String productName, Seq<String> dependencies, boolean logWarning) {
        return this.checkSameVersion(productName, dependencies, logWarning, this.system().settings().FailMixedVersions());
    }

    public boolean checkSameVersion(String productName, Seq<String> dependencies, boolean logWarning, boolean throwException) {
        boolean bl;
        Option<String> option = ManifestInfo$.MODULE$.checkSameVersion(productName, dependencies, this.versions());
        if (option instanceof Some) {
            String message = (String)((Some)option).value();
            if (logWarning) {
                Logging$.MODULE$.apply(this.system(), this.getClass(), LogSource$.MODULE$.fromAnyClass()).warning(message);
            }
            if (throwException) {
                throw new IllegalStateException(message);
            }
            bl = false;
        } else if (None$.MODULE$.equals(option)) {
            bl = true;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    private final void liftedTree1$1(ExtendedActorSystem system$1, ObjectRef manifests$1) {
        try {
            Enumeration<URL> resources = system$1.dynamicAccess().classLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                try (InputStream ios = resources.nextElement().openStream();){
                    String v;
                    String vendor;
                    String v2;
                    String t;
                    Manifest manifest = new Manifest(ios);
                    Attributes attributes = manifest.getMainAttributes();
                    String string = attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$$ImplTitle));
                    String title = string == null ? attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$$BundleName)) : (t = string);
                    String string2 = attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$$ImplVersion));
                    String version = string2 == null ? attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$$BundleVersion)) : (v2 = string2);
                    String string3 = attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$$ImplVendor));
                    String string4 = vendor = string3 == null ? attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$$BundleVendor)) : (v = string3);
                    if (title == null || version == null || vendor == null || !ManifestInfo$.MODULE$.akka$util$ManifestInfo$$$knownVendors.apply((Object)vendor)) continue;
                    Map map = (Map)((Map)manifests$1.elem).updated((Object)title, (Object)new Version(version));
                    manifests$1.elem = map;
                }
            }
        }
        catch (IOException ioe) {
            Logging$.MODULE$.apply(system$1, this.getClass(), LogSource$.MODULE$.fromAnyClass()).warning("Could not read manifest information. {}", ioe);
        }
    }

    public static final class Version
    implements Comparable<Version> {
        private final String version;
        private final int[] numbers;
        private final String rest;

        public Version(String version) {
            int[] numbers;
            String string;
            block6: {
                Tuple2 tuple2;
                block5: {
                    this.version = version;
                    int[] numbers2 = new int[3];
                    String[] segments = version.split("[.-]");
                    IntRef segmentPos = IntRef.create((int)0);
                    IntRef numbersPos = IntRef.create((int)0);
                    while (numbersPos.elem < 3) {
                        int n;
                        if (segmentPos.elem < segments.length) {
                            this.liftedTree2$1(numbers2, segments, segmentPos, numbersPos);
                        }
                        numbersPos.elem = n = numbersPos.elem + 1;
                    }
                    String rest = segmentPos.elem >= segments.length ? "" : String.join((CharSequence)"-", Arrays.asList(Arrays.copyOfRange(segments, segmentPos.elem, segments.length)));
                    tuple2 = Tuple2$.MODULE$.apply((Object)numbers2, (Object)rest);
                    if (!(tuple2 instanceof Tuple2)) break block5;
                    Tuple2 tuple22 = tuple2;
                    int[] nArray = (int[])tuple22._1();
                    string = (String)tuple22._2();
                    if (!(nArray instanceof int[])) break block5;
                    numbers = nArray;
                    if (string != null) break block6;
                }
                throw new MatchError((Object)tuple2);
            }
            String rest = string;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)numbers, (Object)rest);
            this.numbers = (int[])tuple2._1();
            this.rest = (String)tuple2._2();
        }

        public String version() {
            return this.version;
        }

        private int[] numbers() {
            return this.numbers;
        }

        private String rest() {
            return this.rest;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(Version other) {
            void var2_2;
            int diff = 0;
            diff = this.numbers()[0] - other.numbers()[0];
            if (diff == 0 && (diff = this.numbers()[1] - other.numbers()[1]) == 0 && (diff = this.numbers()[2] - other.numbers()[2]) == 0) {
                diff = this.rest().compareTo(other.rest());
            }
            return (int)var2_2;
        }

        public boolean equals(Object o) {
            Version v;
            Object object = o;
            return object instanceof Version ? this.compareTo(v = (Version)object) == 0 : false;
        }

        /*
         * WARNING - void declaration
         */
        public int hashCode() {
            void var1_1;
            int result = HashCode$.MODULE$.SEED();
            result = HashCode$.MODULE$.hash(result, this.numbers()[0]);
            result = HashCode$.MODULE$.hash(result, this.numbers()[1]);
            result = HashCode$.MODULE$.hash(result, this.numbers()[2]);
            result = HashCode$.MODULE$.hash(result, this.rest());
            return (int)var1_1;
        }

        public String toString() {
            return this.version();
        }

        private final void liftedTree2$1(int[] numbers$1, String[] segments$1, IntRef segmentPos$1, IntRef numbersPos$1) {
            try {
                int n;
                numbers$1[numbersPos$1.elem] = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(segments$1[segmentPos$1.elem]));
                segmentPos$1.elem = n = segmentPos$1.elem + 1;
            }
            catch (NumberFormatException numberFormatException) {
                numbers$1[numbersPos$1.elem] = Integer.MAX_VALUE;
            }
        }
    }
}

