/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import io.minio.ResponseHeader;
import java.util.Date;

public class ObjectStat {
    private final String bucketName;
    private final String name;
    private final Date createdTime;
    private final long length;
    private final String etag;
    private final String contentType;
    private String contentKey;
    private String encryptionIv;
    private String matDesc;

    public ObjectStat(String bucketName, String name, ResponseHeader header) {
        this.bucketName = bucketName;
        this.name = name;
        this.contentType = header.contentType();
        this.createdTime = (Date)header.lastModified().clone();
        this.length = header.contentLength();
        this.etag = header.etag() != null ? header.etag().replaceAll("\"", "") : "";
        this.contentKey = header.xamzMetaKey();
        this.encryptionIv = header.xamzMetaIv();
        this.matDesc = header.xamzMetaMatdesc();
    }

    public ObjectStat(String bucketName, String name, Date createdTime, long length, String etag, String contentType) {
        this.bucketName = bucketName;
        this.name = name;
        this.contentType = contentType;
        this.createdTime = (Date)createdTime.clone();
        this.length = length;
        this.etag = etag != null ? etag.replaceAll("\"", "") : "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectStat that = (ObjectStat)o;
        if (this.length != that.length) {
            return false;
        }
        if (!this.bucketName.equals(that.bucketName)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.createdTime.equals(that.createdTime)) {
            return false;
        }
        if (!this.etag.equals(that.etag)) {
            return false;
        }
        return this.contentType.equals(that.contentType);
    }

    public int hashCode() {
        int result = this.bucketName.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.createdTime.hashCode();
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + this.etag.hashCode();
        result = 31 * result + this.contentType.hashCode();
        return result;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String name() {
        return this.name;
    }

    public Date createdTime() {
        return (Date)this.createdTime.clone();
    }

    public long length() {
        return this.length;
    }

    public String etag() {
        return this.etag;
    }

    public String contentType() {
        return this.contentType;
    }

    public String toString() {
        return "ObjectStat{bucket='" + this.bucketName + '\'' + ", name='" + this.name + '\'' + ", contentType='" + this.contentType + '\'' + ", createdTime=" + this.createdTime + ", length=" + this.length + ", etag='" + this.etag + '\'' + '}';
    }

    public String contentKey() {
        return this.contentKey;
    }

    public String encryptionIv() {
        return this.encryptionIv;
    }

    public String matDesc() {
        return this.matDesc;
    }
}

