/*
 * Decompiled with CFR 0.152.
 */
package play.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import play.api.Logger;
import play.api.Logger$;
import scala.Function0;
import scala.Serializable;
import scala.io.Codec;

public final class PlayIO$ {
    public static final PlayIO$ MODULE$;
    private final Logger logger;

    static {
        new PlayIO$();
    }

    private Logger logger() {
        return this.logger;
    }

    private byte[] readStream(InputStream stream) {
        try {
            byte[] buffer = new byte[8192];
            int len = stream.read(buffer);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while (len != -1) {
                out.write(buffer, 0, len);
                len = stream.read(buffer);
            }
            return out.toByteArray();
        }
        finally {
            this.closeQuietly(stream);
        }
    }

    public byte[] readFile(File file) {
        return this.readStream(new FileInputStream(file));
    }

    public String readStreamAsString(InputStream stream, Codec codec) {
        return new String(this.readStream(stream), codec.name());
    }

    public String readUrlAsString(URL url, Codec codec) {
        return this.readStreamAsString(url.openStream(), codec);
    }

    public String readFileAsString(File file, Codec codec) {
        return this.readStreamAsString(new FileInputStream(file), codec);
    }

    public void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            this.logger().warn((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error closing stream";
                }
            }, (Function0<Throwable>)new Serializable(iOException){
                public static final long serialVersionUID = 0L;
                private final IOException e$1;

                public final IOException apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
        }
    }

    private PlayIO$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(this.getClass());
    }
}

