/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import org.apache.commons.codec.binary.BaseNCodec;
import org.apache.commons.codec.binary.StringUtils;

public class ZBase32
extends BaseNCodec {
    private static final int BITS_PER_ENCODED_BYTE = 5;
    private static final int BYTES_PER_ENCODED_BLOCK = 8;
    private static final int BYTES_PER_UNENCODED_BLOCK = 5;
    private static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    private static final byte[] decodeTable = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 18, -1, 25, 26, 27, 30, 29, 7, 31, -1, -1, -1, -1, -1, -1, -1, 24, 1, 12, 3, 8, 5, 6, 28, 21, 9, 10, -1, 11, 2, 16, 13, 14, 4, 22, 17, 19, -1, 20, 15, 0, 23, -1, -1, -1, -1, -1, -1, 24, 1, 12, 3, 8, 5, 6, 28, 21, 9, 10, -1, 11, 2, 16, 13, 14, 4, 22, 17, 19, -1, 20, 15, 0, 23};
    private static final byte[] encodeTable = new byte[]{121, 98, 110, 100, 114, 102, 103, 56, 101, 106, 107, 109, 99, 112, 113, 120, 111, 116, 49, 117, 119, 105, 115, 122, 97, 51, 52, 53, 104, 55, 54, 57};
    private static final int MASK_5BITS = 31;
    private final int decodeSize;
    private final int encodeSize;
    private final byte[] lineSeparator;

    public ZBase32() {
        this(0, null, 61);
    }

    public ZBase32(int n) {
        this(n, CHUNK_SEPARATOR, 61);
    }

    public ZBase32(int n, byte[] byArray) {
        this(n, byArray, 61);
    }

    public ZBase32(int n, byte[] byArray, byte by) {
        super(5, 8, n, byArray == null ? 0 : byArray.length, by);
        if (n > 0) {
            if (byArray == null) {
                throw new IllegalArgumentException("lineLength " + n + " > 0, but lineSeparator is null");
            }
            if (this.containsAlphabetOrPad(byArray)) {
                String string = StringUtils.newStringUtf8((byte[])byArray);
                throw new IllegalArgumentException("lineSeparator must not contain Base32 characters: [" + string + "]");
            }
            this.encodeSize = 8 + byArray.length;
            this.lineSeparator = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.lineSeparator, 0, byArray.length);
        } else {
            this.encodeSize = 8;
            this.lineSeparator = null;
        }
        this.decodeSize = this.encodeSize - 1;
        if (this.isInAlphabet(by) || ZBase32.isWhiteSpace((byte)by)) {
            throw new IllegalArgumentException("pad must not be in alphabet or whitespace");
        }
    }

    void decode(byte[] byArray, int n, int n2, BaseNCodec.Context context) {
        if (context.eof) {
            return;
        }
        if (n2 < 0) {
            context.eof = true;
        }
        for (int i = 0; i < n2; ++i) {
            byte by;
            if ((by = byArray[n++]) == this.pad) {
                context.eof = true;
                break;
            }
            byte[] byArray2 = this.ensureBufferSize(this.decodeSize, context);
            if (by < 0) continue;
            if (by >= decodeTable.length) continue;
            byte by2 = decodeTable[by];
            if (by2 < 0) continue;
            context.modulus = (context.modulus + 1) % 8;
            context.lbitWorkArea = (context.lbitWorkArea << 5) + (long)by2;
            if (context.modulus != 0) continue;
            byArray2[context.pos++] = (byte)(context.lbitWorkArea >> 32 & 0xFFL);
            byArray2[context.pos++] = (byte)(context.lbitWorkArea >> 24 & 0xFFL);
            byArray2[context.pos++] = (byte)(context.lbitWorkArea >> 16 & 0xFFL);
            byArray2[context.pos++] = (byte)(context.lbitWorkArea >> 8 & 0xFFL);
            byArray2[context.pos++] = (byte)(context.lbitWorkArea & 0xFFL);
        }
        if (context.eof && context.modulus >= 2) {
            byte[] byArray3 = this.ensureBufferSize(this.decodeSize, context);
            switch (context.modulus) {
                case 2: {
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea >> 2 & 0xFFL);
                    break;
                }
                case 3: {
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea >> 7 & 0xFFL);
                    break;
                }
                case 4: {
                    context.lbitWorkArea >>= 4;
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea >> 8 & 0xFFL);
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea & 0xFFL);
                    break;
                }
                case 5: {
                    context.lbitWorkArea >>= 1;
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea >> 16 & 0xFFL);
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea >> 8 & 0xFFL);
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea & 0xFFL);
                    break;
                }
                case 6: {
                    context.lbitWorkArea >>= 6;
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea >> 16 & 0xFFL);
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea >> 8 & 0xFFL);
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea & 0xFFL);
                    break;
                }
                case 7: {
                    context.lbitWorkArea >>= 3;
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea >> 24 & 0xFFL);
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea >> 16 & 0xFFL);
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea >> 8 & 0xFFL);
                    byArray3[context.pos++] = (byte)(context.lbitWorkArea & 0xFFL);
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible modulus " + context.modulus);
                }
            }
        }
    }

    void encode(byte[] byArray, int n, int n2, BaseNCodec.Context context) {
        if (context.eof) {
            return;
        }
        if (n2 < 0) {
            context.eof = true;
            if (0 == context.modulus && this.lineLength == 0) {
                return;
            }
            byte[] byArray2 = this.ensureBufferSize(this.encodeSize, context);
            int n3 = context.pos;
            switch (context.modulus) {
                case 0: {
                    break;
                }
                case 1: {
                    byArray2[context.pos++] = encodeTable[(int)(context.lbitWorkArea >> 3) & 0x1F];
                    byArray2[context.pos++] = encodeTable[(int)(context.lbitWorkArea << 2) & 0x1F];
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    break;
                }
                case 2: {
                    byArray2[context.pos++] = encodeTable[(int)(context.lbitWorkArea >> 11) & 0x1F];
                    byArray2[context.pos++] = encodeTable[(int)(context.lbitWorkArea >> 6) & 0x1F];
                    byArray2[context.pos++] = encodeTable[(int)(context.lbitWorkArea >> 1) & 0x1F];
                    byArray2[context.pos++] = encodeTable[(int)(context.lbitWorkArea << 4) & 0x1F];
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    break;
                }
                case 3: {
                    byArray2[context.pos++] = encodeTable[(int)(context.lbitWorkArea >> 19) & 0x1F];
                    byArray2[context.pos++] = encodeTable[(int)(context.lbitWorkArea >> 14) & 0x1F];
                    byArray2[context.pos++] = encodeTable[(int)(context.lbitWorkArea >> 9) & 0x1F];
                    byArray2[context.pos++] = encodeTable[(int)(context.lbitWorkArea >> 4) & 0x1F];
                    byArray2[context.pos++] = encodeTable[(int)(context.lbitWorkArea << 1) & 0x1F];
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    break;
                }
                case 4: {
                    byArray2[context.pos++] = encodeTable[(int)(context.lbitWorkArea >> 27) & 0x1F];
                    byArray2[context.pos++] = encodeTable[(int)(context.lbitWorkArea >> 22) & 0x1F];
                    byArray2[context.pos++] = encodeTable[(int)(context.lbitWorkArea >> 17) & 0x1F];
                    byArray2[context.pos++] = encodeTable[(int)(context.lbitWorkArea >> 12) & 0x1F];
                    byArray2[context.pos++] = encodeTable[(int)(context.lbitWorkArea >> 7) & 0x1F];
                    byArray2[context.pos++] = encodeTable[(int)(context.lbitWorkArea >> 2) & 0x1F];
                    byArray2[context.pos++] = encodeTable[(int)(context.lbitWorkArea << 3) & 0x1F];
                    byArray2[context.pos++] = this.pad;
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible modulus " + context.modulus);
                }
            }
            context.currentLinePos += context.pos - n3;
            if (this.lineLength > 0 && context.currentLinePos > 0) {
                System.arraycopy(this.lineSeparator, 0, byArray2, context.pos, this.lineSeparator.length);
                context.pos += this.lineSeparator.length;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n4;
                byte[] byArray3 = this.ensureBufferSize(this.encodeSize, context);
                context.modulus = (context.modulus + 1) % 5;
                if ((n4 = byArray[n++]) < 0) {
                    n4 += 256;
                }
                context.lbitWorkArea = (context.lbitWorkArea << 8) + (long)n4;
                if (0 != context.modulus) continue;
                byArray3[context.pos++] = encodeTable[(int)(context.lbitWorkArea >> 35) & 0x1F];
                byArray3[context.pos++] = encodeTable[(int)(context.lbitWorkArea >> 30) & 0x1F];
                byArray3[context.pos++] = encodeTable[(int)(context.lbitWorkArea >> 25) & 0x1F];
                byArray3[context.pos++] = encodeTable[(int)(context.lbitWorkArea >> 20) & 0x1F];
                byArray3[context.pos++] = encodeTable[(int)(context.lbitWorkArea >> 15) & 0x1F];
                byArray3[context.pos++] = encodeTable[(int)(context.lbitWorkArea >> 10) & 0x1F];
                byArray3[context.pos++] = encodeTable[(int)(context.lbitWorkArea >> 5) & 0x1F];
                byArray3[context.pos++] = encodeTable[(int)context.lbitWorkArea & 0x1F];
                context.currentLinePos += 8;
                if (this.lineLength <= 0 || this.lineLength > context.currentLinePos) continue;
                System.arraycopy(this.lineSeparator, 0, byArray3, context.pos, this.lineSeparator.length);
                context.pos += this.lineSeparator.length;
                context.currentLinePos = 0;
            }
        }
    }

    public boolean isInAlphabet(byte by) {
        return by >= 0 && by < decodeTable.length && decodeTable[by] != -1;
    }
}

