/**
 *
 * satya - social authentication framework
 * Copyright (c) 2014, Sandeep Gupta
 * 
 * http://sangupta.com/projects/satya
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 		http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

package com.sangupta.satya;

import com.sangupta.jerry.oauth.domain.KeySecretPair;

/**
 * Value object to store configuration for a given {@link AuthProvider}.
 * 
 * @author sangupta
 *
 */
public class AuthProviderConfiguration {

	public final KeySecretPair keySecretPair;
	
	public final String[] scopes;
	
	public AuthProviderConfiguration(KeySecretPair keySecretPair, String... scopes) {
		this.keySecretPair = keySecretPair;
		this.scopes = scopes;
	}
	
}
