/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.satya;

import com.sangupta.jerry.exceptions.NotImplementedException;
import com.sangupta.jerry.oauth.domain.KeySecretPair;
import com.sangupta.jerry.util.AssertUtils;
import com.sangupta.satya.AuthProvider;
import com.sangupta.satya.AuthProviderConfiguration;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AuthConfig {
    private final Map<AuthProvider, AuthProviderConfiguration> config = new HashMap<AuthProvider, AuthProviderConfiguration>();

    public void addConfig(AuthProvider authProvider, KeySecretPair keySecretPair, String scope) {
        this.addConfig(authProvider, keySecretPair, new String[]{scope});
    }

    public void addConfig(AuthProvider authProvider, KeySecretPair keySecretPair, String ... scopes) {
        if (authProvider == null) {
            throw new IllegalArgumentException("AuthProvider cannot be null");
        }
        if (keySecretPair == null) {
            throw new IllegalArgumentException("KeySecretPair cannot be null");
        }
        if (scopes == null) {
            throw new IllegalArgumentException("Default scopes cannot be null/empty");
        }
        this.config.put(authProvider, new AuthProviderConfiguration(keySecretPair, scopes));
    }

    public AuthProviderConfiguration getConfig(AuthProvider provider) {
        if (provider == null) {
            return null;
        }
        return this.config.get((Object)provider);
    }

    public Set<AuthProvider> getProviders() {
        return this.config.keySet();
    }

    public void load(String filePath) {
        if (AssertUtils.isEmpty((String)filePath)) {
            throw new IllegalArgumentException("File path cannot be empty/null");
        }
        File file = new File(filePath);
        if (!file.exists()) {
            throw new IllegalArgumentException("File path cannot be empty/null");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("File does not represent a valid file");
        }
        throw new NotImplementedException();
    }
}

