/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.satya;

import com.sangupta.jerry.oauth.domain.TokenAndUrl;
import com.sangupta.jerry.util.AssertUtils;
import com.sangupta.satya.AuthConfig;
import com.sangupta.satya.AuthPermissions;
import com.sangupta.satya.AuthProvider;
import com.sangupta.satya.AuthProviderConfiguration;
import com.sangupta.satya.AuthenticatedUser;
import com.sangupta.satya.client.AuthClient;
import com.sangupta.satya.client.impl.DropBoxAuthClient;
import com.sangupta.satya.client.impl.FacebookAuthClient;
import com.sangupta.satya.client.impl.GithubAuthClient;
import com.sangupta.satya.client.impl.GoogleAuthClient;
import com.sangupta.satya.client.impl.LinkedInAuthClient;
import com.sangupta.satya.client.impl.MicrosoftLiveAuthClient;
import com.sangupta.satya.client.impl.TwitterAuthClient;
import com.sangupta.satya.client.impl.YahooAuthClient;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public final class AuthManager {
    private static final Map<AuthProvider, AuthClient> AUTH_CLIENTS = new HashMap<AuthProvider, AuthClient>();

    private AuthManager() {
    }

    public static void loadConfig(AuthConfig authConfig) {
        if (authConfig == null) {
            throw new IllegalArgumentException("AuthConfig cannot be null");
        }
        Set<AuthProvider> providers = authConfig.getProviders();
        if (AssertUtils.isEmpty(providers)) {
            throw new IllegalArgumentException("No providers are configured in AuthConfig");
        }
        block10: for (AuthProvider provider : providers) {
            AuthProviderConfiguration configuration = authConfig.getConfig(provider);
            switch (provider) {
                case Google: {
                    AUTH_CLIENTS.put(provider, new GoogleAuthClient(configuration.keySecretPair, configuration.scopes));
                    continue block10;
                }
                case Facebook: {
                    AUTH_CLIENTS.put(provider, new FacebookAuthClient(configuration.keySecretPair, configuration.scopes));
                    continue block10;
                }
                case Twitter: {
                    AUTH_CLIENTS.put(provider, new TwitterAuthClient(configuration.keySecretPair, configuration.scopes));
                    continue block10;
                }
                case Yahoo: {
                    AUTH_CLIENTS.put(provider, new YahooAuthClient(configuration.keySecretPair, configuration.scopes));
                    continue block10;
                }
                case MicrosoftLive: {
                    AUTH_CLIENTS.put(provider, new MicrosoftLiveAuthClient(configuration.keySecretPair, configuration.scopes));
                    continue block10;
                }
                case LinkedIn: {
                    AUTH_CLIENTS.put(provider, new LinkedInAuthClient(configuration.keySecretPair, configuration.scopes));
                    continue block10;
                }
                case Github: {
                    AUTH_CLIENTS.put(provider, new GithubAuthClient(configuration.keySecretPair, configuration.scopes));
                    continue block10;
                }
                case DropBox: {
                    AUTH_CLIENTS.put(provider, new DropBoxAuthClient(configuration.keySecretPair, configuration.scopes));
                    continue block10;
                }
            }
        }
    }

    public static TokenAndUrl getAuthRedirectURL(String provider, String callbackURL, AuthPermissions permissions) {
        AuthProvider authProvider = AuthProvider.fromString(provider);
        return AuthManager.getAuthRedirectURL(authProvider, callbackURL, permissions);
    }

    public static TokenAndUrl getAuthRedirectURL(AuthProvider provider, String callbackURL, AuthPermissions permissions) {
        if (provider == null) {
            throw new IllegalArgumentException("Authentication provider cannot be null");
        }
        if (permissions == null) {
            throw new IllegalArgumentException("Authentication permissions cannot be null");
        }
        if (AssertUtils.isEmpty((String)callbackURL)) {
            throw new IllegalArgumentException("Callback URL cannot be null/empty");
        }
        AuthClient client = AUTH_CLIENTS.get((Object)provider);
        if (client == null) {
            throw new IllegalArgumentException("Authentication provider not available in the system");
        }
        return client.getLoginRedirectURL(callbackURL, permissions.getScopes(provider));
    }

    public static AuthenticatedUser authenticateUser(AuthProvider authProvider, HttpServletRequest request, TokenAndUrl tokenAndUrl) {
        AuthClient client = AUTH_CLIENTS.get((Object)authProvider);
        if (client == null) {
            throw new AssertionError((Object)("No authentication client configured for the given provider: " + (Object)((Object)authProvider)));
        }
        return client.verifyUser(request, tokenAndUrl);
    }

    public static AuthenticatedUser authenticateUser(AuthProvider authProvider, String token, TokenAndUrl tokenAndUrl) {
        AuthClient client = AUTH_CLIENTS.get((Object)authProvider);
        if (client == null) {
            throw new AssertionError((Object)("No authentication client configured for the given provider: " + (Object)((Object)authProvider)));
        }
        return client.verifyUser(token, tokenAndUrl);
    }

    public static AuthClient getAuthClient(AuthProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("AuthProvider cannot be null");
        }
        return AUTH_CLIENTS.get((Object)provider);
    }

    public static void shutDown() {
        AUTH_CLIENTS.clear();
    }
}

