/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.satya;

import com.sangupta.jerry.util.StringUtils;
import com.sangupta.satya.AuthProvider;

public enum AuthPermissions {
    BASIC_PROFILE,
    PUBLISH;


    public String[] getScopes(AuthProvider provider) {
        switch (this) {
            case BASIC_PROFILE: {
                return this.basicProfileScopes(provider);
            }
            case PUBLISH: {
                return this.publishScopes(provider);
            }
        }
        return null;
    }

    private String[] basicProfileScopes(AuthProvider provider) {
        switch (provider) {
            case DropBox: {
                return StringUtils.EMPTY_STRING_LIST;
            }
            case Facebook: {
                return new String[]{"email", "basic_info"};
            }
            case Github: {
                return new String[]{""};
            }
            case Google: {
                return new String[]{"email", "profile"};
            }
            case LinkedIn: {
                return new String[]{"r_fullprofile"};
            }
            case MicrosoftLive: {
                return new String[]{"wl.basic"};
            }
            case Twitter: {
                return StringUtils.EMPTY_STRING_LIST;
            }
            case Yahoo: {
                return StringUtils.EMPTY_STRING_LIST;
            }
        }
        return StringUtils.EMPTY_STRING_LIST;
    }

    private String[] publishScopes(AuthProvider provider) {
        switch (provider) {
            case DropBox: {
                return StringUtils.EMPTY_STRING_LIST;
            }
            case Facebook: {
                return new String[]{"publish_actions"};
            }
            case Github: {
                return new String[]{"", "gist", "notifications", "write:org", "write:repo_hook", "user"};
            }
            case Google: {
                return new String[]{"email", "profile"};
            }
            case LinkedIn: {
                return new String[]{"r_fullprofile", "rw_nus", "w_messages", "rw_groups"};
            }
            case MicrosoftLive: {
                return new String[]{"wl.basic", "wl.offline_access"};
            }
            case Twitter: {
                return StringUtils.EMPTY_STRING_LIST;
            }
            case Yahoo: {
                return StringUtils.EMPTY_STRING_LIST;
            }
        }
        return StringUtils.EMPTY_STRING_LIST;
    }
}

