/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.satya.client;

import com.google.gson.FieldNamingPolicy;
import com.sangupta.jerry.http.WebInvoker;
import com.sangupta.jerry.http.WebRequest;
import com.sangupta.jerry.http.WebRequestMethod;
import com.sangupta.jerry.http.WebResponse;
import com.sangupta.jerry.oauth.domain.KeySecretPair;
import com.sangupta.jerry.oauth.domain.TokenAndUrl;
import com.sangupta.jerry.oauth.extractor.TokenExtractor;
import com.sangupta.jerry.oauth.service.OAuth1ServiceImpl;
import com.sangupta.jerry.oauth.service.OAuth2ServiceImpl;
import com.sangupta.jerry.oauth.service.OAuthService;
import com.sangupta.jerry.util.AssertUtils;
import com.sangupta.jerry.util.GsonUtils;
import com.sangupta.jerry.util.StringUtils;
import com.sangupta.satya.AuthProvider;
import com.sangupta.satya.AuthenticatedUser;
import com.sangupta.satya.client.AuthClient;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAuthClient
implements AuthClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseAuthClient.class);
    protected final OAuthService service;
    protected final String defaultScopes;

    public BaseAuthClient(OAuthService service, String scope) {
        if (service == null) {
            throw new IllegalArgumentException("OAuthService to be used cannot be null");
        }
        this.service = service;
        this.defaultScopes = scope;
    }

    public BaseAuthClient(OAuthService service, String ... scopes) {
        if (service == null) {
            throw new IllegalArgumentException("OAuthService to be used cannot be null");
        }
        this.service = service;
        this.defaultScopes = StringUtils.merge((String[])scopes, (char)this.getScopeMergingCharacter());
    }

    @Override
    public TokenAndUrl getLoginRedirectURL(String successUrl) {
        return this.service.getLoginURL(successUrl, this.defaultScopes);
    }

    @Override
    public TokenAndUrl getLoginRedirectURL(String successUrl, String scope) {
        return this.service.getLoginURL(successUrl, scope);
    }

    @Override
    public TokenAndUrl getLoginRedirectURL(String successUrl, String ... scopes) {
        return this.service.getLoginURL(successUrl, StringUtils.merge((String[])scopes, (char)this.getScopeMergingCharacter()));
    }

    protected abstract AuthProvider getAuthProvider();

    protected char getScopeMergingCharacter() {
        return ',';
    }

    @Override
    public OAuthService getOAuthService() {
        return this.service;
    }

    @Override
    public AuthenticatedUser verifyUser(HttpServletRequest request, TokenAndUrl tokenAndUrl) {
        String errorCode = request.getParameter("error");
        if (AssertUtils.isNotEmpty((String)errorCode)) {
            return null;
        }
        errorCode = request.getParameter("error_code");
        if (AssertUtils.isNotEmpty((String)errorCode)) {
            return null;
        }
        String code = request.getParameter(this.service.getVerificationCodeParamName());
        return this.verifyUser(code, tokenAndUrl);
    }

    protected abstract TokenExtractor getTokenExtractor();

    protected abstract AuthenticatedUser createNewAuthenticatedUser(Map<String, String> var1);

    @Override
    public AuthenticatedUser verifyUser(String verifier, TokenAndUrl tokenAndUrl) {
        if (this.service instanceof OAuth2ServiceImpl) {
            return this.verifyUserOAuth2(tokenAndUrl, verifier);
        }
        if (this.service instanceof OAuth1ServiceImpl) {
            return this.verifyUserOAuth1(tokenAndUrl, verifier);
        }
        throw new IllegalStateException("Don't know how to handle the verification of user");
    }

    protected AuthenticatedUser verifyUserOAuth1(TokenAndUrl tokenAndUrl, String verifier) {
        if (AssertUtils.isEmpty((String)verifier)) {
            throw new IllegalArgumentException("The request does not appear to be a valid " + (Object)((Object)this.getAuthProvider()) + " request");
        }
        String response = this.service.getAuthorizationResponse(tokenAndUrl, verifier);
        if (AssertUtils.isEmpty((String)response)) {
            return null;
        }
        Map map = this.getTokenExtractor().extractTokens(response);
        return this.createNewAuthenticatedUser(map);
    }

    protected AuthenticatedUser verifyUserOAuth2(TokenAndUrl tokenAndUrl, String verifier) {
        if (AssertUtils.isEmpty((String)verifier)) {
            throw new IllegalArgumentException("The request does not appear to be a valid " + (Object)((Object)this.getAuthProvider()) + " request");
        }
        System.out.println("Using " + (Object)((Object)this.getAuthProvider()) + " verification code: " + verifier);
        String response = this.service.getAuthorizationResponse(tokenAndUrl, verifier);
        if (AssertUtils.isEmpty((String)response)) {
            return null;
        }
        Map map = this.getTokenExtractor().extractTokens(response);
        return this.createNewAuthenticatedUser(map);
    }

    protected FieldNamingPolicy getFieldNamingPolicy() {
        return FieldNamingPolicy.IDENTITY;
    }

    @Override
    public boolean signOut() {
        return false;
    }

    @Override
    public <T> T getUsingJson(KeySecretPair accessPair, String url, Class<T> clazz) {
        url = this.service.signRequestUrl(url, accessPair);
        LOGGER.debug("Hitting signed URL: {}", (Object)url);
        WebRequest request = WebInvoker.getWebRequest((String)url, (WebRequestMethod)WebRequestMethod.GET);
        this.service.signRequest(request, accessPair);
        WebResponse response = WebInvoker.executeSilently((WebRequest)request);
        if (response == null) {
            LOGGER.error("Null response from url: {}", (Object)url);
            return null;
        }
        if (!response.isSuccess()) {
            LOGGER.error("Invalid response from url: {} with response: {}", (Object)url, (Object)response.trace());
            LOGGER.error(response.getContent());
            return null;
        }
        String content = response.getContent();
        LOGGER.debug("Webresponse: " + content);
        return (T)GsonUtils.getGson((FieldNamingPolicy)this.getFieldNamingPolicy()).fromJson(content, clazz);
    }

    @Override
    public void signRequest(KeySecretPair accessPair, WebRequest request) {
        this.service.signRequest(request, accessPair);
    }
}

