/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.satya.client.impl;

import com.google.gson.FieldNamingPolicy;
import com.sangupta.jerry.oauth.domain.KeySecretPair;
import com.sangupta.jerry.oauth.extractor.JSONTokenExtractor;
import com.sangupta.jerry.oauth.extractor.TokenExtractor;
import com.sangupta.jerry.oauth.service.OAuthService;
import com.sangupta.jerry.oauth.service.impl.DropBoxOAuthServiceImpl;
import com.sangupta.satya.AuthProvider;
import com.sangupta.satya.AuthenticatedUser;
import com.sangupta.satya.UserProfile;
import com.sangupta.satya.client.BaseAuthClient;
import com.sangupta.satya.user.BaseAuthenticatedUser;
import com.sangupta.satya.user.impl.DropBoxUserProfile;
import java.util.Map;

public class DropBoxAuthClient
extends BaseAuthClient {
    public DropBoxAuthClient(KeySecretPair keySecretPair, String ... scopes) {
        super((OAuthService)new DropBoxOAuthServiceImpl(keySecretPair), scopes);
    }

    @Override
    protected AuthProvider getAuthProvider() {
        return AuthProvider.DropBox;
    }

    @Override
    protected TokenExtractor getTokenExtractor() {
        return JSONTokenExtractor.INSTANCE;
    }

    @Override
    protected FieldNamingPolicy getFieldNamingPolicy() {
        return FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES;
    }

    @Override
    protected AuthenticatedUser createNewAuthenticatedUser(Map<String, String> rawParameters) {
        return new BaseAuthenticatedUser(this, rawParameters){

            @Override
            public String getUserProfileURL() {
                return "https://api.dropbox.com/1/account/info";
            }

            @Override
            public Class<? extends UserProfile> getUserProfileClass() {
                return DropBoxUserProfile.class;
            }
        };
    }
}

