/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.satya.client.impl;

import com.google.gson.FieldNamingPolicy;
import com.sangupta.jerry.oauth.domain.KeySecretPair;
import com.sangupta.jerry.oauth.extractor.TokenExtractor;
import com.sangupta.jerry.oauth.extractor.UrlParamTokenExtractor;
import com.sangupta.jerry.oauth.service.OAuthService;
import com.sangupta.jerry.oauth.service.impl.FacebookOAuthServiceImpl;
import com.sangupta.satya.AuthProvider;
import com.sangupta.satya.AuthenticatedUser;
import com.sangupta.satya.UserProfile;
import com.sangupta.satya.client.BaseAuthClient;
import com.sangupta.satya.user.BaseAuthenticatedUser;
import com.sangupta.satya.user.impl.FacebookUserProfile;
import java.util.Map;

public class FacebookAuthClient
extends BaseAuthClient {
    public FacebookAuthClient(KeySecretPair keySecretPair, String ... scopes) {
        super((OAuthService)new FacebookOAuthServiceImpl(keySecretPair), scopes);
    }

    @Override
    protected AuthProvider getAuthProvider() {
        return AuthProvider.Facebook;
    }

    @Override
    protected TokenExtractor getTokenExtractor() {
        return UrlParamTokenExtractor.INSTANCE;
    }

    @Override
    protected FieldNamingPolicy getFieldNamingPolicy() {
        return FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES;
    }

    @Override
    protected AuthenticatedUser createNewAuthenticatedUser(Map<String, String> rawParameters) {
        return new BaseAuthenticatedUser(this, rawParameters){

            @Override
            public String getUserProfileURL() {
                return "https://graph.facebook.com/me";
            }

            @Override
            public Class<? extends UserProfile> getUserProfileClass() {
                return FacebookUserProfile.class;
            }
        };
    }
}

