/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.satya.client.impl;

import com.google.gson.FieldNamingPolicy;
import com.sangupta.jerry.oauth.domain.KeySecretPair;
import com.sangupta.jerry.oauth.extractor.TokenExtractor;
import com.sangupta.jerry.oauth.extractor.UrlParamTokenExtractor;
import com.sangupta.jerry.oauth.service.OAuthService;
import com.sangupta.jerry.oauth.service.impl.GithubOAuthServiceImpl;
import com.sangupta.satya.AuthProvider;
import com.sangupta.satya.AuthenticatedUser;
import com.sangupta.satya.UserProfile;
import com.sangupta.satya.client.BaseAuthClient;
import com.sangupta.satya.user.BaseAuthenticatedUser;
import com.sangupta.satya.user.impl.GithubUserProfile;
import java.util.Map;

public class GithubAuthClient
extends BaseAuthClient {
    public GithubAuthClient(KeySecretPair keySecretPair, String ... scopes) {
        super((OAuthService)new GithubOAuthServiceImpl(keySecretPair), scopes);
    }

    @Override
    protected AuthProvider getAuthProvider() {
        return AuthProvider.Github;
    }

    @Override
    protected TokenExtractor getTokenExtractor() {
        return UrlParamTokenExtractor.INSTANCE;
    }

    @Override
    protected FieldNamingPolicy getFieldNamingPolicy() {
        return FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES;
    }

    @Override
    protected AuthenticatedUser createNewAuthenticatedUser(Map<String, String> rawParameters) {
        return new BaseAuthenticatedUser(this, rawParameters){

            @Override
            public String getUserProfileURL() {
                return "https://api.github.com/user";
            }

            @Override
            public Class<? extends UserProfile> getUserProfileClass() {
                return GithubUserProfile.class;
            }
        };
    }
}

