/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.satya.client.impl;

import com.sangupta.jerry.oauth.domain.KeySecretPair;
import com.sangupta.jerry.oauth.extractor.JSONTokenExtractor;
import com.sangupta.jerry.oauth.extractor.TokenExtractor;
import com.sangupta.jerry.oauth.service.OAuthService;
import com.sangupta.jerry.oauth.service.impl.GoogleOAuthServiceImpl;
import com.sangupta.satya.AuthProvider;
import com.sangupta.satya.AuthenticatedUser;
import com.sangupta.satya.UserProfile;
import com.sangupta.satya.client.BaseAuthClient;
import com.sangupta.satya.user.BaseAuthenticatedUser;
import com.sangupta.satya.user.impl.GoogleUserProfile;
import java.util.Map;

public class GoogleAuthClient
extends BaseAuthClient {
    public GoogleAuthClient(KeySecretPair pair, String ... scopes) {
        super((OAuthService)new GoogleOAuthServiceImpl(pair), scopes);
    }

    @Override
    protected char getScopeMergingCharacter() {
        return ' ';
    }

    @Override
    protected AuthProvider getAuthProvider() {
        return AuthProvider.Google;
    }

    @Override
    protected TokenExtractor getTokenExtractor() {
        return JSONTokenExtractor.INSTANCE;
    }

    @Override
    public boolean signOut() {
        return false;
    }

    @Override
    protected AuthenticatedUser createNewAuthenticatedUser(Map<String, String> rawParameters) {
        return new BaseAuthenticatedUser(this, rawParameters){

            @Override
            public String getUserProfileURL() {
                return "https://www.googleapis.com/oauth2/v1/userinfo?alt=json";
            }

            @Override
            public Class<? extends UserProfile> getUserProfileClass() {
                return GoogleUserProfile.class;
            }
        };
    }
}

