/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.satya.client.impl;

import com.sangupta.jerry.oauth.domain.KeySecretPair;
import com.sangupta.jerry.oauth.extractor.JSONTokenExtractor;
import com.sangupta.jerry.oauth.extractor.TokenExtractor;
import com.sangupta.jerry.oauth.service.OAuthService;
import com.sangupta.jerry.oauth.service.impl.LinkedInOAuthServiceImpl;
import com.sangupta.satya.AuthProvider;
import com.sangupta.satya.AuthenticatedUser;
import com.sangupta.satya.UserProfile;
import com.sangupta.satya.client.BaseAuthClient;
import com.sangupta.satya.user.BaseAuthenticatedUser;
import com.sangupta.satya.user.impl.LinkedInUserProfile;
import java.util.Map;

public class LinkedInAuthClient
extends BaseAuthClient {
    public LinkedInAuthClient(KeySecretPair pair, String ... scopes) {
        super((OAuthService)new LinkedInOAuthServiceImpl(pair), scopes);
    }

    @Override
    protected AuthProvider getAuthProvider() {
        return AuthProvider.LinkedIn;
    }

    @Override
    protected TokenExtractor getTokenExtractor() {
        return JSONTokenExtractor.INSTANCE;
    }

    @Override
    protected AuthenticatedUser createNewAuthenticatedUser(Map<String, String> rawParameters) {
        return new BaseAuthenticatedUser(this, rawParameters){

            @Override
            public String getUserProfileURL() {
                return "https://api.linkedin.com/v1/people/~:(id,first-name,last-name,headline,site-standard-profile-request,summary,picture-url,public-profile-url,email-address)?format=json";
            }

            @Override
            public Class<? extends UserProfile> getUserProfileClass() {
                return LinkedInUserProfile.class;
            }
        };
    }
}

