/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.satya.client.impl;

import com.google.gson.FieldNamingPolicy;
import com.sangupta.jerry.oauth.domain.KeySecretPair;
import com.sangupta.jerry.oauth.extractor.JSONTokenExtractor;
import com.sangupta.jerry.oauth.extractor.TokenExtractor;
import com.sangupta.jerry.oauth.service.OAuthService;
import com.sangupta.jerry.oauth.service.impl.MicrosoftLiveOAuthServiceImpl;
import com.sangupta.satya.AuthProvider;
import com.sangupta.satya.AuthenticatedUser;
import com.sangupta.satya.UserProfile;
import com.sangupta.satya.client.BaseAuthClient;
import com.sangupta.satya.user.BaseAuthenticatedUser;
import com.sangupta.satya.user.impl.MicrosoftLiveUserProfile;
import java.util.Map;

public class MicrosoftLiveAuthClient
extends BaseAuthClient {
    public MicrosoftLiveAuthClient(KeySecretPair pair, String ... scopes) {
        super((OAuthService)new MicrosoftLiveOAuthServiceImpl(pair), scopes);
    }

    @Override
    protected AuthProvider getAuthProvider() {
        return AuthProvider.MicrosoftLive;
    }

    @Override
    protected TokenExtractor getTokenExtractor() {
        return JSONTokenExtractor.INSTANCE;
    }

    @Override
    protected FieldNamingPolicy getFieldNamingPolicy() {
        return FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES;
    }

    @Override
    protected AuthenticatedUser createNewAuthenticatedUser(Map<String, String> rawParameters) {
        return new BaseAuthenticatedUser(this, rawParameters){

            @Override
            public String getUserProfileURL() {
                return "https://apis.live.net/v5.0/me";
            }

            @Override
            public Class<? extends UserProfile> getUserProfileClass() {
                return MicrosoftLiveUserProfile.class;
            }
        };
    }
}

