/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.satya.client.impl;

import com.sangupta.jerry.oauth.domain.KeySecretPair;
import com.sangupta.jerry.oauth.extractor.TokenExtractor;
import com.sangupta.jerry.oauth.extractor.UrlParamTokenExtractor;
import com.sangupta.jerry.oauth.service.OAuthService;
import com.sangupta.jerry.oauth.service.impl.YahooOAuthServiceImpl;
import com.sangupta.satya.AuthProvider;
import com.sangupta.satya.AuthenticatedUser;
import com.sangupta.satya.UserProfile;
import com.sangupta.satya.client.BaseAuthClient;
import com.sangupta.satya.user.BaseAuthenticatedUser;
import com.sangupta.satya.user.impl.YahooUserProfile;
import java.util.Map;

public class YahooAuthClient
extends BaseAuthClient {
    public YahooAuthClient(KeySecretPair pair, String ... scopes) {
        super((OAuthService)new YahooOAuthServiceImpl(pair), scopes);
    }

    @Override
    protected AuthProvider getAuthProvider() {
        return AuthProvider.Yahoo;
    }

    @Override
    protected TokenExtractor getTokenExtractor() {
        return UrlParamTokenExtractor.INSTANCE;
    }

    @Override
    protected AuthenticatedUser createNewAuthenticatedUser(Map<String, String> rawParameters) {
        return new BaseAuthenticatedUser(this, rawParameters){

            @Override
            public String getUserProfileURL() {
                String userID = (String)this.rawParameters.get("xoauth_yahoo_guid");
                return "https://social.yahooapis.com/v1/user/" + userID + "/profile?format=json";
            }

            @Override
            public Class<? extends UserProfile> getUserProfileClass() {
                return YahooUserProfile.class;
            }
        };
    }
}

