/*
 * Decompiled with CFR 0.152.
 */
package com.sangupta.satya.user;

import com.sangupta.jerry.http.WebRequest;
import com.sangupta.jerry.oauth.domain.KeySecretPair;
import com.sangupta.jerry.oauth.service.OAuthService;
import com.sangupta.jerry.util.StringUtils;
import com.sangupta.satya.AuthenticatedUser;
import com.sangupta.satya.UserProfile;
import com.sangupta.satya.client.AuthClient;
import java.util.Map;

public abstract class BaseAuthenticatedUser
implements AuthenticatedUser {
    protected AuthClient authClient;
    protected Map<String, String> rawParameters;
    protected KeySecretPair userAccessPair;
    protected String userRefreshToken;
    protected long expiry;
    protected UserProfile userProfile;

    public BaseAuthenticatedUser(AuthClient authClient, Map<String, String> rawParameters) {
        this.authClient = authClient;
        this.rawParameters = rawParameters;
        OAuthService service = this.authClient.getOAuthService();
        this.userAccessPair = new KeySecretPair(rawParameters.get(service.getAccessTokenParamName()), rawParameters.get(service.getAccessTokenSecretParamName()));
        if (service.getRefreshTokenParamName() != null) {
            this.userRefreshToken = rawParameters.get(service.getRefreshTokenParamName());
        }
        if (service.getAccessTokenExpiryParamName() != null) {
            this.expiry = StringUtils.getLongValue((String)rawParameters.get(service.getAccessTokenExpiryParamName()), (long)this.getDefaultTokenExpiryTime());
        }
    }

    public BaseAuthenticatedUser(AuthClient authClient, KeySecretPair userAccessPair) {
        this.authClient = authClient;
        this.userAccessPair = userAccessPair;
    }

    public abstract String getUserProfileURL();

    public abstract Class<? extends UserProfile> getUserProfileClass();

    public long getDefaultTokenExpiryTime() {
        return 3600L;
    }

    @Override
    public final UserProfile getUserProfile() {
        if (this.userProfile == null) {
            return this.fetchUserProfile();
        }
        return this.userProfile;
    }

    @Override
    public UserProfile fetchUserProfile() {
        UserProfile profile;
        this.userProfile = profile = this.authClient.getUsingJson(this.userAccessPair, this.getUserProfileURL(), this.getUserProfileClass());
        return profile;
    }

    @Override
    public void signOut() {
        this.userAccessPair = null;
        this.userRefreshToken = null;
        this.expiry = 0L;
        this.authClient.signOut();
    }

    @Override
    public void signRequest(WebRequest request) {
        this.authClient.signRequest(this.userAccessPair, request);
    }

    @Override
    public KeySecretPair getUserAccessPair() {
        return this.userAccessPair;
    }

    public String getUserRefreshToken() {
        return this.userRefreshToken;
    }

    public long getExpiry() {
        return this.expiry;
    }
}

