/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.client;

import com.google.common.annotations.Beta;
import com.sap.ai.sdk.grounding.model.CreatePipeline;
import com.sap.ai.sdk.grounding.model.DocumentsStatusResponse;
import com.sap.ai.sdk.grounding.model.GetPipeline;
import com.sap.ai.sdk.grounding.model.GetPipelineExecutionById;
import com.sap.ai.sdk.grounding.model.GetPipelineExecutions;
import com.sap.ai.sdk.grounding.model.GetPipelineStatus;
import com.sap.ai.sdk.grounding.model.GetPipelines;
import com.sap.ai.sdk.grounding.model.ManualPipelineTrigger;
import com.sap.ai.sdk.grounding.model.PatchPipeline;
import com.sap.ai.sdk.grounding.model.PipelineDocumentResponse;
import com.sap.ai.sdk.grounding.model.PipelineId;
import com.sap.ai.sdk.grounding.model.SearchPipeline;
import com.sap.ai.sdk.grounding.model.SearchPipelinesResponse;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.services.openapi.apiclient.ApiClient;
import com.sap.cloud.sdk.services.openapi.core.AbstractOpenApiService;
import com.sap.cloud.sdk.services.openapi.core.OpenApiRequestException;
import com.sap.cloud.sdk.services.openapi.core.OpenApiResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class PipelinesApi
extends AbstractOpenApiService {
    public PipelinesApi(@Nonnull Destination httpDestination) {
        super(httpDestination);
    }

    @Beta
    public PipelinesApi(@Nonnull ApiClient apiClient) {
        super(apiClient);
    }

    @Nonnull
    public PipelineId createPipeline(@Nonnull String aiResourceGroup, @Nonnull CreatePipeline createPipeline) throws OpenApiRequestException {
        CreatePipeline localVarPostBody = createPipeline;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling createPipeline");
        }
        if (createPipeline == null) {
            throw new OpenApiRequestException("Missing the required parameter 'createPipeline' when calling pipelineV1PipelineEndpointsCreatePipeline");
        }
        String localVarPath = UriComponentsBuilder.fromPath((String)"/pipelines").build().toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<PipelineId> localVarReturnType = new ParameterizedTypeReference<PipelineId>(){};
        return (PipelineId)this.apiClient.invokeAPI(localVarPath, HttpMethod.POST, (MultiValueMap)localVarQueryParams, (Object)localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public OpenApiResponse deletePipelineById(@Nonnull String aiResourceGroup, @Nonnull String pipelineId) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling deletePipelineById");
        }
        if (pipelineId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'pipelineId' when calling deletePipelineById");
        }
        HashMap<String, String> localVarPathParams = new HashMap<String, String>();
        localVarPathParams.put("pipelineId", pipelineId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/pipelines/{pipelineId}").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        this.apiClient.invokeAPI(localVarPath, HttpMethod.DELETE, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
        return new OpenApiResponse(this.apiClient);
    }

    @Nonnull
    public GetPipelines getAllPipelines(@Nonnull String aiResourceGroup, @Nullable Integer $top, @Nullable Integer $skip, @Nullable Boolean $count) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling getAllPipelines");
        }
        String localVarPath = UriComponentsBuilder.fromPath((String)"/pipelines").build().toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$top", (Object)$top));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$skip", (Object)$skip));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$count", (Object)$count));
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<GetPipelines> localVarReturnType = new ParameterizedTypeReference<GetPipelines>(){};
        return (GetPipelines)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public GetPipelines getAllPipelines(@Nonnull String aiResourceGroup) throws OpenApiRequestException {
        return this.getAllPipelines(aiResourceGroup, null, null, null);
    }

    @Nonnull
    public GetPipeline getPipelineById(@Nonnull String aiResourceGroup, @Nonnull String pipelineId) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling getPipelineById");
        }
        if (pipelineId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'pipelineId' when calling getPipelineById");
        }
        HashMap<String, String> localVarPathParams = new HashMap<String, String>();
        localVarPathParams.put("pipelineId", pipelineId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/pipelines/{pipelineId}").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<GetPipeline> localVarReturnType = new ParameterizedTypeReference<GetPipeline>(){};
        return (GetPipeline)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public PipelineDocumentResponse getDocumentByIdForPipeline(@Nonnull String aiResourceGroup, @Nonnull String pipelineId, @Nonnull String documentId) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling getDocumentByIdForPipeline");
        }
        if (pipelineId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'pipelineId' when calling getDocumentByIdForPipeline");
        }
        if (documentId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'documentId' when calling getDocumentByIdForPipeline");
        }
        HashMap<String, String> localVarPathParams = new HashMap<String, String>();
        localVarPathParams.put("pipelineId", pipelineId);
        localVarPathParams.put("documentId", documentId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/pipelines/{pipelineId}/documents/{documentId}").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<PipelineDocumentResponse> localVarReturnType = new ParameterizedTypeReference<PipelineDocumentResponse>(){};
        return (PipelineDocumentResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public DocumentsStatusResponse getAllDocumentsForPipeline(@Nonnull String aiResourceGroup, @Nonnull String pipelineId, @Nullable Integer $top, @Nullable Integer $skip, @Nullable Boolean $count) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling getAllDocumentsForPipeline");
        }
        if (pipelineId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'pipelineId' when calling getAllDocumentsForPipeline");
        }
        HashMap<String, String> localVarPathParams = new HashMap<String, String>();
        localVarPathParams.put("pipelineId", pipelineId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/pipelines/{pipelineId}/documents").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$top", (Object)$top));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$skip", (Object)$skip));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$count", (Object)$count));
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<DocumentsStatusResponse> localVarReturnType = new ParameterizedTypeReference<DocumentsStatusResponse>(){};
        return (DocumentsStatusResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public DocumentsStatusResponse getAllDocumentsForPipeline(@Nonnull String aiResourceGroup, @Nonnull String pipelineId) throws OpenApiRequestException {
        return this.getAllDocumentsForPipeline(aiResourceGroup, pipelineId, null, null, null);
    }

    @Nonnull
    public GetPipelineExecutionById getExecutionDetailsByIdForPipelineExecution(@Nonnull String aiResourceGroup, @Nonnull String pipelineId, @Nonnull String executionId) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling getExecutionDetailsByIdForPipelineExecution");
        }
        if (pipelineId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'pipelineId' when calling getExecutionDetailsByIdForPipelineExecution");
        }
        if (executionId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'executionId' when calling getExecutionDetailsByIdForPipelineExecution");
        }
        HashMap<String, String> localVarPathParams = new HashMap<String, String>();
        localVarPathParams.put("pipelineId", pipelineId);
        localVarPathParams.put("executionId", executionId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/pipelines/{pipelineId}/executions/{executionId}").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<GetPipelineExecutionById> localVarReturnType = new ParameterizedTypeReference<GetPipelineExecutionById>(){};
        return (GetPipelineExecutionById)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public PipelineDocumentResponse getDocumentByIdForPipelineExecution(@Nonnull String aiResourceGroup, @Nonnull String pipelineId, @Nonnull String executionId, @Nonnull String documentId) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling getDocumentByIdForPipelineExecution");
        }
        if (pipelineId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'pipelineId' when calling getDocumentByIdForPipelineExecution");
        }
        if (executionId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'executionId' when calling getDocumentByIdForPipelineExecution");
        }
        if (documentId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'documentId' when calling getDocumentByIdForPipelineExecution");
        }
        HashMap<String, String> localVarPathParams = new HashMap<String, String>();
        localVarPathParams.put("pipelineId", pipelineId);
        localVarPathParams.put("executionId", executionId);
        localVarPathParams.put("documentId", documentId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/pipelines/{pipelineId}/executions/{executionId}/documents/{documentId}").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<PipelineDocumentResponse> localVarReturnType = new ParameterizedTypeReference<PipelineDocumentResponse>(){};
        return (PipelineDocumentResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public DocumentsStatusResponse getDocumentsForPipelineExecution(@Nonnull String aiResourceGroup, @Nonnull String pipelineId, @Nonnull String executionId, @Nullable Integer $top, @Nullable Integer $skip, @Nullable Boolean $count) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling getDocumentsForPipelineExecution");
        }
        if (pipelineId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'pipelineId' when calling getDocumentsForPipelineExecution");
        }
        if (executionId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'executionId' when calling getDocumentsForPipelineExecution");
        }
        HashMap<String, String> localVarPathParams = new HashMap<String, String>();
        localVarPathParams.put("pipelineId", pipelineId);
        localVarPathParams.put("executionId", executionId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/pipelines/{pipelineId}/executions/{executionId}/documents").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$top", (Object)$top));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$skip", (Object)$skip));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$count", (Object)$count));
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<DocumentsStatusResponse> localVarReturnType = new ParameterizedTypeReference<DocumentsStatusResponse>(){};
        return (DocumentsStatusResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public DocumentsStatusResponse getDocumentsForPipelineExecution(@Nonnull String aiResourceGroup, @Nonnull String pipelineId, @Nonnull String executionId) throws OpenApiRequestException {
        return this.getDocumentsForPipelineExecution(aiResourceGroup, pipelineId, executionId, null, null, null);
    }

    @Nonnull
    public GetPipelineExecutions getAllExecutionsForPipeline(@Nonnull String aiResourceGroup, @Nonnull String pipelineId, @Nullable Boolean lastExecution, @Nullable Integer $top, @Nullable Integer $skip, @Nullable Boolean $count) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling getAllExecutionsForPipeline");
        }
        if (pipelineId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'pipelineId' when calling getAllExecutionsForPipeline");
        }
        HashMap<String, String> localVarPathParams = new HashMap<String, String>();
        localVarPathParams.put("pipelineId", pipelineId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/pipelines/{pipelineId}/executions").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "lastExecution", (Object)lastExecution));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$top", (Object)$top));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$skip", (Object)$skip));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$count", (Object)$count));
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<GetPipelineExecutions> localVarReturnType = new ParameterizedTypeReference<GetPipelineExecutions>(){};
        return (GetPipelineExecutions)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public GetPipelineExecutions getAllExecutionsForPipeline(@Nonnull String aiResourceGroup, @Nonnull String pipelineId) throws OpenApiRequestException {
        return this.getAllExecutionsForPipeline(aiResourceGroup, pipelineId, null, null, null, null);
    }

    @Nonnull
    public GetPipelineStatus getPipelineStatus(@Nonnull String aiResourceGroup, @Nonnull String pipelineId) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling getPipelineStatus");
        }
        if (pipelineId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'pipelineId' when calling getPipelineStatus");
        }
        HashMap<String, String> localVarPathParams = new HashMap<String, String>();
        localVarPathParams.put("pipelineId", pipelineId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/pipelines/{pipelineId}/status").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<GetPipelineStatus> localVarReturnType = new ParameterizedTypeReference<GetPipelineStatus>(){};
        return (GetPipelineStatus)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public OpenApiResponse patchPipelineById(@Nonnull String aiResourceGroup, @Nonnull String pipelineId, @Nonnull PatchPipeline patchPipeline) throws OpenApiRequestException {
        PatchPipeline localVarPostBody = patchPipeline;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling patchPipelineById");
        }
        if (pipelineId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'pipelineId' when calling patchPipelineById");
        }
        if (patchPipeline == null) {
            throw new OpenApiRequestException("Missing the required parameter 'patchPipeline' when calling pipelineV1PipelineEndpointsPatchPipelineById");
        }
        HashMap<String, String> localVarPathParams = new HashMap<String, String>();
        localVarPathParams.put("pipelineId", pipelineId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/pipelines/{pipelineId}").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        this.apiClient.invokeAPI(localVarPath, HttpMethod.PATCH, (MultiValueMap)localVarQueryParams, (Object)localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
        return new OpenApiResponse(this.apiClient);
    }

    @Nonnull
    public SearchPipelinesResponse searchPipelinesByMetadata(@Nonnull String aiResourceGroup, @Nonnull SearchPipeline searchPipeline, @Nullable Integer $top, @Nullable Integer $skip, @Nullable Boolean $count) throws OpenApiRequestException {
        SearchPipeline localVarPostBody = searchPipeline;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling searchPipelinesByMetadata");
        }
        if (searchPipeline == null) {
            throw new OpenApiRequestException("Missing the required parameter 'searchPipeline' when calling pipelineV1PipelineEndpointsSearchPipeline");
        }
        String localVarPath = UriComponentsBuilder.fromPath((String)"/pipelines/search").build().toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$top", (Object)$top));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$skip", (Object)$skip));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$count", (Object)$count));
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<SearchPipelinesResponse> localVarReturnType = new ParameterizedTypeReference<SearchPipelinesResponse>(){};
        return (SearchPipelinesResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.POST, (MultiValueMap)localVarQueryParams, (Object)localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public SearchPipelinesResponse searchPipelinesByMetadata(@Nonnull String aiResourceGroup, @Nonnull SearchPipeline searchPipeline) throws OpenApiRequestException {
        return this.searchPipelinesByMetadata(aiResourceGroup, searchPipeline, null, null, null);
    }

    @Nonnull
    public OpenApiResponse manualTriggerPipeline(@Nonnull String aiResourceGroup, @Nonnull ManualPipelineTrigger manualPipelineTrigger) throws OpenApiRequestException {
        ManualPipelineTrigger localVarPostBody = manualPipelineTrigger;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling manualTriggerPipeline");
        }
        if (manualPipelineTrigger == null) {
            throw new OpenApiRequestException("Missing the required parameter 'manualPipelineTrigger' when calling pipelineV1PipelineEndpointsTriggerPipeline");
        }
        String localVarPath = UriComponentsBuilder.fromPath((String)"/pipelines/trigger").build().toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        this.apiClient.invokeAPI(localVarPath, HttpMethod.POST, (MultiValueMap)localVarQueryParams, (Object)localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
        return new OpenApiResponse(this.apiClient);
    }
}

