/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.client;

import com.google.common.annotations.Beta;
import com.sap.ai.sdk.grounding.model.DataRepositories;
import com.sap.ai.sdk.grounding.model.DataRepository;
import com.sap.ai.sdk.grounding.model.RetrievalSearchInput;
import com.sap.ai.sdk.grounding.model.RetrievalSearchResults;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.services.openapi.apiclient.ApiClient;
import com.sap.cloud.sdk.services.openapi.core.AbstractOpenApiService;
import com.sap.cloud.sdk.services.openapi.core.OpenApiRequestException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class RetrievalApi
extends AbstractOpenApiService {
    public RetrievalApi(@Nonnull Destination httpDestination) {
        super(httpDestination);
    }

    @Beta
    public RetrievalApi(@Nonnull ApiClient apiClient) {
        super(apiClient);
    }

    @Nonnull
    public DataRepositories getDataRepositories(@Nonnull String aiResourceGroup, @Nullable Integer $top, @Nullable Integer $skip, @Nullable Boolean $count) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling getDataRepositories");
        }
        String localVarPath = UriComponentsBuilder.fromPath((String)"/retrieval/dataRepositories").build().toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$top", (Object)$top));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$skip", (Object)$skip));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$count", (Object)$count));
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<DataRepositories> localVarReturnType = new ParameterizedTypeReference<DataRepositories>(){};
        return (DataRepositories)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public DataRepositories getDataRepositories(@Nonnull String aiResourceGroup) throws OpenApiRequestException {
        return this.getDataRepositories(aiResourceGroup, null, null, null);
    }

    @Nonnull
    public DataRepository getDataRepositoryById(@Nonnull String aiResourceGroup, @Nonnull UUID repositoryId) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling getDataRepositoryById");
        }
        if (repositoryId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'repositoryId' when calling getDataRepositoryById");
        }
        HashMap<String, UUID> localVarPathParams = new HashMap<String, UUID>();
        localVarPathParams.put("repositoryId", repositoryId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/retrieval/dataRepositories/{repositoryId}").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<DataRepository> localVarReturnType = new ParameterizedTypeReference<DataRepository>(){};
        return (DataRepository)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public RetrievalSearchResults search(@Nonnull String aiResourceGroup, @Nonnull RetrievalSearchInput retrievalSearchInput) throws OpenApiRequestException {
        RetrievalSearchInput localVarPostBody = retrievalSearchInput;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling search");
        }
        if (retrievalSearchInput == null) {
            throw new OpenApiRequestException("Missing the required parameter 'retrievalSearchInput' when calling retrievalV1RetrievalEndpointsSearch");
        }
        String localVarPath = UriComponentsBuilder.fromPath((String)"/retrieval/search").build().toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<RetrievalSearchResults> localVarReturnType = new ParameterizedTypeReference<RetrievalSearchResults>(){};
        return (RetrievalSearchResults)this.apiClient.invokeAPI(localVarPath, HttpMethod.POST, (MultiValueMap)localVarQueryParams, (Object)localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }
}

