/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.client;

import com.google.common.annotations.Beta;
import com.sap.ai.sdk.grounding.model.Collection;
import com.sap.ai.sdk.grounding.model.CollectionRequest;
import com.sap.ai.sdk.grounding.model.CollectionsListResponse;
import com.sap.ai.sdk.grounding.model.DocumentCreateRequest;
import com.sap.ai.sdk.grounding.model.DocumentResponse;
import com.sap.ai.sdk.grounding.model.DocumentUpdateRequest;
import com.sap.ai.sdk.grounding.model.Documents;
import com.sap.ai.sdk.grounding.model.DocumentsListResponse;
import com.sap.ai.sdk.grounding.model.TextSearchRequest;
import com.sap.ai.sdk.grounding.model.VectorSearchResults;
import com.sap.ai.sdk.grounding.model.VectorV1VectorEndpointsGetCollectionCreationStatus200Response;
import com.sap.ai.sdk.grounding.model.VectorV1VectorEndpointsGetCollectionDeletionStatus200Response;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.services.openapi.apiclient.ApiClient;
import com.sap.cloud.sdk.services.openapi.core.AbstractOpenApiService;
import com.sap.cloud.sdk.services.openapi.core.OpenApiRequestException;
import com.sap.cloud.sdk.services.openapi.core.OpenApiResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class VectorApi
extends AbstractOpenApiService {
    public VectorApi(@Nonnull Destination httpDestination) {
        super(httpDestination);
    }

    @Beta
    public VectorApi(@Nonnull ApiClient apiClient) {
        super(apiClient);
    }

    @Nonnull
    public OpenApiResponse createCollection(@Nonnull String aiResourceGroup, @Nonnull CollectionRequest collectionRequest) throws OpenApiRequestException {
        CollectionRequest localVarPostBody = collectionRequest;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling createCollection");
        }
        if (collectionRequest == null) {
            throw new OpenApiRequestException("Missing the required parameter 'collectionRequest' when calling vectorV1VectorEndpointsCreateCollection");
        }
        String localVarPath = UriComponentsBuilder.fromPath((String)"/vector/collections").build().toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        this.apiClient.invokeAPI(localVarPath, HttpMethod.POST, (MultiValueMap)localVarQueryParams, (Object)localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
        return new OpenApiResponse(this.apiClient);
    }

    @Nonnull
    public DocumentsListResponse createDocuments(@Nonnull String aiResourceGroup, @Nonnull UUID collectionId, @Nonnull DocumentCreateRequest documentCreateRequest) throws OpenApiRequestException {
        DocumentCreateRequest localVarPostBody = documentCreateRequest;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling createDocuments");
        }
        if (collectionId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'collectionId' when calling createDocuments");
        }
        if (documentCreateRequest == null) {
            throw new OpenApiRequestException("Missing the required parameter 'documentCreateRequest' when calling vectorV1VectorEndpointsCreateDocuments");
        }
        HashMap<String, UUID> localVarPathParams = new HashMap<String, UUID>();
        localVarPathParams.put("collectionId", collectionId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/vector/collections/{collectionId}/documents").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<DocumentsListResponse> localVarReturnType = new ParameterizedTypeReference<DocumentsListResponse>(){};
        return (DocumentsListResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.POST, (MultiValueMap)localVarQueryParams, (Object)localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public OpenApiResponse deleteCollectionById(@Nonnull String aiResourceGroup, @Nonnull String collectionId) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling deleteCollectionById");
        }
        if (collectionId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'collectionId' when calling deleteCollectionById");
        }
        HashMap<String, String> localVarPathParams = new HashMap<String, String>();
        localVarPathParams.put("collectionId", collectionId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/vector/collections/{collectionId}").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        this.apiClient.invokeAPI(localVarPath, HttpMethod.DELETE, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
        return new OpenApiResponse(this.apiClient);
    }

    @Nonnull
    public OpenApiResponse deleteDocumentById(@Nonnull String aiResourceGroup, @Nonnull UUID collectionId, @Nonnull UUID documentId) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling deleteDocumentById");
        }
        if (collectionId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'collectionId' when calling deleteDocumentById");
        }
        if (documentId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'documentId' when calling deleteDocumentById");
        }
        HashMap<String, UUID> localVarPathParams = new HashMap<String, UUID>();
        localVarPathParams.put("collectionId", collectionId);
        localVarPathParams.put("documentId", documentId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/vector/collections/{collectionId}/documents/{documentId}").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        this.apiClient.invokeAPI(localVarPath, HttpMethod.DELETE, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
        return new OpenApiResponse(this.apiClient);
    }

    @Nonnull
    public CollectionsListResponse getAllCollections(@Nonnull String aiResourceGroup, @Nullable Integer $top, @Nullable Integer $skip, @Nullable Boolean $count) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling getAllCollections");
        }
        String localVarPath = UriComponentsBuilder.fromPath((String)"/vector/collections").build().toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$top", (Object)$top));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$skip", (Object)$skip));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$count", (Object)$count));
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<CollectionsListResponse> localVarReturnType = new ParameterizedTypeReference<CollectionsListResponse>(){};
        return (CollectionsListResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public CollectionsListResponse getAllCollections(@Nonnull String aiResourceGroup) throws OpenApiRequestException {
        return this.getAllCollections(aiResourceGroup, null, null, null);
    }

    @Nonnull
    public Documents getAllDocuments(@Nonnull String aiResourceGroup, @Nonnull UUID collectionId, @Nullable Integer $top, @Nullable Integer $skip, @Nullable Boolean $count) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling getAllDocuments");
        }
        if (collectionId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'collectionId' when calling getAllDocuments");
        }
        HashMap<String, UUID> localVarPathParams = new HashMap<String, UUID>();
        localVarPathParams.put("collectionId", collectionId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/vector/collections/{collectionId}/documents").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$top", (Object)$top));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$skip", (Object)$skip));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "$count", (Object)$count));
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Documents> localVarReturnType = new ParameterizedTypeReference<Documents>(){};
        return (Documents)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public Documents getAllDocuments(@Nonnull String aiResourceGroup, @Nonnull UUID collectionId) throws OpenApiRequestException {
        return this.getAllDocuments(aiResourceGroup, collectionId, null, null, null);
    }

    @Nonnull
    public Collection getCollectionById(@Nonnull String aiResourceGroup, @Nonnull UUID collectionId) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling getCollectionById");
        }
        if (collectionId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'collectionId' when calling getCollectionById");
        }
        HashMap<String, UUID> localVarPathParams = new HashMap<String, UUID>();
        localVarPathParams.put("collectionId", collectionId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/vector/collections/{collectionId}").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Collection> localVarReturnType = new ParameterizedTypeReference<Collection>(){};
        return (Collection)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public VectorV1VectorEndpointsGetCollectionCreationStatus200Response getCollectionCreationStatus(@Nonnull String aiResourceGroup, @Nonnull UUID id) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling getCollectionCreationStatus");
        }
        if (id == null) {
            throw new OpenApiRequestException("Missing the required parameter 'id' when calling getCollectionCreationStatus");
        }
        HashMap<String, UUID> localVarPathParams = new HashMap<String, UUID>();
        localVarPathParams.put("id", id);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/vector/collections/{id}/creationStatus").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<VectorV1VectorEndpointsGetCollectionCreationStatus200Response> localVarReturnType = new ParameterizedTypeReference<VectorV1VectorEndpointsGetCollectionCreationStatus200Response>(){};
        return (VectorV1VectorEndpointsGetCollectionCreationStatus200Response)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public VectorV1VectorEndpointsGetCollectionDeletionStatus200Response getCollectionDeletionStatus(@Nonnull String aiResourceGroup, @Nonnull UUID id) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling getCollectionDeletionStatus");
        }
        if (id == null) {
            throw new OpenApiRequestException("Missing the required parameter 'id' when calling getCollectionDeletionStatus");
        }
        HashMap<String, UUID> localVarPathParams = new HashMap<String, UUID>();
        localVarPathParams.put("id", id);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/vector/collections/{id}/deletionStatus").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<VectorV1VectorEndpointsGetCollectionDeletionStatus200Response> localVarReturnType = new ParameterizedTypeReference<VectorV1VectorEndpointsGetCollectionDeletionStatus200Response>(){};
        return (VectorV1VectorEndpointsGetCollectionDeletionStatus200Response)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public DocumentResponse getDocumentById(@Nonnull String aiResourceGroup, @Nonnull UUID collectionId, @Nonnull UUID documentId) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling getDocumentById");
        }
        if (collectionId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'collectionId' when calling getDocumentById");
        }
        if (documentId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'documentId' when calling getDocumentById");
        }
        HashMap<String, UUID> localVarPathParams = new HashMap<String, UUID>();
        localVarPathParams.put("collectionId", collectionId);
        localVarPathParams.put("documentId", documentId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/vector/collections/{collectionId}/documents/{documentId}").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<DocumentResponse> localVarReturnType = new ParameterizedTypeReference<DocumentResponse>(){};
        return (DocumentResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public VectorSearchResults search(@Nonnull String aiResourceGroup, @Nonnull TextSearchRequest textSearchRequest) throws OpenApiRequestException {
        TextSearchRequest localVarPostBody = textSearchRequest;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling search");
        }
        if (textSearchRequest == null) {
            throw new OpenApiRequestException("Missing the required parameter 'textSearchRequest' when calling vectorV1VectorEndpointsSearchChunk");
        }
        String localVarPath = UriComponentsBuilder.fromPath((String)"/vector/search").build().toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<VectorSearchResults> localVarReturnType = new ParameterizedTypeReference<VectorSearchResults>(){};
        return (VectorSearchResults)this.apiClient.invokeAPI(localVarPath, HttpMethod.POST, (MultiValueMap)localVarQueryParams, (Object)localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public DocumentsListResponse updateDocuments(@Nonnull String aiResourceGroup, @Nonnull UUID collectionId, @Nonnull DocumentUpdateRequest documentUpdateRequest) throws OpenApiRequestException {
        DocumentUpdateRequest localVarPostBody = documentUpdateRequest;
        if (aiResourceGroup == null) {
            throw new OpenApiRequestException("Missing the required parameter 'aiResourceGroup' when calling updateDocuments");
        }
        if (collectionId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'collectionId' when calling updateDocuments");
        }
        if (documentUpdateRequest == null) {
            throw new OpenApiRequestException("Missing the required parameter 'documentUpdateRequest' when calling vectorV1VectorEndpointsUpdateDocuments");
        }
        HashMap<String, UUID> localVarPathParams = new HashMap<String, UUID>();
        localVarPathParams.put("collectionId", collectionId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/vector/collections/{collectionId}/documents").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<DocumentsListResponse> localVarReturnType = new ParameterizedTypeReference<DocumentsListResponse>(){};
        return (DocumentsListResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.PATCH, (MultiValueMap)localVarQueryParams, (Object)localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }
}

